/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import oracle.jdbc.diagnostics.OracleLogRecord;
import oracle.jdbc.diagnostics.OracleTraceKey;
import oracle.jdbc.diagnostics.TraceAttributes;

public class OracleSimpleFormatter
extends SimpleFormatter {
    @Override
    public String formatMessage(LogRecord record) {
        if (record instanceof OracleLogRecord) {
            OracleLogRecord rec = (OracleLogRecord)record;
            TraceAttributes attributes = rec.getTraceAttributes();
            StringBuilder result = new StringBuilder();
            result.append(rec.getSecurityLabel().getLabel()).append(":").append("thread-").append(rec.getThreadID()).append(" ").append(rec.getThreadName()).append(" ");
            if (attributes != null) {
                for (TraceAttributes.Entry e : attributes) {
                    if (e.value == null || e.key == OracleTraceKey.SQL && rec.getLevel().intValue() >= Level.INFO.intValue()) continue;
                    result.append(e.key).append("=").append(e.value).append(",");
                }
            }
            result.append(super.formatMessage(record));
            return result.toString();
        }
        return super.formatMessage(record);
    }
}

