/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;

public class LocaleUtils {
    public static Locale parse(String localeStr) {
        char c;
        boolean useUnderscoreAsSeparator = false;
        for (int i = 0; i < localeStr.length() && (c = localeStr.charAt(i)) != '-'; ++i) {
            if (c != '_') continue;
            useUnderscoreAsSeparator = true;
            break;
        }
        String[] parts = useUnderscoreAsSeparator ? localeStr.split("_", -1) : localeStr.split("-", -1);
        Locale locale = LocaleUtils.parseParts(parts);
        try {
            locale.getISO3Language();
        }
        catch (MissingResourceException e) {
            throw new IllegalArgumentException("Unknown language: " + parts[0], e);
        }
        try {
            locale.getISO3Country();
        }
        catch (MissingResourceException e) {
            throw new IllegalArgumentException("Unknown country: " + parts[1], e);
        }
        return locale;
    }

    private static Locale parseParts(String[] parts) {
        return switch (parts.length) {
            case 3 -> new Locale.Builder().setLanguage(parts[0]).setRegion(parts[1]).setVariant(parts[2]).build();
            case 2 -> new Locale.Builder().setLanguage(parts[0]).setRegion(parts[1]).build();
            case 1 -> {
                if ("ROOT".equalsIgnoreCase(parts[0])) {
                    yield Locale.ROOT;
                }
                yield new Locale.Builder().setLanguage(parts[0]).build();
            }
            default -> throw new IllegalArgumentException("Locales can have at most 3 parts but got " + parts.length + ": " + String.valueOf(Arrays.asList(parts)));
        };
    }
}

