/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.secure_sm.policy;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.opensearch.secure_sm.policy.GrantEntry;
import org.opensearch.secure_sm.policy.PermissionEntry;
import org.opensearch.secure_sm.policy.PropertyExpander;
import org.opensearch.secure_sm.policy.Token;
import org.opensearch.secure_sm.policy.TokenStream;

public class PolicyParser {
    private PolicyParser() {
    }

    public static List<GrantEntry> read(Reader policy) throws ParsingException, IOException {
        ArrayList<GrantEntry> grantEntries = new ArrayList<GrantEntry>();
        if (!(policy instanceof BufferedReader)) {
            policy = new BufferedReader(policy);
        }
        TokenStream tokenStream = new TokenStream(policy);
        while (!tokenStream.isEOF()) {
            if (!PolicyParser.peek(tokenStream, "grant")) continue;
            PolicyParser.parseGrantEntry(tokenStream).ifPresent(grantEntries::add);
        }
        return grantEntries;
    }

    private static boolean pollOnMatch(TokenStream tokenStream, String expect) throws ParsingException, IOException {
        if (PolicyParser.peek(tokenStream, expect)) {
            PolicyParser.poll(tokenStream, expect);
            return true;
        }
        return false;
    }

    private static boolean peek(TokenStream tokenStream, String expected) throws IOException {
        Token token = tokenStream.peek();
        return expected.equalsIgnoreCase(token.text());
    }

    private static String poll(TokenStream tokenStream, String expected) throws IOException, ParsingException {
        Token token = tokenStream.consume();
        if (expected.equalsIgnoreCase("grant") || expected.equalsIgnoreCase("Codebase") || expected.equalsIgnoreCase("Permission") || expected.equalsIgnoreCase("{") || expected.equalsIgnoreCase("}") || expected.equalsIgnoreCase(";") || expected.equalsIgnoreCase(",")) {
            if (!expected.equalsIgnoreCase(token.text())) {
                throw new ParsingException(token.line(), expected, token.text());
            }
            return token.text();
        }
        if (token.type() == -3 || token.type() == 34 || token.type() == 39) {
            return token.text();
        }
        throw new ParsingException(token.line(), expected, token.text());
    }

    private static Optional<GrantEntry> parseGrantEntry(TokenStream tokenStream) throws ParsingException, IOException {
        String codeBase = null;
        ArrayList<PermissionEntry> permissionEntries = new ArrayList<PermissionEntry>();
        PolicyParser.poll(tokenStream, "grant");
        while (!PolicyParser.peek(tokenStream, "{")) {
            if (PolicyParser.pollOnMatch(tokenStream, "Codebase")) {
                if (codeBase != null) {
                    throw new ParsingException(tokenStream.line(), "Multiple Codebase expressions");
                }
                String rawCodebase = PolicyParser.poll(tokenStream, tokenStream.peek().text());
                try {
                    codeBase = PropertyExpander.expand(rawCodebase, true).replace(File.separatorChar, '/');
                }
                catch (PropertyExpander.ExpandException e) {
                    PolicyParser.skipCurrentGrantBlock(tokenStream);
                    return Optional.empty();
                }
                PolicyParser.pollOnMatch(tokenStream, ",");
                continue;
            }
            throw new ParsingException(tokenStream.line(), "Expected codeBase");
        }
        PolicyParser.poll(tokenStream, "{");
        while (!PolicyParser.peek(tokenStream, "}")) {
            if (PolicyParser.peek(tokenStream, "Permission")) {
                permissionEntries.add(PolicyParser.parsePermissionEntry(tokenStream));
                PolicyParser.poll(tokenStream, ";");
                continue;
            }
            throw new ParsingException(tokenStream.line(), "Expected permission entry");
        }
        PolicyParser.poll(tokenStream, "}");
        if (PolicyParser.peek(tokenStream, ";")) {
            PolicyParser.poll(tokenStream, ";");
        }
        if (codeBase != null) {
            codeBase = codeBase.replace(File.separatorChar, '/');
        }
        return Optional.of(new GrantEntry(codeBase, permissionEntries));
    }

    private static void skipCurrentGrantBlock(TokenStream tokenStream) throws IOException, ParsingException {
        Token token;
        int braceDepth = 0;
        while (!tokenStream.isEOF()) {
            token = tokenStream.peek();
            if ("{".equals(token.text())) {
                ++braceDepth;
                tokenStream.consume();
                break;
            }
            tokenStream.consume();
        }
        while (braceDepth > 0 && !tokenStream.isEOF()) {
            token = tokenStream.consume();
            if ("{".equals(token.text())) {
                ++braceDepth;
                continue;
            }
            if (!"}".equals(token.text())) continue;
            --braceDepth;
        }
        if (PolicyParser.peek(tokenStream, ";")) {
            PolicyParser.poll(tokenStream, ";");
        }
    }

    private static PermissionEntry parsePermissionEntry(TokenStream tokenStream) throws ParsingException, IOException {
        String name = null;
        String action = null;
        PolicyParser.poll(tokenStream, "Permission");
        String permission = PolicyParser.poll(tokenStream, tokenStream.peek().text());
        if (PolicyParser.isQuotedToken(tokenStream.peek())) {
            name = PolicyParser.poll(tokenStream, tokenStream.peek().text());
        }
        if (PolicyParser.peek(tokenStream, ",")) {
            PolicyParser.poll(tokenStream, ",");
        }
        if (PolicyParser.isQuotedToken(tokenStream.peek())) {
            action = PolicyParser.poll(tokenStream, tokenStream.peek().text());
        }
        return new PermissionEntry(permission, name, action);
    }

    private static boolean isQuotedToken(Token token) {
        return token.type() == 34 || token.type() == 39;
    }

    public static class ParsingException
    extends Exception {
        public ParsingException(String message) {
            super(message);
        }

        public ParsingException(int line, String expected) {
            super("line " + line + ": expected [" + expected + "]");
        }

        public ParsingException(int line, String expected, String found) {
            super("line " + line + ": expected [" + expected + "], found [" + found + "]");
        }
    }
}

