/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ConditionTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, ConditionTokenFilter> {
    @Nonnull
    private final List<String> filter;
    @Nonnull
    private final Script script;
    public static final JsonpDeserializer<ConditionTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ConditionTokenFilter::setupConditionTokenFilterDeserializer);

    private ConditionTokenFilter(Builder builder) {
        super(builder);
        this.filter = ApiTypeHelper.unmodifiableRequired(builder.filter, (Object)this, "filter");
        this.script = ApiTypeHelper.requireNonNull(builder.script, this, "script");
    }

    public static ConditionTokenFilter of(Function<Builder, ObjectBuilder<ConditionTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Condition;
    }

    @Nonnull
    public final List<String> filter() {
        return this.filter;
    }

    @Nonnull
    public final Script script() {
        return this.script;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "condition");
        super.serializeInternal(generator, mapper);
        generator.writeKey("filter");
        generator.writeStartArray();
        for (String item0 : this.filter) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("script");
        this.script.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupConditionTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        ConditionTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "filter");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.filter.hashCode();
        result = 31 * result + this.script.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionTokenFilter other = (ConditionTokenFilter)o;
        return this.filter.equals(other.filter) && this.script.equals(other.script);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ConditionTokenFilter> {
        private List<String> filter;
        private Script script;

        public Builder() {
        }

        private Builder(ConditionTokenFilter o) {
            super(o);
            this.filter = Builder._listCopy(o.filter);
            this.script = o.script;
        }

        private Builder(Builder o) {
            super(o);
            this.filter = Builder._listCopy(o.filter);
            this.script = o.script;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder filter(List<String> list) {
            this.filter = Builder._listAddAll(this.filter, list);
            return this;
        }

        @Nonnull
        public final Builder filter(String value, String ... values) {
            this.filter = Builder._listAdd(this.filter, value, values);
            return this;
        }

        @Nonnull
        public final Builder script(Script value) {
            this.script = value;
            return this;
        }

        @Nonnull
        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        @Override
        @Nonnull
        public ConditionTokenFilter build() {
            this._checkSingleUse();
            return new ConditionTokenFilter(this);
        }
    }
}

