/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.ActionGroupsV7;

public class FlattenedActionGroups {
    public static final FlattenedActionGroups EMPTY = new FlattenedActionGroups();
    private static final Logger log = LogManager.getLogger(FlattenedActionGroups.class);
    private final ImmutableMap<String, Set<String>> resolvedActionGroups;

    public FlattenedActionGroups(SecurityDynamicConfiguration<ActionGroupsV7> actionGroups) {
        HashMap<String, Set> resolved = new HashMap<String, Set>(actionGroups.getCEntries().size());
        HashMap<String, Set> needsResolution = new HashMap<String, Set>(actionGroups.getCEntries().size());
        for (Map.Entry<String, ActionGroupsV7> entry : actionGroups.getCEntries().entrySet()) {
            String key = entry.getKey();
            Set actions = resolved.computeIfAbsent(key, k -> new HashSet());
            for (String action : entry.getValue().getAllowed_actions()) {
                actions.add(action);
                if (!actionGroups.getCEntries().containsKey(action) || action.equals(key)) continue;
                needsResolution.computeIfAbsent(key, k -> new HashSet()).add(action);
            }
        }
        boolean settled = false;
        int i = 0;
        while (!settled) {
            boolean changed = false;
            for (Map.Entry entry : needsResolution.entrySet()) {
                String key = (String)entry.getKey();
                Set resolvedActions = (Set)resolved.get(key);
                for (String action : (Set)entry.getValue()) {
                    Set mappedActions = (Set)resolved.get(action);
                    changed |= resolvedActions.addAll(mappedActions);
                }
            }
            if (!changed) {
                settled = true;
                if (log.isDebugEnabled()) {
                    log.debug("Action groups settled after {} loops.\nResolved: {}", (Object)i, resolved);
                }
            }
            if (i >= 1000) {
                log.error("Found too deeply nested action groups. Aborting resolution.\nResolved so far: {}", resolved);
                break;
            }
            ++i;
        }
        this.resolvedActionGroups = ImmutableMap.copyOf(resolved);
    }

    public ImmutableSet<String> resolve(Collection<String> actions) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (String action : actions) {
            if (action == null) continue;
            result.add((Object)action);
            Set mappedActions = (Set)this.resolvedActionGroups.get((Object)action);
            if (mappedActions == null) continue;
            result.addAll((Iterable)mappedActions);
        }
        return result.build();
    }

    private FlattenedActionGroups() {
        this.resolvedActionGroups = ImmutableMap.of();
    }

    public String toString() {
        return this.resolvedActionGroups.toString();
    }
}

