﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/ResponseMetadata.h>
#include <aws/ec2/model/TransitGateway.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
class DescribeTransitGatewaysResponse {
 public:
  AWS_EC2_API DescribeTransitGatewaysResponse() = default;
  AWS_EC2_API DescribeTransitGatewaysResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API DescribeTransitGatewaysResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>Information about the transit gateways.</p>
   */
  inline const Aws::Vector<TransitGateway>& GetTransitGateways() const { return m_transitGateways; }
  template <typename TransitGatewaysT = Aws::Vector<TransitGateway>>
  void SetTransitGateways(TransitGatewaysT&& value) {
    m_transitGatewaysHasBeenSet = true;
    m_transitGateways = std::forward<TransitGatewaysT>(value);
  }
  template <typename TransitGatewaysT = Aws::Vector<TransitGateway>>
  DescribeTransitGatewaysResponse& WithTransitGateways(TransitGatewaysT&& value) {
    SetTransitGateways(std::forward<TransitGatewaysT>(value));
    return *this;
  }
  template <typename TransitGatewaysT = TransitGateway>
  DescribeTransitGatewaysResponse& AddTransitGateways(TransitGatewaysT&& value) {
    m_transitGatewaysHasBeenSet = true;
    m_transitGateways.emplace_back(std::forward<TransitGatewaysT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to use to retrieve the next page of results. This value is
   * <code>null</code> when there are no more results to return.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeTransitGatewaysResponse& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DescribeTransitGatewaysResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<TransitGateway> m_transitGateways;

  Aws::String m_nextToken;

  ResponseMetadata m_responseMetadata;
  bool m_transitGatewaysHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
