/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectorSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

@NotThreadSafe
public class DeduplicatingComponentSelectorSerializer
implements Serializer<ComponentSelector> {
    private final ComponentSelectorSerializer delegate;
    private final Map<ComponentSelector, Integer> writeIndex = new HashMap<ComponentSelector, Integer>();
    private final List<ComponentSelector> readIndex = new ArrayList<ComponentSelector>();

    public DeduplicatingComponentSelectorSerializer(ComponentSelectorSerializer delegate) {
        this.delegate = delegate;
    }

    public ComponentSelector read(Decoder decoder) throws Exception {
        ComponentSelector selector;
        int idx = decoder.readSmallInt();
        if (idx == this.readIndex.size()) {
            selector = this.delegate.read(decoder);
            this.readIndex.add(selector);
        } else {
            selector = this.readIndex.get(idx);
        }
        return selector;
    }

    public void write(Encoder encoder, ComponentSelector selector) throws Exception {
        Integer idx = this.writeIndex.get(selector);
        if (idx == null) {
            int index = this.writeIndex.size();
            encoder.writeSmallInt(index);
            this.writeIndex.put(selector, index);
            this.delegate.write(encoder, selector);
        } else {
            encoder.writeSmallInt(idx.intValue());
        }
    }
}

