/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmInlineApplicabilityChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class JvmInlineApplicabilityChecker
implements DeclarationChecker {
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(descriptor instanceof ClassDescriptor)) {
            return;
        }
        AnnotationDescriptor annotation = descriptor.getAnnotations().findAnnotation(InlineClassesUtilsKt.getJVM_INLINE_ANNOTATION_FQ_NAME());
        if (annotation != null && !((ClassDescriptor)descriptor).isValue()) {
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation((AnnotationDescriptor)annotation);
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry = ktAnnotationEntry;
            context.getTrace().report((Diagnostic)ErrorsJvm.JVM_INLINE_WITHOUT_VALUE_CLASS.on((PsiElement)annotationEntry));
        }
        if (((ClassDescriptor)descriptor).isValue() && annotation == null && !((ClassDescriptor)descriptor).isExpect()) {
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.VALUE_KEYWORD)) == null) {
                return;
            }
            KtModifierList valueKeyword = ktModifierList;
            context.getTrace().report((Diagnostic)ErrorsJvm.VALUE_CLASS_WITHOUT_JVM_INLINE_ANNOTATION.on((PsiElement)valueKeyword));
        }
    }
}

