/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Extracts the selected index of the vector that is the input pixel
type.


This filter is templated over the input image type and output image
type.

The filter expect the input image pixel type to be a vector and the
output image pixel type to be a scalar. The only requirement on the
type used for representing the vector is that it must provide an
operator[].


See:
 ComposeImageFilter

 itk::simple::VectorIndexSelectionCast for the procedural interface

 itk::VectorIndexSelectionCastImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkVectorIndexSelectionCastImageFilter.h
*/
public class VectorIndexSelectionCastImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected VectorIndexSelectionCastImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.VectorIndexSelectionCastImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(VectorIndexSelectionCastImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(VectorIndexSelectionCastImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::VectorIndexSelectionCastImageFilter::~VectorIndexSelectionCastImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_VectorIndexSelectionCastImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::VectorIndexSelectionCastImageFilter::VectorIndexSelectionCastImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  VectorIndexSelectionCastImageFilter() {
    this(SimpleITKJNI.new_VectorIndexSelectionCastImageFilter(), true);
  }

  /**
Self&amp; itk::simple::VectorIndexSelectionCastImageFilter::SetIndex(unsigned int Index)

Get/Set methods for the index

*/
public  void setIndex(long Index) {
    SimpleITKJNI.VectorIndexSelectionCastImageFilter_setIndex(swigCPtr, this, Index);
  }

  /**
unsigned int itk::simple::VectorIndexSelectionCastImageFilter::GetIndex() const
*/
public  long getIndex() {
    return SimpleITKJNI.VectorIndexSelectionCastImageFilter_getIndex(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::VectorIndexSelectionCastImageFilter::SetOutputPixelType(PixelIDValueEnum OutputPixelType)

Set the output pixel type of the scalar component to extract.

*/
public  void setOutputPixelType(PixelIDValueEnum OutputPixelType) {
    SimpleITKJNI.VectorIndexSelectionCastImageFilter_setOutputPixelType(swigCPtr, this, OutputPixelType.swigValue());
  }

  /**
PixelIDValueEnum itk::simple::VectorIndexSelectionCastImageFilter::GetOutputPixelType() const

Get the ouput pixel type.

*/
public  PixelIDValueEnum getOutputPixelType() {
    return PixelIDValueEnum.swigToEnum(SimpleITKJNI.VectorIndexSelectionCastImageFilter_getOutputPixelType(swigCPtr, this));
  }

  /**
std::string itk::simple::VectorIndexSelectionCastImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.VectorIndexSelectionCastImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::VectorIndexSelectionCastImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.VectorIndexSelectionCastImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::VectorIndexSelectionCastImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.VectorIndexSelectionCastImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
