/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import java.util.Collections;
import java.util.List;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.Provider;

public interface Authenticator
extends Provider {
    public void authenticate(AuthenticationFlowContext var1);

    public void action(AuthenticationFlowContext var1);

    public boolean requiresUser();

    public boolean configuredFor(KeycloakSession var1, RealmModel var2, UserModel var3);

    public void setRequiredActions(KeycloakSession var1, RealmModel var2, UserModel var3);

    default public List<RequiredActionFactory> getRequiredActions(KeycloakSession session) {
        return Collections.emptyList();
    }

    default public boolean areRequiredActionsEnabled(KeycloakSession session, RealmModel realm) {
        for (RequiredActionFactory raf : this.getRequiredActions(session)) {
            RequiredActionProviderModel rafpm = realm.getRequiredActionProviderByAlias(raf.getId());
            if (rafpm == null) {
                return false;
            }
            if (rafpm.isEnabled()) continue;
            return false;
        }
        return true;
    }
}

