/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.common.VerificationException;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.dpop.DPoP;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AuthorizationRequestContext;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;
import org.keycloak.services.clientpolicy.context.TokenRefreshContext;
import org.keycloak.services.clientpolicy.context.TokenRequestContext;
import org.keycloak.services.clientpolicy.context.TokenRevokeContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.services.util.DPoPUtil;

public class DPoPBindEnforcerExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(DPoPBindEnforcerExecutor.class);
    private final KeycloakSession session;
    private Configuration configuration;

    public DPoPBindEnforcerExecutor(KeycloakSession session) {
        this.session = session;
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "dpop-bind-enforcer";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DPOP)) {
            logger.warnf("DPoP executor is used, but DPOP feature is disabled. So DPOP is not enforced for the clients. Please enable DPOP feature in order to be able to have DPOP checks applied.", new Object[0]);
            return;
        }
        HttpRequest request = this.session.getContext().getHttpRequest();
        switch (context.getEvent()) {
            case REGISTER: 
            case UPDATE: {
                ClientCRUDContext clientUpdateContext = (ClientCRUDContext)context;
                this.autoConfigure(clientUpdateContext.getProposedClientRepresentation());
                this.validate(clientUpdateContext.getProposedClientRepresentation());
                break;
            }
            case AUTHORIZATION_REQUEST: {
                AuthorizationRequestContext authzRequestContext = (AuthorizationRequestContext)context;
                this.checkOnAuthorizationRequest(authzRequestContext);
                break;
            }
            case TOKEN_REQUEST: {
                TokenRequestContext authorizationRequestContext = (TokenRequestContext)context;
                this.validateAndBindOnlyRefreshToken(authorizationRequestContext.getClient());
                break;
            }
            case TOKEN_REFRESH: {
                TokenRefreshContext tokenRefreshContext = (TokenRefreshContext)context;
                this.validateAndBindOnlyRefreshToken(tokenRefreshContext.getClient());
                break;
            }
            case USERINFO_REQUEST: 
            case BACKCHANNEL_TOKEN_REQUEST: {
                if (request.getHttpHeaders().getHeaderString("DPoP") != null) break;
                throw new ClientPolicyException("invalid_dpop_proof", "DPoP proof is missing");
            }
            case TOKEN_REVOKE: {
                this.checkTokenRevoke((TokenRevokeContext)context, request);
            }
            default: {
                return;
            }
        }
    }

    private void autoConfigure(ClientRepresentation rep) {
        if (this.configuration.isAutoConfigure().booleanValue()) {
            OIDCAdvancedConfigWrapper.fromClientRepresentation(rep).setUseDPoP(true);
        }
    }

    private void validate(ClientRepresentation rep) throws ClientPolicyException {
        boolean useDPoPToken = OIDCAdvancedConfigWrapper.fromClientRepresentation(rep).isUseDPoP();
        if (!useDPoPToken) {
            throw new ClientPolicyException("invalid_client_metadata", "Invalid client metadata: DPoP token in disabled");
        }
    }

    private void checkTokenRevoke(TokenRevokeContext context, HttpRequest request) throws ClientPolicyException {
        DPoP dPoP = this.retrieveAndVerifyDPoP(request);
        MultivaluedMap<String, String> revokeParameters = context.getParams();
        String encodedRevokeToken = (String)revokeParameters.getFirst((Object)"token");
        AccessToken token = (AccessToken)this.session.tokens().decode(encodedRevokeToken, AccessToken.class);
        if (token == null) {
            return;
        }
        this.validateBinding(token, dPoP);
    }

    private void validateAndBindOnlyRefreshToken(ClientModel client) throws ClientPolicyException {
        boolean useDPoPToken = OIDCAdvancedConfigWrapper.fromClientModel(client).isUseDPoP();
        if (useDPoPToken || this.configuration.getAllowOnlyRefreshTokenBinding() == null || !this.configuration.getAllowOnlyRefreshTokenBinding().booleanValue() || !client.isPublicClient()) {
            return;
        }
        DPoP dPoP = (DPoP)this.session.getAttribute("dpop", DPoP.class);
        if (dPoP == null) {
            throw new ClientPolicyException("invalid_dpop_proof", "DPoP proof is missing");
        }
        this.session.setAttribute("dpop-binding-only-refresh-token", (Object)true);
    }

    private void checkOnAuthorizationRequest(AuthorizationRequestContext authzRequestContext) throws ClientPolicyException {
        if (this.configuration.getEnforceAuthorizationCodeBindingToDpop() != null && this.configuration.getEnforceAuthorizationCodeBindingToDpop().booleanValue() && authzRequestContext.getAuthorizationEndpointRequest().getDpopJkt() == null) {
            throw new ClientPolicyException("invalid_request", "Missing parameter: dpop_jkt");
        }
    }

    private DPoP retrieveAndVerifyDPoP(HttpRequest request) throws ClientPolicyException {
        DPoP dPoP = null;
        try {
            dPoP = new DPoPUtil.Validator(this.session).request(request).uriInfo((UriInfo)this.session.getContext().getUri()).validate();
        }
        catch (VerificationException ex) {
            logger.tracev("dpop verification error = {0}", (Object)ex.getMessage());
            throw new ClientPolicyException("invalid_dpop_proof", ex.getMessage());
        }
        return dPoP;
    }

    private void validateBinding(AccessToken token, DPoP dPoP) throws ClientPolicyException {
        try {
            DPoPUtil.validateBinding(token, dPoP);
        }
        catch (VerificationException ex) {
            logger.tracev("dpop bind refresh token verification error = {0}", (Object)ex.getMessage());
            throw new ClientPolicyException("invalid_token", "DPoP proof and token binding verification failed");
        }
    }

    public static class Configuration
    extends ClientPolicyExecutorConfigurationRepresentation {
        @JsonProperty(value="auto-configure")
        protected Boolean autoConfigure;
        @JsonProperty(value="enforce-authorization-code-binding-to-dpop")
        protected Boolean enforceAuthorizationCodeBindingToDpop;
        @JsonProperty(value="allow-only-refresh-token-binding")
        protected Boolean allowOnlyRefreshTokenBinding;

        public Boolean isAutoConfigure() {
            return this.autoConfigure;
        }

        public void setAutoConfigure(Boolean autoConfigure) {
            this.autoConfigure = autoConfigure;
        }

        public Boolean getEnforceAuthorizationCodeBindingToDpop() {
            return this.enforceAuthorizationCodeBindingToDpop;
        }

        public void setEnforceAuthorizationCodeBindingToDpop(Boolean enforceAuthorizationCodeBindingToDpop) {
            this.enforceAuthorizationCodeBindingToDpop = enforceAuthorizationCodeBindingToDpop;
        }

        public Boolean getAllowOnlyRefreshTokenBinding() {
            return this.allowOnlyRefreshTokenBinding;
        }

        public void setAllowOnlyRefreshTokenBinding(Boolean allowOnlyRefreshTokenBinding) {
            this.allowOnlyRefreshTokenBinding = allowOnlyRefreshTokenBinding;
        }
    }
}

