import { RemoteUser } from "matrix-appservice-bridge";
import { IrcServer } from "../irc/IrcServer";
export declare class IrcUser extends RemoteUser {
    readonly server: IrcServer;
    readonly nick: string;
    readonly isVirtual: boolean;
    readonly password: string | null;
    /**
     * Construct a new IRC user.
     * @constructor
     * @param {IrcServer} server : The IRC server the user is on.
     * @param {string} nick : The nick for this user.
     * @param {boolean} isVirtual : True if the user is not a real IRC user.
     * @param {string} password : The password to give to NickServ.
     * @param {string} username : The username of the client (for ident)
     */
    constructor(server: IrcServer, nick: string, isVirtual: boolean, password?: string | null, username?: string | null);
    getUsername(): string;
    toString(): string;
}
