/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.lang;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.lang.LangCode;
import org.protege.editor.owl.model.lang.LangCodesResource;

public class LangCodeRegistry {
    private ImmutableMap<String, LangCode> registry;
    private ImmutableList<LangCode> langCodes;

    private LangCodeRegistry(@Nonnull ImmutableList<LangCode> langCodes, @Nonnull ImmutableMap<String, LangCode> registry) {
        this.langCodes = (ImmutableList)Preconditions.checkNotNull(langCodes);
        this.registry = (ImmutableMap)Preconditions.checkNotNull(registry);
    }

    public Optional<LangCode> getLangCode(@Nonnull String langCode) {
        return Optional.ofNullable((LangCode)this.registry.get((Object)langCode));
    }

    public static LangCodeRegistry get() {
        ImmutableList<LangCode> langCodes = LangCodesResource.getLangCodes();
        ImmutableMap.Builder registryBuilder = ImmutableMap.builder();
        langCodes.forEach(lc -> registryBuilder.put((Object)lc.getLangCode().toLowerCase(), lc));
        return new LangCodeRegistry(langCodes, (ImmutableMap<String, LangCode>)registryBuilder.build());
    }

    public ImmutableList<LangCode> getLangCodes() {
        return this.langCodes;
    }
}

