#!/bin/bash
currentMode=$1
changeConfig=1
changeDesktop=1
domesticVersion=0
if [ -e '/usr/share/mime/packages/custom-wps-office.xml' ]; then
	domesticVersion=1
fi

if [ -e '/opt/apps/cn.wps.wps-office-pro/files/kingsoft/wps-office/office6/wps' ]; then
	InstallPath="/opt/apps/cn.wps.wps-office-pro/files/kingsoft/wps-office"
elif [ -e '/opt/apps/cn.wps.wps-office/files/kingsoft/wps-office/office6/wps' ]; then
	InstallPath="/opt/apps/cn.wps.wps-office/files/kingsoft/wps-office"
else 
	InstallPath="/opt/kingsoft/wps-office"
fi

UserName=`echo $USER`
gDesktopName="桌面"
UserPath=""
if [ ${UserName} = "root" ] ; then
	UserPath="/root"
else
	UserPath="/home/${UserName}"
fi

if [ -f "${UserPath}/.config/user-dirs.dirs" ]; then
	source "${UserPath}/.config/user-dirs.dirs"
	if [ ! -d "${XDG_DESKTOP_DIR}" ]; then
		mkdir -p "${XDG_DESKTOP_DIR}" >/dev/null 2>&1 || true
	fi
	gDesktopName="${XDG_DESKTOP_DIR//${HOME}\//}"
else 
	if [ -d "${UserPath}/桌面" ]; then
		gDesktopName="桌面"
	elif [ -d "${UserPath}/Desktop" ]; then
		gDesktopName="Desktop"
	fi
fi
if [ ! -d "${UserPath}/${gDesktopName}" ]; then
	mkdir -p "${UserPath}/${gDesktopName}"
fi

common_word_mimes=('text/rtf' 'application/rtf' 'application/msword' 'application/x-msword' 'application/wordperfect' 'application/vnd.ms-word' 'application/msword-template' 'application/vnd.wordperfect' 'application/vnd.sun.xml.writer' 'application/vnd.sun.xml.writer.global' 'application/vnd.sun.xml.writer.template' 'application/vnd.oasis.opendocument.text' 'application/vnd.oasis.opendocument.text-template' 'application/vnd.openxmlformats-officedocument.wordprocessingml.document' 'application/vnd.openxmlformats-officedocument.wordprocessingml.template')

common_ppt_mimes=('application/powerpoint' 'application/mspowerpoint' 'application/x-mspowerpoint' 'application/vnd.mspowerpoint' 'application/vnd.ms-powerpoint' 'application/vnd.sun.xml.impress' 'application/vnd.stardivision.impress' 'application/vnd.sun.xml.impress.template' 'application/vnd.oasis.opendocument.presentation' 'application/vnd.oasis.opendocument.presentation-template' 'application/vnd.openxmlformats-officedocument.presentationml.slide' 'application/vnd.openxmlformats-officedocument.presentationml.template' 'application/vnd.openxmlformats-officedocument.presentationml.slideshow' 'application/vnd.openxmlformats-officedocument.presentationml.presentation')

common_excel_mimes=('text/csv' 'application/xls' 'application/csv' 'text/spreadsheet' 'application/x-123' 'application/x-xls' 'application/excel' 'application/x-oleo' 'application/msexcel' 'application/x-msexcel' 'application/x-ms-excel' 'application/vnd.ms-excel' 'application/x-quattropro' 'application/x-planperfect' 'application/x-dos_ms_excel' 'text/comma-separated-values' 'application/vnd.sun.xml.calc' 'text/x-comma-separated-values' 'application/x-applix-spreadsheet' 'application/tab-separated-values' 'application/vnd.stardivision.calc' 'application/vnd.sun.xml.calc.template' 'application/vnd.oasis.opendocument.spreadsheet' 'application/vnd.oasis.opendocument.spreadsheet-template' 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' 'application/vnd.openxmlformats-officedocument.spreadsheetml.template' 'application/vnd.lotus-1-2-3' 'application/x-excel' 'application/x-mps' 'application/x-sc' 'application/x-sylk' 'application/x-xbase' 'text/tab-separated-values' 'zz-application/zz-winassoc-xls')

common_pdf_mimes=('application/pdf' 'application/wps-office.pdf')

common_ofd_mimes=('application/wps-office.ofd')
common_flow_mimes=('application/wps-office.pos')
common_mind_mimes=('application/wps-office.pof')

wps_word_mimes=('application/wps-office.doc' 'application/wps-office.dot' 'application/wps-office.dotx' 'application/wps-office.docx' 'application/wps-office.wps' 'application/wps-office.wpt' 'application/wps-office.wpss' 'application/wps-office.wpso')
wps_ppt_mimes=('application/wps-office.ppt' 'application/wps-office.pptx' 'application/wps-office.pot' 'application/wps-office.potx' 'application/wps-office.dps' 'application/wps-office.dpt' 'application/wps-office.dpss' 'application/wps-office.dpso')
wps_excel_mimes=('application/wps-office.xls' 'application/wps-office.xlt' 'application/wps-office.xlsx' 'application/wps-office.xltx' 'application/wps-office.et' 'application/wps-office.ett' 'application/wps-office.ets' 'application/wps-office.eto')

function restore_mimeapp_config()
{
	mimetype=$1
	defaulttype=$2
	configFilePath=$3
	touch $configFilePath
	if type python3 >/dev/null 2>&1 ; then
	python3 - <<END
import configparser
section = 'Default Applications'
inifilepath = '$configFilePath'
config = configparser.ConfigParser(strict=False)
config.read(inifilepath)
allmime = ""
for indexc in '$mimetype':
	allmime += indexc
for onemime in allmime.split(' '):
	if config.has_section(section):
			if config.has_option(section,onemime):
					appstr = config[section][onemime]
					apps = appstr.split(';')
					appcount = len(apps)
					if appcount == 1:
							if apps[0] == '$defaulttype':
									config.remove_option(section,onemime)
					else:
							if '$defaulttype' in apps:
									apps.remove('$defaulttype')
							appstr = '++'.join(apps)
							config[section][onemime] = appstr
	with open(inifilepath, 'w') as configfile:
			config.write(configfile, space_around_delimiters=False)
END
	elif type python2 >/dev/null 2>&1 ; then
	python2 - <<END
import ConfigParser
section = 'Default Applications'
inifilepath = '$configFilePath'
config = ConfigParser.ConfigParser()
config.read(inifilepath)
allmime = ""
for indexc in '$mimetype':
	allmime += indexc
for onemime in allmime.split(' '):
	if config.has_section(section):
			if config.has_option(section,onemime):
					appstr = config[section][onemime]
					apps = appstr.split(';')
					appcount = len(apps)
					if appcount == 1:
							if apps[0] == '$defaulttype':
									config.remove_option(section,onemime)
					else:
							if '$defaulttype' in apps:
									apps.remove('$defaulttype')
							appstr = '++'.join(apps)
							config[section][onemime] = appstr
	with open(inifilepath, 'w') as configfile:
			config.write(configfile)
END
        fi
}

function write_mimeapp_config()
{
	mimetype=$1
	defaulttype=$2
	configFilePath=$3
	touch $configFilePath
	if type python3 >/dev/null 2>&1 ; then
	python3 - <<END
import configparser
section = 'Default Applications'
inifilepath = '$configFilePath'
config = configparser.ConfigParser(strict=False)
config.read(inifilepath)
allmime = ""
for indexc in '$mimetype':
	allmime += indexc
for onemime in allmime.split(' '):
	if config.has_section(section):
			if config.has_option(section,onemime):
					appstr = config[section][onemime]
					if 'wpspdf.desktop' not in appstr:
							config[section][onemime] = '$defaulttype'
			else:
					config[section][onemime] = '$defaulttype'
	else:
			config.add_section(section)
			config[section][onemime] = '$defaulttype'
	with open(inifilepath, 'w') as configfile:
			config.write(configfile, space_around_delimiters=False)
END
	elif type python2 >/dev/null 2>&1 ; then
	python2 - <<END
import ConfigParser
section = 'Default Applications'
inifilepath = '$configFilePath'
config = ConfigParser.ConfigParser()
config.read(inifilepath)
allmime = ""
for indexc in '$mimetype':
	allmime += indexc
for onemime in allmime.split(' '):
	if config.has_section(section):
			if config.has_option(section,onemime):
					appstr = config.get(section, onemime)
					if 'wpspdf.desktop' not in appstr:
							config.set(section, onemime, '$defaulttype')
			else:
					config.set(section, onemime, '$defaulttype')
	else:
			config.add_section(section)
			config.set(section, onemime, '$defaulttype')
	with open(inifilepath, 'w') as configfile:
			config.write(configfile)
END
		fi
}

function copy_install_to_desktop()
{
	if [ $# -ne 1 ] ; then
		return;
	fi
	WpsDesktopName=$1
	if [ -e "${InstallPath}/desktops/${WpsDesktopName}" ]; then
		cp -f "${InstallPath}/desktops/${WpsDesktopName}" "${UserPath}/${gDesktopName}/${WpsDesktopName}"
		if test $? -eq 0; then
			chmod +x "${UserPath}/${gDesktopName}/${WpsDesktopName}"
			chown ${UserName} "${UserPath}/${gDesktopName}/${WpsDesktopName}"
		fi
	fi
	
}

function changeMode()
{
	if [ $# -ne 1 ] ; then
		echo "exit 1"
		exit 1
	fi
	if [ $1 = "fusion" ] ; then
		#整合
		if [ -d "${UserPath}/.config" ] && [ $changeConfig -eq 1 ]; then
			write_mimeapp_config "${common_excel_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			write_mimeapp_config "${wps_excel_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			write_mimeapp_config "${common_ppt_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			write_mimeapp_config "${wps_ppt_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			write_mimeapp_config "${common_word_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			write_mimeapp_config "${wps_word_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			if [ $domesticVersion -eq 1 ]; then
				write_mimeapp_config "${common_pdf_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			fi
			if [ -e "${InstallPath}/desktops/wps-office-ofd.desktop" ]; then
				write_mimeapp_config "${common_ofd_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			fi
			if [ -e "${InstallPath}/desktops/wps-office-flow.desktop" ]; then
				write_mimeapp_config "${common_flow_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			fi
			if [ -e "${InstallPath}/desktops/wps-office-mind.desktop" ]; then
				write_mimeapp_config "${common_mind_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			fi
		fi
		if [ -d "${InstallPath}/desktops" ] && [ $changeDesktop -eq 1 ]; then
			rm -rf ${UserPath}/${gDesktopName}/wps-office-wps.desktop
			rm -rf ${UserPath}/${gDesktopName}/wps-office-et.desktop
			rm -rf ${UserPath}/${gDesktopName}/wps-office-wpp.desktop
			rm -rf ${UserPath}/${gDesktopName}/wps-office-pdf.desktop
			rm -rf ${UserPath}/${gDesktopName}/wps-office-ofd.desktop
			rm -rf ${UserPath}/${gDesktopName}/wps-office-mind.desktop
			rm -rf ${UserPath}/${gDesktopName}/wps-office-flow.desktop
			rm -rf ${UserPath}/${gDesktopName}/wps-office-official.desktop
			rm -rf ${UserPath}/${gDesktopName}/wps-office-prometheus.desktop
			copy_install_to_desktop "wps-office-prometheus.desktop"
		fi
	else
		#多组建
		if [ -d "${UserPath}/.config" ] && [ $changeConfig -eq 1 ]; then
			restore_mimeapp_config "${common_excel_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			restore_mimeapp_config "${wps_excel_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			restore_mimeapp_config "${common_ppt_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			restore_mimeapp_config "${wps_ppt_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			restore_mimeapp_config "${common_word_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			restore_mimeapp_config "${wps_word_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			if [ $domesticVersion -eq 1 ]; then
				restore_mimeapp_config "${common_pdf_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			fi
			if [ -e "${InstallPath}/desktops/wps-office-ofd.desktop" ]; then
				restore_mimeapp_config "${common_ofd_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			fi
			if [ -e "${InstallPath}/desktops/wps-office-flow.desktop" ]; then
				restore_mimeapp_config "${common_flow_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			fi
			if [ -e "${InstallPath}/desktops/wps-office-mind.desktop" ]; then
				restore_mimeapp_config "${common_mind_mimes[*]}" "wps-office-prometheus.desktop" "${UserPath}/.config/mimeapps.list"
			fi
		fi
		if [ -d "${InstallPath}/desktops" ] && [ $changeDesktop -eq 1 ]; then
			rm -rf ${UserPath}/${gDesktopName}/wps-office-wps.desktop
			rm -rf ${UserPath}/${gDesktopName}/wps-office-et.desktop
			rm -rf ${UserPath}/${gDesktopName}/wps-office-wpp.desktop
			rm -rf ${UserPath}/${gDesktopName}/wps-office-pdf.desktop
			rm -rf ${UserPath}/${gDesktopName}/wps-office-ofd.desktop
			rm -rf ${UserPath}/${gDesktopName}/wps-office-mind.desktop
			rm -rf ${UserPath}/${gDesktopName}/wps-office-flow.desktop
			rm -rf ${UserPath}/${gDesktopName}/wps-office-official.desktop
			rm -rf ${UserPath}/${gDesktopName}/wps-office-prometheus.desktop
			copy_install_to_desktop "wps-office-ofd.desktop"
			copy_install_to_desktop "wps-office-mind.desktop"
			copy_install_to_desktop "wps-office-flow.desktop"
			copy_install_to_desktop "wps-office-pdf.desktop"
			copy_install_to_desktop "wps-office-et.desktop"
			copy_install_to_desktop "wps-office-wpp.desktop"
			copy_install_to_desktop "wps-office-wps.desktop"
			copy_install_to_desktop "wps-office-official.desktop"
		fi
	fi
}

changeMode ${currentMode}
