function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { OuiScreenReaderOnly } from '../accessibility';
import { OuiIcon } from '../icon';
import { resolveWidthAsStyle } from './utils';
import { OuiInnerText } from '../inner_text';
import { LEFT_ALIGNMENT, RIGHT_ALIGNMENT, CENTER_ALIGNMENT } from '../../services';
import { OuiI18n } from '../i18n';
var CellContents = function CellContents(_ref) {
  var className = _ref.className,
    description = _ref.description,
    children = _ref.children,
    isSorted = _ref.isSorted,
    isSortAscending = _ref.isSortAscending,
    showSortMsg = _ref.showSortMsg;
  return /*#__PURE__*/React.createElement("span", {
    className: className
  }, /*#__PURE__*/React.createElement(OuiInnerText, null, function (ref, innerText) {
    return /*#__PURE__*/React.createElement(OuiI18n, {
      token: "ouiTableHeaderCell.titleTextWithDesc",
      default: "{innerText}; {description}",
      values: {
        innerText: innerText,
        description: description
      }
    }, function (titleTextWithDesc) {
      return /*#__PURE__*/React.createElement("span", {
        title: description ? titleTextWithDesc : innerText,
        ref: ref,
        className: "ouiTableCellContent__text"
      }, children);
    });
  }), description && /*#__PURE__*/React.createElement(OuiScreenReaderOnly, null, /*#__PURE__*/React.createElement("span", null, description)), showSortMsg && isSorted && /*#__PURE__*/React.createElement(OuiIcon, {
    className: "ouiTableSortIcon",
    type: isSortAscending ? 'sortUp' : 'sortDown',
    size: "m"
  }));
};
export var OuiTableHeaderCell = function OuiTableHeaderCell(_ref2) {
  var children = _ref2.children,
    _ref2$align = _ref2.align,
    align = _ref2$align === void 0 ? LEFT_ALIGNMENT : _ref2$align,
    onSort = _ref2.onSort,
    isSorted = _ref2.isSorted,
    isSortAscending = _ref2.isSortAscending,
    className = _ref2.className,
    _ref2$scope = _ref2.scope,
    scope = _ref2$scope === void 0 ? 'col' : _ref2$scope,
    _ref2$mobileOptions = _ref2.mobileOptions,
    mobileOptions = _ref2$mobileOptions === void 0 ? {
      show: true
    } : _ref2$mobileOptions,
    width = _ref2.width,
    style = _ref2.style,
    readOnly = _ref2.readOnly,
    isMobileHeader = _ref2.isMobileHeader,
    hideForMobile = _ref2.hideForMobile,
    description = _ref2.description,
    rest = _objectWithoutProperties(_ref2, ["children", "align", "onSort", "isSorted", "isSortAscending", "className", "scope", "mobileOptions", "width", "style", "readOnly", "isMobileHeader", "hideForMobile", "description"]);
  var classes = classNames('ouiTableHeaderCell', className, {
    'ouiTableHeaderCell--hideForDesktop': mobileOptions.only || isMobileHeader,
    'ouiTableHeaderCell--hideForMobile': !mobileOptions.show || hideForMobile
  });
  var contentClasses = classNames('ouiTableCellContent', className, {
    'ouiTableCellContent--alignRight': align === RIGHT_ALIGNMENT,
    'ouiTableCellContent--alignCenter': align === CENTER_ALIGNMENT
  });
  var styleObj = resolveWidthAsStyle(style, width);
  var CellComponent = children ? 'th' : 'td';
  if (onSort || isSorted) {
    var buttonClasses = classNames('ouiTableHeaderButton', {
      'ouiTableHeaderButton-isSorted': isSorted
    });
    var ariaSortValue = 'none';
    if (isSorted) {
      ariaSortValue = isSortAscending ? 'ascending' : 'descending';
    }
    var cellContents = /*#__PURE__*/React.createElement(CellContents, {
      className: contentClasses,
      description: description,
      showSortMsg: true,
      children: children,
      isSorted: isSorted,
      isSortAscending: isSortAscending
    });
    return /*#__PURE__*/React.createElement(CellComponent, _extends({
      className: classes,
      scope: scope,
      role: "columnheader",
      "aria-sort": ariaSortValue,
      "aria-live": "polite",
      style: styleObj
    }, rest), onSort && !readOnly ? /*#__PURE__*/React.createElement("button", {
      type: "button",
      className: buttonClasses,
      onClick: onSort,
      "data-test-subj": "tableHeaderSortButton"
    }, cellContents) : cellContents);
  }
  return /*#__PURE__*/React.createElement(CellComponent, _extends({
    className: classes,
    scope: scope,
    role: "columnheader",
    style: styleObj
  }, rest), /*#__PURE__*/React.createElement(CellContents, {
    className: contentClasses,
    description: description,
    showSortMsg: false,
    children: children,
    isSorted: isSorted,
    isSortAscending: isSortAscending
  }));
};

/* OUI -> EUI Aliases: Build-Time */
OuiTableHeaderCell.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  align: PropTypes.oneOf(["left", "right", "center"]),
  /**
       * _DEPRECATED: use `mobileOptions.show = false`_ Indicates if the
       * column should not show for mobile users (typically hidden because a
       * custom mobile header utilizes the column's contents)
       */
  hideForMobile: PropTypes.bool,
  /**
       * _DEPRECATED: use `mobileOptions.only = true`_ Indicates if the
       * column was created to be the row's heading in mobile view (this
       * column will be hidden at larger screens)
       */
  isMobileHeader: PropTypes.bool,
  isSortAscending: PropTypes.bool,
  isSorted: PropTypes.bool,
  /**
       * Mobile options for displaying differently at small screens
       */
  mobileOptions: PropTypes.shape({
    /**
           * If false, will not render the column at all for mobile
           */
    show: PropTypes.bool,
    /**
           * Only show for mobile? If true, will not render the column at all
           * for desktop
           */
    only: PropTypes.bool
  }),
  onSort: PropTypes.func,
  scope: PropTypes.oneOf(["col", "row", "colgroup", "rowgroup"]),
  width: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.number.isRequired]),
  description: PropTypes.string,
  /**
       * Shows the sort indicator but removes the button
       */
  readOnly: PropTypes.bool
};
/* OUI -> EUI Aliases: Build-Time */export { EuiTableHeaderCell } from '../../eui_components/table/table_header_cell';