/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search.lucene;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Scorable;

public final class MultiLeafFieldComparator
implements LeafFieldComparator {
    private final LeafFieldComparator[] comparators;
    private final int[] reverseMul;
    private final LeafFieldComparator firstComparator;
    private final int firstReverseMul;

    public MultiLeafFieldComparator(LeafFieldComparator[] comparators, int[] reverseMul) {
        if (comparators.length != reverseMul.length) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Must have the same number of comparators and reverseMul, got %s and %s", comparators.length, reverseMul.length));
        }
        this.comparators = comparators;
        this.reverseMul = reverseMul;
        this.firstComparator = comparators[0];
        this.firstReverseMul = reverseMul[0];
    }

    public void setBottom(int slot) throws IOException {
        for (LeafFieldComparator comparator : this.comparators) {
            comparator.setBottom(slot);
        }
    }

    public int compareBottom(int doc) throws IOException {
        int comparison = this.firstReverseMul * this.firstComparator.compareBottom(doc);
        if (comparison != 0) {
            return comparison;
        }
        for (int i = 1; i < this.comparators.length; ++i) {
            comparison = this.reverseMul[i] * this.comparators[i].compareBottom(doc);
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    public int compareTop(int doc) throws IOException {
        int comparison = this.firstReverseMul * this.firstComparator.compareTop(doc);
        if (comparison != 0) {
            return comparison;
        }
        for (int i = 1; i < this.comparators.length; ++i) {
            comparison = this.reverseMul[i] * this.comparators[i].compareTop(doc);
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    public void copy(int slot, int doc) throws IOException {
        for (LeafFieldComparator comparator : this.comparators) {
            comparator.copy(slot, doc);
        }
    }

    public void setScorer(Scorable scorer) throws IOException {
        for (LeafFieldComparator comparator : this.comparators) {
            comparator.setScorer(scorer);
        }
    }

    public void setHitsThresholdReached() throws IOException {
        this.firstComparator.setHitsThresholdReached();
    }

    public DocIdSetIterator competitiveIterator() throws IOException {
        return this.firstComparator.competitiveIterator();
    }
}

