/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.Component3DManager;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.TextureImage;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.AutoCommitSpinner;
import com.eteks.sweethome3d.swing.FontNameComboBox;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.UserPreferencesController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.security.AccessControlException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractSpinnerModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UserPreferencesPanel
extends JPanel
implements DialogView {
    private final UserPreferencesController controller;
    private JLabel languageLabel;
    private JComboBox languageComboBox;
    private JButton languageLibraryImportButton;
    private JLabel unitLabel;
    private JComboBox unitComboBox;
    private JLabel currencyLabel;
    private JComboBox currencyComboBox;
    private JCheckBox valueAddedTaxCheckBox;
    private JLabel furnitureCatalogViewLabel;
    private JRadioButton treeRadioButton;
    private JRadioButton listRadioButton;
    private JLabel navigationPanelLabel;
    private JCheckBox navigationPanelCheckBox;
    private JLabel editingIn3DViewLabel;
    private JCheckBox editingIn3DViewCheckBox;
    private JLabel aerialViewCenteredOnSelectionLabel;
    private JCheckBox aerialViewCenteredOnSelectionCheckBox;
    private JLabel observerCameraSelectedAtChangeLabel;
    private JCheckBox observerCameraSelectedAtChangeCheckBox;
    private JLabel magnetismLabel;
    private JCheckBox magnetismCheckBox;
    private JLabel rulersLabel;
    private JCheckBox rulersCheckBox;
    private JLabel gridLabel;
    private JCheckBox gridCheckBox;
    private JLabel defaultFontNameLabel;
    private FontNameComboBox defaultFontNameComboBox;
    private JLabel furnitureIconLabel;
    private JRadioButton catalogIconRadioButton;
    private JRadioButton topViewRadioButton;
    private JLabel iconSizeLabel;
    private JComboBox iconSizeComboBox;
    private JLabel roomRenderingLabel;
    private JRadioButton monochromeRadioButton;
    private JRadioButton floorColorOrTextureRadioButton;
    private JLabel wallPatternLabel;
    private JComboBox wallPatternComboBox;
    private JLabel newWallPatternLabel;
    private JComboBox newWallPatternComboBox;
    private JLabel newWallThicknessLabel;
    private JSpinner newWallThicknessSpinner;
    private JLabel newWallHeightLabel;
    private JSpinner newWallHeightSpinner;
    private JLabel newFloorThicknessLabel;
    private JSpinner newFloorThicknessSpinner;
    private JCheckBox checkUpdatesCheckBox;
    private JButton checkUpdatesNowButton;
    private JCheckBox autoSaveDelayForRecoveryCheckBox;
    private JSpinner autoSaveDelayForRecoverySpinner;
    private JLabel autoSaveDelayForRecoveryUnitLabel;
    private JButton resetDisplayedActionTipsButton;
    private String dialogTitle;

    public UserPreferencesPanel(UserPreferences userPreferences, UserPreferencesController userPreferencesController) {
        super(new GridBagLayout());
        this.controller = userPreferencesController;
        this.createComponents(userPreferences, userPreferencesController);
        this.setMnemonics(userPreferences);
        this.layoutComponents();
    }

    private void createComponents(UserPreferences userPreferences, final UserPreferencesController userPreferencesController) {
        boolean bl;
        Object object;
        Object object2;
        Serializable serializable;
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.LANGUAGE)) {
            this.languageLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "languageLabel.text", new Object[0]));
            this.languageComboBox = new JComboBox<String>(new DefaultComboBoxModel<String>(userPreferences.getSupportedLanguages()));
            this.languageComboBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    String string = (String)object;
                    int n2 = string.indexOf("_");
                    Locale locale = n2 != -1 ? new Locale(string.substring(0, n2), string.substring(n2 + 1)) : new Locale(string);
                    String string2 = locale.getDisplayLanguage(locale);
                    string2 = Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
                    if (n2 != -1) {
                        string2 = string2 + " - " + locale.getDisplayCountry(locale);
                    }
                    return super.getListCellRendererComponent((JList<?>)jList, string2, n, bl, bl2);
                }
            });
            this.languageComboBox.setMaximumRowCount(Integer.MAX_VALUE);
            this.languageComboBox.setSelectedItem(userPreferencesController.getLanguage());
            this.languageComboBox.addItemListener(new ItemListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        userPreferencesController.setLanguage((String)this.this$0.languageComboBox.getSelectedItem());
                    }
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.LANGUAGE, new PropertyChangeListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.languageComboBox.setSelectedItem(userPreferencesController.getLanguage());
                }
            });
            userPreferences.addPropertyChangeListener(UserPreferences.Property.SUPPORTED_LANGUAGES, new SupportedLanguagesChangeListener(this));
        }
        if (userPreferencesController.mayImportLanguageLibrary()) {
            this.languageLibraryImportButton = new JButton(new ResourceAction(this, userPreferences, UserPreferencesPanel.class, "IMPORT_LANGUAGE_LIBRARY", true){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                    super(userPreferences, clazz, string, bl);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    userPreferencesController.importLanguageLibrary();
                }
            });
            this.languageLibraryImportButton.setToolTipText(userPreferences.getLocalizedString(UserPreferencesPanel.class, "IMPORT_LANGUAGE_LIBRARY.tooltip", new Object[0]));
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.UNIT)) {
            this.unitLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "unitLabel.text", new Object[0]));
            this.unitComboBox = new JComboBox<LengthUnit>(LengthUnit.values());
            serializable = new HashMap();
            serializable.put(LengthUnit.MILLIMETER, userPreferences.getLocalizedString(UserPreferencesPanel.class, "unitComboBox.millimeter.text", new Object[0]));
            serializable.put(LengthUnit.CENTIMETER, userPreferences.getLocalizedString(UserPreferencesPanel.class, "unitComboBox.centimeter.text", new Object[0]));
            serializable.put(LengthUnit.METER, userPreferences.getLocalizedString(UserPreferencesPanel.class, "unitComboBox.meter.text", new Object[0]));
            serializable.put(LengthUnit.INCH, userPreferences.getLocalizedString(UserPreferencesPanel.class, "unitComboBox.inch.text", new Object[0]));
            serializable.put(LengthUnit.INCH_FRACTION, userPreferences.getLocalizedString(UserPreferencesPanel.class, "unitComboBox.inchFraction.text", new Object[0]));
            serializable.put(LengthUnit.INCH_DECIMALS, userPreferences.getLocalizedString(UserPreferencesPanel.class, "unitComboBox.inchDecimals.text", new Object[0]));
            serializable.put(LengthUnit.FOOT_DECIMALS, userPreferences.getLocalizedString(UserPreferencesPanel.class, "unitComboBox.footDecimals.text", new Object[0]));
            this.unitComboBox.setRenderer(new DefaultListCellRenderer(this, (Map)((Object)serializable)){
                final /* synthetic */ Map val$comboBoxTexts;
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.val$comboBoxTexts = map;
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    return super.getListCellRendererComponent((JList<?>)jList, this.val$comboBoxTexts.get(object), n, bl, bl2);
                }
            });
            this.unitComboBox.setSelectedItem((Object)userPreferencesController.getUnit());
            this.unitComboBox.addItemListener(new ItemListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setUnit((LengthUnit)((Object)this.this$0.unitComboBox.getSelectedItem()));
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.UNIT, new PropertyChangeListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.unitComboBox.setSelectedItem((Object)userPreferencesController.getUnit());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.CURRENCY)) {
            Currency currency;
            this.currencyLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "currencyLabel.text", new Object[0]));
            serializable = new HashMap<Object, String>();
            for (Locale object32 : Locale.getAvailableLocales()) {
                try {
                    Currency illegalArgumentException = Currency.getInstance(object32);
                    if (serializable.get(illegalArgumentException.getCurrencyCode()) != null && ((String)serializable.get(illegalArgumentException.getCurrencyCode())).length() <= illegalArgumentException.getSymbol(object32).length()) continue;
                    serializable.put(illegalArgumentException.getCurrencyCode(), illegalArgumentException.getSymbol(object32));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            object2 = new Vector(serializable.keySet());
            Collections.sort(object2);
            object = Locale.getDefault();
            Currency currency2 = currency = ((Locale)object).getCountry() != null && ((Locale)object).getCountry().length() == 2 ? Currency.getInstance((Locale)object) : null;
            if (currency != null) {
                ((Vector)object2).add(0, currency.getCurrencyCode());
            }
            ((Vector)object2).add(0, null);
            this.currencyComboBox = new JComboBox(object2);
            final String string = userPreferences.getLocalizedString(UserPreferencesPanel.class, "currencyComboBox.noCurrency.text", new Object[0]);
            this.currencyComboBox.setRenderer(new DefaultListCellRenderer(this, (Map)((Object)serializable)){
                final /* synthetic */ Map val$currencyMap;
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.val$currencyMap = map;
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    object = object == null ? string : object + " " + (String)this.val$currencyMap.get(object);
                    return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                }
            });
            this.currencyComboBox.setSelectedItem(userPreferencesController.getCurrency());
            this.currencyComboBox.addItemListener(new ItemListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setCurrency((String)this.this$0.currencyComboBox.getSelectedItem());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.CURRENCY, new PropertyChangeListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.currencyComboBox.setSelectedItem(userPreferencesController.getCurrency());
                    if (this.this$0.valueAddedTaxCheckBox != null) {
                        this.this$0.valueAddedTaxCheckBox.setEnabled(userPreferencesController.getCurrency() != null);
                    }
                }
            });
            if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.VALUE_ADDED_TAX_ENABLED)) {
                this.valueAddedTaxCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "valueAddedTaxCheckBox.text", new Object[0]));
                this.valueAddedTaxCheckBox.setEnabled(userPreferencesController.getCurrency() != null);
                this.valueAddedTaxCheckBox.setSelected(userPreferencesController.isValueAddedTaxEnabled());
                this.valueAddedTaxCheckBox.addChangeListener(new ChangeListener(){
                    final /* synthetic */ UserPreferencesPanel this$0;
                    {
                        this.this$0 = userPreferencesPanel;
                    }

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        userPreferencesController.setValueAddedTaxEnabled(this.this$0.valueAddedTaxCheckBox.isSelected());
                    }
                });
                userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.VALUE_ADDED_TAX_ENABLED, new PropertyChangeListener(){
                    final /* synthetic */ UserPreferencesPanel this$0;
                    {
                        this.this$0 = userPreferencesPanel;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        this.this$0.valueAddedTaxCheckBox.setEnabled(userPreferencesController.getCurrency() != null);
                        this.this$0.valueAddedTaxCheckBox.setSelected(userPreferencesController.isValueAddedTaxEnabled());
                    }
                });
            }
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.FURNITURE_CATALOG_VIEWED_IN_TREE)) {
            this.furnitureCatalogViewLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "furnitureCatalogViewLabel.text", new Object[0]));
            this.treeRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "treeRadioButton.text", new Object[0]), userPreferencesController.isFurnitureCatalogViewedInTree());
            this.listRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "listRadioButton.text", new Object[0]), !userPreferencesController.isFurnitureCatalogViewedInTree());
            serializable = new ButtonGroup();
            ((ButtonGroup)serializable).add(this.treeRadioButton);
            ((ButtonGroup)serializable).add(this.listRadioButton);
            object2 = new ItemListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setFurnitureCatalogViewedInTree(this.this$0.treeRadioButton.isSelected());
                }
            };
            this.treeRadioButton.addItemListener((ItemListener)object2);
            this.listRadioButton.addItemListener((ItemListener)object2);
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.FURNITURE_CATALOG_VIEWED_IN_TREE, new PropertyChangeListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.treeRadioButton.setSelected(userPreferencesController.isFurnitureCatalogViewedInTree());
                }
            });
        }
        try {
            bl = Boolean.getBoolean("com.eteks.sweethome3d.no3D");
        }
        catch (AccessControlException accessControlException) {
            bl = true;
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.NAVIGATION_PANEL_VISIBLE) && !bl) {
            this.navigationPanelLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "navigationPanelLabel.text", new Object[0]));
            this.navigationPanelCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "navigationPanelCheckBox.text", new Object[0]));
            if (!OperatingSystem.isMacOSX() || OperatingSystem.isMacOSXLeopardOrSuperior()) {
                this.navigationPanelCheckBox.setSelected(userPreferencesController.isNavigationPanelVisible());
                this.navigationPanelCheckBox.addItemListener(new ItemListener(){
                    final /* synthetic */ UserPreferencesPanel this$0;
                    {
                        this.this$0 = userPreferencesPanel;
                    }

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        userPreferencesController.setNavigationPanelVisible(this.this$0.navigationPanelCheckBox.isSelected());
                    }
                });
                userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.NAVIGATION_PANEL_VISIBLE, new PropertyChangeListener(){
                    final /* synthetic */ UserPreferencesPanel this$0;
                    {
                        this.this$0 = userPreferencesPanel;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        this.this$0.navigationPanelCheckBox.setSelected(userPreferencesController.isNavigationPanelVisible());
                    }
                });
            } else {
                this.navigationPanelCheckBox.setEnabled(false);
            }
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.EDITING_IN_3D_VIEW_ENABLED) && !bl) {
            this.editingIn3DViewLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "editingIn3DViewLabel.text", new Object[0]));
            this.editingIn3DViewCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "editingIn3DViewCheckBox.text", new Object[0]), userPreferencesController.isEditingIn3DViewEnabled());
            this.editingIn3DViewCheckBox.addItemListener(new ItemListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setEditingIn3DViewEnabled(this.this$0.editingIn3DViewCheckBox.isSelected());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.EDITING_IN_3D_VIEW_ENABLED, new PropertyChangeListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.editingIn3DViewCheckBox.setSelected(userPreferencesController.isEditingIn3DViewEnabled());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.AERIAL_VIEW_CENTERED_ON_SELECTION_ENABLED) && !bl) {
            this.aerialViewCenteredOnSelectionLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "aerialViewCenteredOnSelectionLabel.text", new Object[0]));
            this.aerialViewCenteredOnSelectionCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "aerialViewCenteredOnSelectionCheckBox.text", new Object[0]), userPreferencesController.isAerialViewCenteredOnSelectionEnabled());
            this.aerialViewCenteredOnSelectionCheckBox.addItemListener(new ItemListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setAerialViewCenteredOnSelectionEnabled(this.this$0.aerialViewCenteredOnSelectionCheckBox.isSelected());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.AERIAL_VIEW_CENTERED_ON_SELECTION_ENABLED, new PropertyChangeListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.aerialViewCenteredOnSelectionCheckBox.setSelected(userPreferencesController.isAerialViewCenteredOnSelectionEnabled());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.OBSERVER_CAMERA_SELECTED_AT_CHANGE) && !bl) {
            this.observerCameraSelectedAtChangeLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "observerCameraSelectedAtChangeLabel.text", new Object[0]));
            this.observerCameraSelectedAtChangeCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "observerCameraSelectedAtChangeCheckBox.text", new Object[0]), userPreferencesController.isObserverCameraSelectedAtChange());
            this.observerCameraSelectedAtChangeCheckBox.addItemListener(new ItemListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setObserverCameraSelectedAtChange(this.this$0.observerCameraSelectedAtChangeCheckBox.isSelected());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.OBSERVER_CAMERA_SELECTED_AT_CHANGE, new PropertyChangeListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.observerCameraSelectedAtChangeCheckBox.setSelected(userPreferencesController.isObserverCameraSelectedAtChange());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.MAGNETISM_ENABLED)) {
            this.magnetismLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "magnetismLabel.text", new Object[0]));
            this.magnetismCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "magnetismCheckBox.text", new Object[0]), userPreferencesController.isMagnetismEnabled());
            this.magnetismCheckBox.addItemListener(new ItemListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setMagnetismEnabled(this.this$0.magnetismCheckBox.isSelected());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.MAGNETISM_ENABLED, new PropertyChangeListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.magnetismCheckBox.setSelected(userPreferencesController.isMagnetismEnabled());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.RULERS_VISIBLE)) {
            this.rulersLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "rulersLabel.text", new Object[0]));
            this.rulersCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "rulersCheckBox.text", new Object[0]), userPreferencesController.isRulersVisible());
            this.rulersCheckBox.addItemListener(new ItemListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setRulersVisible(this.this$0.rulersCheckBox.isSelected());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.RULERS_VISIBLE, new PropertyChangeListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.rulersCheckBox.setSelected(userPreferencesController.isRulersVisible());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.GRID_VISIBLE)) {
            this.gridLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "gridLabel.text", new Object[0]));
            this.gridCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "gridCheckBox.text", new Object[0]), userPreferencesController.isGridVisible());
            this.gridCheckBox.addItemListener(new ItemListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setGridVisible(this.this$0.gridCheckBox.isSelected());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.GRID_VISIBLE, new PropertyChangeListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.gridCheckBox.setSelected(userPreferencesController.isGridVisible());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.DEFAULT_FONT_NAME)) {
            this.defaultFontNameLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "defaultFontNameLabel.text", new Object[0]));
            this.defaultFontNameComboBox = new FontNameComboBox(userPreferences);
            this.defaultFontNameComboBox.addItemListener(new ItemListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    String string = (String)this.this$0.defaultFontNameComboBox.getSelectedItem();
                    userPreferencesController.setDefaultFontName(string == "DEFAULT_SYSTEM_FONT_NAME" ? null : string);
                }
            });
            object2 = new PropertyChangeListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = userPreferencesController.getDefaultFontName();
                    this.this$0.defaultFontNameComboBox.setSelectedItem(string == null ? "DEFAULT_SYSTEM_FONT_NAME" : string);
                }
            };
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.DEFAULT_FONT_NAME, (PropertyChangeListener)object2);
            object2.propertyChange(null);
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.FURNITURE_VIEWED_FROM_TOP)) {
            this.furnitureIconLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "furnitureIconLabel.text", new Object[0]));
            this.catalogIconRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "catalogIconRadioButton.text", new Object[0]), !userPreferencesController.isFurnitureViewedFromTop());
            this.topViewRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "topViewRadioButton.text", new Object[0]), userPreferencesController.isFurnitureViewedFromTop());
            if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.FURNITURE_MODEL_ICON_SIZE) && !bl) {
                this.iconSizeLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "iconSizeLabel.text", new Object[0]));
                object2 = new TreeSet<Integer>(Arrays.asList(128, 256, 512, 1024));
                object2.add(userPreferencesController.getFurnitureModelIconSize());
                this.iconSizeComboBox = new JComboBox<Object>(object2.toArray());
                this.iconSizeComboBox.setRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                        return super.getListCellRendererComponent((JList<?>)jList, object + "\u00d7" + object, n, bl, bl2);
                    }
                });
                this.iconSizeComboBox.setSelectedItem(userPreferencesController.getFurnitureModelIconSize());
                this.iconSizeComboBox.addItemListener(new ItemListener(){
                    final /* synthetic */ UserPreferencesPanel this$0;
                    {
                        this.this$0 = userPreferencesPanel;
                    }

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        userPreferencesController.setFurnitureModelIconSize((Integer)this.this$0.iconSizeComboBox.getSelectedItem());
                    }
                });
                userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.FURNITURE_MODEL_ICON_SIZE, new PropertyChangeListener(){
                    final /* synthetic */ UserPreferencesPanel this$0;
                    {
                        this.this$0 = userPreferencesPanel;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        this.this$0.iconSizeComboBox.setSelectedItem(userPreferencesController.getFurnitureModelIconSize());
                    }
                });
            }
            if (bl) {
                this.catalogIconRadioButton.setEnabled(false);
                this.topViewRadioButton.setEnabled(false);
            } else if (Component3DManager.getInstance().isOffScreenImageSupported()) {
                object2 = new ButtonGroup();
                ((ButtonGroup)object2).add(this.catalogIconRadioButton);
                ((ButtonGroup)object2).add(this.topViewRadioButton);
                object = new ItemListener(){
                    final /* synthetic */ UserPreferencesPanel this$0;
                    {
                        this.this$0 = userPreferencesPanel;
                    }

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        userPreferencesController.setFurnitureViewedFromTop(this.this$0.topViewRadioButton.isSelected());
                    }
                };
                this.catalogIconRadioButton.addItemListener((ItemListener)object);
                this.topViewRadioButton.addItemListener((ItemListener)object);
                userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.FURNITURE_VIEWED_FROM_TOP, new PropertyChangeListener(){
                    final /* synthetic */ UserPreferencesPanel this$0;
                    {
                        this.this$0 = userPreferencesPanel;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        this.this$0.topViewRadioButton.setSelected(userPreferencesController.isFurnitureViewedFromTop());
                        if (this.this$0.iconSizeComboBox != null) {
                            this.this$0.iconSizeComboBox.setEnabled(userPreferencesController.isFurnitureViewedFromTop());
                        }
                    }
                });
                if (this.iconSizeComboBox != null) {
                    this.iconSizeComboBox.setEnabled(userPreferencesController.isFurnitureViewedFromTop());
                }
            } else {
                this.catalogIconRadioButton.setEnabled(false);
                this.topViewRadioButton.setEnabled(false);
            }
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.ROOM_FLOOR_COLORED_OR_TEXTURED)) {
            this.roomRenderingLabel = new JLabel(userPreferences.getLocalizedString(UserPreferencesPanel.class, "roomRenderingLabel.text", new Object[0]));
            this.monochromeRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "monochromeRadioButton.text", new Object[0]), !userPreferencesController.isRoomFloorColoredOrTextured());
            this.floorColorOrTextureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "floorColorOrTextureRadioButton.text", new Object[0]), userPreferencesController.isRoomFloorColoredOrTextured());
            object2 = new ButtonGroup();
            ((ButtonGroup)object2).add(this.monochromeRadioButton);
            ((ButtonGroup)object2).add(this.floorColorOrTextureRadioButton);
            object = new ItemListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setRoomFloorColoredOrTextured(this.this$0.floorColorOrTextureRadioButton.isSelected());
                }
            };
            this.monochromeRadioButton.addItemListener((ItemListener)object);
            this.floorColorOrTextureRadioButton.addItemListener((ItemListener)object);
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.ROOM_FLOOR_COLORED_OR_TEXTURED, new PropertyChangeListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.floorColorOrTextureRadioButton.setSelected(userPreferencesController.isRoomFloorColoredOrTextured());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.NEW_WALL_PATTERN)) {
            this.newWallPatternLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "newWallPatternLabel.text", new Object[0]));
            object2 = userPreferences.getPatternsCatalog().getPatterns();
            this.newWallPatternComboBox = new JComboBox<Object>(new DefaultComboBoxModel<Object>(object2.toArray()));
            this.newWallPatternComboBox.setRenderer(this.getPatternRenderer());
            object = userPreferencesController.getNewWallPattern();
            this.newWallPatternComboBox.setSelectedItem(object != null ? object : userPreferencesController.getWallPattern());
            this.newWallPatternComboBox.addItemListener(new ItemListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setNewWallPattern((TextureImage)this.this$0.newWallPatternComboBox.getSelectedItem());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.NEW_WALL_PATTERN, new PropertyChangeListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.newWallPatternComboBox.setSelectedItem(userPreferencesController.getNewWallPattern());
                }
            });
        } else if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.WALL_PATTERN)) {
            this.wallPatternLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "wallPatternLabel.text", new Object[0]));
            object2 = userPreferences.getPatternsCatalog().getPatterns();
            this.wallPatternComboBox = new JComboBox<Object>(new DefaultComboBoxModel<Object>(object2.toArray()));
            this.wallPatternComboBox.setRenderer(this.getPatternRenderer());
            this.wallPatternComboBox.setSelectedItem(userPreferencesController.getWallPattern());
            this.wallPatternComboBox.addItemListener(new ItemListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setWallPattern((TextureImage)this.this$0.wallPatternComboBox.getSelectedItem());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.WALL_PATTERN, new PropertyChangeListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.wallPatternComboBox.setSelectedItem(userPreferencesController.getWallPattern());
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.NEW_WALL_THICKNESS)) {
            this.newWallThicknessLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "newWallThicknessLabel.text", new Object[0]));
            object2 = new SpinnerLengthModel(LengthUnit.CENTIMETER.getStepSize(), LengthUnit.INCH.getStepSize(), userPreferencesController);
            this.newWallThicknessSpinner = new AutoCommitLengthSpinner((SpinnerModel)object2, userPreferencesController);
            ((SpinnerNumberModel)object2).setValue(Float.valueOf(userPreferencesController.getNewWallThickness()));
            ((AbstractSpinnerModel)object2).addChangeListener(new ChangeListener(){
                final /* synthetic */ SpinnerLengthModel val$newWallThicknessSpinnerModel;
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.val$newWallThicknessSpinnerModel = spinnerLengthModel;
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    userPreferencesController.setNewWallThickness(((Number)this.val$newWallThicknessSpinnerModel.getValue()).floatValue());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.NEW_WALL_THICKNESS, new PropertyChangeListener(){
                final /* synthetic */ SpinnerLengthModel val$newWallThicknessSpinnerModel;
                final /* synthetic */ UserPreferencesController val$controller;
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.val$newWallThicknessSpinnerModel = spinnerLengthModel;
                    this.val$controller = userPreferencesController;
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$newWallThicknessSpinnerModel.setValue(Float.valueOf(this.val$controller.getNewWallThickness()));
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.NEW_WALL_HEIGHT)) {
            this.newWallHeightLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "newWallHeightLabel.text", new Object[0]));
            object2 = new SpinnerLengthModel(LengthUnit.CENTIMETER.getStepSize() * 20.0f, LengthUnit.INCH.getStepSize() * 16.0f, userPreferencesController);
            this.newWallHeightSpinner = new AutoCommitLengthSpinner((SpinnerModel)object2, userPreferencesController);
            ((SpinnerNumberModel)object2).setValue(Float.valueOf(userPreferencesController.getNewWallHeight()));
            ((AbstractSpinnerModel)object2).addChangeListener(new ChangeListener(){
                final /* synthetic */ SpinnerLengthModel val$newWallHeightSpinnerModel;
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.val$newWallHeightSpinnerModel = spinnerLengthModel;
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    userPreferencesController.setNewWallHeight(((Number)this.val$newWallHeightSpinnerModel.getValue()).floatValue());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.NEW_WALL_HEIGHT, new PropertyChangeListener(){
                final /* synthetic */ SpinnerLengthModel val$newWallHeightSpinnerModel;
                final /* synthetic */ UserPreferencesController val$controller;
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.val$newWallHeightSpinnerModel = spinnerLengthModel;
                    this.val$controller = userPreferencesController;
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$newWallHeightSpinnerModel.setValue(Float.valueOf(this.val$controller.getNewWallHeight()));
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.NEW_FLOOR_THICKNESS)) {
            this.newFloorThicknessLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "newFloorThicknessLabel.text", new Object[0]));
            object2 = new SpinnerLengthModel(LengthUnit.CENTIMETER.getStepSize(), LengthUnit.INCH.getStepSize(), userPreferencesController);
            this.newFloorThicknessSpinner = new AutoCommitLengthSpinner((SpinnerModel)object2, userPreferencesController);
            ((SpinnerNumberModel)object2).setValue(Float.valueOf(userPreferencesController.getNewFloorThickness()));
            ((AbstractSpinnerModel)object2).addChangeListener(new ChangeListener(){
                final /* synthetic */ SpinnerLengthModel val$newFloorThicknessSpinnerModel;
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.val$newFloorThicknessSpinnerModel = spinnerLengthModel;
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    userPreferencesController.setNewFloorThickness(((Number)this.val$newFloorThicknessSpinnerModel.getValue()).floatValue());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.NEW_FLOOR_THICKNESS, new PropertyChangeListener(){
                final /* synthetic */ SpinnerLengthModel val$newFloorThicknessSpinnerModel;
                final /* synthetic */ UserPreferencesController val$controller;
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.val$newFloorThicknessSpinnerModel = spinnerLengthModel;
                    this.val$controller = userPreferencesController;
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$newFloorThicknessSpinnerModel.setValue(Float.valueOf(this.val$controller.getNewFloorThickness()));
                }
            });
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.CHECK_UPDATES_ENABLED) && Boolean.parseBoolean(System.getProperty("com.eteks.sweethome3d.checkUpdates", "true"))) {
            this.checkUpdatesCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "checkUpdatesCheckBox.text", new Object[0]), userPreferencesController.isCheckUpdatesEnabled());
            this.checkUpdatesCheckBox.addItemListener(new ItemListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    userPreferencesController.setCheckUpdatesEnabled(this.this$0.checkUpdatesCheckBox.isSelected());
                }
            });
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.CHECK_UPDATES_ENABLED, new PropertyChangeListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.checkUpdatesCheckBox.setSelected(userPreferencesController.isCheckUpdatesEnabled());
                }
            });
            this.checkUpdatesNowButton = new JButton(new ResourceAction.ButtonAction(new ResourceAction(this, userPreferences, UserPreferencesPanel.class, "CHECK_UPDATES_NOW", true){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                    super(userPreferences, clazz, string, bl);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    userPreferencesController.checkUpdates();
                }
            }));
        }
        if (userPreferencesController.isPropertyEditable(UserPreferencesController.Property.AUTO_SAVE_DELAY_FOR_RECOVERY)) {
            this.autoSaveDelayForRecoveryCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "autoSaveDelayForRecoveryCheckBox.text", new Object[0]));
            object2 = new SpinnerNumberModel(10, 1, 60, 5){

                @Override
                public Object getNextValue() {
                    if (((Number)this.getValue()).intValue() == ((Number)((Object)this.getMinimum())).intValue()) {
                        return this.getStepSize();
                    }
                    return super.getNextValue();
                }

                @Override
                public Object getPreviousValue() {
                    if (((Number)this.getValue()).intValue() - this.getStepSize().intValue() < ((Number)((Object)this.getMinimum())).intValue()) {
                        return super.getMinimum();
                    }
                    return super.getPreviousValue();
                }
            };
            this.autoSaveDelayForRecoverySpinner = new AutoCommitSpinner((SpinnerModel)object2);
            this.autoSaveDelayForRecoveryUnitLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, UserPreferencesPanel.class, "autoSaveDelayForRecoveryUnitLabel.text", new Object[0]));
            this.updateAutoSaveDelayForRecoveryComponents(userPreferencesController);
            this.autoSaveDelayForRecoveryCheckBox.addChangeListener(new ChangeListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    userPreferencesController.setAutoSaveForRecoveryEnabled(this.this$0.autoSaveDelayForRecoveryCheckBox.isSelected());
                }
            });
            ((AbstractSpinnerModel)object2).addChangeListener(new ChangeListener(){
                final /* synthetic */ SpinnerNumberModel val$autoSaveDelayForRecoverySpinnerModel;
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.val$autoSaveDelayForRecoverySpinnerModel = spinnerNumberModel;
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    userPreferencesController.setAutoSaveDelayForRecovery(((Number)this.val$autoSaveDelayForRecoverySpinnerModel.getValue()).intValue() * 60000);
                }
            });
            object = new PropertyChangeListener(){
                final /* synthetic */ UserPreferencesPanel this$0;
                {
                    this.this$0 = userPreferencesPanel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.updateAutoSaveDelayForRecoveryComponents(userPreferencesController);
                }
            };
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.AUTO_SAVE_DELAY_FOR_RECOVERY, (PropertyChangeListener)object);
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.AUTO_SAVE_FOR_RECOVERY_ENABLED, (PropertyChangeListener)object);
        }
        this.resetDisplayedActionTipsButton = new JButton(new ResourceAction.ButtonAction(new ResourceAction(this, userPreferences, UserPreferencesPanel.class, "RESET_DISPLAYED_ACTION_TIPS", true){
            final /* synthetic */ UserPreferencesPanel this$0;
            {
                this.this$0 = userPreferencesPanel;
                super(userPreferences, clazz, string, bl);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                userPreferencesController.resetDisplayedActionTips();
            }
        }));
        this.dialogTitle = userPreferences.getLocalizedString(UserPreferencesPanel.class, "preferences.title", new Object[0]);
    }

    private DefaultListCellRenderer getPatternRenderer() {
        final float f = SwingTools.getResolutionScale();
        return new DefaultListCellRenderer(this){
            final /* synthetic */ UserPreferencesPanel this$0;
            {
                this.this$0 = userPreferencesPanel;
            }

            @Override
            public Component getListCellRendererComponent(final JList jList, Object object, int n, boolean bl, boolean bl2) {
                TextureImage textureImage = (TextureImage)object;
                Component component = super.getListCellRendererComponent((JList<?>)jList, "", n, bl, bl2);
                final BufferedImage bufferedImage = SwingTools.getPatternImage(textureImage, jList.getBackground(), jList.getForeground());
                this.setIcon(new Icon(){
                    final /* synthetic */ 56 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    @Override
                    public int getIconWidth() {
                        return (int)((float)(bufferedImage.getWidth() * 4) * f + 1.0f);
                    }

                    @Override
                    public int getIconHeight() {
                        return (int)((float)bufferedImage.getHeight() * f + 2.0f);
                    }

                    @Override
                    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                        Graphics2D graphics2D = (Graphics2D)graphics;
                        graphics2D.scale(f, f);
                        for (int i = 0; i < 4; ++i) {
                            graphics2D.drawImage((Image)bufferedImage, n + i * bufferedImage.getWidth(), n2 + 1, jList);
                        }
                        graphics2D.scale(1.0f / f, 1.0f / f);
                        graphics2D.setColor(jList.getForeground());
                        graphics2D.drawRect(n, n2, this.getIconWidth() - 2, this.getIconHeight() - 1);
                    }
                });
                return component;
            }
        };
    }

    private void updateAutoSaveDelayForRecoveryComponents(UserPreferencesController userPreferencesController) {
        int n = userPreferencesController.getAutoSaveDelayForRecovery() / 60000;
        boolean bl = userPreferencesController.isAutoSaveForRecoveryEnabled();
        this.autoSaveDelayForRecoverySpinner.setEnabled(bl);
        this.autoSaveDelayForRecoveryCheckBox.setSelected(bl);
        if (bl) {
            this.autoSaveDelayForRecoverySpinner.setValue(n);
        }
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            String string;
            if (this.languageLabel != null) {
                this.languageLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "languageLabel.mnemonic", new Object[0])).getKeyCode());
                this.languageLabel.setLabelFor(this.languageComboBox);
            }
            if (this.unitLabel != null) {
                this.unitLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "unitLabel.mnemonic", new Object[0])).getKeyCode());
                this.unitLabel.setLabelFor(this.unitComboBox);
            }
            if (this.currencyLabel != null) {
                this.currencyLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "currencyLabel.mnemonic", new Object[0])).getKeyCode());
                this.currencyLabel.setLabelFor(this.currencyComboBox);
            }
            if (this.valueAddedTaxCheckBox != null) {
                this.valueAddedTaxCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "valueAddedTaxCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.furnitureCatalogViewLabel != null) {
                this.treeRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "treeRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.listRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "listRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.navigationPanelLabel != null) {
                this.navigationPanelCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "navigationPanelCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.editingIn3DViewLabel != null && (string = userPreferences.getLocalizedString(UserPreferencesPanel.class, "editingIn3DViewCheckBox.mnemonic", new Object[0])).length() > 0) {
                this.editingIn3DViewCheckBox.setMnemonic(KeyStroke.getKeyStroke(string).getKeyCode());
            }
            if (this.aerialViewCenteredOnSelectionLabel != null) {
                this.aerialViewCenteredOnSelectionCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "aerialViewCenteredOnSelectionCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.observerCameraSelectedAtChangeLabel != null && (string = userPreferences.getLocalizedString(UserPreferencesPanel.class, "observerCameraSelectedAtChangeCheckBox.mnemonic", new Object[0])).length() > 0) {
                this.observerCameraSelectedAtChangeCheckBox.setMnemonic(KeyStroke.getKeyStroke(string).getKeyCode());
            }
            if (this.magnetismLabel != null) {
                this.magnetismCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "magnetismCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.rulersLabel != null) {
                this.rulersCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "rulersCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.gridLabel != null) {
                this.gridCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "gridCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.defaultFontNameLabel != null) {
                this.defaultFontNameLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "defaultFontNameLabel.mnemonic", new Object[0])).getKeyCode());
                this.defaultFontNameLabel.setLabelFor(this.defaultFontNameComboBox);
            }
            if (this.furnitureIconLabel != null) {
                this.catalogIconRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "catalogIconRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.topViewRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "topViewRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.iconSizeLabel != null && (string = userPreferences.getLocalizedString(UserPreferencesPanel.class, "iconSizeLabel.mnemonic", new Object[0])).length() > 0) {
                this.iconSizeLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(string).getKeyCode());
            }
            if (this.roomRenderingLabel != null) {
                this.monochromeRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "monochromeRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.floorColorOrTextureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "floorColorOrTextureRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.newWallPatternLabel != null) {
                this.newWallPatternLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "newWallPatternLabel.mnemonic", new Object[0])).getKeyCode());
                this.newWallPatternLabel.setLabelFor(this.newWallPatternComboBox);
            } else if (this.wallPatternLabel != null) {
                this.wallPatternLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "wallPatternLabel.mnemonic", new Object[0])).getKeyCode());
                this.wallPatternLabel.setLabelFor(this.wallPatternComboBox);
            }
            if (this.newWallThicknessLabel != null) {
                this.newWallThicknessLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "newWallThicknessLabel.mnemonic", new Object[0])).getKeyCode());
                this.newWallThicknessLabel.setLabelFor(this.newWallThicknessSpinner);
            }
            if (this.newWallHeightLabel != null) {
                this.newWallHeightLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "newWallHeightLabel.mnemonic", new Object[0])).getKeyCode());
                this.newWallHeightLabel.setLabelFor(this.newWallHeightSpinner);
            }
            if (this.newFloorThicknessLabel != null) {
                this.newFloorThicknessLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "newFloorThicknessLabel.mnemonic", new Object[0])).getKeyCode());
                this.newFloorThicknessLabel.setLabelFor(this.newFloorThicknessSpinner);
            }
            if (this.checkUpdatesCheckBox != null) {
                this.checkUpdatesCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "checkUpdatesCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.autoSaveDelayForRecoveryCheckBox != null) {
                this.autoSaveDelayForRecoveryCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(UserPreferencesPanel.class, "autoSaveDelayForRecoveryCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
        }
    }

    private void layoutComponents() {
        Serializable serializable;
        boolean bl = OperatingSystem.isMacOSX();
        int n = bl ? 22 : 21;
        boolean bl2 = this.getToolkit().getScreenSize().height <= (bl ? 768 : 650);
        int n2 = Math.round(5.0f * SwingTools.getResolutionScale());
        if (bl2) {
            n2 = bl ? 4 : 3;
        }
        int n3 = (int)(3.0f * SwingTools.getResolutionScale());
        Insets insets = new Insets(0, 0, n2, n2);
        Insets insets2 = new Insets(0, 0, bl2 ? (bl ? 2 : 0) : (bl ? 5 : n3), n2);
        Insets insets3 = new Insets(0, 0, bl2 ? 2 : 10, n2);
        Insets insets4 = new Insets(0, 0, n2, 0);
        Insets insets5 = new Insets(0, 0, bl2 ? (bl ? 2 : 0) : (bl ? 5 : n3), 0);
        Insets insets6 = new Insets(0, 0, bl2 ? 0 : 10, 0);
        if (this.languageLabel != null) {
            this.add((Component)this.languageLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.languageComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(bl ? 1 : 0, 0, n2, 0), 0, 0));
            if (this.languageLibraryImportButton != null) {
                this.add((Component)this.languageLibraryImportButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, n2, n2, 0), 0, 0));
            }
        }
        if (this.unitLabel != null) {
            this.add((Component)this.unitLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.unitComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, insets4, bl ? -20 : 0, 0));
        }
        if (this.currencyLabel != null) {
            this.add((Component)this.currencyLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.currencyComboBox, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 21, 2, insets4, 0, 0));
            if (this.valueAddedTaxCheckBox != null) {
                this.add((Component)this.valueAddedTaxCheckBox, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, n2, n2, 0), 0, 0));
            }
        }
        if (this.furnitureCatalogViewLabel != null) {
            this.add((Component)this.furnitureCatalogViewLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, n, 0, insets2, 0, 0));
            serializable = new JPanel(new GridBagLayout());
            ((Container)serializable).add(this.treeRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 10), 0, 0));
            ((Container)serializable).add(this.listRadioButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)serializable, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 21, 0, insets5, 0, 0));
        }
        if (this.navigationPanelLabel != null) {
            this.add((Component)this.navigationPanelLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, n, 0, insets2, 0, 0));
            this.add((Component)this.navigationPanelCheckBox, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 21, 0, insets5, 0, 0));
        }
        if (this.editingIn3DViewLabel != null) {
            this.add((Component)this.editingIn3DViewLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, n, 0, insets2, 0, 0));
            this.add((Component)this.editingIn3DViewCheckBox, new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 21, 0, insets5, 0, 0));
        }
        if (this.aerialViewCenteredOnSelectionLabel != null) {
            this.add((Component)this.aerialViewCenteredOnSelectionLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, n, 0, insets2, 0, 0));
            this.add((Component)this.aerialViewCenteredOnSelectionCheckBox, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 21, 0, insets5, 0, 0));
        }
        if (this.observerCameraSelectedAtChangeLabel != null) {
            this.add((Component)this.observerCameraSelectedAtChangeLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, n, 0, insets3, 0, 0));
            this.add((Component)this.observerCameraSelectedAtChangeCheckBox, new GridBagConstraints(1, 8, 2, 1, 0.0, 0.0, 21, 0, insets6, 0, 0));
        }
        if (this.magnetismLabel != null) {
            this.add((Component)this.magnetismLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, n, 0, insets2, 0, 0));
            this.add((Component)this.magnetismCheckBox, new GridBagConstraints(1, 9, 2, 1, 0.0, 0.0, 21, 0, insets5, 0, 0));
        }
        if (this.rulersLabel != null) {
            this.add((Component)this.rulersLabel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, n, 0, insets2, 0, 0));
            this.add((Component)this.rulersCheckBox, new GridBagConstraints(1, 10, 2, 1, 0.0, 0.0, 21, 0, insets5, 0, 0));
        }
        if (this.gridLabel != null) {
            serializable = new JPanel(new GridBagLayout());
            ((Container)serializable).add(this.gridLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 0, insets2, 0, 0));
            ((Container)serializable).add(this.gridCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, insets5, 0, 0));
            this.add((Component)serializable, new GridBagConstraints(2, 10, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (this.defaultFontNameLabel != null) {
            this.add((Component)this.defaultFontNameLabel, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            serializable = this.defaultFontNameComboBox.getPreferredSize();
            ((Dimension)serializable).width = this.unitComboBox != null && this.floorColorOrTextureRadioButton != null ? Math.min(((Dimension)serializable).width, this.unitComboBox.getPreferredSize().width + 5 + this.floorColorOrTextureRadioButton.getPreferredSize().width) : Math.min(((Dimension)serializable).width, 250);
            this.defaultFontNameComboBox.setPreferredSize((Dimension)serializable);
            this.add((Component)this.defaultFontNameComboBox, new GridBagConstraints(1, 11, 2, 1, 0.0, 0.0, 21, 0, insets4, 0, 0));
        }
        if (this.furnitureIconLabel != null) {
            this.add((Component)this.furnitureIconLabel, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, n, 0, insets2, 0, 0));
            this.add((Component)this.catalogIconRadioButton, new GridBagConstraints(1, 12, 1, 1, 0.0, 0.0, 21, 0, insets5, 0, 0));
            serializable = new JPanel(new GridBagLayout());
            ((Container)serializable).add(this.topViewRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 15), 0, 0));
            if (this.iconSizeLabel != null) {
                ((Container)serializable).add(this.iconSizeLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, n2), 0, 0));
                ((Container)serializable).add(this.iconSizeComboBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.add((Component)serializable, new GridBagConstraints(1, 13, 2, 1, 0.0, 0.0, 21, 0, insets6, 0, 0));
        }
        if (this.roomRenderingLabel != null) {
            this.add((Component)this.roomRenderingLabel, new GridBagConstraints(0, 14, 1, 1, 0.0, 0.0, n, 0, insets2, 0, 0));
            serializable = new JPanel(new GridBagLayout());
            ((Container)serializable).add(this.monochromeRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 10), 0, 0));
            ((Container)serializable).add(this.floorColorOrTextureRadioButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)serializable, new GridBagConstraints(1, 14, 2, 1, 0.0, 0.0, 21, 2, insets5, 0, 0));
        }
        if (this.newWallPatternLabel != null) {
            this.add((Component)this.newWallPatternLabel, new GridBagConstraints(0, 15, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.newWallPatternComboBox, new GridBagConstraints(1, 15, 2, 1, 0.0, 0.0, 21, 0, insets4, 0, 0));
        } else if (this.wallPatternLabel != null) {
            this.add((Component)this.wallPatternLabel, new GridBagConstraints(0, 15, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.wallPatternComboBox, new GridBagConstraints(1, 15, 2, 1, 0.0, 0.0, 21, 0, insets4, 0, 0));
        }
        if (this.newWallThicknessLabel != null) {
            this.add((Component)this.newWallThicknessLabel, new GridBagConstraints(0, 16, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.newWallThicknessSpinner, new GridBagConstraints(1, 16, 1, 1, 0.0, 0.0, 21, 2, insets4, 0, 0));
        }
        if (this.newWallHeightLabel != null) {
            this.add((Component)this.newWallHeightLabel, new GridBagConstraints(0, 17, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.newWallHeightSpinner, new GridBagConstraints(1, 17, 1, 1, 0.0, 0.0, 21, 2, insets4, 0, 0));
        }
        if (this.newFloorThicknessLabel != null) {
            this.add((Component)this.newFloorThicknessLabel, new GridBagConstraints(0, 18, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.newFloorThicknessSpinner, new GridBagConstraints(1, 18, 1, 1, 0.0, 0.0, 21, 2, insets4, 0, 0));
        }
        if (this.checkUpdatesCheckBox != null || this.autoSaveDelayForRecoveryCheckBox != null) {
            serializable = new JPanel(new GridBagLayout());
            if (this.checkUpdatesCheckBox != null) {
                ((Container)serializable).add(this.checkUpdatesCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets2, 0, 0));
                ((Container)serializable).add(this.checkUpdatesNowButton, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 21, 0, insets5, 0, 0));
            }
            if (this.autoSaveDelayForRecoveryCheckBox != null) {
                ((Container)serializable).add(this.autoSaveDelayForRecoveryCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, n2), 0, 0));
                ((Container)serializable).add(this.autoSaveDelayForRecoverySpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, n2), 0, 0));
                ((Container)serializable).add(this.autoSaveDelayForRecoveryUnitLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.add((Component)serializable, new GridBagConstraints(0, 19, 3, 1, 0.0, 0.0, 21, 2, insets4, 0, 0));
        }
        if (this.resetDisplayedActionTipsButton.getText() != null && this.resetDisplayedActionTipsButton.getText().length() > 0) {
            this.add((Component)this.resetDisplayedActionTipsButton, new GridBagConstraints(0, 20, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    @Override
    public void displayView(View view) {
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, this.languageComboBox) == 0 && this.controller != null) {
            this.controller.modifyUserPreferences();
        }
    }

    private static class SupportedLanguagesChangeListener
    implements PropertyChangeListener {
        private WeakReference<UserPreferencesPanel> userPreferencesPanel;

        public SupportedLanguagesChangeListener(UserPreferencesPanel userPreferencesPanel) {
            this.userPreferencesPanel = new WeakReference<UserPreferencesPanel>(userPreferencesPanel);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            UserPreferencesPanel userPreferencesPanel = (UserPreferencesPanel)this.userPreferencesPanel.get();
            if (userPreferencesPanel == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.SUPPORTED_LANGUAGES, this);
            } else {
                JComboBox jComboBox = userPreferencesPanel.languageComboBox;
                List<String> list = Arrays.asList((String[])propertyChangeEvent.getOldValue());
                String[] stringArray = (String[])propertyChangeEvent.getNewValue();
                jComboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
                jComboBox.setSelectedItem(userPreferencesPanel.controller.getLanguage());
                for (String string : stringArray) {
                    if (list.contains(string)) continue;
                    jComboBox.setSelectedItem(string);
                    break;
                }
            }
        }
    }

    private static class SpinnerLengthModel
    extends SpinnerNumberModel {
        public SpinnerLengthModel(final float f, final float f2, final UserPreferencesController userPreferencesController) {
            super(new Float(1.0f), new Float(0.0f), new Float(100000.0f), new Float(f));
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.UNIT, new PropertyChangeListener(){
                final /* synthetic */ SpinnerLengthModel this$0;
                {
                    this.this$0 = spinnerLengthModel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.updateStepsAndLength(f, f2, userPreferencesController);
                }
            });
            this.updateStepsAndLength(f, f2, userPreferencesController);
        }

        private void updateStepsAndLength(float f, float f2, UserPreferencesController userPreferencesController) {
            if (userPreferencesController.getUnit().isMetric()) {
                this.setStepSize(Float.valueOf(f));
            } else {
                this.setStepSize(Float.valueOf(f2));
            }
            this.setMinimum(Float.valueOf(userPreferencesController.getUnit().getMinimumLength()));
            if (((Number)((Object)this.getMinimum())).floatValue() > ((Number)this.getValue()).floatValue()) {
                this.setValue(this.getMinimum());
            }
            this.fireStateChanged();
        }
    }

    private static class AutoCommitLengthSpinner
    extends AutoCommitSpinner {
        public AutoCommitLengthSpinner(SpinnerModel spinnerModel, final UserPreferencesController userPreferencesController) {
            super(spinnerModel, userPreferencesController.getUnit().getFormat(), false);
            userPreferencesController.addPropertyChangeListener(UserPreferencesController.Property.UNIT, new PropertyChangeListener(){
                final /* synthetic */ AutoCommitLengthSpinner this$0;
                {
                    this.this$0 = autoCommitLengthSpinner;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.setFormat((DecimalFormat)userPreferencesController.getUnit().getFormat());
                }
            });
        }
    }
}

