/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.TexturesCatalog;
import com.eteks.sweethome3d.model.TexturesCategory;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import com.eteks.sweethome3d.viewcontroller.WizardController;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;

public class ImportedTextureWizardController
extends WizardController
implements Controller {
    private final CatalogTexture texture;
    private final String textureName;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final PropertyChangeSupport propertyChangeSupport;
    private final ImportedTextureWizardStepState textureImageStepState;
    private final ImportedTextureWizardStepState textureAttributesStepState;
    private View stepsView;
    private Step step;
    private Content image;
    private String name;
    private TexturesCategory category;
    private String creator;
    private float width;
    private float height;

    public ImportedTextureWizardController(UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager) {
        this(null, null, userPreferences, viewFactory, contentManager);
    }

    public ImportedTextureWizardController(String string, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager) {
        this(null, string, userPreferences, viewFactory, contentManager);
    }

    public ImportedTextureWizardController(CatalogTexture catalogTexture, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager) {
        this(catalogTexture, null, userPreferences, viewFactory, contentManager);
    }

    private ImportedTextureWizardController(CatalogTexture catalogTexture, String string, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager) {
        super(userPreferences, viewFactory);
        this.texture = catalogTexture;
        this.textureName = string;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.setTitle(this.preferences.getLocalizedString(ImportedTextureWizardController.class, catalogTexture == null ? "importTextureWizard.title" : "modifyTextureWizard.title", new Object[0]));
        this.textureImageStepState = new TextureImageStepState();
        this.textureAttributesStepState = new TextureAttributesStepState();
        this.setStepState(this.textureImageStepState);
    }

    @Override
    public void finish() {
        CatalogTexture catalogTexture = new CatalogTexture(null, this.getName(), this.getImage(), this.getWidth(), this.getHeight(), this.getCreator(), true);
        TexturesCatalog texturesCatalog = this.preferences.getTexturesCatalog();
        if (this.texture != null) {
            texturesCatalog.delete(this.texture);
        }
        texturesCatalog.add(this.category, catalogTexture);
    }

    public ContentManager getContentManager() {
        return this.contentManager;
    }

    @Override
    protected ImportedTextureWizardStepState getStepState() {
        return (ImportedTextureWizardStepState)super.getStepState();
    }

    protected ImportedTextureWizardStepState getTextureImageStepState() {
        return this.textureImageStepState;
    }

    protected ImportedTextureWizardStepState getTextureAttributesStepState() {
        return this.textureAttributesStepState;
    }

    protected View getStepsView() {
        if (this.stepsView == null) {
            this.stepsView = this.viewFactory.createImportedTextureWizardStepsView(this.texture, this.textureName, this.preferences, this);
        }
        return this.stepsView;
    }

    protected void setStep(Step step) {
        if (step != this.step) {
            Step step2 = this.step;
            this.step = step;
            this.propertyChangeSupport.firePropertyChange(Property.STEP.name(), (Object)step2, (Object)step);
        }
    }

    public Step getStep() {
        return this.step;
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void setImage(Content content) {
        if (content != this.image) {
            Content content2 = this.image;
            this.image = content;
            this.propertyChangeSupport.firePropertyChange(Property.IMAGE.name(), content2, content);
        }
    }

    public Content getImage() {
        return this.image;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string != this.name) {
            String string2 = this.name;
            this.name = string;
            if (this.propertyChangeSupport != null) {
                this.propertyChangeSupport.firePropertyChange(Property.NAME.name(), string2, string);
            }
        }
    }

    public TexturesCategory getCategory() {
        return this.category;
    }

    public void setCategory(TexturesCategory texturesCategory) {
        if (texturesCategory != this.category) {
            TexturesCategory texturesCategory2 = this.category;
            this.category = texturesCategory;
            this.propertyChangeSupport.firePropertyChange(Property.CATEGORY.name(), texturesCategory2, texturesCategory);
        }
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String string) {
        if (string != this.creator) {
            String string2 = this.creator;
            this.creator = string;
            if (this.propertyChangeSupport != null) {
                this.propertyChangeSupport.firePropertyChange(Property.CREATOR.name(), string2, string);
            }
        }
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f) {
        if (f != this.width) {
            float f2 = this.width;
            this.width = f;
            this.propertyChangeSupport.firePropertyChange(Property.WIDTH.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float f) {
        if (f != this.height) {
            float f2 = this.height;
            this.height = f;
            this.propertyChangeSupport.firePropertyChange(Property.HEIGHT.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public boolean isTextureNameValid() {
        return this.name != null && this.name.length() > 0 && this.category != null;
    }

    private class TextureImageStepState
    extends ImportedTextureWizardStepState {
        public TextureImageStepState() {
            ImportedTextureWizardController.this.addPropertyChangeListener(Property.IMAGE, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    TextureImageStepState.this.setNextStepEnabled(ImportedTextureWizardController.this.getImage() != null);
                }
            });
        }

        @Override
        public void enter() {
            super.enter();
            this.setFirstStep(true);
            this.setNextStepEnabled(ImportedTextureWizardController.this.getImage() != null);
        }

        @Override
        public Step getStep() {
            return Step.IMAGE;
        }

        @Override
        public void goToNextStep() {
            ImportedTextureWizardController.this.setStepState(ImportedTextureWizardController.this.getTextureAttributesStepState());
        }
    }

    protected abstract class ImportedTextureWizardStepState
    extends WizardController.WizardControllerStepState {
        private URL icon = ImportedTextureWizardController.class.getResource("resources/importedTextureWizard.png");

        protected ImportedTextureWizardStepState() {
        }

        public abstract Step getStep();

        @Override
        public void enter() {
            ImportedTextureWizardController.this.setStep(this.getStep());
        }

        @Override
        public View getView() {
            return ImportedTextureWizardController.this.getStepsView();
        }

        @Override
        public URL getIcon() {
            return this.icon;
        }
    }

    private class TextureAttributesStepState
    extends ImportedTextureWizardStepState {
        private PropertyChangeListener widthChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImportedTextureWizardController.this.removePropertyChangeListener(Property.HEIGHT, TextureAttributesStepState.this.heightChangeListener);
                float f = ((Float)propertyChangeEvent.getNewValue()).floatValue() / ((Float)propertyChangeEvent.getOldValue()).floatValue();
                ImportedTextureWizardController.this.setHeight(ImportedTextureWizardController.this.getHeight() * f);
                ImportedTextureWizardController.this.addPropertyChangeListener(Property.HEIGHT, TextureAttributesStepState.this.heightChangeListener);
            }
        };
        private PropertyChangeListener heightChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImportedTextureWizardController.this.removePropertyChangeListener(Property.WIDTH, TextureAttributesStepState.this.widthChangeListener);
                float f = ((Float)propertyChangeEvent.getNewValue()).floatValue() / ((Float)propertyChangeEvent.getOldValue()).floatValue();
                ImportedTextureWizardController.this.setWidth(ImportedTextureWizardController.this.getWidth() * f);
                ImportedTextureWizardController.this.addPropertyChangeListener(Property.WIDTH, TextureAttributesStepState.this.widthChangeListener);
            }
        };
        private PropertyChangeListener nameAndCategoryChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TextureAttributesStepState.this.setNextStepEnabled(ImportedTextureWizardController.this.isTextureNameValid());
            }
        };

        @Override
        public void enter() {
            super.enter();
            this.setLastStep(true);
            ImportedTextureWizardController.this.addPropertyChangeListener(Property.WIDTH, this.widthChangeListener);
            ImportedTextureWizardController.this.addPropertyChangeListener(Property.HEIGHT, this.heightChangeListener);
            ImportedTextureWizardController.this.addPropertyChangeListener(Property.NAME, this.nameAndCategoryChangeListener);
            ImportedTextureWizardController.this.addPropertyChangeListener(Property.CATEGORY, this.nameAndCategoryChangeListener);
            this.setNextStepEnabled(ImportedTextureWizardController.this.isTextureNameValid());
        }

        @Override
        public Step getStep() {
            return Step.ATTRIBUTES;
        }

        @Override
        public void goBackToPreviousStep() {
            ImportedTextureWizardController.this.setStepState(ImportedTextureWizardController.this.getTextureImageStepState());
        }

        @Override
        public void exit() {
            ImportedTextureWizardController.this.removePropertyChangeListener(Property.WIDTH, this.widthChangeListener);
            ImportedTextureWizardController.this.removePropertyChangeListener(Property.HEIGHT, this.heightChangeListener);
            ImportedTextureWizardController.this.removePropertyChangeListener(Property.NAME, this.nameAndCategoryChangeListener);
            ImportedTextureWizardController.this.removePropertyChangeListener(Property.CATEGORY, this.nameAndCategoryChangeListener);
        }
    }

    public static enum Step {
        IMAGE,
        ATTRIBUTES;

    }

    public static enum Property {
        STEP,
        IMAGE,
        NAME,
        CATEGORY,
        CREATOR,
        WIDTH,
        HEIGHT;

    }
}

