﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-voice/ChimeSDKVoice_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ChimeSDKVoice {
namespace Model {
class SearchAvailablePhoneNumbersResult {
 public:
  AWS_CHIMESDKVOICE_API SearchAvailablePhoneNumbersResult() = default;
  AWS_CHIMESDKVOICE_API SearchAvailablePhoneNumbersResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CHIMESDKVOICE_API SearchAvailablePhoneNumbersResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Confines a search to just the phone numbers in the E.164 format.</p>
   */
  inline const Aws::Vector<Aws::String>& GetE164PhoneNumbers() const { return m_e164PhoneNumbers; }
  template <typename E164PhoneNumbersT = Aws::Vector<Aws::String>>
  void SetE164PhoneNumbers(E164PhoneNumbersT&& value) {
    m_e164PhoneNumbersHasBeenSet = true;
    m_e164PhoneNumbers = std::forward<E164PhoneNumbersT>(value);
  }
  template <typename E164PhoneNumbersT = Aws::Vector<Aws::String>>
  SearchAvailablePhoneNumbersResult& WithE164PhoneNumbers(E164PhoneNumbersT&& value) {
    SetE164PhoneNumbers(std::forward<E164PhoneNumbersT>(value));
    return *this;
  }
  template <typename E164PhoneNumbersT = Aws::String>
  SearchAvailablePhoneNumbersResult& AddE164PhoneNumbers(E164PhoneNumbersT&& value) {
    m_e164PhoneNumbersHasBeenSet = true;
    m_e164PhoneNumbers.emplace_back(std::forward<E164PhoneNumbersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token used to return the next page of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  SearchAvailablePhoneNumbersResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  SearchAvailablePhoneNumbersResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_e164PhoneNumbers;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_e164PhoneNumbersHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKVoice
}  // namespace Aws
