﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudformation/CloudFormation_EXPORTS.h>
#include <aws/cloudformation/model/ResponseMetadata.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace CloudFormation {
namespace Model {
/**
 * <p>The output for the <a>GetStackPolicy</a> action.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicyOutput">AWS
 * API Reference</a></p>
 */
class GetStackPolicyResult {
 public:
  AWS_CLOUDFORMATION_API GetStackPolicyResult() = default;
  AWS_CLOUDFORMATION_API GetStackPolicyResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_CLOUDFORMATION_API GetStackPolicyResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>Structure that contains the stack policy body. For more information, see <a
   * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html">Prevent
   * updates to stack resources</a> in the <i>CloudFormation User Guide</i>.</p>
   */
  inline const Aws::String& GetStackPolicyBody() const { return m_stackPolicyBody; }
  template <typename StackPolicyBodyT = Aws::String>
  void SetStackPolicyBody(StackPolicyBodyT&& value) {
    m_stackPolicyBodyHasBeenSet = true;
    m_stackPolicyBody = std::forward<StackPolicyBodyT>(value);
  }
  template <typename StackPolicyBodyT = Aws::String>
  GetStackPolicyResult& WithStackPolicyBody(StackPolicyBodyT&& value) {
    SetStackPolicyBody(std::forward<StackPolicyBodyT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  GetStackPolicyResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_stackPolicyBody;

  ResponseMetadata m_responseMetadata;
  bool m_stackPolicyBodyHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudFormation
}  // namespace Aws
