/*******************************************************************************
* Copyright 1999-2022 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
!  Content:
!      C B L A S _ C D O T C _ S U B   Example Program Text ( C Interface )
!******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "mkl.h"

#include "mkl_example.h"

int main(int argc, char *argv[])
{
      FILE *in_file;
      char *in_file_name;

      MKL_INT        n, incx, incy;
      MKL_Complex8  *x, *y;
      MKL_Complex8   res;
      MKL_INT        len_x, len_y;

      printf("\n     C B L A S _ C D O T C _ S U B  EXAMPLE PROGRAM\n");

/*       Get input parameters                                  */

      if (argc == 1) {
         printf("\n You must specify in_file data file as 1-st parameter");
         return 1;
      }
      in_file_name = argv[1];

/*       Get input data                                       */

      if( (in_file = fopen( in_file_name, "r" )) == NULL ) {
         printf("\n ERROR on OPEN '%s' with mode=\"r\"\n", in_file_name);
         return 1;
      }
      if( GetIntegerParameters(in_file, &n) != 1 ) {
          printf("\n ERROR of n reading\n");
          fclose(in_file);
          return 1;
      }
      if( GetIntegerParameters(in_file, &incx, &incy) != 2 ) {
          printf("\n ERROR of incx, incy reading\n");
          fclose(in_file);
          return 1;
      }

      len_x = 1+(n-1)*ABS(incx);
      len_y = 1+(n-1)*ABS(incy);
      x    = (MKL_Complex8 *)mkl_calloc(len_x, sizeof( MKL_Complex8 ), 64);
      y    = (MKL_Complex8 *)mkl_calloc(len_y, sizeof( MKL_Complex8 ), 64);
      if( x == NULL || y == NULL ) {
          printf( "\n Can't allocate memory for arrays\n");
          mkl_free(x);
          mkl_free(y);
          fclose(in_file);
          return 1;
      }
      if( GetVectorC(in_file, n, x, incx) != len_x ) {
        printf("\n ERROR of vector X reading\n");
        mkl_free(x);
        mkl_free(y);
        fclose(in_file);
        return 1;
      }
      if( GetVectorC(in_file, n, y, incy) != len_y ) {
        printf("\n ERROR of vector Y reading\n");
        mkl_free(x);
        mkl_free(y);
        fclose(in_file);
        return 1;
      }
      fclose(in_file);

/*       Print input data                                      */

      printf("\n     INPUT DATA");
      printf("\n       N="INT_FORMAT, n);
      PrintVectorC(FULLPRINT, n, x, incx, "X");
      PrintVectorC(FULLPRINT, n, y, incy, "Y");

/*      Call CBLAS_CDOTC_SUB subroutine ( C Interface )        */

      cblas_cdotc_sub(n, x, incx, y, incy, &res);

/*       Print output data                                     */

      printf("\n\n     OUTPUT DATA");
      printf("\n       CDOTC_SUB = (%7.3f,%7.3f)", res.real, res.imag);

      mkl_free(x);
      mkl_free(y);

      return 0;
}

