/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.sort;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.comparators.NumericComparator;
import org.apache.lucene.util.NumericUtils;

public class SortedWiderNumericSortField
extends SortedNumericSortField {
    private final int byteCounts;
    private final Comparator<Number> comparator;

    public SortedWiderNumericSortField(String field, SortField.Type type, boolean reverse) {
        super(field, type, reverse);
        if (type == SortField.Type.LONG) {
            this.byteCounts = 8;
            this.comparator = Comparator.comparingLong(Number::longValue);
        } else if (type == SortField.Type.DOUBLE) {
            this.byteCounts = 8;
            this.comparator = Comparator.comparingDouble(Number::doubleValue);
        } else {
            throw new IllegalArgumentException("Unsupported numeric type: " + String.valueOf(type));
        }
    }

    public FieldComparator<?> getComparator(int numHits, Pruning pruning) {
        return new NumericComparator<Number>(this.getField(), (Number)this.getMissingValue(), this.getReverse(), pruning, this.byteCounts){

            public int compare(int slot1, int slot2) {
                throw new UnsupportedOperationException();
            }

            public Number value(int slot) {
                throw new UnsupportedOperationException();
            }

            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                throw new UnsupportedOperationException();
            }

            public int compareValues(Number first, Number second) {
                if (first == null) {
                    if (second == null) {
                        return 0;
                    }
                    return -1;
                }
                if (second == null) {
                    return 1;
                }
                return SortedWiderNumericSortField.this.comparator.compare(first, second);
            }

            protected long missingValueAsComparableLong() {
                Number number = this.missingValue;
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Double.class, Float.class, Number.class}, (Object)number, n)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        Double d = (Double)number;
                        yield NumericUtils.doubleToSortableLong((double)d);
                    }
                    case 1 -> {
                        Float f = (Float)number;
                        yield NumericUtils.floatToSortableInt((float)f.floatValue());
                    }
                    case 2 -> {
                        Number n = number;
                        yield n.longValue();
                    }
                    case -1 -> 0L;
                };
            }

            protected long sortableBytesToLong(byte[] bytes) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static boolean isTypeSupported(SortField.Type type) {
        switch (type) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }
}

