/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AssignedPrivateIpAddress;
import software.amazon.awssdk.services.ec2.model.AssignedPrivateIpAddressListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecification;
import software.amazon.awssdk.services.ec2.model.Ipv4PrefixesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssignPrivateIpAddressesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, AssignPrivateIpAddressesResponse> {
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(AssignPrivateIpAddressesResponse.getter(AssignPrivateIpAddressesResponse::networkInterfaceId)).setter(AssignPrivateIpAddressesResponse.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<List<AssignedPrivateIpAddress>> ASSIGNED_PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssignedPrivateIpAddresses").getter(AssignPrivateIpAddressesResponse.getter(AssignPrivateIpAddressesResponse::assignedPrivateIpAddresses)).setter(AssignPrivateIpAddressesResponse.setter(Builder::assignedPrivateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignedPrivateIpAddressesSet").unmarshallLocationName("assignedPrivateIpAddressesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssignedPrivateIpAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Ipv4PrefixSpecification>> ASSIGNED_IPV4_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssignedIpv4Prefixes").getter(AssignPrivateIpAddressesResponse.getter(AssignPrivateIpAddressesResponse::assignedIpv4Prefixes)).setter(AssignPrivateIpAddressesResponse.setter(Builder::assignedIpv4Prefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignedIpv4PrefixSet").unmarshallLocationName("assignedIpv4PrefixSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ipv4PrefixSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ID_FIELD, ASSIGNED_PRIVATE_IP_ADDRESSES_FIELD, ASSIGNED_IPV4_PREFIXES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssignPrivateIpAddressesResponse.memberNameToFieldInitializer();
    private final String networkInterfaceId;
    private final List<AssignedPrivateIpAddress> assignedPrivateIpAddresses;
    private final List<Ipv4PrefixSpecification> assignedIpv4Prefixes;

    private AssignPrivateIpAddressesResponse(BuilderImpl builder) {
        super(builder);
        this.networkInterfaceId = builder.networkInterfaceId;
        this.assignedPrivateIpAddresses = builder.assignedPrivateIpAddresses;
        this.assignedIpv4Prefixes = builder.assignedIpv4Prefixes;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final boolean hasAssignedPrivateIpAddresses() {
        return this.assignedPrivateIpAddresses != null && !(this.assignedPrivateIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<AssignedPrivateIpAddress> assignedPrivateIpAddresses() {
        return this.assignedPrivateIpAddresses;
    }

    public final boolean hasAssignedIpv4Prefixes() {
        return this.assignedIpv4Prefixes != null && !(this.assignedIpv4Prefixes instanceof SdkAutoConstructList);
    }

    public final List<Ipv4PrefixSpecification> assignedIpv4Prefixes() {
        return this.assignedIpv4Prefixes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssignedPrivateIpAddresses() ? this.assignedPrivateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssignedIpv4Prefixes() ? this.assignedIpv4Prefixes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignPrivateIpAddressesResponse)) {
            return false;
        }
        AssignPrivateIpAddressesResponse other = (AssignPrivateIpAddressesResponse)((Object)obj);
        return Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && this.hasAssignedPrivateIpAddresses() == other.hasAssignedPrivateIpAddresses() && Objects.equals(this.assignedPrivateIpAddresses(), other.assignedPrivateIpAddresses()) && this.hasAssignedIpv4Prefixes() == other.hasAssignedIpv4Prefixes() && Objects.equals(this.assignedIpv4Prefixes(), other.assignedIpv4Prefixes());
    }

    public final String toString() {
        return ToString.builder((String)"AssignPrivateIpAddressesResponse").add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("AssignedPrivateIpAddresses", this.hasAssignedPrivateIpAddresses() ? this.assignedPrivateIpAddresses() : null).add("AssignedIpv4Prefixes", this.hasAssignedIpv4Prefixes() ? this.assignedIpv4Prefixes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "AssignedPrivateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.assignedPrivateIpAddresses()));
            }
            case "AssignedIpv4Prefixes": {
                return Optional.ofNullable(clazz.cast(this.assignedIpv4Prefixes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("AssignedPrivateIpAddressesSet", ASSIGNED_PRIVATE_IP_ADDRESSES_FIELD);
        map.put("AssignedIpv4PrefixSet", ASSIGNED_IPV4_PREFIXES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssignPrivateIpAddressesResponse, T> g) {
        return obj -> g.apply((AssignPrivateIpAddressesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String networkInterfaceId;
        private List<AssignedPrivateIpAddress> assignedPrivateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private List<Ipv4PrefixSpecification> assignedIpv4Prefixes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssignPrivateIpAddressesResponse model) {
            super(model);
            this.networkInterfaceId(model.networkInterfaceId);
            this.assignedPrivateIpAddresses(model.assignedPrivateIpAddresses);
            this.assignedIpv4Prefixes(model.assignedIpv4Prefixes);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final List<AssignedPrivateIpAddress.Builder> getAssignedPrivateIpAddresses() {
            List<AssignedPrivateIpAddress.Builder> result = AssignedPrivateIpAddressListCopier.copyToBuilder(this.assignedPrivateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssignedPrivateIpAddresses(Collection<AssignedPrivateIpAddress.BuilderImpl> assignedPrivateIpAddresses) {
            this.assignedPrivateIpAddresses = AssignedPrivateIpAddressListCopier.copyFromBuilder(assignedPrivateIpAddresses);
        }

        @Override
        public final Builder assignedPrivateIpAddresses(Collection<AssignedPrivateIpAddress> assignedPrivateIpAddresses) {
            this.assignedPrivateIpAddresses = AssignedPrivateIpAddressListCopier.copy(assignedPrivateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedPrivateIpAddresses(AssignedPrivateIpAddress ... assignedPrivateIpAddresses) {
            this.assignedPrivateIpAddresses(Arrays.asList(assignedPrivateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedPrivateIpAddresses(Consumer<AssignedPrivateIpAddress.Builder> ... assignedPrivateIpAddresses) {
            this.assignedPrivateIpAddresses(Stream.of(assignedPrivateIpAddresses).map(c -> (AssignedPrivateIpAddress)((AssignedPrivateIpAddress.Builder)AssignedPrivateIpAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Ipv4PrefixSpecification.Builder> getAssignedIpv4Prefixes() {
            List<Ipv4PrefixSpecification.Builder> result = Ipv4PrefixesListCopier.copyToBuilder(this.assignedIpv4Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssignedIpv4Prefixes(Collection<Ipv4PrefixSpecification.BuilderImpl> assignedIpv4Prefixes) {
            this.assignedIpv4Prefixes = Ipv4PrefixesListCopier.copyFromBuilder(assignedIpv4Prefixes);
        }

        @Override
        public final Builder assignedIpv4Prefixes(Collection<Ipv4PrefixSpecification> assignedIpv4Prefixes) {
            this.assignedIpv4Prefixes = Ipv4PrefixesListCopier.copy(assignedIpv4Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedIpv4Prefixes(Ipv4PrefixSpecification ... assignedIpv4Prefixes) {
            this.assignedIpv4Prefixes(Arrays.asList(assignedIpv4Prefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedIpv4Prefixes(Consumer<Ipv4PrefixSpecification.Builder> ... assignedIpv4Prefixes) {
            this.assignedIpv4Prefixes(Stream.of(assignedIpv4Prefixes).map(c -> (Ipv4PrefixSpecification)((Ipv4PrefixSpecification.Builder)Ipv4PrefixSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AssignPrivateIpAddressesResponse build() {
            return new AssignPrivateIpAddressesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssignPrivateIpAddressesResponse> {
        public Builder networkInterfaceId(String var1);

        public Builder assignedPrivateIpAddresses(Collection<AssignedPrivateIpAddress> var1);

        public Builder assignedPrivateIpAddresses(AssignedPrivateIpAddress ... var1);

        public Builder assignedPrivateIpAddresses(Consumer<AssignedPrivateIpAddress.Builder> ... var1);

        public Builder assignedIpv4Prefixes(Collection<Ipv4PrefixSpecification> var1);

        public Builder assignedIpv4Prefixes(Ipv4PrefixSpecification ... var1);

        public Builder assignedIpv4Prefixes(Consumer<Ipv4PrefixSpecification.Builder> ... var1);
    }
}

