/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageRecycleBinInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageRecycleBinInfo> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(ImageRecycleBinInfo.getter(ImageRecycleBinInfo::imageId)).setter(ImageRecycleBinInfo.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("imageId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ImageRecycleBinInfo.getter(ImageRecycleBinInfo::name)).setter(ImageRecycleBinInfo.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ImageRecycleBinInfo.getter(ImageRecycleBinInfo::description)).setter(ImageRecycleBinInfo.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<Instant> RECYCLE_BIN_ENTER_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RecycleBinEnterTime").getter(ImageRecycleBinInfo.getter(ImageRecycleBinInfo::recycleBinEnterTime)).setter(ImageRecycleBinInfo.setter(Builder::recycleBinEnterTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecycleBinEnterTime").unmarshallLocationName("recycleBinEnterTime").build()}).build();
    private static final SdkField<Instant> RECYCLE_BIN_EXIT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RecycleBinExitTime").getter(ImageRecycleBinInfo.getter(ImageRecycleBinInfo::recycleBinExitTime)).setter(ImageRecycleBinInfo.setter(Builder::recycleBinExitTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecycleBinExitTime").unmarshallLocationName("recycleBinExitTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, RECYCLE_BIN_ENTER_TIME_FIELD, RECYCLE_BIN_EXIT_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageRecycleBinInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String imageId;
    private final String name;
    private final String description;
    private final Instant recycleBinEnterTime;
    private final Instant recycleBinExitTime;

    private ImageRecycleBinInfo(BuilderImpl builder) {
        this.imageId = builder.imageId;
        this.name = builder.name;
        this.description = builder.description;
        this.recycleBinEnterTime = builder.recycleBinEnterTime;
        this.recycleBinExitTime = builder.recycleBinExitTime;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Instant recycleBinEnterTime() {
        return this.recycleBinEnterTime;
    }

    public final Instant recycleBinExitTime() {
        return this.recycleBinExitTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.recycleBinEnterTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.recycleBinExitTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageRecycleBinInfo)) {
            return false;
        }
        ImageRecycleBinInfo other = (ImageRecycleBinInfo)obj;
        return Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.recycleBinEnterTime(), other.recycleBinEnterTime()) && Objects.equals(this.recycleBinExitTime(), other.recycleBinExitTime());
    }

    public final String toString() {
        return ToString.builder((String)"ImageRecycleBinInfo").add("ImageId", (Object)this.imageId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("RecycleBinEnterTime", (Object)this.recycleBinEnterTime()).add("RecycleBinExitTime", (Object)this.recycleBinExitTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RecycleBinEnterTime": {
                return Optional.ofNullable(clazz.cast(this.recycleBinEnterTime()));
            }
            case "RecycleBinExitTime": {
                return Optional.ofNullable(clazz.cast(this.recycleBinExitTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RecycleBinEnterTime", RECYCLE_BIN_ENTER_TIME_FIELD);
        map.put("RecycleBinExitTime", RECYCLE_BIN_EXIT_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageRecycleBinInfo, T> g) {
        return obj -> g.apply((ImageRecycleBinInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageId;
        private String name;
        private String description;
        private Instant recycleBinEnterTime;
        private Instant recycleBinExitTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageRecycleBinInfo model) {
            this.imageId(model.imageId);
            this.name(model.name);
            this.description(model.description);
            this.recycleBinEnterTime(model.recycleBinEnterTime);
            this.recycleBinExitTime(model.recycleBinExitTime);
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getRecycleBinEnterTime() {
            return this.recycleBinEnterTime;
        }

        public final void setRecycleBinEnterTime(Instant recycleBinEnterTime) {
            this.recycleBinEnterTime = recycleBinEnterTime;
        }

        @Override
        public final Builder recycleBinEnterTime(Instant recycleBinEnterTime) {
            this.recycleBinEnterTime = recycleBinEnterTime;
            return this;
        }

        public final Instant getRecycleBinExitTime() {
            return this.recycleBinExitTime;
        }

        public final void setRecycleBinExitTime(Instant recycleBinExitTime) {
            this.recycleBinExitTime = recycleBinExitTime;
        }

        @Override
        public final Builder recycleBinExitTime(Instant recycleBinExitTime) {
            this.recycleBinExitTime = recycleBinExitTime;
            return this;
        }

        public ImageRecycleBinInfo build() {
            return new ImageRecycleBinInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageRecycleBinInfo> {
        public Builder imageId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder recycleBinEnterTime(Instant var1);

        public Builder recycleBinExitTime(Instant var1);
    }
}

