/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PurchaseCapacityBlockExtensionRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, PurchaseCapacityBlockExtensionRequest> {
    private static final SdkField<String> CAPACITY_BLOCK_EXTENSION_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityBlockExtensionOfferingId").getter(PurchaseCapacityBlockExtensionRequest.getter(PurchaseCapacityBlockExtensionRequest::capacityBlockExtensionOfferingId)).setter(PurchaseCapacityBlockExtensionRequest.setter(Builder::capacityBlockExtensionOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockExtensionOfferingId").unmarshallLocationName("CapacityBlockExtensionOfferingId").build()}).build();
    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationId").getter(PurchaseCapacityBlockExtensionRequest.getter(PurchaseCapacityBlockExtensionRequest::capacityReservationId)).setter(PurchaseCapacityBlockExtensionRequest.setter(Builder::capacityReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId").unmarshallLocationName("CapacityReservationId").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(PurchaseCapacityBlockExtensionRequest.getter(PurchaseCapacityBlockExtensionRequest::dryRun)).setter(PurchaseCapacityBlockExtensionRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_BLOCK_EXTENSION_OFFERING_ID_FIELD, CAPACITY_RESERVATION_ID_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PurchaseCapacityBlockExtensionRequest.memberNameToFieldInitializer();
    private final String capacityBlockExtensionOfferingId;
    private final String capacityReservationId;
    private final Boolean dryRun;

    private PurchaseCapacityBlockExtensionRequest(BuilderImpl builder) {
        super(builder);
        this.capacityBlockExtensionOfferingId = builder.capacityBlockExtensionOfferingId;
        this.capacityReservationId = builder.capacityReservationId;
        this.dryRun = builder.dryRun;
    }

    public final String capacityBlockExtensionOfferingId() {
        return this.capacityBlockExtensionOfferingId;
    }

    public final String capacityReservationId() {
        return this.capacityReservationId;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityBlockExtensionOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseCapacityBlockExtensionRequest)) {
            return false;
        }
        PurchaseCapacityBlockExtensionRequest other = (PurchaseCapacityBlockExtensionRequest)((Object)obj);
        return Objects.equals(this.capacityBlockExtensionOfferingId(), other.capacityBlockExtensionOfferingId()) && Objects.equals(this.capacityReservationId(), other.capacityReservationId()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"PurchaseCapacityBlockExtensionRequest").add("CapacityBlockExtensionOfferingId", (Object)this.capacityBlockExtensionOfferingId()).add("CapacityReservationId", (Object)this.capacityReservationId()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityBlockExtensionOfferingId": {
                return Optional.ofNullable(clazz.cast(this.capacityBlockExtensionOfferingId()));
            }
            case "CapacityReservationId": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationId()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityBlockExtensionOfferingId", CAPACITY_BLOCK_EXTENSION_OFFERING_ID_FIELD);
        map.put("CapacityReservationId", CAPACITY_RESERVATION_ID_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PurchaseCapacityBlockExtensionRequest, T> g) {
        return obj -> g.apply((PurchaseCapacityBlockExtensionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String capacityBlockExtensionOfferingId;
        private String capacityReservationId;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseCapacityBlockExtensionRequest model) {
            super(model);
            this.capacityBlockExtensionOfferingId(model.capacityBlockExtensionOfferingId);
            this.capacityReservationId(model.capacityReservationId);
            this.dryRun(model.dryRun);
        }

        public final String getCapacityBlockExtensionOfferingId() {
            return this.capacityBlockExtensionOfferingId;
        }

        public final void setCapacityBlockExtensionOfferingId(String capacityBlockExtensionOfferingId) {
            this.capacityBlockExtensionOfferingId = capacityBlockExtensionOfferingId;
        }

        @Override
        public final Builder capacityBlockExtensionOfferingId(String capacityBlockExtensionOfferingId) {
            this.capacityBlockExtensionOfferingId = capacityBlockExtensionOfferingId;
            return this;
        }

        public final String getCapacityReservationId() {
            return this.capacityReservationId;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseCapacityBlockExtensionRequest build() {
            return new PurchaseCapacityBlockExtensionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PurchaseCapacityBlockExtensionRequest> {
        public Builder capacityBlockExtensionOfferingId(String var1);

        public Builder capacityReservationId(String var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

