# This file has been autogenerated by the pywayland scanner

# Copyright © 2023 Valve Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlSurface
from .wp_commit_timer_v1 import WpCommitTimerV1


class WpCommitTimingManagerV1(Interface):
    """Commit timing

    When a compositor latches on to new content updates it will check for any
    number of requirements of the available content updates (such as fences of
    all buffers being signalled) to consider the update ready.

    This protocol provides a method for adding a time constraint to surface
    content. This constraint indicates to the compositor that a content update
    should be presented as closely as possible to, but not before, a specified
    time.

    This protocol does not change the Wayland property that content updates are
    applied in the order they are received, even when some content updates
    contain timestamps and others do not.

    To provide timestamps, this global factory interface must be used to
    acquire a wp_commit_timing_v1 object for a surface, which may then be used
    to provide timestamp information for commits.

    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """

    name = "wp_commit_timing_manager_v1"
    version = 1

    class error(enum.IntEnum):
        commit_timer_exists = 0


class WpCommitTimingManagerV1Proxy(Proxy[WpCommitTimingManagerV1]):
    interface = WpCommitTimingManagerV1

    @WpCommitTimingManagerV1.request()
    def destroy(self) -> None:
        """Unbind from the commit timing interface

        Informs the server that the client will no longer be using this
        protocol object. Existing objects created by this object are not
        affected.
        """
        self._marshal(0)
        self._destroy()

    @WpCommitTimingManagerV1.request(
        Argument(ArgumentType.NewId, interface=WpCommitTimerV1),
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def get_timer(self, surface: WlSurface) -> Proxy[WpCommitTimerV1]:
        """Request commit timer interface for surface

        Establish a timing controller for a surface.

        Only one commit timer can be created for a surface, or a
        commit_timer_exists protocol error will be generated.

        :param surface:
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :returns:
            :class:`~pywayland.protocol.commit_timing_v1.WpCommitTimerV1`
        """
        id = self._marshal_constructor(1, WpCommitTimerV1, surface)
        return id


class WpCommitTimingManagerV1Resource(Resource):
    interface = WpCommitTimingManagerV1


class WpCommitTimingManagerV1Global(Global):
    interface = WpCommitTimingManagerV1


WpCommitTimingManagerV1._gen_c()
WpCommitTimingManagerV1.proxy_class = WpCommitTimingManagerV1Proxy
WpCommitTimingManagerV1.resource_class = WpCommitTimingManagerV1Resource
WpCommitTimingManagerV1.global_class = WpCommitTimingManagerV1Global
