/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.Objects;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.internal.webkit.WebKitGTK;
import org.jkiss.dbeaver.Log;

public class DBeaverBrowserHelper {
    private static final Log log = Log.getLog(DBeaverBrowserHelper.class);

    private DBeaverBrowserHelper() {
    }

    public static void clearCookies(Browser browser) {
        Objects.requireNonNull(browser, "browser cannot be null");
        if (!WebKitGTK.LibraryLoaded) {
            return;
        }
        if (WebKitGTK.webkit_get_minor_version() < 16) {
            log.warn((Object)"SWT WebKit: clear sessions only supported on WebKitGtk version 2.16 and above.");
            return;
        }
        long context = WebKitGTK.webkit_web_context_get_default();
        long manager = WebKitGTK.webkit_web_context_get_website_data_manager((long)context);
        WebKitGTK.webkit_website_data_manager_clear((long)manager, (long)WebKitGTK.WEBKIT_WEBSITE_DATA_COOKIES, (long)0L, (long)0L, (long)0L, (long)0L);
    }
}

