/**
 * SECTION:anti-linkable
 * @short_description: Interface for <link linkend="FolksPersona"><type>FolksPersona</type></link> subclasses from backends which support storage of, anti-linking data.
 * 
 * <para>Anti-links are stored as a set of <link linkend="FolksPersona--uid"><type>"uid"</type></link>s with each <link linkend="FolksPersona"><type>FolksPersona</type></link> (A), specifying that A must not be linked into an <link linkend="FolksIndividual"><type>FolksIndividual</type></link> with any of the personas in its anti-links set.</para>
 *
 * Since: 0.7.3
 */
/**
 * folks_anti_linkable_change_anti_links:
 * @self: the <link linkend="FolksAntiLinkable"><type>FolksAntiLinkable</type></link> instance
 * @anti_links: (in): &nbsp;.  <para>the new set of anti-links from this persona </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the <link linkend="FolksPersona"><type>FolksPersona</type></link>&apos;s set of anti-links.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksAntiLinkable--anti-links"><type>"anti-links"</type></link> directly, as this method gives error notification and will only return once the anti-links have been written to the relevant backing store (or the operation&apos;s failed).</para><para>It should be noted that <link linkend="folks-individual-aggregator-link-personas"><function>folks_individual_aggregator_link_personas()</function></link> and <link linkend="folks-individual-aggregator-unlink-individual"><function>folks_individual_aggregator_unlink_individual()</function></link> will modify the anti-links sets of the personas they touch, in order to remove and add anti-links, respectively. It is expected that these <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> methods will be used to modify anti-links indirectly, rather than calling <link linkend="folks-anti-linkable-change-anti-links"><function>folks_anti_linkable_change_anti_links()</function></link> directly.</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the anti-links failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-anti-linkable-change-anti-links-finish"><function>folks_anti_linkable_change_anti_links_finish()</function></link>
 *
 * Since: 0.7.3
 */
/**
 * folks_anti_linkable_change_anti_links_finish:
 * @self: the <link linkend="FolksAntiLinkable"><type>FolksAntiLinkable</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the <link linkend="FolksPersona"><type>FolksPersona</type></link>&apos;s set of anti-links.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksAntiLinkable--anti-links"><type>"anti-links"</type></link> directly, as this method gives error notification and will only return once the anti-links have been written to the relevant backing store (or the operation&apos;s failed).</para><para>It should be noted that <link linkend="folks-individual-aggregator-link-personas"><function>folks_individual_aggregator_link_personas()</function></link> and <link linkend="folks-individual-aggregator-unlink-individual"><function>folks_individual_aggregator_unlink_individual()</function></link> will modify the anti-links sets of the personas they touch, in order to remove and add anti-links, respectively. It is expected that these <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> methods will be used to modify anti-links indirectly, rather than calling <link linkend="folks-anti-linkable-change-anti-links"><function>folks_anti_linkable_change_anti_links()</function></link> directly.</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the anti-links failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-anti-linkable-change-anti-links"><function>folks_anti_linkable_change_anti_links()</function></link>
 *
 * Since: 0.7.3
 */
/**
 * folks_anti_linkable_has_anti_link_with_persona:
 * @self: the <link linkend="FolksAntiLinkable"><type>FolksAntiLinkable</type></link> instance
 * @other_persona: (in): &nbsp;.  <para>the persona to check is anti-linked </para>
 * 
 * Check for an anti-link with another persona.
 * 
 * <para>This will return <code>true</code> if <code>other_persona</code>&apos;s UID is listed in this persona&apos;s anti-links set. Note that this check is not symmetric.</para>
 * 
 * Returns: <para><code>true</code> if an anti-link exists, <code>false</code> otherwise </para>
 *
 * Since: 0.7.3
 */
/**
 * folks_anti_linkable_add_anti_links:
 * @self: the <link linkend="FolksAntiLinkable"><type>FolksAntiLinkable</type></link> instance
 * @other_personas: (in): &nbsp;.  <para>the personas to anti-link to this one </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Add anti-links to other personas.
 * 
 * <para>The UIDs of all personas in <code>other_personas</code> will be added to this persona&apos;s anti-links set and the changes propagated to backends.</para><para>Any attempt to anti-link a persona with itself is not an error, but is ignored.</para><para>This method is safe to call multiple times concurrently (e.g. begin one asynchronous call, then begin another before the first has finished).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the anti-links failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-anti-linkable-add-anti-links-finish"><function>folks_anti_linkable_add_anti_links_finish()</function></link>
 *
 * Since: 0.7.3
 */
/**
 * folks_anti_linkable_add_anti_links_finish:
 * @self: the <link linkend="FolksAntiLinkable"><type>FolksAntiLinkable</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Add anti-links to other personas.
 * 
 * <para>The UIDs of all personas in <code>other_personas</code> will be added to this persona&apos;s anti-links set and the changes propagated to backends.</para><para>Any attempt to anti-link a persona with itself is not an error, but is ignored.</para><para>This method is safe to call multiple times concurrently (e.g. begin one asynchronous call, then begin another before the first has finished).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the anti-links failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-anti-linkable-add-anti-links"><function>folks_anti_linkable_add_anti_links()</function></link>
 *
 * Since: 0.7.3
 */
/**
 * folks_anti_linkable_remove_anti_links:
 * @self: the <link linkend="FolksAntiLinkable"><type>FolksAntiLinkable</type></link> instance
 * @other_personas: (in): &nbsp;.  <para>the personas to remove anti-links from this one </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Remove anti-links to other personas.
 * 
 * <para>The UIDs of all personas in <code>other_personas</code> will be removed from this persona&apos;s anti-links set and the changes propagated to backends.</para><para>If the global anti-link is set, this will not have any effect until the global anti-link is removed.</para><para>This method is safe to call multiple times concurrently (e.g. begin one asynchronous call, then begin another before the first has finished).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the anti-links failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-anti-linkable-remove-anti-links-finish"><function>folks_anti_linkable_remove_anti_links_finish()</function></link>
 *
 * Since: 0.7.3
 */
/**
 * folks_anti_linkable_remove_anti_links_finish:
 * @self: the <link linkend="FolksAntiLinkable"><type>FolksAntiLinkable</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Remove anti-links to other personas.
 * 
 * <para>The UIDs of all personas in <code>other_personas</code> will be removed from this persona&apos;s anti-links set and the changes propagated to backends.</para><para>If the global anti-link is set, this will not have any effect until the global anti-link is removed.</para><para>This method is safe to call multiple times concurrently (e.g. begin one asynchronous call, then begin another before the first has finished).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the anti-links failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-anti-linkable-remove-anti-links"><function>folks_anti_linkable_remove_anti_links()</function></link>
 *
 * Since: 0.7.3
 */
/**
 * folks_anti_linkable_add_global_anti_link:
 * @self: the <link linkend="FolksAntiLinkable"><type>FolksAntiLinkable</type></link> instance
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Prevent persona from being linked with any other personas
 * 
 * <para>This function will add a wildcard <code>*</code> to the set of anti-links, which will prevent the persona from being linked with any other personas.</para><para>To make the persona linkable again you need to remove the global anti-link</para><para>This method is safe to call multiple times concurrently (e.g. begin one asynchronous call, then begin another before the first has finished).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the anti-links failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-anti-linkable-add-global-anti-link-finish"><function>folks_anti_linkable_add_global_anti_link_finish()</function></link>
 *
 * Since: 0.9.7
 */
/**
 * folks_anti_linkable_add_global_anti_link_finish:
 * @self: the <link linkend="FolksAntiLinkable"><type>FolksAntiLinkable</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Prevent persona from being linked with any other personas
 * 
 * <para>This function will add a wildcard <code>*</code> to the set of anti-links, which will prevent the persona from being linked with any other personas.</para><para>To make the persona linkable again you need to remove the global anti-link</para><para>This method is safe to call multiple times concurrently (e.g. begin one asynchronous call, then begin another before the first has finished).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the anti-links failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-anti-linkable-add-global-anti-link"><function>folks_anti_linkable_add_global_anti_link()</function></link>
 *
 * Since: 0.9.7
 */
/**
 * folks_anti_linkable_remove_global_anti_link:
 * @self: the <link linkend="FolksAntiLinkable"><type>FolksAntiLinkable</type></link> instance
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Allow persona to be linked with other personas
 * 
 * <para>This function removes the wildcard <code>*</code> from the set of anti-links, allowing the persona to be linked again.</para><para>This method is safe to call multiple times concurrently (e.g. begin one asynchronous call, then begin another before the first has finished).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the anti-links failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-anti-linkable-remove-global-anti-link-finish"><function>folks_anti_linkable_remove_global_anti_link_finish()</function></link>
 *
 * Since: 0.9.7
 */
/**
 * folks_anti_linkable_remove_global_anti_link_finish:
 * @self: the <link linkend="FolksAntiLinkable"><type>FolksAntiLinkable</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Allow persona to be linked with other personas
 * 
 * <para>This function removes the wildcard <code>*</code> from the set of anti-links, allowing the persona to be linked again.</para><para>This method is safe to call multiple times concurrently (e.g. begin one asynchronous call, then begin another before the first has finished).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the anti-links failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-anti-linkable-remove-global-anti-link"><function>folks_anti_linkable_remove_global_anti_link()</function></link>
 *
 * Since: 0.9.7
 */
/**
 * folks_anti_linkable_has_global_anti_link:
 * @self: the <link linkend="FolksAntiLinkable"><type>FolksAntiLinkable</type></link> instance
 * 
 * Check if the persona has a global anti link.
 * 
 * <para>If the persona has global anti link this means that the persona can not be linked with any other persona.</para>
 *
 * Since: 0.9.7
 */
/**
 * FolksAntiLinkable:anti-links:
 * 
 * UIDs of anti-linked <link linkend="FolksPersona"><type>FolksPersona</type></link>s.
 * 
 * <para>The <link linkend="FolksPersona"><type>FolksPersona</type></link>s identified by their UIDs in this set are guaranteed to not be linked to this <link linkend="FolksPersona"><type>FolksPersona</type></link>, even if their linkable properties match.</para><para>No UIDs may be <code>null</code>. Well-formed but non-existent UIDs (i.e. UIDs which can be successfully parsed, but which don&apos;t currently correspond to a <link linkend="FolksPersona"><type>FolksPersona</type></link> instance) are permitted, as personas may appear and disappear over time.</para><para>The special UID <code>*</code> is used as a wildcard to mark the persona as globally anti-linked. See <link linkend="folks-anti-linkable-has-global-anti-link"><function>folks_anti_linkable_has_global_anti_link()</function></link>.</para><para>It is expected, but not guaranteed, that anti-links made between personas will be reciprocal. That is, if persona A lists persona B&apos;s UID in its <link linkend="FolksAntiLinkable--anti-links"><type>"anti-links"</type></link> set, persona B will typically also list persona A in its anti-links set.</para>
 *
 * Since: 0.7.3
 */
/**
 * folks_anti_linkable_get_anti_links:
 * @self: the <link linkend="FolksAntiLinkable"><type>FolksAntiLinkable</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksAntiLinkable--anti-links"><type>"anti-links"</type></link> property.
 * 
 * UIDs of anti-linked <link linkend="FolksPersona"><type>FolksPersona</type></link>s.
 * 
 * <para>The <link linkend="FolksPersona"><type>FolksPersona</type></link>s identified by their UIDs in this set are guaranteed to not be linked to this <link linkend="FolksPersona"><type>FolksPersona</type></link>, even if their linkable properties match.</para><para>No UIDs may be <code>null</code>. Well-formed but non-existent UIDs (i.e. UIDs which can be successfully parsed, but which don&apos;t currently correspond to a <link linkend="FolksPersona"><type>FolksPersona</type></link> instance) are permitted, as personas may appear and disappear over time.</para><para>The special UID <code>*</code> is used as a wildcard to mark the persona as globally anti-linked. See <link linkend="folks-anti-linkable-has-global-anti-link"><function>folks_anti_linkable_has_global_anti_link()</function></link>.</para><para>It is expected, but not guaranteed, that anti-links made between personas will be reciprocal. That is, if persona A lists persona B&apos;s UID in its <link linkend="FolksAntiLinkable--anti-links"><type>"anti-links"</type></link> set, persona B will typically also list persona A in its anti-links set.</para>
 * 
 * Returns: the value of the <link linkend="FolksAntiLinkable--anti-links"><type>"anti-links"</type></link> property
 *
 * Since: 0.7.3
 */
/**
 * folks_anti_linkable_set_anti_links:
 * @self: the <link linkend="FolksAntiLinkable"><type>FolksAntiLinkable</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksAntiLinkable--anti-links"><type>"anti-links"</type></link> property
 * 
 * Set the value of the <link linkend="FolksAntiLinkable--anti-links"><type>"anti-links"</type></link> property to @value.
 * 
 * UIDs of anti-linked <link linkend="FolksPersona"><type>FolksPersona</type></link>s.
 * 
 * <para>The <link linkend="FolksPersona"><type>FolksPersona</type></link>s identified by their UIDs in this set are guaranteed to not be linked to this <link linkend="FolksPersona"><type>FolksPersona</type></link>, even if their linkable properties match.</para><para>No UIDs may be <code>null</code>. Well-formed but non-existent UIDs (i.e. UIDs which can be successfully parsed, but which don&apos;t currently correspond to a <link linkend="FolksPersona"><type>FolksPersona</type></link> instance) are permitted, as personas may appear and disappear over time.</para><para>The special UID <code>*</code> is used as a wildcard to mark the persona as globally anti-linked. See <link linkend="folks-anti-linkable-has-global-anti-link"><function>folks_anti_linkable_has_global_anti_link()</function></link>.</para><para>It is expected, but not guaranteed, that anti-links made between personas will be reciprocal. That is, if persona A lists persona B&apos;s UID in its <link linkend="FolksAntiLinkable--anti-links"><type>"anti-links"</type></link> set, persona B will typically also list persona A in its anti-links set.</para>
 *
 * Since: 0.7.3
 */
/**
 * FolksAntiLinkable:
 * 
 * Interface for <link linkend="FolksPersona"><type>FolksPersona</type></link> subclasses from backends which support storage of, anti-linking data.
 * 
 * <para>Anti-links are stored as a set of <link linkend="FolksPersona--uid"><type>"uid"</type></link>s with each <link linkend="FolksPersona"><type>FolksPersona</type></link> (A), specifying that A must not be linked into an <link linkend="FolksIndividual"><type>FolksIndividual</type></link> with any of the personas in its anti-links set.</para>
 *
 * Since: 0.7.3
 */
/**
 * FolksAntiLinkableIface:
 * @change_anti_links: virtual method called by <link linkend="folks-anti-linkable-change-anti-links"><function>folks_anti_linkable_change_anti_links()</function></link>
 * @change_anti_links_finish: asynchronous finish function for <structfield>change_anti_links</structfield>, called by <link linkend="folks-anti-linkable-change-anti-links"><function>folks_anti_linkable_change_anti_links()</function></link>
 * @get_anti_links: getter method for the abstract property <link linkend="FolksAntiLinkable--anti-links"><type>"anti-links"</type></link>
 * @set_anti_links: setter method for the abstract property <link linkend="FolksAntiLinkable--anti-links"><type>"anti-links"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksAntiLinkable"><type>FolksAntiLinkable</type></link> implementations.
 */
