/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;

class TableWorks {
    private Table table;
    private Session session;

    TableWorks(Session session, Table table) {
        this.table = table;
        this.session = session;
    }

    Table getTable() {
        return this.table;
    }

    void createForeignKey(int[] nArray, int[] nArray2, HsqlNameManager.HsqlName hsqlName, Table table, int n, int n2) throws HsqlException {
        this.table.database.schemaManager.checkConstraintExists(hsqlName.name, this.table.getSchemaName(), false);
        if (this.table.getConstraint(hsqlName.name) != null) {
            throw Trace.error(60);
        }
        if (this.table.getConstraintForColumns(table, nArray2, nArray) != null) {
            throw Trace.error(60);
        }
        if (table.isTemp() != this.table.isTemp()) {
            throw Trace.error(47);
        }
        boolean bl = this.table == table;
        int n3 = this.table.database.schemaManager.getTableIndex(this.table);
        boolean bl2 = n3 != -1 && n3 < this.table.database.schemaManager.getTableIndex(table);
        Index index = table.getUniqueConstraintIndexForColumns(nArray2);
        if (index == null) {
            throw Trace.error(170, table.getName().statementName);
        }
        Constraint.checkReferencedRows(this.session, this.table, nArray, index);
        HsqlNameManager.HsqlName hsqlName2 = this.table.database.nameManager.newAutoName("IDX");
        Index index2 = this.createIndex(nArray, hsqlName2, false, true, bl2);
        HsqlNameManager.HsqlName hsqlName3 = this.table.database.nameManager.newAutoName("REF", hsqlName.name);
        if (bl) {
            table = this.table;
        }
        Constraint constraint = new Constraint(hsqlName3, hsqlName, table, this.table, nArray2, nArray, index, index2, n, n2);
        this.table.addConstraint(constraint);
        table.addConstraint(new Constraint(hsqlName3, constraint));
        this.table.database.schemaManager.registerConstraintName(hsqlName.name, this.table.getName());
    }

    Index createIndex(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3) throws HsqlException {
        Index index;
        if (this.table.isEmpty(this.session) || this.table.isIndexingMutable()) {
            index = this.table.createIndex(this.session, nArray, hsqlName, bl, bl2, bl3);
            this.table.database.schemaManager.clearTempTables(this.session, this.table);
        } else {
            Table table = this.table.moveDefinition(null, null, -1, 0);
            index = table.createIndexStructure(nArray, hsqlName, bl, bl2, bl3);
            table.moveData(this.session, this.table, -1, 0);
            table.updateConstraintsTables(this.session, this.table, -1, 0);
            int n = this.table.database.schemaManager.getTableIndex(this.table);
            this.table.database.schemaManager.setTable(n, table);
            this.table = table;
        }
        this.table.database.schemaManager.clearTempTables(this.session, this.table);
        this.table.database.schemaManager.registerIndexName(index.getName().name, this.table.getName());
        this.table.database.schemaManager.recompileViews(this.table);
        return index;
    }

    void addPrimaryKey(int[] nArray, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        if (hsqlName == null) {
            hsqlName = this.table.makeSysPKName();
        }
        this.table.database.schemaManager.checkConstraintExists(hsqlName.name, this.table.getSchemaName(), false);
        this.addOrDropPrimaryKey(nArray, false);
        Constraint constraint = new Constraint(hsqlName, this.table, this.table.getPrimaryIndex(), 4);
        this.table.addConstraint(constraint);
        this.table.database.schemaManager.registerConstraintName(hsqlName.name, this.table.getName());
    }

    void addOrDropPrimaryKey(int[] nArray, boolean bl) throws HsqlException {
        if (nArray == null) {
            this.table.checkDropIndex(this.table.getIndexes()[0].getName().name, null, true);
        }
        Table table = this.table.moveDefinitionPK(nArray, bl);
        table.moveData(this.session, this.table, -1, 0);
        table.updateConstraintsTables(this.session, this.table, -1, 0);
        int n = this.table.database.schemaManager.getTableIndex(this.table);
        this.table.database.schemaManager.setTable(n, table);
        this.table = table;
        this.table.database.schemaManager.recompileViews(this.table);
    }

    void createUniqueConstraint(int[] nArray, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        Constraint constraint2;
        this.table.database.schemaManager.checkConstraintExists(hsqlName.name, this.table.getSchemaName(), false);
        for (Constraint constraint2 : this.table.getConstraints()) {
            if (!constraint2.isEquivalent(nArray, 2) && !constraint2.getName().name.equals(hsqlName.name)) continue;
            throw Trace.error(60);
        }
        HsqlNameManager.HsqlName hsqlName2 = this.table.database.nameManager.newAutoName("IDX", hsqlName.name);
        Index index = this.createIndex(nArray, hsqlName2, true, true, false);
        constraint2 = new Constraint(hsqlName, this.table, index, 2);
        this.table.addConstraint(constraint2);
        this.table.database.schemaManager.registerConstraintName(hsqlName.name, this.table.getName());
    }

    void createCheckConstraint(Constraint constraint, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        this.table.database.schemaManager.checkConstraintExists(hsqlName.name, this.table.getSchemaName(), false);
        Expression expression = constraint.core.check;
        expression.setLikeOptimised();
        Select select = Expression.getCheckSelect(this.session, this.table, expression);
        Result result = select.getResult(this.session, 1);
        constraint.core.checkFilter = select.tFilter[0];
        constraint.core.mainTable = this.table;
        if (result.getSize() != 0) {
            throw Trace.error(157);
        }
        expression.getDDL();
        constraint.core.checkFilter.setAsCheckFilter();
        this.table.addConstraint(constraint);
        this.table.database.schemaManager.registerConstraintName(hsqlName.name, this.table.getName());
    }

    void dropIndex(String string) throws HsqlException {
        if (this.table.isIndexingMutable()) {
            this.table.dropIndex(this.session, string);
        } else {
            int[] nArray = new int[]{this.table.getIndexIndex(string)};
            Table table = this.table.moveDefinition(nArray, null, -1, 0);
            table.moveData(this.session, this.table, -1, 0);
            table.updateConstraintsTables(this.session, this.table, -1, 0);
            int n = this.table.database.schemaManager.getTableIndex(this.table);
            this.table.database.schemaManager.setTable(n, table);
            this.table = table;
        }
        this.table.database.schemaManager.removeIndexName(string, this.table.getName());
        this.table.database.schemaManager.recompileViews(this.table);
    }

    void retypeColumn(Column column, int n) throws HsqlException {
        if (this.table.isText() && !this.table.isEmpty(this.session)) {
            throw Trace.error(73);
        }
        this.table.database.schemaManager.checkColumnIsInView(this.table, this.table.getColumn((int)n).columnName.name);
        this.table.checkColumnInCheckConstraint(this.table.getColumn((int)n).columnName.name);
        int[] nArray = null;
        Table table = this.table.moveDefinition(nArray, column, n, 0);
        table.moveData(this.session, this.table, n, 0);
        table.updateConstraintsTables(this.session, this.table, n, 0);
        int n2 = this.table.database.schemaManager.getTableIndex(this.table);
        this.table.database.schemaManager.setTable(n2, table);
        this.table = table;
        this.table.database.schemaManager.recompileViews(this.table);
    }

    void dropColumn(int n) throws HsqlException {
        Constraint constraint;
        HsqlNameManager.HsqlName hsqlName = null;
        if (this.table.isText() && !this.table.isEmpty(this.session)) {
            throw Trace.error(73);
        }
        this.table.database.schemaManager.checkColumnIsInView(this.table, this.table.getColumn((int)n).columnName.name);
        this.table.checkColumnInCheckConstraint(this.table.getColumn((int)n).columnName.name);
        Table table = this.table;
        int[] nArray = null;
        String string = table.getColumn((int)n).columnName.name;
        table.checkColumnInFKConstraint(n);
        if (this.table.getPrimaryKey().length == 1 && this.table.getPrimaryKey()[0] == n) {
            this.table.checkDropIndex(this.table.getIndex((int)0).getName().name, null, true);
            hsqlName = this.table.constraintList[0].getName();
            table = this.table.moveDefinitionPK(null, false);
        }
        if ((constraint = table.getUniqueConstraintForColumns(new int[]{n})) != null) {
            Index index = constraint.getMainIndex();
            nArray = new int[]{table.getIndexIndex(index.getName().name)};
            hsqlName = constraint.getName();
        }
        table = table.moveDefinition(nArray, null, n, -1);
        table.moveData(this.session, this.table, n, -1);
        table.updateConstraintsTables(this.session, this.table, n, -1);
        int n2 = this.table.database.schemaManager.getTableIndex(this.table);
        this.table.database.schemaManager.setTable(n2, table);
        this.table = table;
        this.table.database.schemaManager.recompileViews(this.table);
        if (hsqlName != null) {
            this.table.removeConstraint(hsqlName.name);
            this.table.database.schemaManager.removeConstraintName(hsqlName.name, this.table.getName());
        }
    }

    void addColumn(Column column, int n) throws HsqlException {
        if (this.table.isText() && !this.table.isEmpty(this.session)) {
            throw Trace.error(73);
        }
        Table table = this.table;
        table = table.moveDefinition(null, column, n, 1);
        if (column.isPrimaryKey()) {
            table = table.moveDefinitionPK(new int[]{n}, true);
        }
        table.moveData(this.session, this.table, n, 1);
        table.updateConstraintsTables(this.session, this.table, n, 1);
        int n2 = this.table.database.schemaManager.getTableIndex(this.table);
        this.table.database.schemaManager.setTable(n2, table);
        this.table = table;
        this.table.database.schemaManager.recompileViews(this.table);
        if (column.isPrimaryKey()) {
            HsqlNameManager.HsqlName hsqlName = table.makeSysPKName();
            Constraint constraint = new Constraint(hsqlName, this.table, this.table.getPrimaryIndex(), 4);
            this.table.addConstraint(constraint);
            this.table.database.schemaManager.registerConstraintName(hsqlName.name, this.table.getName());
        }
    }

    void dropConstraint(String string) throws HsqlException {
        Constraint constraint = this.table.getConstraint(string);
        if (constraint == null) {
            throw Trace.error(61, 171, new Object[]{string, this.table.getName().name});
        }
        int n = constraint.getType();
        if (n == 1) {
            throw Trace.error(59);
        }
        if (n == 4) {
            this.addOrDropPrimaryKey(null, false);
            this.table.removeConstraint(string);
        } else if (n == 0) {
            this.dropFKConstraint(constraint);
        } else if (n == 2) {
            HashSet hashSet = new HashSet();
            hashSet.add(constraint);
            this.table.checkDropIndex(constraint.getMainIndex().getName().name, hashSet, false);
            this.dropIndex(constraint.getMainIndex().getName().name);
            this.table.removeConstraint(string);
        } else if (n == 3) {
            this.table.removeConstraint(string);
        }
        this.table.database.schemaManager.removeConstraintName(string, this.table.getName());
    }

    void dropFKConstraint(Constraint constraint) throws HsqlException {
        Index index = constraint.getRefIndex();
        this.dropIndex(index.getName().name);
        Table table = constraint.getMain();
        table.removeConstraint(constraint.getPkName());
        this.table.removeConstraint(constraint.getFkName());
    }

    void reTypeColumn(Column column, Column column2) throws HsqlException {
        boolean bl = false;
        int n = column.getType();
        int n2 = column2.getType();
        switch (n2) {
            case -4: 
            case -3: 
            case -2: 
            case 1111: 
            case 2000: {
                bl = n2 != n && !this.table.isEmpty(this.session);
            }
        }
        switch (n) {
            case -4: 
            case -3: 
            case -2: 
            case 1111: 
            case 2000: {
                bl = n2 != n && !this.table.isEmpty(this.session);
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                switch (n2) {
                    case 91: 
                    case 92: 
                    case 93: {
                        bl = !this.table.isEmpty(this.session);
                    }
                }
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                switch (n2) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        bl = !this.table.isEmpty(this.session);
                    }
                }
            }
        }
        if (bl) {
            throw Trace.error(95);
        }
        int n3 = this.table.getColumnNr(column.columnName.name);
        if (this.table.getPrimaryKey().length > 1) {
            if (column2.isIdentity()) {
                throw Trace.error(24);
            }
            column2.setPrimaryKey(column.isPrimaryKey());
            if (ArrayUtil.find(this.table.getPrimaryKey(), n3) != -1) {
                column2.setNullable(false);
            }
        } else if (this.table.hasPrimaryKey()) {
            if (column.isPrimaryKey()) {
                column2.setPrimaryKey(true);
                column2.setNullable(false);
            } else if (column2.isPrimaryKey()) {
                throw Trace.error(24);
            }
        } else if (column2.isPrimaryKey()) {
            throw Trace.error(251);
        }
        if (n2 == n && column.isNullable() == column2.isNullable() && column.getScale() == column2.getScale() && column.isIdentity() == column2.isIdentity() && column.identityIncrement == column2.identityIncrement && (column.getSize() == column2.getSize() || column.getSize() < column2.getSize() && (n == 12 || n == 3 || n == 2))) {
            column.setType(column2);
            column.setDefaultExpression(column2.getDefaultExpression());
            this.table.colSizes[n3] = column.getSize();
            this.table.colDefaults[n3] = column.getDefaultExpression();
            this.table.resetDefaultsFlag();
            return;
        }
        this.table.database.schemaManager.checkColumnIsInView(this.table, this.table.getColumn((int)n3).columnName.name);
        this.table.checkColumnInCheckConstraint(this.table.getColumn((int)n3).columnName.name);
        this.table.checkColumnInFKConstraint(n3);
        this.checkConvertColDataType(column, column2);
        this.retypeColumn(column2, n3);
    }

    void checkConvertColDataType(Column column, Column column2) throws HsqlException {
        int n = this.table.getColumnNr(column.columnName.name);
        RowIterator rowIterator = this.table.getPrimaryIndex().firstRow(this.session);
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            Object object = row.getData()[n];
            Column.convertObject(this.session, object, column2.getType(), column2.getSize(), column2.getScale());
        }
    }

    void setColNullability(Column column, boolean bl) throws HsqlException {
        int n = this.table.getColumnNr(column.columnName.name);
        if (bl) {
            if (column.isPrimaryKey()) {
                throw Trace.error(10);
            }
            this.table.checkColumnInFKConstraint(n, 2);
        } else {
            RowIterator rowIterator = this.table.getPrimaryIndex().firstRow(this.session);
            while (rowIterator.hasNext()) {
                Row row = rowIterator.next();
                Object object = row.getData()[n];
                if (object != null) continue;
                throw Trace.error(10);
            }
        }
        column.setNullable(bl);
        this.table.setColumnTypeVars(n);
    }

    void setColDefaultExpression(int n, Expression expression) throws HsqlException {
        if (expression == null) {
            this.table.checkColumnInFKConstraint(n, 4);
        }
        this.table.setDefaultExpression(n, expression);
    }
}

