/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.Nullable;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.transport.BoundTransportAddress;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.discovery.HandshakingTransportAddressConnector;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskManager;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.ClusterConnectionManager;
import org.opensearch.transport.ConnectTransportException;
import org.opensearch.transport.ConnectionProfile;
import org.opensearch.transport.RemoteClusterService;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportInterceptor;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public class StreamTransportService
extends TransportService {
    private static final Logger logger = LogManager.getLogger(StreamTransportService.class);
    public static final Setting<TimeValue> STREAM_TRANSPORT_REQ_TIMEOUT_SETTING = Setting.timeSetting("transport.stream.request_timeout", TimeValue.timeValueMinutes((long)5L), Setting.Property.NodeScope, Setting.Property.Dynamic);
    private volatile TimeValue streamTransportReqTimeout;

    public StreamTransportService(Settings settings, Transport streamTransport, ThreadPool threadPool, TransportInterceptor transportInterceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, TaskManager taskManager, RemoteClusterService remoteClusterService, Tracer tracer) {
        super(settings, streamTransport, threadPool, transportInterceptor, localNodeFactory, new ClusterConnectionManager(ConnectionProfile.buildSingleChannelProfile(TransportRequestOptions.Type.STREAM, HandshakingTransportAddressConnector.PROBE_CONNECT_TIMEOUT_SETTING.get(settings), HandshakingTransportAddressConnector.PROBE_HANDSHAKE_TIMEOUT_SETTING.get(settings), TimeValue.MINUS_ONE, false), streamTransport), tracer, taskManager, remoteClusterService, true);
        this.streamTransportReqTimeout = STREAM_TRANSPORT_REQ_TIMEOUT_SETTING.get(settings);
        if (clusterSettings != null) {
            clusterSettings.addSettingsUpdateConsumer(STREAM_TRANSPORT_REQ_TIMEOUT_SETTING, this::setStreamTransportReqTimeout);
        }
    }

    @Override
    public <T extends TransportResponse> void sendChildRequest(Transport.Connection connection, String action, TransportRequest request, Task parentTask, TransportResponseHandler<T> handler) {
        this.sendChildRequest(connection, action, request, parentTask, TransportRequestOptions.builder().withType(TransportRequestOptions.Type.STREAM).withTimeout(this.streamTransportReqTimeout).build(), handler);
    }

    @Override
    public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile, ActionListener<Void> listener) {
        if (this.isLocalNode(node)) {
            listener.onResponse(null);
            return;
        }
        ActionListener wrappedListener = ActionListener.wrap(response -> listener.onResponse(response), exception -> {
            logger.warn("Failed to connect to streaming node [{}]: {}", (Object)node, (Object)exception.getMessage());
            listener.onFailure((Exception)((Object)new ConnectTransportException(node, "Failed to connect for streaming", (Throwable)exception)));
        });
        this.connectionManager.connectToNode(node, connectionProfile, (connection, profile, listener1) -> listener1.onResponse(null), (ActionListener<Void>)wrappedListener);
    }

    @Override
    public Transport.Connection getConnection(DiscoveryNode node) {
        try {
            return this.connectionManager.getConnection(node);
        }
        catch (Exception e) {
            logger.error("Failed to get streaming connection to node [{}]: {}", (Object)node, (Object)e.getMessage());
            throw new ConnectTransportException(node, "Failed to get streaming connection", e);
        }
    }

    private void setStreamTransportReqTimeout(TimeValue streamTransportReqTimeout) {
        this.streamTransportReqTimeout = streamTransportReqTimeout;
    }
}

