/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import jogamp.graph.font.typecast.ot.Glyph;
import jogamp.graph.font.typecast.ot.OTFont;
import jogamp.graph.font.typecast.ot.TTGlyph;
import jogamp.graph.font.typecast.ot.table.GaspTable;
import jogamp.graph.font.typecast.ot.table.GlyfDescript;
import jogamp.graph.font.typecast.ot.table.GlyfTable;
import jogamp.graph.font.typecast.ot.table.HdmxTable;
import jogamp.graph.font.typecast.ot.table.KernTable;
import jogamp.graph.font.typecast.ot.table.LocaTable;
import jogamp.graph.font.typecast.ot.table.TableDirectory;
import jogamp.graph.font.typecast.ot.table.VdmxTable;

public class TTFont
extends OTFont {
    private final GlyfTable _glyf;
    private GaspTable _gasp;
    private KernTable _kern;
    private HdmxTable _hdmx;
    private VdmxTable _vdmx;

    private static TableDirectory readTableDir(DataInputStream dataInputStream, int n) throws IOException {
        dataInputStream.reset();
        dataInputStream.skip(n);
        return new TableDirectory(dataInputStream);
    }

    private static DataInputStream openStream(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File <" + file.getName() + "> doesn't exist.");
        }
        int n = (int)file.length();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), n);
        if (!bufferedInputStream.markSupported()) {
            throw new IllegalArgumentException("stream of type " + bufferedInputStream.getClass().getName() + " doesn't support mark");
        }
        bufferedInputStream.mark(n);
        return new DataInputStream(bufferedInputStream);
    }

    private static DataInputStream openStream(InputStream inputStream, int n) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, n);
        if (!bufferedInputStream.markSupported()) {
            throw new IllegalArgumentException("stream of type " + inputStream.getClass().getName() + " doesn't support mark");
        }
        bufferedInputStream.mark(n);
        return new DataInputStream(bufferedInputStream);
    }

    public TTFont(File file) throws IOException {
        this(TTFont.openStream(file), 0, 0);
    }

    public TTFont(InputStream inputStream, int n) throws IOException {
        this(TTFont.openStream(inputStream, n), 0, 0);
    }

    public TTFont(DataInputStream dataInputStream, int n, int n2) throws IOException {
        this(dataInputStream, TTFont.readTableDir(dataInputStream, n), n2);
    }

    TTFont(DataInputStream dataInputStream, TableDirectory tableDirectory, int n) throws IOException {
        super(dataInputStream, tableDirectory, n);
        int n2 = this.seekTable(tableDirectory, dataInputStream, n, 1819239265);
        LocaTable locaTable = new LocaTable(dataInputStream, n2, this.getHeadTable(), this.getMaxpTable());
        n2 = this.seekTable(tableDirectory, dataInputStream, n, 1735162214);
        this._glyf = new GlyfTable(dataInputStream, n2, this.getMaxpTable(), locaTable);
        n2 = this.seekTable(tableDirectory, dataInputStream, n, 1734439792);
        if (n2 > 0) {
            this._gasp = new GaspTable(dataInputStream);
        }
        if ((n2 = this.seekTable(tableDirectory, dataInputStream, n, 1801810542)) > 0) {
            this._kern = new KernTable(dataInputStream);
        }
        if ((n2 = this.seekTable(tableDirectory, dataInputStream, n, 1751412088)) > 0) {
            this._hdmx = new HdmxTable(dataInputStream, n2, this.getMaxpTable());
        }
        if ((n2 = this.seekTable(tableDirectory, dataInputStream, n, 1447316824)) > 0) {
            this._vdmx = new VdmxTable(dataInputStream);
        }
    }

    public GlyfTable getGlyfTable() {
        return this._glyf;
    }

    public GaspTable getGaspTable() {
        return this._gasp;
    }

    public KernTable getKernTable() {
        return this._kern;
    }

    public HdmxTable getHdmxTable() {
        return this._hdmx;
    }

    public VdmxTable getVdmxTable() {
        return this._vdmx;
    }

    @Override
    public int getGlyphCount() {
        return this._glyf.getSize();
    }

    @Override
    public Glyph getGlyph(int n) {
        GlyfDescript glyfDescript = this._glyf.getDescription(n);
        if (null != glyfDescript) {
            return new TTGlyph(glyfDescript, this.getHmtxTable().getLeftSideBearing(n), this.getHmtxTable().getAdvanceWidth(n));
        }
        return null;
    }
}

