/* parsed class NVA0B5 */

#include "nvtypes.h"
#include "cla0b5.h"

#include <assert.h>
#include <stdio.h>
#include "util/u_math.h"

struct nv_nva0b5_NOP {
    uint32_t parameter;
};

static inline void
__NVA0B5_NOP(uint32_t *val_out, struct nv_nva0b5_NOP st)
{
    uint32_t val = 0;
    
    val |= st.parameter;
    *val_out = val;
}

#define V_NVA0B5_NOP(val, args...) { \
    struct nv_nva0b5_NOP __data = { .parameter = (args) }; \
    __NVA0B5_NOP(&val, __data); \
}

#define VA_NVA0B5_NOP V_NVA0B5_NOP

#define P_NVA0B5_NOP(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_NOP(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_NOP, nvk_p_ret); \
} while(0)

struct nv_nva0b5_PM_TRIGGER {
    uint32_t v;
};

static inline void
__NVA0B5_PM_TRIGGER(uint32_t *val_out, struct nv_nva0b5_PM_TRIGGER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA0B5_PM_TRIGGER(val, args...) { \
    struct nv_nva0b5_PM_TRIGGER __data = { .v = (args) }; \
    __NVA0B5_PM_TRIGGER(&val, __data); \
}

#define VA_NVA0B5_PM_TRIGGER V_NVA0B5_PM_TRIGGER

#define P_NVA0B5_PM_TRIGGER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_PM_TRIGGER(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_PM_TRIGGER, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_SEMAPHORE_A {
    uint32_t upper;
};

static inline void
__NVA0B5_SET_SEMAPHORE_A(uint32_t *val_out, struct nv_nva0b5_SET_SEMAPHORE_A st)
{
    uint32_t val = 0;
    
    assert(st.upper < (1ULL << 8));
    val |= st.upper << 0;
    *val_out = val;
}

#define V_NVA0B5_SET_SEMAPHORE_A(val, args...) { \
    struct nv_nva0b5_SET_SEMAPHORE_A __data = { .upper = (args) }; \
    __NVA0B5_SET_SEMAPHORE_A(&val, __data); \
}

#define VA_NVA0B5_SET_SEMAPHORE_A V_NVA0B5_SET_SEMAPHORE_A

#define P_NVA0B5_SET_SEMAPHORE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_SEMAPHORE_A(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_SEMAPHORE_A, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_SEMAPHORE_B {
    uint32_t lower;
};

static inline void
__NVA0B5_SET_SEMAPHORE_B(uint32_t *val_out, struct nv_nva0b5_SET_SEMAPHORE_B st)
{
    uint32_t val = 0;
    
    val |= st.lower;
    *val_out = val;
}

#define V_NVA0B5_SET_SEMAPHORE_B(val, args...) { \
    struct nv_nva0b5_SET_SEMAPHORE_B __data = { .lower = (args) }; \
    __NVA0B5_SET_SEMAPHORE_B(&val, __data); \
}

#define VA_NVA0B5_SET_SEMAPHORE_B V_NVA0B5_SET_SEMAPHORE_B

#define P_NVA0B5_SET_SEMAPHORE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_SEMAPHORE_B(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_SEMAPHORE_B, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_SEMAPHORE_PAYLOAD {
    uint32_t payload;
};

static inline void
__NVA0B5_SET_SEMAPHORE_PAYLOAD(uint32_t *val_out, struct nv_nva0b5_SET_SEMAPHORE_PAYLOAD st)
{
    uint32_t val = 0;
    
    val |= st.payload;
    *val_out = val;
}

#define V_NVA0B5_SET_SEMAPHORE_PAYLOAD(val, args...) { \
    struct nv_nva0b5_SET_SEMAPHORE_PAYLOAD __data = { .payload = (args) }; \
    __NVA0B5_SET_SEMAPHORE_PAYLOAD(&val, __data); \
}

#define VA_NVA0B5_SET_SEMAPHORE_PAYLOAD V_NVA0B5_SET_SEMAPHORE_PAYLOAD

#define P_NVA0B5_SET_SEMAPHORE_PAYLOAD(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_SEMAPHORE_PAYLOAD(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_SEMAPHORE_PAYLOAD, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_RENDER_ENABLE_A {
    uint32_t upper;
};

static inline void
__NVA0B5_SET_RENDER_ENABLE_A(uint32_t *val_out, struct nv_nva0b5_SET_RENDER_ENABLE_A st)
{
    uint32_t val = 0;
    
    assert(st.upper < (1ULL << 8));
    val |= st.upper << 0;
    *val_out = val;
}

#define V_NVA0B5_SET_RENDER_ENABLE_A(val, args...) { \
    struct nv_nva0b5_SET_RENDER_ENABLE_A __data = { .upper = (args) }; \
    __NVA0B5_SET_RENDER_ENABLE_A(&val, __data); \
}

#define VA_NVA0B5_SET_RENDER_ENABLE_A V_NVA0B5_SET_RENDER_ENABLE_A

#define P_NVA0B5_SET_RENDER_ENABLE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_RENDER_ENABLE_A(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_RENDER_ENABLE_A, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_RENDER_ENABLE_B {
    uint32_t lower;
};

static inline void
__NVA0B5_SET_RENDER_ENABLE_B(uint32_t *val_out, struct nv_nva0b5_SET_RENDER_ENABLE_B st)
{
    uint32_t val = 0;
    
    val |= st.lower;
    *val_out = val;
}

#define V_NVA0B5_SET_RENDER_ENABLE_B(val, args...) { \
    struct nv_nva0b5_SET_RENDER_ENABLE_B __data = { .lower = (args) }; \
    __NVA0B5_SET_RENDER_ENABLE_B(&val, __data); \
}

#define VA_NVA0B5_SET_RENDER_ENABLE_B V_NVA0B5_SET_RENDER_ENABLE_B

#define P_NVA0B5_SET_RENDER_ENABLE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_RENDER_ENABLE_B(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_RENDER_ENABLE_B, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_RENDER_ENABLE_C {
    uint32_t mode;
};

static inline void
__NVA0B5_SET_RENDER_ENABLE_C(uint32_t *val_out, struct nv_nva0b5_SET_RENDER_ENABLE_C st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 3));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NVA0B5_SET_RENDER_ENABLE_C(val, args...) { \
    UNUSED uint32_t MODE_FALSE = NVA0B5_SET_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NVA0B5_SET_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NVA0B5_SET_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NVA0B5_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NVA0B5_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    struct nv_nva0b5_SET_RENDER_ENABLE_C __data = { .mode = (args) }; \
    __NVA0B5_SET_RENDER_ENABLE_C(&val, __data); \
}

#define VA_NVA0B5_SET_RENDER_ENABLE_C V_NVA0B5_SET_RENDER_ENABLE_C

#define P_NVA0B5_SET_RENDER_ENABLE_C(push, args...) do { \
    UNUSED uint32_t MODE_FALSE = NVA0B5_SET_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NVA0B5_SET_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NVA0B5_SET_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NVA0B5_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NVA0B5_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_RENDER_ENABLE_C(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_RENDER_ENABLE_C, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_SRC_PHYS_MODE {
    uint32_t target;
};

static inline void
__NVA0B5_SET_SRC_PHYS_MODE(uint32_t *val_out, struct nv_nva0b5_SET_SRC_PHYS_MODE st)
{
    uint32_t val = 0;
    
    assert(st.target < (1ULL << 2));
    val |= st.target << 0;
    *val_out = val;
}

#define V_NVA0B5_SET_SRC_PHYS_MODE(val, args...) { \
    UNUSED uint32_t TARGET_LOCAL_FB = NVA0B5_SET_SRC_PHYS_MODE_TARGET_LOCAL_FB; \
    UNUSED uint32_t TARGET_COHERENT_SYSMEM = NVA0B5_SET_SRC_PHYS_MODE_TARGET_COHERENT_SYSMEM; \
    UNUSED uint32_t TARGET_NONCOHERENT_SYSMEM = NVA0B5_SET_SRC_PHYS_MODE_TARGET_NONCOHERENT_SYSMEM; \
    struct nv_nva0b5_SET_SRC_PHYS_MODE __data = { .target = (args) }; \
    __NVA0B5_SET_SRC_PHYS_MODE(&val, __data); \
}

#define VA_NVA0B5_SET_SRC_PHYS_MODE V_NVA0B5_SET_SRC_PHYS_MODE

#define P_NVA0B5_SET_SRC_PHYS_MODE(push, args...) do { \
    UNUSED uint32_t TARGET_LOCAL_FB = NVA0B5_SET_SRC_PHYS_MODE_TARGET_LOCAL_FB; \
    UNUSED uint32_t TARGET_COHERENT_SYSMEM = NVA0B5_SET_SRC_PHYS_MODE_TARGET_COHERENT_SYSMEM; \
    UNUSED uint32_t TARGET_NONCOHERENT_SYSMEM = NVA0B5_SET_SRC_PHYS_MODE_TARGET_NONCOHERENT_SYSMEM; \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_SRC_PHYS_MODE(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_SRC_PHYS_MODE, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_DST_PHYS_MODE {
    uint32_t target;
};

static inline void
__NVA0B5_SET_DST_PHYS_MODE(uint32_t *val_out, struct nv_nva0b5_SET_DST_PHYS_MODE st)
{
    uint32_t val = 0;
    
    assert(st.target < (1ULL << 2));
    val |= st.target << 0;
    *val_out = val;
}

#define V_NVA0B5_SET_DST_PHYS_MODE(val, args...) { \
    UNUSED uint32_t TARGET_LOCAL_FB = NVA0B5_SET_DST_PHYS_MODE_TARGET_LOCAL_FB; \
    UNUSED uint32_t TARGET_COHERENT_SYSMEM = NVA0B5_SET_DST_PHYS_MODE_TARGET_COHERENT_SYSMEM; \
    UNUSED uint32_t TARGET_NONCOHERENT_SYSMEM = NVA0B5_SET_DST_PHYS_MODE_TARGET_NONCOHERENT_SYSMEM; \
    struct nv_nva0b5_SET_DST_PHYS_MODE __data = { .target = (args) }; \
    __NVA0B5_SET_DST_PHYS_MODE(&val, __data); \
}

#define VA_NVA0B5_SET_DST_PHYS_MODE V_NVA0B5_SET_DST_PHYS_MODE

#define P_NVA0B5_SET_DST_PHYS_MODE(push, args...) do { \
    UNUSED uint32_t TARGET_LOCAL_FB = NVA0B5_SET_DST_PHYS_MODE_TARGET_LOCAL_FB; \
    UNUSED uint32_t TARGET_COHERENT_SYSMEM = NVA0B5_SET_DST_PHYS_MODE_TARGET_COHERENT_SYSMEM; \
    UNUSED uint32_t TARGET_NONCOHERENT_SYSMEM = NVA0B5_SET_DST_PHYS_MODE_TARGET_NONCOHERENT_SYSMEM; \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_DST_PHYS_MODE(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_DST_PHYS_MODE, nvk_p_ret); \
} while(0)

struct nv_nva0b5_LAUNCH_DMA {
    uint32_t data_transfer_type;
    uint32_t flush_enable;
    uint32_t semaphore_type;
    uint32_t interrupt_type;
    uint32_t src_memory_layout;
    uint32_t dst_memory_layout;
    uint32_t multi_line_enable;
    uint32_t remap_enable;
    uint32_t bypass_l2;
    uint32_t src_type;
    uint32_t dst_type;
    uint32_t semaphore_reduction;
    uint32_t semaphore_reduction_sign;
    uint32_t semaphore_reduction_enable;
};

static inline void
__NVA0B5_LAUNCH_DMA(uint32_t *val_out, struct nv_nva0b5_LAUNCH_DMA st)
{
    uint32_t val = 0;
    
    assert(st.data_transfer_type < (1ULL << 2));
    val |= st.data_transfer_type << 0;
    
    assert(st.flush_enable < (1ULL << 1));
    val |= st.flush_enable << 2;
    
    assert(st.semaphore_type < (1ULL << 2));
    val |= st.semaphore_type << 3;
    
    assert(st.interrupt_type < (1ULL << 2));
    val |= st.interrupt_type << 5;
    
    assert(st.src_memory_layout < (1ULL << 1));
    val |= st.src_memory_layout << 7;
    
    assert(st.dst_memory_layout < (1ULL << 1));
    val |= st.dst_memory_layout << 8;
    
    assert(st.multi_line_enable < (1ULL << 1));
    val |= st.multi_line_enable << 9;
    
    assert(st.remap_enable < (1ULL << 1));
    val |= st.remap_enable << 10;
    
    assert(st.bypass_l2 < (1ULL << 1));
    val |= st.bypass_l2 << 11;
    
    assert(st.src_type < (1ULL << 1));
    val |= st.src_type << 12;
    
    assert(st.dst_type < (1ULL << 1));
    val |= st.dst_type << 13;
    
    assert(st.semaphore_reduction < (1ULL << 4));
    val |= st.semaphore_reduction << 14;
    
    assert(st.semaphore_reduction_sign < (1ULL << 1));
    val |= st.semaphore_reduction_sign << 18;
    
    assert(st.semaphore_reduction_enable < (1ULL << 1));
    val |= st.semaphore_reduction_enable << 19;
    *val_out = val;
}

#define V_NVA0B5_LAUNCH_DMA(val, args...) { \
    UNUSED uint32_t DATA_TRANSFER_TYPE_NONE = NVA0B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_NONE; \
    UNUSED uint32_t DATA_TRANSFER_TYPE_PIPELINED = NVA0B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_PIPELINED; \
    UNUSED uint32_t DATA_TRANSFER_TYPE_NON_PIPELINED = NVA0B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_NON_PIPELINED; \
    UNUSED uint32_t FLUSH_ENABLE_FALSE = NVA0B5_LAUNCH_DMA_FLUSH_ENABLE_FALSE; \
    UNUSED uint32_t FLUSH_ENABLE_TRUE = NVA0B5_LAUNCH_DMA_FLUSH_ENABLE_TRUE; \
    UNUSED uint32_t SEMAPHORE_TYPE_NONE = NVA0B5_LAUNCH_DMA_SEMAPHORE_TYPE_NONE; \
    UNUSED uint32_t SEMAPHORE_TYPE_RELEASE_ONE_WORD_SEMAPHORE = NVA0B5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_ONE_WORD_SEMAPHORE; \
    UNUSED uint32_t SEMAPHORE_TYPE_RELEASE_FOUR_WORD_SEMAPHORE = NVA0B5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_FOUR_WORD_SEMAPHORE; \
    UNUSED uint32_t INTERRUPT_TYPE_NONE = NVA0B5_LAUNCH_DMA_INTERRUPT_TYPE_NONE; \
    UNUSED uint32_t INTERRUPT_TYPE_BLOCKING = NVA0B5_LAUNCH_DMA_INTERRUPT_TYPE_BLOCKING; \
    UNUSED uint32_t INTERRUPT_TYPE_NON_BLOCKING = NVA0B5_LAUNCH_DMA_INTERRUPT_TYPE_NON_BLOCKING; \
    UNUSED uint32_t SRC_MEMORY_LAYOUT_BLOCKLINEAR = NVA0B5_LAUNCH_DMA_SRC_MEMORY_LAYOUT_BLOCKLINEAR; \
    UNUSED uint32_t SRC_MEMORY_LAYOUT_PITCH = NVA0B5_LAUNCH_DMA_SRC_MEMORY_LAYOUT_PITCH; \
    UNUSED uint32_t DST_MEMORY_LAYOUT_BLOCKLINEAR = NVA0B5_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR; \
    UNUSED uint32_t DST_MEMORY_LAYOUT_PITCH = NVA0B5_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH; \
    UNUSED uint32_t MULTI_LINE_ENABLE_FALSE = NVA0B5_LAUNCH_DMA_MULTI_LINE_ENABLE_FALSE; \
    UNUSED uint32_t MULTI_LINE_ENABLE_TRUE = NVA0B5_LAUNCH_DMA_MULTI_LINE_ENABLE_TRUE; \
    UNUSED uint32_t REMAP_ENABLE_FALSE = NVA0B5_LAUNCH_DMA_REMAP_ENABLE_FALSE; \
    UNUSED uint32_t REMAP_ENABLE_TRUE = NVA0B5_LAUNCH_DMA_REMAP_ENABLE_TRUE; \
    UNUSED uint32_t BYPASS_L2_USE_PTE_SETTING = NVA0B5_LAUNCH_DMA_BYPASS_L2_USE_PTE_SETTING; \
    UNUSED uint32_t BYPASS_L2_FORCE_VOLATILE = NVA0B5_LAUNCH_DMA_BYPASS_L2_FORCE_VOLATILE; \
    UNUSED uint32_t SRC_TYPE_VIRTUAL = NVA0B5_LAUNCH_DMA_SRC_TYPE_VIRTUAL; \
    UNUSED uint32_t SRC_TYPE_PHYSICAL = NVA0B5_LAUNCH_DMA_SRC_TYPE_PHYSICAL; \
    UNUSED uint32_t DST_TYPE_VIRTUAL = NVA0B5_LAUNCH_DMA_DST_TYPE_VIRTUAL; \
    UNUSED uint32_t DST_TYPE_PHYSICAL = NVA0B5_LAUNCH_DMA_DST_TYPE_PHYSICAL; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IMIN = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IMIN; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IMAX = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IMAX; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IXOR = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IXOR; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IAND = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IAND; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IOR = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IOR; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IADD = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IADD; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_INC = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_INC; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_DEC = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_DEC; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_FADD = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_FADD; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_FMIN = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_FMIN; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_FMAX = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_FMAX; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_FMUL = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_FMUL; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IMUL = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IMUL; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_SIGN_SIGNED = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_SIGN_SIGNED; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_SIGN_UNSIGNED = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_SIGN_UNSIGNED; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_ENABLE_FALSE = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_ENABLE_FALSE; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_ENABLE_TRUE = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_ENABLE_TRUE; \
    struct nv_nva0b5_LAUNCH_DMA __data = args; \
    __NVA0B5_LAUNCH_DMA(&val, __data); \
}

#define VA_NVA0B5_LAUNCH_DMA V_NVA0B5_LAUNCH_DMA

#define P_NVA0B5_LAUNCH_DMA(push, args...) do { \
    UNUSED uint32_t DATA_TRANSFER_TYPE_NONE = NVA0B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_NONE; \
    UNUSED uint32_t DATA_TRANSFER_TYPE_PIPELINED = NVA0B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_PIPELINED; \
    UNUSED uint32_t DATA_TRANSFER_TYPE_NON_PIPELINED = NVA0B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_NON_PIPELINED; \
    UNUSED uint32_t FLUSH_ENABLE_FALSE = NVA0B5_LAUNCH_DMA_FLUSH_ENABLE_FALSE; \
    UNUSED uint32_t FLUSH_ENABLE_TRUE = NVA0B5_LAUNCH_DMA_FLUSH_ENABLE_TRUE; \
    UNUSED uint32_t SEMAPHORE_TYPE_NONE = NVA0B5_LAUNCH_DMA_SEMAPHORE_TYPE_NONE; \
    UNUSED uint32_t SEMAPHORE_TYPE_RELEASE_ONE_WORD_SEMAPHORE = NVA0B5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_ONE_WORD_SEMAPHORE; \
    UNUSED uint32_t SEMAPHORE_TYPE_RELEASE_FOUR_WORD_SEMAPHORE = NVA0B5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_FOUR_WORD_SEMAPHORE; \
    UNUSED uint32_t INTERRUPT_TYPE_NONE = NVA0B5_LAUNCH_DMA_INTERRUPT_TYPE_NONE; \
    UNUSED uint32_t INTERRUPT_TYPE_BLOCKING = NVA0B5_LAUNCH_DMA_INTERRUPT_TYPE_BLOCKING; \
    UNUSED uint32_t INTERRUPT_TYPE_NON_BLOCKING = NVA0B5_LAUNCH_DMA_INTERRUPT_TYPE_NON_BLOCKING; \
    UNUSED uint32_t SRC_MEMORY_LAYOUT_BLOCKLINEAR = NVA0B5_LAUNCH_DMA_SRC_MEMORY_LAYOUT_BLOCKLINEAR; \
    UNUSED uint32_t SRC_MEMORY_LAYOUT_PITCH = NVA0B5_LAUNCH_DMA_SRC_MEMORY_LAYOUT_PITCH; \
    UNUSED uint32_t DST_MEMORY_LAYOUT_BLOCKLINEAR = NVA0B5_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR; \
    UNUSED uint32_t DST_MEMORY_LAYOUT_PITCH = NVA0B5_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH; \
    UNUSED uint32_t MULTI_LINE_ENABLE_FALSE = NVA0B5_LAUNCH_DMA_MULTI_LINE_ENABLE_FALSE; \
    UNUSED uint32_t MULTI_LINE_ENABLE_TRUE = NVA0B5_LAUNCH_DMA_MULTI_LINE_ENABLE_TRUE; \
    UNUSED uint32_t REMAP_ENABLE_FALSE = NVA0B5_LAUNCH_DMA_REMAP_ENABLE_FALSE; \
    UNUSED uint32_t REMAP_ENABLE_TRUE = NVA0B5_LAUNCH_DMA_REMAP_ENABLE_TRUE; \
    UNUSED uint32_t BYPASS_L2_USE_PTE_SETTING = NVA0B5_LAUNCH_DMA_BYPASS_L2_USE_PTE_SETTING; \
    UNUSED uint32_t BYPASS_L2_FORCE_VOLATILE = NVA0B5_LAUNCH_DMA_BYPASS_L2_FORCE_VOLATILE; \
    UNUSED uint32_t SRC_TYPE_VIRTUAL = NVA0B5_LAUNCH_DMA_SRC_TYPE_VIRTUAL; \
    UNUSED uint32_t SRC_TYPE_PHYSICAL = NVA0B5_LAUNCH_DMA_SRC_TYPE_PHYSICAL; \
    UNUSED uint32_t DST_TYPE_VIRTUAL = NVA0B5_LAUNCH_DMA_DST_TYPE_VIRTUAL; \
    UNUSED uint32_t DST_TYPE_PHYSICAL = NVA0B5_LAUNCH_DMA_DST_TYPE_PHYSICAL; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IMIN = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IMIN; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IMAX = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IMAX; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IXOR = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IXOR; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IAND = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IAND; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IOR = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IOR; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IADD = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IADD; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_INC = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_INC; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_DEC = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_DEC; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_FADD = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_FADD; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_FMIN = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_FMIN; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_FMAX = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_FMAX; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_FMUL = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_FMUL; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_IMUL = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IMUL; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_SIGN_SIGNED = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_SIGN_SIGNED; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_SIGN_UNSIGNED = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_SIGN_UNSIGNED; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_ENABLE_FALSE = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_ENABLE_FALSE; \
    UNUSED uint32_t SEMAPHORE_REDUCTION_ENABLE_TRUE = NVA0B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA0B5_LAUNCH_DMA(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_LAUNCH_DMA, nvk_p_ret); \
} while(0)

struct nv_nva0b5_OFFSET_IN_UPPER {
    uint32_t upper;
};

static inline void
__NVA0B5_OFFSET_IN_UPPER(uint32_t *val_out, struct nv_nva0b5_OFFSET_IN_UPPER st)
{
    uint32_t val = 0;
    
    assert(st.upper < (1ULL << 8));
    val |= st.upper << 0;
    *val_out = val;
}

#define V_NVA0B5_OFFSET_IN_UPPER(val, args...) { \
    struct nv_nva0b5_OFFSET_IN_UPPER __data = { .upper = (args) }; \
    __NVA0B5_OFFSET_IN_UPPER(&val, __data); \
}

#define VA_NVA0B5_OFFSET_IN_UPPER V_NVA0B5_OFFSET_IN_UPPER

#define P_NVA0B5_OFFSET_IN_UPPER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_OFFSET_IN_UPPER(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_OFFSET_IN_UPPER, nvk_p_ret); \
} while(0)

struct nv_nva0b5_OFFSET_IN_LOWER {
    uint32_t value;
};

static inline void
__NVA0B5_OFFSET_IN_LOWER(uint32_t *val_out, struct nv_nva0b5_OFFSET_IN_LOWER st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVA0B5_OFFSET_IN_LOWER(val, args...) { \
    struct nv_nva0b5_OFFSET_IN_LOWER __data = { .value = (args) }; \
    __NVA0B5_OFFSET_IN_LOWER(&val, __data); \
}

#define VA_NVA0B5_OFFSET_IN_LOWER V_NVA0B5_OFFSET_IN_LOWER

#define P_NVA0B5_OFFSET_IN_LOWER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_OFFSET_IN_LOWER(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_OFFSET_IN_LOWER, nvk_p_ret); \
} while(0)

struct nv_nva0b5_OFFSET_OUT_UPPER {
    uint32_t upper;
};

static inline void
__NVA0B5_OFFSET_OUT_UPPER(uint32_t *val_out, struct nv_nva0b5_OFFSET_OUT_UPPER st)
{
    uint32_t val = 0;
    
    assert(st.upper < (1ULL << 8));
    val |= st.upper << 0;
    *val_out = val;
}

#define V_NVA0B5_OFFSET_OUT_UPPER(val, args...) { \
    struct nv_nva0b5_OFFSET_OUT_UPPER __data = { .upper = (args) }; \
    __NVA0B5_OFFSET_OUT_UPPER(&val, __data); \
}

#define VA_NVA0B5_OFFSET_OUT_UPPER V_NVA0B5_OFFSET_OUT_UPPER

#define P_NVA0B5_OFFSET_OUT_UPPER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_OFFSET_OUT_UPPER(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_OFFSET_OUT_UPPER, nvk_p_ret); \
} while(0)

struct nv_nva0b5_OFFSET_OUT_LOWER {
    uint32_t value;
};

static inline void
__NVA0B5_OFFSET_OUT_LOWER(uint32_t *val_out, struct nv_nva0b5_OFFSET_OUT_LOWER st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVA0B5_OFFSET_OUT_LOWER(val, args...) { \
    struct nv_nva0b5_OFFSET_OUT_LOWER __data = { .value = (args) }; \
    __NVA0B5_OFFSET_OUT_LOWER(&val, __data); \
}

#define VA_NVA0B5_OFFSET_OUT_LOWER V_NVA0B5_OFFSET_OUT_LOWER

#define P_NVA0B5_OFFSET_OUT_LOWER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_OFFSET_OUT_LOWER(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_OFFSET_OUT_LOWER, nvk_p_ret); \
} while(0)

struct nv_nva0b5_PITCH_IN {
    uint32_t value;
};

static inline void
__NVA0B5_PITCH_IN(uint32_t *val_out, struct nv_nva0b5_PITCH_IN st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVA0B5_PITCH_IN(val, args...) { \
    struct nv_nva0b5_PITCH_IN __data = { .value = (args) }; \
    __NVA0B5_PITCH_IN(&val, __data); \
}

#define VA_NVA0B5_PITCH_IN V_NVA0B5_PITCH_IN

#define P_NVA0B5_PITCH_IN(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_PITCH_IN(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_PITCH_IN, nvk_p_ret); \
} while(0)

struct nv_nva0b5_PITCH_OUT {
    uint32_t value;
};

static inline void
__NVA0B5_PITCH_OUT(uint32_t *val_out, struct nv_nva0b5_PITCH_OUT st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVA0B5_PITCH_OUT(val, args...) { \
    struct nv_nva0b5_PITCH_OUT __data = { .value = (args) }; \
    __NVA0B5_PITCH_OUT(&val, __data); \
}

#define VA_NVA0B5_PITCH_OUT V_NVA0B5_PITCH_OUT

#define P_NVA0B5_PITCH_OUT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_PITCH_OUT(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_PITCH_OUT, nvk_p_ret); \
} while(0)

struct nv_nva0b5_LINE_LENGTH_IN {
    uint32_t value;
};

static inline void
__NVA0B5_LINE_LENGTH_IN(uint32_t *val_out, struct nv_nva0b5_LINE_LENGTH_IN st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVA0B5_LINE_LENGTH_IN(val, args...) { \
    struct nv_nva0b5_LINE_LENGTH_IN __data = { .value = (args) }; \
    __NVA0B5_LINE_LENGTH_IN(&val, __data); \
}

#define VA_NVA0B5_LINE_LENGTH_IN V_NVA0B5_LINE_LENGTH_IN

#define P_NVA0B5_LINE_LENGTH_IN(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_LINE_LENGTH_IN(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_LINE_LENGTH_IN, nvk_p_ret); \
} while(0)

struct nv_nva0b5_LINE_COUNT {
    uint32_t value;
};

static inline void
__NVA0B5_LINE_COUNT(uint32_t *val_out, struct nv_nva0b5_LINE_COUNT st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVA0B5_LINE_COUNT(val, args...) { \
    struct nv_nva0b5_LINE_COUNT __data = { .value = (args) }; \
    __NVA0B5_LINE_COUNT(&val, __data); \
}

#define VA_NVA0B5_LINE_COUNT V_NVA0B5_LINE_COUNT

#define P_NVA0B5_LINE_COUNT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_LINE_COUNT(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_LINE_COUNT, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_REMAP_CONST_A {
    uint32_t v;
};

static inline void
__NVA0B5_SET_REMAP_CONST_A(uint32_t *val_out, struct nv_nva0b5_SET_REMAP_CONST_A st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA0B5_SET_REMAP_CONST_A(val, args...) { \
    struct nv_nva0b5_SET_REMAP_CONST_A __data = { .v = (args) }; \
    __NVA0B5_SET_REMAP_CONST_A(&val, __data); \
}

#define VA_NVA0B5_SET_REMAP_CONST_A V_NVA0B5_SET_REMAP_CONST_A

#define P_NVA0B5_SET_REMAP_CONST_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_REMAP_CONST_A(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_REMAP_CONST_A, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_REMAP_CONST_B {
    uint32_t v;
};

static inline void
__NVA0B5_SET_REMAP_CONST_B(uint32_t *val_out, struct nv_nva0b5_SET_REMAP_CONST_B st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA0B5_SET_REMAP_CONST_B(val, args...) { \
    struct nv_nva0b5_SET_REMAP_CONST_B __data = { .v = (args) }; \
    __NVA0B5_SET_REMAP_CONST_B(&val, __data); \
}

#define VA_NVA0B5_SET_REMAP_CONST_B V_NVA0B5_SET_REMAP_CONST_B

#define P_NVA0B5_SET_REMAP_CONST_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_REMAP_CONST_B(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_REMAP_CONST_B, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_REMAP_COMPONENTS {
    uint32_t dst_x;
    uint32_t dst_y;
    uint32_t dst_z;
    uint32_t dst_w;
    uint32_t component_size;
    uint32_t num_src_components;
    uint32_t num_dst_components;
};

static inline void
__NVA0B5_SET_REMAP_COMPONENTS(uint32_t *val_out, struct nv_nva0b5_SET_REMAP_COMPONENTS st)
{
    uint32_t val = 0;
    
    assert(st.dst_x < (1ULL << 3));
    val |= st.dst_x << 0;
    
    assert(st.dst_y < (1ULL << 3));
    val |= st.dst_y << 4;
    
    assert(st.dst_z < (1ULL << 3));
    val |= st.dst_z << 8;
    
    assert(st.dst_w < (1ULL << 3));
    val |= st.dst_w << 12;
    
    assert(st.component_size < (1ULL << 2));
    val |= st.component_size << 16;
    
    assert(st.num_src_components < (1ULL << 2));
    val |= st.num_src_components << 20;
    
    assert(st.num_dst_components < (1ULL << 2));
    val |= st.num_dst_components << 24;
    *val_out = val;
}

#define V_NVA0B5_SET_REMAP_COMPONENTS(val, args...) { \
    UNUSED uint32_t DST_X_SRC_X = NVA0B5_SET_REMAP_COMPONENTS_DST_X_SRC_X; \
    UNUSED uint32_t DST_X_SRC_Y = NVA0B5_SET_REMAP_COMPONENTS_DST_X_SRC_Y; \
    UNUSED uint32_t DST_X_SRC_Z = NVA0B5_SET_REMAP_COMPONENTS_DST_X_SRC_Z; \
    UNUSED uint32_t DST_X_SRC_W = NVA0B5_SET_REMAP_COMPONENTS_DST_X_SRC_W; \
    UNUSED uint32_t DST_X_CONST_A = NVA0B5_SET_REMAP_COMPONENTS_DST_X_CONST_A; \
    UNUSED uint32_t DST_X_CONST_B = NVA0B5_SET_REMAP_COMPONENTS_DST_X_CONST_B; \
    UNUSED uint32_t DST_X_NO_WRITE = NVA0B5_SET_REMAP_COMPONENTS_DST_X_NO_WRITE; \
    UNUSED uint32_t DST_Y_SRC_X = NVA0B5_SET_REMAP_COMPONENTS_DST_Y_SRC_X; \
    UNUSED uint32_t DST_Y_SRC_Y = NVA0B5_SET_REMAP_COMPONENTS_DST_Y_SRC_Y; \
    UNUSED uint32_t DST_Y_SRC_Z = NVA0B5_SET_REMAP_COMPONENTS_DST_Y_SRC_Z; \
    UNUSED uint32_t DST_Y_SRC_W = NVA0B5_SET_REMAP_COMPONENTS_DST_Y_SRC_W; \
    UNUSED uint32_t DST_Y_CONST_A = NVA0B5_SET_REMAP_COMPONENTS_DST_Y_CONST_A; \
    UNUSED uint32_t DST_Y_CONST_B = NVA0B5_SET_REMAP_COMPONENTS_DST_Y_CONST_B; \
    UNUSED uint32_t DST_Y_NO_WRITE = NVA0B5_SET_REMAP_COMPONENTS_DST_Y_NO_WRITE; \
    UNUSED uint32_t DST_Z_SRC_X = NVA0B5_SET_REMAP_COMPONENTS_DST_Z_SRC_X; \
    UNUSED uint32_t DST_Z_SRC_Y = NVA0B5_SET_REMAP_COMPONENTS_DST_Z_SRC_Y; \
    UNUSED uint32_t DST_Z_SRC_Z = NVA0B5_SET_REMAP_COMPONENTS_DST_Z_SRC_Z; \
    UNUSED uint32_t DST_Z_SRC_W = NVA0B5_SET_REMAP_COMPONENTS_DST_Z_SRC_W; \
    UNUSED uint32_t DST_Z_CONST_A = NVA0B5_SET_REMAP_COMPONENTS_DST_Z_CONST_A; \
    UNUSED uint32_t DST_Z_CONST_B = NVA0B5_SET_REMAP_COMPONENTS_DST_Z_CONST_B; \
    UNUSED uint32_t DST_Z_NO_WRITE = NVA0B5_SET_REMAP_COMPONENTS_DST_Z_NO_WRITE; \
    UNUSED uint32_t DST_W_SRC_X = NVA0B5_SET_REMAP_COMPONENTS_DST_W_SRC_X; \
    UNUSED uint32_t DST_W_SRC_Y = NVA0B5_SET_REMAP_COMPONENTS_DST_W_SRC_Y; \
    UNUSED uint32_t DST_W_SRC_Z = NVA0B5_SET_REMAP_COMPONENTS_DST_W_SRC_Z; \
    UNUSED uint32_t DST_W_SRC_W = NVA0B5_SET_REMAP_COMPONENTS_DST_W_SRC_W; \
    UNUSED uint32_t DST_W_CONST_A = NVA0B5_SET_REMAP_COMPONENTS_DST_W_CONST_A; \
    UNUSED uint32_t DST_W_CONST_B = NVA0B5_SET_REMAP_COMPONENTS_DST_W_CONST_B; \
    UNUSED uint32_t DST_W_NO_WRITE = NVA0B5_SET_REMAP_COMPONENTS_DST_W_NO_WRITE; \
    UNUSED uint32_t COMPONENT_SIZE_ONE = NVA0B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_ONE; \
    UNUSED uint32_t COMPONENT_SIZE_TWO = NVA0B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_TWO; \
    UNUSED uint32_t COMPONENT_SIZE_THREE = NVA0B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_THREE; \
    UNUSED uint32_t COMPONENT_SIZE_FOUR = NVA0B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_FOUR; \
    UNUSED uint32_t NUM_SRC_COMPONENTS_ONE = NVA0B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_ONE; \
    UNUSED uint32_t NUM_SRC_COMPONENTS_TWO = NVA0B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_TWO; \
    UNUSED uint32_t NUM_SRC_COMPONENTS_THREE = NVA0B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_THREE; \
    UNUSED uint32_t NUM_SRC_COMPONENTS_FOUR = NVA0B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_FOUR; \
    UNUSED uint32_t NUM_DST_COMPONENTS_ONE = NVA0B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_ONE; \
    UNUSED uint32_t NUM_DST_COMPONENTS_TWO = NVA0B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_TWO; \
    UNUSED uint32_t NUM_DST_COMPONENTS_THREE = NVA0B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_THREE; \
    UNUSED uint32_t NUM_DST_COMPONENTS_FOUR = NVA0B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_FOUR; \
    struct nv_nva0b5_SET_REMAP_COMPONENTS __data = args; \
    __NVA0B5_SET_REMAP_COMPONENTS(&val, __data); \
}

#define VA_NVA0B5_SET_REMAP_COMPONENTS V_NVA0B5_SET_REMAP_COMPONENTS

#define P_NVA0B5_SET_REMAP_COMPONENTS(push, args...) do { \
    UNUSED uint32_t DST_X_SRC_X = NVA0B5_SET_REMAP_COMPONENTS_DST_X_SRC_X; \
    UNUSED uint32_t DST_X_SRC_Y = NVA0B5_SET_REMAP_COMPONENTS_DST_X_SRC_Y; \
    UNUSED uint32_t DST_X_SRC_Z = NVA0B5_SET_REMAP_COMPONENTS_DST_X_SRC_Z; \
    UNUSED uint32_t DST_X_SRC_W = NVA0B5_SET_REMAP_COMPONENTS_DST_X_SRC_W; \
    UNUSED uint32_t DST_X_CONST_A = NVA0B5_SET_REMAP_COMPONENTS_DST_X_CONST_A; \
    UNUSED uint32_t DST_X_CONST_B = NVA0B5_SET_REMAP_COMPONENTS_DST_X_CONST_B; \
    UNUSED uint32_t DST_X_NO_WRITE = NVA0B5_SET_REMAP_COMPONENTS_DST_X_NO_WRITE; \
    UNUSED uint32_t DST_Y_SRC_X = NVA0B5_SET_REMAP_COMPONENTS_DST_Y_SRC_X; \
    UNUSED uint32_t DST_Y_SRC_Y = NVA0B5_SET_REMAP_COMPONENTS_DST_Y_SRC_Y; \
    UNUSED uint32_t DST_Y_SRC_Z = NVA0B5_SET_REMAP_COMPONENTS_DST_Y_SRC_Z; \
    UNUSED uint32_t DST_Y_SRC_W = NVA0B5_SET_REMAP_COMPONENTS_DST_Y_SRC_W; \
    UNUSED uint32_t DST_Y_CONST_A = NVA0B5_SET_REMAP_COMPONENTS_DST_Y_CONST_A; \
    UNUSED uint32_t DST_Y_CONST_B = NVA0B5_SET_REMAP_COMPONENTS_DST_Y_CONST_B; \
    UNUSED uint32_t DST_Y_NO_WRITE = NVA0B5_SET_REMAP_COMPONENTS_DST_Y_NO_WRITE; \
    UNUSED uint32_t DST_Z_SRC_X = NVA0B5_SET_REMAP_COMPONENTS_DST_Z_SRC_X; \
    UNUSED uint32_t DST_Z_SRC_Y = NVA0B5_SET_REMAP_COMPONENTS_DST_Z_SRC_Y; \
    UNUSED uint32_t DST_Z_SRC_Z = NVA0B5_SET_REMAP_COMPONENTS_DST_Z_SRC_Z; \
    UNUSED uint32_t DST_Z_SRC_W = NVA0B5_SET_REMAP_COMPONENTS_DST_Z_SRC_W; \
    UNUSED uint32_t DST_Z_CONST_A = NVA0B5_SET_REMAP_COMPONENTS_DST_Z_CONST_A; \
    UNUSED uint32_t DST_Z_CONST_B = NVA0B5_SET_REMAP_COMPONENTS_DST_Z_CONST_B; \
    UNUSED uint32_t DST_Z_NO_WRITE = NVA0B5_SET_REMAP_COMPONENTS_DST_Z_NO_WRITE; \
    UNUSED uint32_t DST_W_SRC_X = NVA0B5_SET_REMAP_COMPONENTS_DST_W_SRC_X; \
    UNUSED uint32_t DST_W_SRC_Y = NVA0B5_SET_REMAP_COMPONENTS_DST_W_SRC_Y; \
    UNUSED uint32_t DST_W_SRC_Z = NVA0B5_SET_REMAP_COMPONENTS_DST_W_SRC_Z; \
    UNUSED uint32_t DST_W_SRC_W = NVA0B5_SET_REMAP_COMPONENTS_DST_W_SRC_W; \
    UNUSED uint32_t DST_W_CONST_A = NVA0B5_SET_REMAP_COMPONENTS_DST_W_CONST_A; \
    UNUSED uint32_t DST_W_CONST_B = NVA0B5_SET_REMAP_COMPONENTS_DST_W_CONST_B; \
    UNUSED uint32_t DST_W_NO_WRITE = NVA0B5_SET_REMAP_COMPONENTS_DST_W_NO_WRITE; \
    UNUSED uint32_t COMPONENT_SIZE_ONE = NVA0B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_ONE; \
    UNUSED uint32_t COMPONENT_SIZE_TWO = NVA0B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_TWO; \
    UNUSED uint32_t COMPONENT_SIZE_THREE = NVA0B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_THREE; \
    UNUSED uint32_t COMPONENT_SIZE_FOUR = NVA0B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_FOUR; \
    UNUSED uint32_t NUM_SRC_COMPONENTS_ONE = NVA0B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_ONE; \
    UNUSED uint32_t NUM_SRC_COMPONENTS_TWO = NVA0B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_TWO; \
    UNUSED uint32_t NUM_SRC_COMPONENTS_THREE = NVA0B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_THREE; \
    UNUSED uint32_t NUM_SRC_COMPONENTS_FOUR = NVA0B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_FOUR; \
    UNUSED uint32_t NUM_DST_COMPONENTS_ONE = NVA0B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_ONE; \
    UNUSED uint32_t NUM_DST_COMPONENTS_TWO = NVA0B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_TWO; \
    UNUSED uint32_t NUM_DST_COMPONENTS_THREE = NVA0B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_THREE; \
    UNUSED uint32_t NUM_DST_COMPONENTS_FOUR = NVA0B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_FOUR; \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_REMAP_COMPONENTS(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_REMAP_COMPONENTS, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_DST_BLOCK_SIZE {
    uint32_t width;
    uint32_t height;
    uint32_t depth;
    uint32_t gob_height;
};

static inline void
__NVA0B5_SET_DST_BLOCK_SIZE(uint32_t *val_out, struct nv_nva0b5_SET_DST_BLOCK_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.width < (1ULL << 4));
    val |= st.width << 0;
    
    assert(st.height < (1ULL << 4));
    val |= st.height << 4;
    
    assert(st.depth < (1ULL << 4));
    val |= st.depth << 8;
    
    assert(st.gob_height < (1ULL << 4));
    val |= st.gob_height << 12;
    *val_out = val;
}

#define V_NVA0B5_SET_DST_BLOCK_SIZE(val, args...) { \
    UNUSED uint32_t WIDTH_QUARTER_GOB = NVA0B5_SET_DST_BLOCK_SIZE_WIDTH_QUARTER_GOB; \
    UNUSED uint32_t WIDTH_ONE_GOB = NVA0B5_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NVA0B5_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NVA0B5_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB; \
    UNUSED uint32_t DEPTH_TWO_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS; \
    UNUSED uint32_t DEPTH_FOUR_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t DEPTH_EIGHT_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t DEPTH_SIXTEEN_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t DEPTH_THIRTYTWO_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS; \
    UNUSED uint32_t GOB_HEIGHT_GOB_HEIGHT_TESLA_4 = NVA0B5_SET_DST_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_TESLA_4; \
    UNUSED uint32_t GOB_HEIGHT_GOB_HEIGHT_FERMI_8 = NVA0B5_SET_DST_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_FERMI_8; \
    struct nv_nva0b5_SET_DST_BLOCK_SIZE __data = args; \
    __NVA0B5_SET_DST_BLOCK_SIZE(&val, __data); \
}

#define VA_NVA0B5_SET_DST_BLOCK_SIZE V_NVA0B5_SET_DST_BLOCK_SIZE

#define P_NVA0B5_SET_DST_BLOCK_SIZE(push, args...) do { \
    UNUSED uint32_t WIDTH_QUARTER_GOB = NVA0B5_SET_DST_BLOCK_SIZE_WIDTH_QUARTER_GOB; \
    UNUSED uint32_t WIDTH_ONE_GOB = NVA0B5_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NVA0B5_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NVA0B5_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB; \
    UNUSED uint32_t DEPTH_TWO_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS; \
    UNUSED uint32_t DEPTH_FOUR_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t DEPTH_EIGHT_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t DEPTH_SIXTEEN_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t DEPTH_THIRTYTWO_GOBS = NVA0B5_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS; \
    UNUSED uint32_t GOB_HEIGHT_GOB_HEIGHT_TESLA_4 = NVA0B5_SET_DST_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_TESLA_4; \
    UNUSED uint32_t GOB_HEIGHT_GOB_HEIGHT_FERMI_8 = NVA0B5_SET_DST_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_FERMI_8; \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_DST_BLOCK_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_DST_BLOCK_SIZE, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_DST_WIDTH {
    uint32_t v;
};

static inline void
__NVA0B5_SET_DST_WIDTH(uint32_t *val_out, struct nv_nva0b5_SET_DST_WIDTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA0B5_SET_DST_WIDTH(val, args...) { \
    struct nv_nva0b5_SET_DST_WIDTH __data = { .v = (args) }; \
    __NVA0B5_SET_DST_WIDTH(&val, __data); \
}

#define VA_NVA0B5_SET_DST_WIDTH V_NVA0B5_SET_DST_WIDTH

#define P_NVA0B5_SET_DST_WIDTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_DST_WIDTH(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_DST_WIDTH, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_DST_HEIGHT {
    uint32_t v;
};

static inline void
__NVA0B5_SET_DST_HEIGHT(uint32_t *val_out, struct nv_nva0b5_SET_DST_HEIGHT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA0B5_SET_DST_HEIGHT(val, args...) { \
    struct nv_nva0b5_SET_DST_HEIGHT __data = { .v = (args) }; \
    __NVA0B5_SET_DST_HEIGHT(&val, __data); \
}

#define VA_NVA0B5_SET_DST_HEIGHT V_NVA0B5_SET_DST_HEIGHT

#define P_NVA0B5_SET_DST_HEIGHT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_DST_HEIGHT(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_DST_HEIGHT, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_DST_DEPTH {
    uint32_t v;
};

static inline void
__NVA0B5_SET_DST_DEPTH(uint32_t *val_out, struct nv_nva0b5_SET_DST_DEPTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA0B5_SET_DST_DEPTH(val, args...) { \
    struct nv_nva0b5_SET_DST_DEPTH __data = { .v = (args) }; \
    __NVA0B5_SET_DST_DEPTH(&val, __data); \
}

#define VA_NVA0B5_SET_DST_DEPTH V_NVA0B5_SET_DST_DEPTH

#define P_NVA0B5_SET_DST_DEPTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_DST_DEPTH(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_DST_DEPTH, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_DST_LAYER {
    uint32_t v;
};

static inline void
__NVA0B5_SET_DST_LAYER(uint32_t *val_out, struct nv_nva0b5_SET_DST_LAYER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA0B5_SET_DST_LAYER(val, args...) { \
    struct nv_nva0b5_SET_DST_LAYER __data = { .v = (args) }; \
    __NVA0B5_SET_DST_LAYER(&val, __data); \
}

#define VA_NVA0B5_SET_DST_LAYER V_NVA0B5_SET_DST_LAYER

#define P_NVA0B5_SET_DST_LAYER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_DST_LAYER(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_DST_LAYER, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_DST_ORIGIN {
    uint32_t x;
    uint32_t y;
};

static inline void
__NVA0B5_SET_DST_ORIGIN(uint32_t *val_out, struct nv_nva0b5_SET_DST_ORIGIN st)
{
    uint32_t val = 0;
    
    assert(st.x < (1ULL << 16));
    val |= st.x << 0;
    
    assert(st.y < (1ULL << 16));
    val |= st.y << 16;
    *val_out = val;
}

#define V_NVA0B5_SET_DST_ORIGIN(val, args...) { \
    struct nv_nva0b5_SET_DST_ORIGIN __data = args; \
    __NVA0B5_SET_DST_ORIGIN(&val, __data); \
}

#define VA_NVA0B5_SET_DST_ORIGIN V_NVA0B5_SET_DST_ORIGIN

#define P_NVA0B5_SET_DST_ORIGIN(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_DST_ORIGIN(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_DST_ORIGIN, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_SRC_BLOCK_SIZE {
    uint32_t width;
    uint32_t height;
    uint32_t depth;
    uint32_t gob_height;
};

static inline void
__NVA0B5_SET_SRC_BLOCK_SIZE(uint32_t *val_out, struct nv_nva0b5_SET_SRC_BLOCK_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.width < (1ULL << 4));
    val |= st.width << 0;
    
    assert(st.height < (1ULL << 4));
    val |= st.height << 4;
    
    assert(st.depth < (1ULL << 4));
    val |= st.depth << 8;
    
    assert(st.gob_height < (1ULL << 4));
    val |= st.gob_height << 12;
    *val_out = val;
}

#define V_NVA0B5_SET_SRC_BLOCK_SIZE(val, args...) { \
    UNUSED uint32_t WIDTH_QUARTER_GOB = NVA0B5_SET_SRC_BLOCK_SIZE_WIDTH_QUARTER_GOB; \
    UNUSED uint32_t WIDTH_ONE_GOB = NVA0B5_SET_SRC_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NVA0B5_SET_SRC_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NVA0B5_SET_SRC_BLOCK_SIZE_DEPTH_ONE_GOB; \
    UNUSED uint32_t DEPTH_TWO_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_DEPTH_TWO_GOBS; \
    UNUSED uint32_t DEPTH_FOUR_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t DEPTH_EIGHT_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t DEPTH_SIXTEEN_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t DEPTH_THIRTYTWO_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS; \
    UNUSED uint32_t GOB_HEIGHT_GOB_HEIGHT_TESLA_4 = NVA0B5_SET_SRC_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_TESLA_4; \
    UNUSED uint32_t GOB_HEIGHT_GOB_HEIGHT_FERMI_8 = NVA0B5_SET_SRC_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_FERMI_8; \
    struct nv_nva0b5_SET_SRC_BLOCK_SIZE __data = args; \
    __NVA0B5_SET_SRC_BLOCK_SIZE(&val, __data); \
}

#define VA_NVA0B5_SET_SRC_BLOCK_SIZE V_NVA0B5_SET_SRC_BLOCK_SIZE

#define P_NVA0B5_SET_SRC_BLOCK_SIZE(push, args...) do { \
    UNUSED uint32_t WIDTH_QUARTER_GOB = NVA0B5_SET_SRC_BLOCK_SIZE_WIDTH_QUARTER_GOB; \
    UNUSED uint32_t WIDTH_ONE_GOB = NVA0B5_SET_SRC_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NVA0B5_SET_SRC_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NVA0B5_SET_SRC_BLOCK_SIZE_DEPTH_ONE_GOB; \
    UNUSED uint32_t DEPTH_TWO_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_DEPTH_TWO_GOBS; \
    UNUSED uint32_t DEPTH_FOUR_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t DEPTH_EIGHT_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t DEPTH_SIXTEEN_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t DEPTH_THIRTYTWO_GOBS = NVA0B5_SET_SRC_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS; \
    UNUSED uint32_t GOB_HEIGHT_GOB_HEIGHT_TESLA_4 = NVA0B5_SET_SRC_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_TESLA_4; \
    UNUSED uint32_t GOB_HEIGHT_GOB_HEIGHT_FERMI_8 = NVA0B5_SET_SRC_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_FERMI_8; \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_SRC_BLOCK_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_SRC_BLOCK_SIZE, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_SRC_WIDTH {
    uint32_t v;
};

static inline void
__NVA0B5_SET_SRC_WIDTH(uint32_t *val_out, struct nv_nva0b5_SET_SRC_WIDTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA0B5_SET_SRC_WIDTH(val, args...) { \
    struct nv_nva0b5_SET_SRC_WIDTH __data = { .v = (args) }; \
    __NVA0B5_SET_SRC_WIDTH(&val, __data); \
}

#define VA_NVA0B5_SET_SRC_WIDTH V_NVA0B5_SET_SRC_WIDTH

#define P_NVA0B5_SET_SRC_WIDTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_SRC_WIDTH(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_SRC_WIDTH, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_SRC_HEIGHT {
    uint32_t v;
};

static inline void
__NVA0B5_SET_SRC_HEIGHT(uint32_t *val_out, struct nv_nva0b5_SET_SRC_HEIGHT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA0B5_SET_SRC_HEIGHT(val, args...) { \
    struct nv_nva0b5_SET_SRC_HEIGHT __data = { .v = (args) }; \
    __NVA0B5_SET_SRC_HEIGHT(&val, __data); \
}

#define VA_NVA0B5_SET_SRC_HEIGHT V_NVA0B5_SET_SRC_HEIGHT

#define P_NVA0B5_SET_SRC_HEIGHT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_SRC_HEIGHT(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_SRC_HEIGHT, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_SRC_DEPTH {
    uint32_t v;
};

static inline void
__NVA0B5_SET_SRC_DEPTH(uint32_t *val_out, struct nv_nva0b5_SET_SRC_DEPTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA0B5_SET_SRC_DEPTH(val, args...) { \
    struct nv_nva0b5_SET_SRC_DEPTH __data = { .v = (args) }; \
    __NVA0B5_SET_SRC_DEPTH(&val, __data); \
}

#define VA_NVA0B5_SET_SRC_DEPTH V_NVA0B5_SET_SRC_DEPTH

#define P_NVA0B5_SET_SRC_DEPTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_SRC_DEPTH(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_SRC_DEPTH, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_SRC_LAYER {
    uint32_t v;
};

static inline void
__NVA0B5_SET_SRC_LAYER(uint32_t *val_out, struct nv_nva0b5_SET_SRC_LAYER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA0B5_SET_SRC_LAYER(val, args...) { \
    struct nv_nva0b5_SET_SRC_LAYER __data = { .v = (args) }; \
    __NVA0B5_SET_SRC_LAYER(&val, __data); \
}

#define VA_NVA0B5_SET_SRC_LAYER V_NVA0B5_SET_SRC_LAYER

#define P_NVA0B5_SET_SRC_LAYER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_SRC_LAYER(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_SRC_LAYER, nvk_p_ret); \
} while(0)

struct nv_nva0b5_SET_SRC_ORIGIN {
    uint32_t x;
    uint32_t y;
};

static inline void
__NVA0B5_SET_SRC_ORIGIN(uint32_t *val_out, struct nv_nva0b5_SET_SRC_ORIGIN st)
{
    uint32_t val = 0;
    
    assert(st.x < (1ULL << 16));
    val |= st.x << 0;
    
    assert(st.y < (1ULL << 16));
    val |= st.y << 16;
    *val_out = val;
}

#define V_NVA0B5_SET_SRC_ORIGIN(val, args...) { \
    struct nv_nva0b5_SET_SRC_ORIGIN __data = args; \
    __NVA0B5_SET_SRC_ORIGIN(&val, __data); \
}

#define VA_NVA0B5_SET_SRC_ORIGIN V_NVA0B5_SET_SRC_ORIGIN

#define P_NVA0B5_SET_SRC_ORIGIN(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_SET_SRC_ORIGIN(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_SET_SRC_ORIGIN, nvk_p_ret); \
} while(0)

struct nv_nva0b5_PM_TRIGGER_END {
    uint32_t v;
};

static inline void
__NVA0B5_PM_TRIGGER_END(uint32_t *val_out, struct nv_nva0b5_PM_TRIGGER_END st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA0B5_PM_TRIGGER_END(val, args...) { \
    struct nv_nva0b5_PM_TRIGGER_END __data = { .v = (args) }; \
    __NVA0B5_PM_TRIGGER_END(&val, __data); \
}

#define VA_NVA0B5_PM_TRIGGER_END V_NVA0B5_PM_TRIGGER_END

#define P_NVA0B5_PM_TRIGGER_END(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA0B5_PM_TRIGGER_END(nvk_p_ret, args); \
    nv_push_val(push, NVA0B5_PM_TRIGGER_END, nvk_p_ret); \
} while(0)


const char *P_PARSE_NVA0B5_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVA0B5_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                              const char *prefix) ATTRIBUTE_COLD;
