// Autogenerated by ARMTargetDefEmitter.cpp

#ifndef ARM_PROCESSOR_FAMILY
#define ARM_PROCESSOR_FAMILY(ENUM)
#endif

ARM_PROCESSOR_FAMILY(TSV110)
ARM_PROCESSOR_FAMILY(CortexR82)
ARM_PROCESSOR_FAMILY(ThunderX2T99)
ARM_PROCESSOR_FAMILY(AppleA17)
ARM_PROCESSOR_FAMILY(Neoverse512TVB)
ARM_PROCESSOR_FAMILY(ThunderXT81)
ARM_PROCESSOR_FAMILY(CortexA725)
ARM_PROCESSOR_FAMILY(CortexA55)
ARM_PROCESSOR_FAMILY(MONAKA)
ARM_PROCESSOR_FAMILY(CortexA78AE)
ARM_PROCESSOR_FAMILY(CortexX4)
ARM_PROCESSOR_FAMILY(CortexA520)
ARM_PROCESSOR_FAMILY(AppleA13)
ARM_PROCESSOR_FAMILY(CortexA76)
ARM_PROCESSOR_FAMILY(NeoverseN1)
ARM_PROCESSOR_FAMILY(Kryo)
ARM_PROCESSOR_FAMILY(AppleA11)
ARM_PROCESSOR_FAMILY(AppleA14)
ARM_PROCESSOR_FAMILY(NeoverseN2)
ARM_PROCESSOR_FAMILY(AppleA16)
ARM_PROCESSOR_FAMILY(CortexA73)
ARM_PROCESSOR_FAMILY(CortexX2)
ARM_PROCESSOR_FAMILY(AppleA7)
ARM_PROCESSOR_FAMILY(CortexA77)
ARM_PROCESSOR_FAMILY(CortexA53)
ARM_PROCESSOR_FAMILY(Ampere1B)
ARM_PROCESSOR_FAMILY(Ampere1A)
ARM_PROCESSOR_FAMILY(CortexA35)
ARM_PROCESSOR_FAMILY(CortexA510)
ARM_PROCESSOR_FAMILY(ExynosM3)
ARM_PROCESSOR_FAMILY(NeoverseV1)
ARM_PROCESSOR_FAMILY(ThunderX)
ARM_PROCESSOR_FAMILY(CortexA710)
ARM_PROCESSOR_FAMILY(AppleM4)
ARM_PROCESSOR_FAMILY(Olympus)
ARM_PROCESSOR_FAMILY(Ampere1)
ARM_PROCESSOR_FAMILY(Oryon)
ARM_PROCESSOR_FAMILY(CortexA78C)
ARM_PROCESSOR_FAMILY(AppleA12)
ARM_PROCESSOR_FAMILY(A64FX)
ARM_PROCESSOR_FAMILY(NeoverseN3)
ARM_PROCESSOR_FAMILY(NeoverseV2)
ARM_PROCESSOR_FAMILY(ThunderX3T110)
ARM_PROCESSOR_FAMILY(CortexA57)
ARM_PROCESSOR_FAMILY(CortexA75)
ARM_PROCESSOR_FAMILY(Saphira)
ARM_PROCESSOR_FAMILY(Carmel)
ARM_PROCESSOR_FAMILY(CortexA72)
ARM_PROCESSOR_FAMILY(ThunderXT83)
ARM_PROCESSOR_FAMILY(NeoverseV3)
ARM_PROCESSOR_FAMILY(ThunderXT88)
ARM_PROCESSOR_FAMILY(Falkor)
ARM_PROCESSOR_FAMILY(CortexX3)
ARM_PROCESSOR_FAMILY(CortexA720)
ARM_PROCESSOR_FAMILY(CortexX1)
ARM_PROCESSOR_FAMILY(CortexA78)
ARM_PROCESSOR_FAMILY(NeoverseE1)
ARM_PROCESSOR_FAMILY(CortexA715)
ARM_PROCESSOR_FAMILY(AppleA15)
ARM_PROCESSOR_FAMILY(CortexR82AE)
ARM_PROCESSOR_FAMILY(AppleA10)
ARM_PROCESSOR_FAMILY(CortexX925)
ARM_PROCESSOR_FAMILY(CortexA65)

#undef ARM_PROCESSOR_FAMILY

#ifndef ARM_ARCHITECTURE
#define ARM_ARCHITECTURE(ENUM)
#endif


#undef ARM_ARCHITECTURE

#ifdef EMIT_ARCHEXTKIND_ENUM
enum ArchExtKind : unsigned {
  AEK_AES,
  AEK_ALTERNATIVENZCV,
  AEK_AM,
  AEK_AMVS,
  AEK_BF16,
  AEK_BRBE,
  AEK_BTI,
  AEK_CCDP,
  AEK_CCIDX,
  AEK_CCPP,
  AEK_CHK,
  AEK_CLRBHB,
  AEK_CMPBR,
  AEK_FCMA,
  AEK_CPA,
  AEK_CRC,
  AEK_CRYPTO,
  AEK_CSSC,
  AEK_D128,
  AEK_DIT,
  AEK_DOTPROD,
  AEK_ENHANCEDCOUNTERVIRTUALIZATION,
  AEK_ETE,
  AEK_F32MM,
  AEK_F64MM,
  AEK_F8F16MM,
  AEK_F8F32MM,
  AEK_FAMINMAX,
  AEK_FINEGRAINEDTRAPS,
  AEK_FLAGM,
  AEK_FP,
  AEK_FP16FML,
  AEK_FP8,
  AEK_FP8DOT2,
  AEK_FP8DOT4,
  AEK_FP8FMA,
  AEK_FPAC,
  AEK_FPRCVT,
  AEK_FRINT3264,
  AEK_FP16,
  AEK_GCS,
  AEK_HBC,
  AEK_HCX,
  AEK_I8MM,
  AEK_ITE,
  AEK_JSCVT,
  AEK_LOR,
  AEK_LS64,
  AEK_LSE,
  AEK_LSE128,
  AEK_LSE2,
  AEK_LSFE,
  AEK_LSUI,
  AEK_LUT,
  AEK_MEC,
  AEK_MOPS,
  AEK_MPAM,
  AEK_MTE,
  AEK_SIMD,
  AEK_NMI,
  AEK_NV,
  AEK_OCCMO,
  AEK_PAN,
  AEK_PAN_RWV,
  AEK_PAUTH,
  AEK_PAUTHLR,
  AEK_PCDPHINT,
  AEK_PERFMON,
  AEK_POPS,
  AEK_PREDRES,
  AEK_PRFM_SLC,
  AEK_RAND,
  AEK_RAS,
  AEK_RASV2,
  AEK_RCPC,
  AEK_RCPC_IMMO,
  AEK_RCPC3,
  AEK_RDM,
  AEK_RME,
  AEK_SB,
  AEK_SEL2,
  AEK_SHA2,
  AEK_SHA3,
  AEK_SM4,
  AEK_SME,
  AEK_SMEB16B16,
  AEK_SMEF16F16,
  AEK_SMEF64F64,
  AEK_SMEF8F16,
  AEK_SMEF8F32,
  AEK_SMEFA64,
  AEK_SMEI16I64,
  AEK_SME_LUTV2,
  AEK_SME_MOP4,
  AEK_SME_TMOP,
  AEK_SME2,
  AEK_SME2P1,
  AEK_SME2P2,
  AEK_PROFILE,
  AEK_SPE_EEF,
  AEK_SPECRES2,
  AEK_SPECRESTRICT,
  AEK_SSBS,
  AEK_SSVE_AES,
  AEK_SSVE_BITPERM,
  AEK_SSVE_FP8DOT2,
  AEK_SSVE_FP8DOT4,
  AEK_SSVE_FP8FMA,
  AEK_SVE,
  AEK_SVEAES,
  AEK_SVE_AES2,
  AEK_SVEB16B16,
  AEK_SVE_BFSCALE,
  AEK_SVEBITPERM,
  AEK_SVE_F16F32MM,
  AEK_SVE2,
  AEK_SVE2AES,
  AEK_SVE2BITPERM,
  AEK_SVE2SHA3,
  AEK_SVE2SM4,
  AEK_SVE2P1,
  AEK_SVE2P2,
  AEK_THE,
  AEK_TLB_RMI,
  AEK_TLBIW,
  AEK_TME,
  AEK_TRACEV8_4,
  AEK_TRBE,
  AEK_PSUAO,
  AEK_VH,
  AEK_WFXT,
  AEK_XS,
  AEK_NUM_EXTENSIONS
};
#undef EMIT_ARCHEXTKIND_ENUM
#endif // EMIT_ARCHEXTKIND_ENUM
#ifdef EMIT_EXTENSIONS
inline constexpr ExtensionInfo Extensions[] = {
  {"aes", {}, AArch64::AEK_AES, "FEAT_AES, FEAT_PMULL", "Enable AES support", "+aes", "-aes"},
  {"", {}, AArch64::AEK_ALTERNATIVENZCV, "FEAT_FlagM2", "Enable alternative NZCV format for floating point comparisons", "+altnzcv", "-altnzcv"},
  {"", {}, AArch64::AEK_AM, "FEAT_AMUv1", "Enable Armv8.4-A Activity Monitors extension", "+am", "-am"},
  {"", {}, AArch64::AEK_AMVS, "FEAT_AMUv1p1", "Enable Armv8.6-A Activity Monitors Virtualization support", "+amvs", "-amvs"},
  {"bf16", {}, AArch64::AEK_BF16, "FEAT_BF16", "Enable BFloat16 Extension", "+bf16", "-bf16"},
  {"brbe", {}, AArch64::AEK_BRBE, "FEAT_BRBE", "Enable Branch Record Buffer Extension", "+brbe", "-brbe"},
  {"bti", {}, AArch64::AEK_BTI, "FEAT_BTI", "Enable Branch Target Identification", "+bti", "-bti"},
  {"", {}, AArch64::AEK_CCDP, "FEAT_DPB2", "Enable Armv8.5-A Cache Clean to Point of Deep Persistence", "+ccdp", "-ccdp"},
  {"", {}, AArch64::AEK_CCIDX, "FEAT_CCIDX", "Enable Armv8.3-A Extend of the CCSIDR number of sets", "+ccidx", "-ccidx"},
  {"", {}, AArch64::AEK_CCPP, "FEAT_DPB", "Enable Armv8.2-A data Cache Clean to Point of Persistence", "+ccpp", "-ccpp"},
  {"", {}, AArch64::AEK_CHK, "FEAT_CHK", "Enable Armv8.0-A Check Feature Status Extension", "+chk", "-chk"},
  {"", {}, AArch64::AEK_CLRBHB, "FEAT_CLRBHB", "Enable Clear BHB instruction", "+clrbhb", "-clrbhb"},
  {"cmpbr", {}, AArch64::AEK_CMPBR, "FEAT_CMPBR", "Enable Armv9.6-A base compare and branch instructions", "+cmpbr", "-cmpbr"},
  {"fcma", {}, AArch64::AEK_FCMA, "FEAT_FCMA", "Enable Armv8.3-A Floating-point complex number support", "+complxnum", "-complxnum"},
  {"cpa", {}, AArch64::AEK_CPA, "FEAT_CPA", "Enable Armv9.5-A Checked Pointer Arithmetic", "+cpa", "-cpa"},
  {"crc", {}, AArch64::AEK_CRC, "FEAT_CRC32", "Enable Armv8.0-A CRC-32 checksum instructions", "+crc", "-crc"},
  {"crypto", {}, AArch64::AEK_CRYPTO, "FEAT_Crypto", "Enable cryptographic instructions", "+crypto", "-crypto"},
  {"cssc", {}, AArch64::AEK_CSSC, "FEAT_CSSC", "Enable Common Short Sequence Compression (CSSC) instructions", "+cssc", "-cssc"},
  {"d128", {}, AArch64::AEK_D128, "FEAT_D128, FEAT_LVA3, FEAT_SYSREG128, FEAT_SYSINSTR128", "Enable Armv9.4-A 128-bit Page Table Descriptors, System Registers and instructions", "+d128", "-d128"},
  {"dit", {}, AArch64::AEK_DIT, "FEAT_DIT", "Enable Armv8.4-A Data Independent Timing instructions", "+dit", "-dit"},
  {"dotprod", {}, AArch64::AEK_DOTPROD, "FEAT_DotProd", "Enable dot product support", "+dotprod", "-dotprod"},
  {"", {}, AArch64::AEK_ENHANCEDCOUNTERVIRTUALIZATION, "FEAT_ECV", "Enable enhanced counter virtualization extension", "+ecv", "-ecv"},
  {"", {}, AArch64::AEK_ETE, "FEAT_ETE", "Enable Embedded Trace Extension", "+ete", "-ete"},
  {"f32mm", {}, AArch64::AEK_F32MM, "FEAT_F32MM", "Enable Matrix Multiply FP32 Extension", "+f32mm", "-f32mm"},
  {"f64mm", {}, AArch64::AEK_F64MM, "FEAT_F64MM", "Enable Matrix Multiply FP64 Extension", "+f64mm", "-f64mm"},
  {"f8f16mm", {}, AArch64::AEK_F8F16MM, "FEAT_F8F16MM", "Enable Armv9.6-A FP8 to Half-Precision Matrix Multiplication", "+f8f16mm", "-f8f16mm"},
  {"f8f32mm", {}, AArch64::AEK_F8F32MM, "FEAT_F8F32MM", "Enable Armv9.6-A FP8 to Single-Precision Matrix Multiplication", "+f8f32mm", "-f8f32mm"},
  {"faminmax", {}, AArch64::AEK_FAMINMAX, "FEAT_FAMINMAX", "Enable FAMIN and FAMAX instructions", "+faminmax", "-faminmax"},
  {"", {}, AArch64::AEK_FINEGRAINEDTRAPS, "FEAT_FGT", "Enable fine grained virtualization traps extension", "+fgt", "-fgt"},
  {"flagm", {}, AArch64::AEK_FLAGM, "FEAT_FlagM", "Enable Armv8.4-A Flag Manipulation instructions", "+flagm", "-flagm"},
  {"fp", {}, AArch64::AEK_FP, "FEAT_FP", "Enable Armv8.0-A Floating Point Extensions", "+fp-armv8", "-fp-armv8"},
  {"fp16fml", {}, AArch64::AEK_FP16FML, "FEAT_FHM", "Enable FP16 FML instructions", "+fp16fml", "-fp16fml"},
  {"fp8", {}, AArch64::AEK_FP8, "FEAT_FP8", "Enable FP8 instructions", "+fp8", "-fp8"},
  {"fp8dot2", {}, AArch64::AEK_FP8DOT2, "FEAT_FP8DOT2", "Enable FP8 2-way dot instructions", "+fp8dot2", "-fp8dot2"},
  {"fp8dot4", {}, AArch64::AEK_FP8DOT4, "FEAT_FP8DOT4", "Enable FP8 4-way dot instructions", "+fp8dot4", "-fp8dot4"},
  {"fp8fma", {}, AArch64::AEK_FP8FMA, "FEAT_FP8FMA", "Enable Armv9.5-A FP8 multiply-add instructions", "+fp8fma", "-fp8fma"},
  {"", {}, AArch64::AEK_FPAC, "FEAT_FPAC", "Enable Armv8.3-A Pointer Authentication Faulting enhancement", "+fpac", "-fpac"},
  {"fprcvt", {}, AArch64::AEK_FPRCVT, "FEAT_FPRCVT", "Enable Armv9.6-A base convert instructions for SIMD&FP scalar register operands of different input and output sizes", "+fprcvt", "-fprcvt"},
  {"", {}, AArch64::AEK_FRINT3264, "FEAT_FRINTTS", "Enable FRInt[32|64][Z|X] instructions that round a floating-point number to an integer (in FP format) forcing it to fit into a 32- or 64-bit int", "+fptoint", "-fptoint"},
  {"fp16", {}, AArch64::AEK_FP16, "FEAT_FP16", "Enable half-precision floating-point data processing", "+fullfp16", "-fullfp16"},
  {"gcs", {}, AArch64::AEK_GCS, "FEAT_GCS", "Enable Armv9.4-A Guarded Call Stack Extension", "+gcs", "-gcs"},
  {"hbc", {}, AArch64::AEK_HBC, "FEAT_HBC", "Enable Armv8.8-A Hinted Conditional Branches Extension", "+hbc", "-hbc"},
  {"", {}, AArch64::AEK_HCX, "FEAT_HCX", "Enable Armv8.7-A HCRX_EL2 system register", "+hcx", "-hcx"},
  {"i8mm", {}, AArch64::AEK_I8MM, "FEAT_I8MM", "Enable Matrix Multiply Int8 Extension", "+i8mm", "-i8mm"},
  {"ite", {}, AArch64::AEK_ITE, "FEAT_ITE", "Enable Armv9.4-A Instrumentation Extension", "+ite", "-ite"},
  {"jscvt", {}, AArch64::AEK_JSCVT, "FEAT_JSCVT", "Enable Armv8.3-A JavaScript FP conversion instructions", "+jsconv", "-jsconv"},
  {"", {}, AArch64::AEK_LOR, "FEAT_LOR", "Enable Armv8.1-A Limited Ordering Regions extension", "+lor", "-lor"},
  {"ls64", {}, AArch64::AEK_LS64, "FEAT_LS64, FEAT_LS64_V, FEAT_LS64_ACCDATA", "Enable Armv8.7-A LD64B/ST64B Accelerator Extension", "+ls64", "-ls64"},
  {"lse", {}, AArch64::AEK_LSE, "FEAT_LSE", "Enable Armv8.1-A Large System Extension (LSE) atomic instructions", "+lse", "-lse"},
  {"lse128", {}, AArch64::AEK_LSE128, "FEAT_LSE128", "Enable Armv9.4-A 128-bit Atomic instructions", "+lse128", "-lse128"},
  {"", {}, AArch64::AEK_LSE2, "FEAT_LSE2", "Enable Armv8.4-A Large System Extension 2 (LSE2) atomicity rules", "+lse2", "-lse2"},
  {"lsfe", {}, AArch64::AEK_LSFE, "FEAT_LSFE", "Enable Armv9.6-A base Atomic floating-point in-memory instructions", "+lsfe", "-lsfe"},
  {"lsui", {}, AArch64::AEK_LSUI, "FEAT_LSUI", "Enable Armv9.6-A unprivileged load/store instructions", "+lsui", "-lsui"},
  {"lut", {}, AArch64::AEK_LUT, "FEAT_LUT", "Enable Lookup Table instructions", "+lut", "-lut"},
  {"", {}, AArch64::AEK_MEC, "FEAT_MEC", "Enable Memory Encryption Contexts Extension", "+mec", "-mec"},
  {"mops", {}, AArch64::AEK_MOPS, "FEAT_MOPS", "Enable Armv8.8-A memcpy and memset acceleration instructions", "+mops", "-mops"},
  {"", {}, AArch64::AEK_MPAM, "FEAT_MPAM", "Enable Armv8.4-A Memory system Partitioning and Monitoring extension", "+mpam", "-mpam"},
  {"memtag", {}, AArch64::AEK_MTE, "FEAT_MTE, FEAT_MTE2", "Enable Memory Tagging Extension", "+mte", "-mte"},
  {"simd", {}, AArch64::AEK_SIMD, "FEAT_AdvSIMD", "Enable Advanced SIMD instructions", "+neon", "-neon"},
  {"", {}, AArch64::AEK_NMI, "FEAT_NMI, FEAT_GICv3_NMI", "Enable Armv8.8-A Non-maskable Interrupts", "+nmi", "-nmi"},
  {"", {}, AArch64::AEK_NV, "FEAT_NV, FEAT_NV2", "Enable Armv8.4-A Nested Virtualization Enchancement", "+nv", "-nv"},
  {"occmo", {}, AArch64::AEK_OCCMO, "FEAT_OCCMO", "Enable Armv9.6-A Outer cacheable cache maintenance operations", "+occmo", "-occmo"},
  {"", {}, AArch64::AEK_PAN, "FEAT_PAN", "Enable Armv8.1-A Privileged Access-Never extension", "+pan", "-pan"},
  {"", {}, AArch64::AEK_PAN_RWV, "FEAT_PAN2", "Enable Armv8.2-A PAN s1e1R and s1e1W Variants", "+pan-rwv", "-pan-rwv"},
  {"pauth", {}, AArch64::AEK_PAUTH, "FEAT_PAuth", "Enable Armv8.3-A Pointer Authentication extension", "+pauth", "-pauth"},
  {"pauth-lr", {}, AArch64::AEK_PAUTHLR, "FEAT_PAuth_LR", "Enable Armv9.5-A PAC enhancements", "+pauth-lr", "-pauth-lr"},
  {"pcdphint", {}, AArch64::AEK_PCDPHINT, "FEAT_PCDPHINT", "Enable Armv9.6-A Producer Consumer Data Placement hints", "+pcdphint", "-pcdphint"},
  {"pmuv3", {}, AArch64::AEK_PERFMON, "FEAT_PMUv3", "Enable Armv8.0-A PMUv3 Performance Monitors extension", "+perfmon", "-perfmon"},
  {"pops", {}, AArch64::AEK_POPS, "FEAT_PoPS", "Enable Armv9.6-A Point Of Physical Storage (PoPS) DC instructions", "+pops", "-pops"},
  {"predres", {}, AArch64::AEK_PREDRES, "FEAT_SPECRES", "Enable Armv8.5-A execution and data prediction invalidation instructions", "+predres", "-predres"},
  {"", {}, AArch64::AEK_PRFM_SLC, "FEAT_PRFMSLC", "Enable SLC target for PRFM instruction", "+prfm-slc-target", "-prfm-slc-target"},
  {"rng", {}, AArch64::AEK_RAND, "FEAT_RNG", "Enable Random Number generation instructions", "+rand", "-rand"},
  {"ras", {}, AArch64::AEK_RAS, "FEAT_RAS, FEAT_RASv1p1", "Enable Armv8.0-A Reliability, Availability and Serviceability Extensions", "+ras", "-ras"},
  {"rasv2", {}, AArch64::AEK_RASV2, "FEAT_RASv2", "Enable Armv8.9-A Reliability, Availability and Serviceability Extensions", "+rasv2", "-rasv2"},
  {"rcpc", {}, AArch64::AEK_RCPC, "FEAT_LRCPC", "Enable support for RCPC extension", "+rcpc", "-rcpc"},
  {"", {}, AArch64::AEK_RCPC_IMMO, "FEAT_LRCPC2", "Enable Armv8.4-A RCPC instructions with Immediate Offsets", "+rcpc-immo", "-rcpc-immo"},
  {"rcpc3", {}, AArch64::AEK_RCPC3, "FEAT_LRCPC3", "Enable Armv8.9-A RCPC instructions for A64 and Advanced SIMD and floating-point instruction set", "+rcpc3", "-rcpc3"},
  {"rdm", "rdma", AArch64::AEK_RDM, "FEAT_RDM", "Enable Armv8.1-A Rounding Double Multiply Add/Subtract instructions", "+rdm", "-rdm"},
  {"", {}, AArch64::AEK_RME, "FEAT_RME", "Enable Realm Management Extension", "+rme", "-rme"},
  {"sb", {}, AArch64::AEK_SB, "FEAT_SB", "Enable Armv8.5-A Speculation Barrier", "+sb", "-sb"},
  {"", {}, AArch64::AEK_SEL2, "FEAT_SEL2", "Enable Armv8.4-A Secure Exception Level 2 extension", "+sel2", "-sel2"},
  {"sha2", {}, AArch64::AEK_SHA2, "FEAT_SHA1, FEAT_SHA256", "Enable SHA1 and SHA256 support", "+sha2", "-sha2"},
  {"sha3", {}, AArch64::AEK_SHA3, "FEAT_SHA3, FEAT_SHA512", "Enable SHA512 and SHA3 support", "+sha3", "-sha3"},
  {"sm4", {}, AArch64::AEK_SM4, "FEAT_SM4, FEAT_SM3", "Enable SM3 and SM4 support", "+sm4", "-sm4"},
  {"sme", {}, AArch64::AEK_SME, "FEAT_SME", "Enable Scalable Matrix Extension (SME)", "+sme", "-sme"},
  {"sme-b16b16", {}, AArch64::AEK_SMEB16B16, "FEAT_SME_B16B16", "Enable SME2.1 ZA-targeting non-widening BFloat16 instructions", "+sme-b16b16", "-sme-b16b16"},
  {"sme-f16f16", {}, AArch64::AEK_SMEF16F16, "FEAT_SME_F16F16", "Enable SME non-widening Float16 instructions", "+sme-f16f16", "-sme-f16f16"},
  {"sme-f64f64", {}, AArch64::AEK_SMEF64F64, "FEAT_SME_F64F64", "Enable Scalable Matrix Extension (SME) F64F64 instructions", "+sme-f64f64", "-sme-f64f64"},
  {"sme-f8f16", {}, AArch64::AEK_SMEF8F16, "FEAT_SME_F8F16", "Enable Scalable Matrix Extension (SME) F8F16 instructions", "+sme-f8f16", "-sme-f8f16"},
  {"sme-f8f32", {}, AArch64::AEK_SMEF8F32, "FEAT_SME_F8F32", "Enable Scalable Matrix Extension (SME) F8F32 instructions", "+sme-f8f32", "-sme-f8f32"},
  {"sme-fa64", {}, AArch64::AEK_SMEFA64, "FEAT_SME_FA64", "Enable the full A64 instruction set in streaming SVE mode", "+sme-fa64", "-sme-fa64"},
  {"sme-i16i64", {}, AArch64::AEK_SMEI16I64, "FEAT_SME_I16I64", "Enable Scalable Matrix Extension (SME) I16I64 instructions", "+sme-i16i64", "-sme-i16i64"},
  {"sme-lutv2", {}, AArch64::AEK_SME_LUTV2, "FEAT_SME_LUTv2", "Enable Scalable Matrix Extension (SME) LUTv2 instructions", "+sme-lutv2", "-sme-lutv2"},
  {"sme-mop4", {}, AArch64::AEK_SME_MOP4, "FEAT_SME_MOP4", "Enable SME Quarter-tile outer product instructions", "+sme-mop4", "-sme-mop4"},
  {"sme-tmop", {}, AArch64::AEK_SME_TMOP, "FEAT_SME_TMOP", "Enable SME Structured sparsity outer product instructions.", "+sme-tmop", "-sme-tmop"},
  {"sme2", {}, AArch64::AEK_SME2, "FEAT_SME2", "Enable Scalable Matrix Extension 2 (SME2) instructions", "+sme2", "-sme2"},
  {"sme2p1", {}, AArch64::AEK_SME2P1, "FEAT_SME2p1", "Enable Scalable Matrix Extension 2.1 instructions", "+sme2p1", "-sme2p1"},
  {"sme2p2", {}, AArch64::AEK_SME2P2, "FEAT_SME2p2", "Enable Armv9.6-A Scalable Matrix Extension 2.2 instructions", "+sme2p2", "-sme2p2"},
  {"profile", {}, AArch64::AEK_PROFILE, "FEAT_SPE", "Enable Statistical Profiling extension", "+spe", "-spe"},
  {"", {}, AArch64::AEK_SPE_EEF, "FEAT_SPEv1p2", "Enable extra register in the Statistical Profiling Extension", "+spe-eef", "-spe-eef"},
  {"predres2", {}, AArch64::AEK_SPECRES2, "FEAT_SPECRES2", "Enable Speculation Restriction Instruction", "+specres2", "-specres2"},
  {"", {}, AArch64::AEK_SPECRESTRICT, "FEAT_CSV2_2", "Enable architectural speculation restriction", "+specrestrict", "-specrestrict"},
  {"ssbs", {}, AArch64::AEK_SSBS, "FEAT_SSBS, FEAT_SSBS2", "Enable Speculative Store Bypass Safe bit", "+ssbs", "-ssbs"},
  {"ssve-aes", {}, AArch64::AEK_SSVE_AES, "FEAT_SSVE_AES", "Enable Armv9.6-A SVE AES support in streaming SVE mode", "+ssve-aes", "-ssve-aes"},
  {"ssve-bitperm", {}, AArch64::AEK_SSVE_BITPERM, "FEAT_SSVE_BitPerm", "Enable Armv9.6-A SVE BitPerm support in streaming SVE mode", "+ssve-bitperm", "-ssve-bitperm"},
  {"ssve-fp8dot2", {}, AArch64::AEK_SSVE_FP8DOT2, "FEAT_SSVE_FP8DOT2", "Enable SVE2 FP8 2-way dot product instructions", "+ssve-fp8dot2", "-ssve-fp8dot2"},
  {"ssve-fp8dot4", {}, AArch64::AEK_SSVE_FP8DOT4, "FEAT_SSVE_FP8DOT4", "Enable SVE2 FP8 4-way dot product instructions", "+ssve-fp8dot4", "-ssve-fp8dot4"},
  {"ssve-fp8fma", {}, AArch64::AEK_SSVE_FP8FMA, "FEAT_SSVE_FP8FMA", "Enable SVE2 FP8 multiply-add instructions", "+ssve-fp8fma", "-ssve-fp8fma"},
  {"sve", {}, AArch64::AEK_SVE, "FEAT_SVE", "Enable Scalable Vector Extension (SVE) instructions", "+sve", "-sve"},
  {"sve-aes", {}, AArch64::AEK_SVEAES, "FEAT_SVE_AES, FEAT_SVE_PMULL128", "Enable SVE AES and quadword SVE polynomial multiply instructions", "+sve-aes", "-sve-aes"},
  {"sve-aes2", {}, AArch64::AEK_SVE_AES2, "FEAT_SVE_AES2", "Enable Armv9.6-A SVE multi-vector AES and multi-vector quadword polynomial multiply instructions", "+sve-aes2", "-sve-aes2"},
  {"sve-b16b16", {}, AArch64::AEK_SVEB16B16, "FEAT_SVE_B16B16", "Enable SVE2 non-widening and SME2 Z-targeting non-widening BFloat16 instructions", "+sve-b16b16", "-sve-b16b16"},
  {"sve-bfscale", {}, AArch64::AEK_SVE_BFSCALE, "FEAT_SVE_BFSCALE", "Enable Armv9.6-A SVE BFloat16 scaling instructions", "+sve-bfscale", "-sve-bfscale"},
  {"sve-bitperm", {}, AArch64::AEK_SVEBITPERM, "FEAT_SVE_BitPerm", "Enable bit permutation SVE2 instructions", "+sve-bitperm", "-sve-bitperm"},
  {"sve-f16f32mm", {}, AArch64::AEK_SVE_F16F32MM, "FEAT_SVE_F16F32MM", "Enable Armv9.6-A FP16 to FP32 Matrix Multiply instructions", "+sve-f16f32mm", "-sve-f16f32mm"},
  {"sve2", {}, AArch64::AEK_SVE2, "FEAT_SVE2", "Enable Scalable Vector Extension 2 (SVE2) instructions", "+sve2", "-sve2"},
  {"sve2-aes", {}, AArch64::AEK_SVE2AES, "", "Shorthand for +sve2+sve-aes", "+sve2-aes", "-sve2-aes"},
  {"sve2-bitperm", {}, AArch64::AEK_SVE2BITPERM, "", "Shorthand for +sve2+sve-bitperm", "+sve2-bitperm", "-sve2-bitperm"},
  {"sve2-sha3", {}, AArch64::AEK_SVE2SHA3, "FEAT_SVE_SHA3", "Enable SHA3 SVE2 instructions", "+sve2-sha3", "-sve2-sha3"},
  {"sve2-sm4", {}, AArch64::AEK_SVE2SM4, "FEAT_SVE_SM4", "Enable SM4 SVE2 instructions", "+sve2-sm4", "-sve2-sm4"},
  {"sve2p1", {}, AArch64::AEK_SVE2P1, "FEAT_SVE2p1", "Enable Scalable Vector Extension 2.1 instructions", "+sve2p1", "-sve2p1"},
  {"sve2p2", {}, AArch64::AEK_SVE2P2, "FEAT_SVE2p2", "Enable Armv9.6-A Scalable Vector Extension 2.2 instructions", "+sve2p2", "-sve2p2"},
  {"the", {}, AArch64::AEK_THE, "FEAT_THE", "Enable Armv8.9-A Translation Hardening Extension", "+the", "-the"},
  {"", {}, AArch64::AEK_TLB_RMI, "FEAT_TLBIOS, FEAT_TLBIRANGE", "Enable Armv8.4-A TLB Range and Maintenance instructions", "+tlb-rmi", "-tlb-rmi"},
  {"tlbiw", {}, AArch64::AEK_TLBIW, "FEAT_TLBIW", "Enable Armv9.5-A TLBI VMALL for Dirty State", "+tlbiw", "-tlbiw"},
  {"tme", {}, AArch64::AEK_TME, "FEAT_TME", "Enable Transactional Memory Extension", "+tme", "-tme"},
  {"", {}, AArch64::AEK_TRACEV8_4, "FEAT_TRF", "Enable Armv8.4-A Trace extension", "+tracev8.4", "-tracev8.4"},
  {"", {}, AArch64::AEK_TRBE, "FEAT_TRBE", "Enable Trace Buffer Extension", "+trbe", "-trbe"},
  {"", {}, AArch64::AEK_PSUAO, "FEAT_UAO", "Enable Armv8.2-A UAO PState", "+uaops", "-uaops"},
  {"", {}, AArch64::AEK_VH, "FEAT_VHE", "Enable Armv8.1-A Virtual Host extension", "+vh", "-vh"},
  {"wfxt", {}, AArch64::AEK_WFXT, "FEAT_WFxT", "Enable Armv8.7-A WFET and WFIT instruction", "+wfxt", "-wfxt"},
  {"", {}, AArch64::AEK_XS, "FEAT_XS", "Enable Armv8.7-A limited-TLB-maintenance instruction", "+xs", "-xs"},
};
#undef EMIT_EXTENSIONS
#endif // EMIT_EXTENSIONS

#ifdef EMIT_FMV_INFO
const std::vector<llvm::AArch64::FMVInfo>& llvm::AArch64::getFMVInfo() {
  static std::vector<FMVInfo> I;
  if(I.size()) return I;
  I.reserve(45);
  I.emplace_back("aes", FEAT_PMULL, PRIOR_PMULL, AEK_AES);
  I.emplace_back("bf16", FEAT_BF16, PRIOR_BF16, AEK_BF16);
  I.emplace_back("bti", FEAT_BTI, PRIOR_BTI, AEK_BTI);
  I.emplace_back("crc", FEAT_CRC, PRIOR_CRC, AEK_CRC);
  I.emplace_back("dit", FEAT_DIT, PRIOR_DIT, AEK_DIT);
  I.emplace_back("dotprod", FEAT_DOTPROD, PRIOR_DOTPROD, AEK_DOTPROD);
  I.emplace_back("dpb", FEAT_DPB, PRIOR_DPB, AEK_CCPP);
  I.emplace_back("dpb2", FEAT_DPB2, PRIOR_DPB2, AEK_CCDP);
  I.emplace_back("f32mm", FEAT_SVE_F32MM, PRIOR_SVE_F32MM, AEK_F32MM);
  I.emplace_back("f64mm", FEAT_SVE_F64MM, PRIOR_SVE_F64MM, AEK_F64MM);
  I.emplace_back("fcma", FEAT_FCMA, PRIOR_FCMA, AEK_FCMA);
  I.emplace_back("flagm", FEAT_FLAGM, PRIOR_FLAGM, AEK_FLAGM);
  I.emplace_back("flagm2", FEAT_FLAGM2, PRIOR_FLAGM2, AEK_ALTERNATIVENZCV);
  I.emplace_back("fp", FEAT_FP, PRIOR_FP, AEK_FP);
  I.emplace_back("fp16", FEAT_FP16, PRIOR_FP16, AEK_FP16);
  I.emplace_back("fp16fml", FEAT_FP16FML, PRIOR_FP16FML, AEK_FP16FML);
  I.emplace_back("frintts", FEAT_FRINTTS, PRIOR_FRINTTS, AEK_FRINT3264);
  I.emplace_back("i8mm", FEAT_I8MM, PRIOR_I8MM, AEK_I8MM);
  I.emplace_back("jscvt", FEAT_JSCVT, PRIOR_JSCVT, AEK_JSCVT);
  I.emplace_back("lse", FEAT_LSE, PRIOR_LSE, AEK_LSE);
  I.emplace_back("memtag", FEAT_MEMTAG2, PRIOR_MEMTAG2, AEK_MTE);
  I.emplace_back("mops", FEAT_MOPS, PRIOR_MOPS, AEK_MOPS);
  I.emplace_back("rcpc", FEAT_RCPC, PRIOR_RCPC, AEK_RCPC);
  I.emplace_back("rcpc2", FEAT_RCPC2, PRIOR_RCPC2, AEK_RCPC_IMMO);
  I.emplace_back("rcpc3", FEAT_RCPC3, PRIOR_RCPC3, AEK_RCPC3);
  I.emplace_back("rdm", FEAT_RDM, PRIOR_RDM, AEK_RDM);
  I.emplace_back("rng", FEAT_RNG, PRIOR_RNG, AEK_RAND);
  I.emplace_back("sb", FEAT_SB, PRIOR_SB, AEK_SB);
  I.emplace_back("sha2", FEAT_SHA2, PRIOR_SHA2, AEK_SHA2);
  I.emplace_back("sha3", FEAT_SHA3, PRIOR_SHA3, AEK_SHA3);
  I.emplace_back("simd", FEAT_SIMD, PRIOR_SIMD, AEK_SIMD);
  I.emplace_back("sm4", FEAT_SM4, PRIOR_SM4, AEK_SM4);
  I.emplace_back("sme", FEAT_SME, PRIOR_SME, AEK_SME);
  I.emplace_back("sme-f64f64", FEAT_SME_F64, PRIOR_SME_F64, AEK_SMEF64F64);
  I.emplace_back("sme-i16i64", FEAT_SME_I64, PRIOR_SME_I64, AEK_SMEI16I64);
  I.emplace_back("sme2", FEAT_SME2, PRIOR_SME2, AEK_SME2);
  I.emplace_back("ssbs", FEAT_SSBS2, PRIOR_SSBS2, AEK_SSBS);
  I.emplace_back("sve", FEAT_SVE, PRIOR_SVE, AEK_SVE);
  I.emplace_back("sve2", FEAT_SVE2, PRIOR_SVE2, AEK_SVE2);
  I.emplace_back("sve2-aes", FEAT_SVE_PMULL128, PRIOR_SVE_PMULL128, AEK_SVE2AES);
  I.emplace_back("sve2-bitperm", FEAT_SVE_BITPERM, PRIOR_SVE_BITPERM, AEK_SVE2BITPERM);
  I.emplace_back("sve2-sha3", FEAT_SVE_SHA3, PRIOR_SVE_SHA3, AEK_SVE2SHA3);
  I.emplace_back("sve2-sm4", FEAT_SVE_SM4, PRIOR_SVE_SM4, AEK_SVE2SM4);
  I.emplace_back("wfxt", FEAT_WFXT, PRIOR_WFXT, AEK_WFXT);
  I.emplace_back("cssc", FEAT_CSSC, PRIOR_CSSC, AEK_CSSC);
  return I;
}
#undef EMIT_FMV_INFO
#endif // EMIT_FMV_INFO

#ifdef EMIT_EXTENSION_DEPENDENCIES
inline constexpr ExtensionDependency ExtensionDependencies[] = {
  {AEK_SIMD, AEK_AES},
  {AEK_FLAGM, AEK_ALTERNATIVENZCV},
  {AEK_AM, AEK_AMVS},
  {AEK_SIMD, AEK_BF16},
  {AEK_CCPP, AEK_CCDP},
  {AEK_SIMD, AEK_FCMA},
  {AEK_SIMD, AEK_CRYPTO},
  {AEK_SHA2, AEK_CRYPTO},
  {AEK_AES, AEK_CRYPTO},
  {AEK_LSE128, AEK_D128},
  {AEK_SIMD, AEK_DOTPROD},
  {AEK_TRBE, AEK_ETE},
  {AEK_SVE, AEK_F32MM},
  {AEK_SVE, AEK_F64MM},
  {AEK_SIMD, AEK_F8F16MM},
  {AEK_FP8, AEK_F8F16MM},
  {AEK_SIMD, AEK_F8F32MM},
  {AEK_FP8, AEK_F8F32MM},
  {AEK_SIMD, AEK_FAMINMAX},
  {AEK_FP16, AEK_FP16FML},
  {AEK_SIMD, AEK_FP16FML},
  {AEK_SIMD, AEK_FP8},
  {AEK_FP8, AEK_FP8DOT2},
  {AEK_FP8, AEK_FP8DOT4},
  {AEK_FP8, AEK_FP8FMA},
  {AEK_FP, AEK_FPRCVT},
  {AEK_FP, AEK_FRINT3264},
  {AEK_FP, AEK_FP16},
  {AEK_CHK, AEK_GCS},
  {AEK_SIMD, AEK_I8MM},
  {AEK_ETE, AEK_ITE},
  {AEK_TRBE, AEK_ITE},
  {AEK_FP, AEK_JSCVT},
  {AEK_LSE, AEK_LSE128},
  {AEK_FP, AEK_LSFE},
  {AEK_SIMD, AEK_LUT},
  {AEK_RME, AEK_MEC},
  {AEK_FP, AEK_SIMD},
  {AEK_PAN, AEK_PAN_RWV},
  {AEK_RAS, AEK_RASV2},
  {AEK_RCPC, AEK_RCPC_IMMO},
  {AEK_RCPC_IMMO, AEK_RCPC3},
  {AEK_SIMD, AEK_RDM},
  {AEK_SIMD, AEK_SHA2},
  {AEK_SIMD, AEK_SHA3},
  {AEK_SHA2, AEK_SHA3},
  {AEK_SIMD, AEK_SM4},
  {AEK_BF16, AEK_SME},
  {AEK_FP16, AEK_SME},
  {AEK_SME2, AEK_SMEB16B16},
  {AEK_SVEB16B16, AEK_SMEB16B16},
  {AEK_SME2, AEK_SMEF16F16},
  {AEK_SME, AEK_SMEF64F64},
  {AEK_SME2, AEK_SMEF8F16},
  {AEK_FP8, AEK_SMEF8F16},
  {AEK_SME2, AEK_SMEF8F32},
  {AEK_FP8, AEK_SMEF8F32},
  {AEK_SME, AEK_SMEFA64},
  {AEK_SVE2, AEK_SMEFA64},
  {AEK_SME, AEK_SMEI16I64},
  {AEK_SME2, AEK_SME_LUTV2},
  {AEK_SME2, AEK_SME_MOP4},
  {AEK_SME2, AEK_SME_TMOP},
  {AEK_SME, AEK_SME2},
  {AEK_SME2, AEK_SME2P1},
  {AEK_SME2P1, AEK_SME2P2},
  {AEK_PREDRES, AEK_SPECRES2},
  {AEK_SME2, AEK_SSVE_AES},
  {AEK_SVEAES, AEK_SSVE_AES},
  {AEK_SME2, AEK_SSVE_BITPERM},
  {AEK_SVEBITPERM, AEK_SSVE_BITPERM},
  {AEK_SME2, AEK_SSVE_FP8DOT2},
  {AEK_FP8, AEK_SSVE_FP8DOT2},
  {AEK_SME2, AEK_SSVE_FP8DOT4},
  {AEK_FP8, AEK_SSVE_FP8DOT4},
  {AEK_SME2, AEK_SSVE_FP8FMA},
  {AEK_FP8, AEK_SSVE_FP8FMA},
  {AEK_FP16, AEK_SVE},
  {AEK_AES, AEK_SVEAES},
  {AEK_SVE, AEK_SVE_F16F32MM},
  {AEK_SVE, AEK_SVE2},
  {AEK_SVE2, AEK_SVE2AES},
  {AEK_SVEAES, AEK_SVE2AES},
  {AEK_SVE2, AEK_SVE2BITPERM},
  {AEK_SVEBITPERM, AEK_SVE2BITPERM},
  {AEK_SVE2, AEK_SVE2SHA3},
  {AEK_SHA3, AEK_SVE2SHA3},
  {AEK_SVE2, AEK_SVE2SM4},
  {AEK_SM4, AEK_SVE2SM4},
  {AEK_SVE2, AEK_SVE2P1},
  {AEK_SVE2P1, AEK_SVE2P2},
  {AEK_RCPC, AEK_RCPC3},
};
#undef EMIT_EXTENSION_DEPENDENCIES
#endif // EMIT_EXTENSION_DEPENDENCIES

#ifdef EMIT_ARCHITECTURES
inline constexpr ArchInfo ARMV8A = {
  VersionTuple{8, 0},
  AProfile,
  "armv8-a",
  "+v8a",
  (AArch64::ExtensionBitset({AArch64::AEK_FP, AArch64::AEK_SIMD, }))
};
inline constexpr ArchInfo ARMV8R = {
  VersionTuple{8, 0},
  RProfile,
  "armv8-r",
  "+v8r",
  (AArch64::ExtensionBitset({AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_SSBS, AArch64::AEK_SB, AArch64::AEK_SSBS, AArch64::AEK_FP16, AArch64::AEK_FP16FML, AArch64::AEK_SB, }))
};
inline constexpr ArchInfo ARMV8_1A = {
  VersionTuple{8, 1},
  AProfile,
  "armv8.1-a",
  "+v8.1a",
  (AArch64::ExtensionBitset({AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, }))
};
inline constexpr ArchInfo ARMV8_2A = {
  VersionTuple{8, 2},
  AProfile,
  "armv8.2-a",
  "+v8.2a",
  (AArch64::ExtensionBitset({AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, }))
};
inline constexpr ArchInfo ARMV8_3A = {
  VersionTuple{8, 3},
  AProfile,
  "armv8.3-a",
  "+v8.3a",
  (AArch64::ExtensionBitset({AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, }))
};
inline constexpr ArchInfo ARMV8_4A = {
  VersionTuple{8, 4},
  AProfile,
  "armv8.4-a",
  "+v8.4a",
  (AArch64::ExtensionBitset({AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, }))
};
inline constexpr ArchInfo ARMV8_5A = {
  VersionTuple{8, 5},
  AProfile,
  "armv8.5-a",
  "+v8.5a",
  (AArch64::ExtensionBitset({AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, }))
};
inline constexpr ArchInfo ARMV8_6A = {
  VersionTuple{8, 6},
  AProfile,
  "armv8.6-a",
  "+v8.6a",
  (AArch64::ExtensionBitset({AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, }))
};
inline constexpr ArchInfo ARMV8_7A = {
  VersionTuple{8, 7},
  AProfile,
  "armv8.7-a",
  "+v8.7a",
  (AArch64::ExtensionBitset({AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_WFXT, AArch64::AEK_SPE_EEF, }))
};
inline constexpr ArchInfo ARMV8_8A = {
  VersionTuple{8, 8},
  AProfile,
  "armv8.8-a",
  "+v8.8a",
  (AArch64::ExtensionBitset({AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_WFXT, AArch64::AEK_SPE_EEF, AArch64::AEK_MOPS, AArch64::AEK_HBC, }))
};
inline constexpr ArchInfo ARMV8_9A = {
  VersionTuple{8, 9},
  AProfile,
  "armv8.9-a",
  "+v8.9a",
  (AArch64::ExtensionBitset({AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_WFXT, AArch64::AEK_SPE_EEF, AArch64::AEK_MOPS, AArch64::AEK_HBC, AArch64::AEK_SPECRES2, AArch64::AEK_CSSC, AArch64::AEK_RASV2, }))
};
inline constexpr ArchInfo ARMV9A = {
  VersionTuple{9, 0},
  AProfile,
  "armv9-a",
  "+v9a",
  (AArch64::ExtensionBitset({AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_FP16, AArch64::AEK_SVE, AArch64::AEK_SVE2, }))
};
inline constexpr ArchInfo ARMV9_1A = {
  VersionTuple{9, 1},
  AProfile,
  "armv9.1-a",
  "+v9.1a",
  (AArch64::ExtensionBitset({AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_FP16, AArch64::AEK_SVE, AArch64::AEK_SVE2, AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_RME, }))
};
inline constexpr ArchInfo ARMV9_2A = {
  VersionTuple{9, 2},
  AProfile,
  "armv9.2-a",
  "+v9.2a",
  (AArch64::ExtensionBitset({AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_FP16, AArch64::AEK_SVE, AArch64::AEK_SVE2, AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_RME, AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_WFXT, AArch64::AEK_SPE_EEF, AArch64::AEK_MEC, }))
};
inline constexpr ArchInfo ARMV9_3A = {
  VersionTuple{9, 3},
  AProfile,
  "armv9.3-a",
  "+v9.3a",
  (AArch64::ExtensionBitset({AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_FP16, AArch64::AEK_SVE, AArch64::AEK_SVE2, AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_RME, AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_WFXT, AArch64::AEK_SPE_EEF, AArch64::AEK_MEC, AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_WFXT, AArch64::AEK_SPE_EEF, AArch64::AEK_MOPS, AArch64::AEK_HBC, }))
};
inline constexpr ArchInfo ARMV9_4A = {
  VersionTuple{9, 4},
  AProfile,
  "armv9.4-a",
  "+v9.4a",
  (AArch64::ExtensionBitset({AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_FP16, AArch64::AEK_SVE, AArch64::AEK_SVE2, AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_RME, AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_WFXT, AArch64::AEK_SPE_EEF, AArch64::AEK_MEC, AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_WFXT, AArch64::AEK_SPE_EEF, AArch64::AEK_MOPS, AArch64::AEK_HBC, AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_WFXT, AArch64::AEK_SPE_EEF, AArch64::AEK_MOPS, AArch64::AEK_HBC, AArch64::AEK_SPECRES2, AArch64::AEK_CSSC, AArch64::AEK_RASV2, AArch64::AEK_SVE2P1, }))
};
inline constexpr ArchInfo ARMV9_5A = {
  VersionTuple{9, 5},
  AProfile,
  "armv9.5-a",
  "+v9.5a",
  (AArch64::ExtensionBitset({AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_FP16, AArch64::AEK_SVE, AArch64::AEK_SVE2, AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_RME, AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_WFXT, AArch64::AEK_SPE_EEF, AArch64::AEK_MEC, AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_WFXT, AArch64::AEK_SPE_EEF, AArch64::AEK_MOPS, AArch64::AEK_HBC, AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_WFXT, AArch64::AEK_SPE_EEF, AArch64::AEK_MOPS, AArch64::AEK_HBC, AArch64::AEK_SPECRES2, AArch64::AEK_CSSC, AArch64::AEK_RASV2, AArch64::AEK_SVE2P1, AArch64::AEK_CPA, AArch64::AEK_LUT, AArch64::AEK_FAMINMAX, }))
};
inline constexpr ArchInfo ARMV9_6A = {
  VersionTuple{9, 6},
  AProfile,
  "armv9.6-a",
  "+v9.6a",
  (AArch64::ExtensionBitset({AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_FP16, AArch64::AEK_SVE, AArch64::AEK_SVE2, AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_RME, AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_WFXT, AArch64::AEK_SPE_EEF, AArch64::AEK_MEC, AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_WFXT, AArch64::AEK_SPE_EEF, AArch64::AEK_MOPS, AArch64::AEK_HBC, AArch64::AEK_FP, AArch64::AEK_SIMD, AArch64::AEK_CRC, AArch64::AEK_LSE, AArch64::AEK_RDM, AArch64::AEK_RAS, AArch64::AEK_FCMA, AArch64::AEK_JSCVT, AArch64::AEK_PAUTH, AArch64::AEK_RCPC, AArch64::AEK_CCIDX, AArch64::AEK_DOTPROD, AArch64::AEK_DIT, AArch64::AEK_FLAGM, AArch64::AEK_PREDRES, AArch64::AEK_SSBS, AArch64::AEK_BTI, AArch64::AEK_SB, AArch64::AEK_BF16, AArch64::AEK_I8MM, AArch64::AEK_WFXT, AArch64::AEK_SPE_EEF, AArch64::AEK_MOPS, AArch64::AEK_HBC, AArch64::AEK_SPECRES2, AArch64::AEK_CSSC, AArch64::AEK_RASV2, AArch64::AEK_SVE2P1, AArch64::AEK_CPA, AArch64::AEK_LUT, AArch64::AEK_FAMINMAX, AArch64::AEK_CMPBR, AArch64::AEK_FPRCVT, AArch64::AEK_SVE2P2, AArch64::AEK_LSUI, AArch64::AEK_OCCMO, }))
};

/// The set of all architectures
static constexpr std::array<const ArchInfo *, 18> ArchInfos = {
  &ARMV8A,
  &ARMV8R,
  &ARMV8_1A,
  &ARMV8_2A,
  &ARMV8_3A,
  &ARMV8_4A,
  &ARMV8_5A,
  &ARMV8_6A,
  &ARMV8_7A,
  &ARMV8_8A,
  &ARMV8_9A,
  &ARMV9A,
  &ARMV9_1A,
  &ARMV9_2A,
  &ARMV9_3A,
  &ARMV9_4A,
  &ARMV9_5A,
  &ARMV9_6A,
};
#undef EMIT_ARCHITECTURES
#endif // EMIT_ARCHITECTURES

#ifdef EMIT_CPU_ALIAS
inline constexpr Alias CpuAliases[] = {
  { "cobalt-100", "neoverse-n2" },
  { "cyclone", "apple-a7" },
  { "apple-a8", "apple-a7" },
  { "apple-a9", "apple-a7" },
  { "apple-s4", "apple-a12" },
  { "apple-s5", "apple-a12" },
  { "apple-s6", "apple-a13" },
  { "apple-s7", "apple-a13" },
  { "apple-s8", "apple-a13" },
  { "apple-m1", "apple-a14" },
  { "apple-m2", "apple-a15" },
  { "apple-m3", "apple-a16" },
  { "apple-s9", "apple-a16" },
  { "apple-s10", "apple-a16" },
  { "apple-a18", "apple-m4" },
  { "apple-latest", "apple-m4" },
};
#undef EMIT_CPU_ALIAS
#endif // EMIT_CPU_ALIAS

#ifdef EMIT_CPU_INFO
inline constexpr CpuInfo CpuInfos[] = {
  {
    "generic",
    ARMV8A,
    AArch64::ExtensionBitset({
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_ETE,
    })
  },
  {
    "cortex-a35",
    ARMV8A,
    AArch64::ExtensionBitset({
      AArch64::AEK_CRC,
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
    })
  },
  {
    "cortex-a34",
    ARMV8A,
    AArch64::ExtensionBitset({
      AArch64::AEK_CRC,
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
    })
  },
  {
    "cortex-a53",
    ARMV8A,
    AArch64::ExtensionBitset({
      AArch64::AEK_CRC,
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
    })
  },
  {
    "cortex-a55",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_FP16,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_RCPC,
      AArch64::AEK_PERFMON,
      AArch64::AEK_CRC,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RDM,
    })
  },
  {
    "cortex-a510",
    ARMV9A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_I8MM,
      AArch64::AEK_BF16,
      AArch64::AEK_AM,
      AArch64::AEK_MTE,
      AArch64::AEK_ETE,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_FP16FML,
      AArch64::AEK_CCIDX,
      AArch64::AEK_SB,
      AArch64::AEK_PAUTH,
      AArch64::AEK_SSBS,
      AArch64::AEK_SVE,
      AArch64::AEK_SVE2,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP,
      AArch64::AEK_FP16,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
    })
  },
  {
    "cortex-a520",
    ARMV9_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_PERFMON,
      AArch64::AEK_AM,
      AArch64::AEK_MTE,
      AArch64::AEK_ETE,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_FP16FML,
      AArch64::AEK_CCIDX,
      AArch64::AEK_SB,
      AArch64::AEK_SSBS,
      AArch64::AEK_PAUTH,
      AArch64::AEK_FLAGM,
      AArch64::AEK_PREDRES,
      AArch64::AEK_SVE,
      AArch64::AEK_SVE2,
      AArch64::AEK_BF16,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_FP,
      AArch64::AEK_FP16,
      AArch64::AEK_I8MM,
      AArch64::AEK_JSCVT,
      AArch64::AEK_SIMD,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
      AArch64::AEK_DOTPROD,
    })
  },
  {
    "cortex-a520ae",
    ARMV9_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_PERFMON,
      AArch64::AEK_AM,
      AArch64::AEK_MTE,
      AArch64::AEK_ETE,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_FP16FML,
      AArch64::AEK_CCIDX,
      AArch64::AEK_SB,
      AArch64::AEK_SSBS,
      AArch64::AEK_PAUTH,
      AArch64::AEK_FLAGM,
      AArch64::AEK_PREDRES,
      AArch64::AEK_SVE,
      AArch64::AEK_SVE2,
      AArch64::AEK_BF16,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_FP,
      AArch64::AEK_FP16,
      AArch64::AEK_I8MM,
      AArch64::AEK_JSCVT,
      AArch64::AEK_SIMD,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
      AArch64::AEK_DOTPROD,
    })
  },
  {
    "cortex-a57",
    ARMV8A,
    AArch64::ExtensionBitset({
      AArch64::AEK_CRC,
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
    })
  },
  {
    "cortex-a65",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_FP16,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_RCPC,
      AArch64::AEK_SSBS,
      AArch64::AEK_RAS,
      AArch64::AEK_PERFMON,
      AArch64::AEK_CRC,
      AArch64::AEK_LSE,
      AArch64::AEK_RDM,
    })
  },
  {
    "cortex-a65ae",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_FP16,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_RCPC,
      AArch64::AEK_SSBS,
      AArch64::AEK_RAS,
      AArch64::AEK_PERFMON,
      AArch64::AEK_CRC,
      AArch64::AEK_LSE,
      AArch64::AEK_RDM,
    })
  },
  {
    "cortex-a72",
    ARMV8A,
    AArch64::ExtensionBitset({
      AArch64::AEK_CRC,
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
    })
  },
  {
    "cortex-a73",
    ARMV8A,
    AArch64::ExtensionBitset({
      AArch64::AEK_CRC,
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
    })
  },
  {
    "cortex-a75",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_FP16,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_RCPC,
      AArch64::AEK_PERFMON,
      AArch64::AEK_CRC,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RDM,
    })
  },
  {
    "cortex-a76",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_FP16,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_RCPC,
      AArch64::AEK_SSBS,
      AArch64::AEK_PERFMON,
      AArch64::AEK_CRC,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RDM,
    })
  },
  {
    "cortex-a76ae",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_FP16,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_RCPC,
      AArch64::AEK_SSBS,
      AArch64::AEK_PERFMON,
      AArch64::AEK_CRC,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RDM,
    })
  },
  {
    "cortex-a77",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_FP16,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_RCPC,
      AArch64::AEK_PERFMON,
      AArch64::AEK_SSBS,
      AArch64::AEK_CRC,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RDM,
    })
  },
  {
    "cortex-a78",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_FP16,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_RCPC,
      AArch64::AEK_PERFMON,
      AArch64::AEK_PROFILE,
      AArch64::AEK_SSBS,
      AArch64::AEK_CRC,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RDM,
    })
  },
  {
    "cortex-a78ae",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_FP16,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_RCPC,
      AArch64::AEK_PERFMON,
      AArch64::AEK_PROFILE,
      AArch64::AEK_SSBS,
      AArch64::AEK_CRC,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RDM,
    })
  },
  {
    "cortex-a78c",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_FP16,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FLAGM,
      AArch64::AEK_PAUTH,
      AArch64::AEK_PERFMON,
      AArch64::AEK_RCPC,
      AArch64::AEK_PROFILE,
      AArch64::AEK_SSBS,
      AArch64::AEK_CRC,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RDM,
    })
  },
  {
    "cortex-a710",
    ARMV9A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_CCIDX,
      AArch64::AEK_SSBS,
      AArch64::AEK_ETE,
      AArch64::AEK_MTE,
      AArch64::AEK_FP16FML,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_BF16,
      AArch64::AEK_I8MM,
      AArch64::AEK_PAUTH,
      AArch64::AEK_FLAGM,
      AArch64::AEK_SB,
      AArch64::AEK_SVE,
      AArch64::AEK_SVE2,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP,
      AArch64::AEK_FP16,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
    })
  },
  {
    "cortex-a715",
    ARMV9A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SIMD,
      AArch64::AEK_MTE,
      AArch64::AEK_CCIDX,
      AArch64::AEK_FP16FML,
      AArch64::AEK_SVE,
      AArch64::AEK_TRBE,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_BF16,
      AArch64::AEK_ETE,
      AArch64::AEK_PERFMON,
      AArch64::AEK_I8MM,
      AArch64::AEK_PROFILE,
      AArch64::AEK_SB,
      AArch64::AEK_SSBS,
      AArch64::AEK_FP16,
      AArch64::AEK_PAUTH,
      AArch64::AEK_PREDRES,
      AArch64::AEK_FLAGM,
      AArch64::AEK_SVE2,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
    })
  },
  {
    "cortex-a720",
    ARMV9_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_MTE,
      AArch64::AEK_FP16FML,
      AArch64::AEK_CCIDX,
      AArch64::AEK_TRBE,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_ETE,
      AArch64::AEK_PERFMON,
      AArch64::AEK_PROFILE,
      AArch64::AEK_SPE_EEF,
      AArch64::AEK_SB,
      AArch64::AEK_SSBS,
      AArch64::AEK_PAUTH,
      AArch64::AEK_FLAGM,
      AArch64::AEK_PREDRES,
      AArch64::AEK_SVE,
      AArch64::AEK_SVE2,
      AArch64::AEK_BF16,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP,
      AArch64::AEK_FP16,
      AArch64::AEK_I8MM,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_SIMD,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
    })
  },
  {
    "cortex-a720ae",
    ARMV9_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_MTE,
      AArch64::AEK_FP16FML,
      AArch64::AEK_CCIDX,
      AArch64::AEK_TRBE,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_ETE,
      AArch64::AEK_PERFMON,
      AArch64::AEK_PROFILE,
      AArch64::AEK_SPE_EEF,
      AArch64::AEK_SB,
      AArch64::AEK_SSBS,
      AArch64::AEK_PAUTH,
      AArch64::AEK_FLAGM,
      AArch64::AEK_PREDRES,
      AArch64::AEK_SVE,
      AArch64::AEK_SVE2,
      AArch64::AEK_BF16,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP,
      AArch64::AEK_FP16,
      AArch64::AEK_I8MM,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_SIMD,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
    })
  },
  {
    "cortex-a725",
    ARMV9_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_MTE,
      AArch64::AEK_FP16FML,
      AArch64::AEK_CCIDX,
      AArch64::AEK_ETE,
      AArch64::AEK_PERFMON,
      AArch64::AEK_PROFILE,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_SPE_EEF,
      AArch64::AEK_TRBE,
      AArch64::AEK_FLAGM,
      AArch64::AEK_PREDRES,
      AArch64::AEK_SB,
      AArch64::AEK_SSBS,
      AArch64::AEK_SVE,
      AArch64::AEK_SVE2,
      AArch64::AEK_BF16,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP,
      AArch64::AEK_FP16,
      AArch64::AEK_I8MM,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_SIMD,
      AArch64::AEK_PAUTH,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
    })
  },
  {
    "cortex-r82",
    ARMV8R,
    AArch64::ExtensionBitset({
      AArch64::AEK_PERFMON,
      AArch64::AEK_FP16,
      AArch64::AEK_FP16FML,
      AArch64::AEK_SSBS,
      AArch64::AEK_PREDRES,
      AArch64::AEK_SB,
      AArch64::AEK_RDM,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FCMA,
      AArch64::AEK_JSCVT,
      AArch64::AEK_CCDP,
      AArch64::AEK_FLAGM,
      AArch64::AEK_CRC,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PAUTH,
      AArch64::AEK_RCPC,
    })
  },
  {
    "cortex-r82ae",
    ARMV8R,
    AArch64::ExtensionBitset({
      AArch64::AEK_PERFMON,
      AArch64::AEK_FP16,
      AArch64::AEK_FP16FML,
      AArch64::AEK_SSBS,
      AArch64::AEK_PREDRES,
      AArch64::AEK_SB,
      AArch64::AEK_RDM,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FCMA,
      AArch64::AEK_JSCVT,
      AArch64::AEK_CCDP,
      AArch64::AEK_LSE,
      AArch64::AEK_FLAGM,
      AArch64::AEK_CRC,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PAUTH,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
    })
  },
  {
    "cortex-x1",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_RCPC,
      AArch64::AEK_PERFMON,
      AArch64::AEK_PROFILE,
      AArch64::AEK_FP16,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_SSBS,
      AArch64::AEK_CRC,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RDM,
    })
  },
  {
    "cortex-x1c",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_RCPC_IMMO,
      AArch64::AEK_PERFMON,
      AArch64::AEK_PROFILE,
      AArch64::AEK_FP16,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_PAUTH,
      AArch64::AEK_SSBS,
      AArch64::AEK_FLAGM,
      AArch64::AEK_LSE2,
      AArch64::AEK_RCPC,
      AArch64::AEK_CRC,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RDM,
    })
  },
  {
    "cortex-x2",
    ARMV9A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_I8MM,
      AArch64::AEK_BF16,
      AArch64::AEK_AM,
      AArch64::AEK_MTE,
      AArch64::AEK_ETE,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_FP16FML,
      AArch64::AEK_CCIDX,
      AArch64::AEK_PAUTH,
      AArch64::AEK_SSBS,
      AArch64::AEK_SB,
      AArch64::AEK_SVE,
      AArch64::AEK_SVE2,
      AArch64::AEK_FLAGM,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP,
      AArch64::AEK_FP16,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
    })
  },
  {
    "cortex-x3",
    ARMV9A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SVE,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_ETE,
      AArch64::AEK_TRBE,
      AArch64::AEK_PROFILE,
      AArch64::AEK_BF16,
      AArch64::AEK_I8MM,
      AArch64::AEK_MTE,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_FP16,
      AArch64::AEK_FP16FML,
      AArch64::AEK_CCIDX,
      AArch64::AEK_SB,
      AArch64::AEK_PAUTH,
      AArch64::AEK_PREDRES,
      AArch64::AEK_FLAGM,
      AArch64::AEK_SSBS,
      AArch64::AEK_SVE2,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_FP,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
      AArch64::AEK_DOTPROD,
    })
  },
  {
    "cortex-x4",
    ARMV9_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_PERFMON,
      AArch64::AEK_ETE,
      AArch64::AEK_TRBE,
      AArch64::AEK_PROFILE,
      AArch64::AEK_MTE,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_FP16FML,
      AArch64::AEK_SPE_EEF,
      AArch64::AEK_CCIDX,
      AArch64::AEK_SB,
      AArch64::AEK_SSBS,
      AArch64::AEK_PAUTH,
      AArch64::AEK_FLAGM,
      AArch64::AEK_PREDRES,
      AArch64::AEK_SVE,
      AArch64::AEK_SVE2,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP,
      AArch64::AEK_FP16,
      AArch64::AEK_I8MM,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_SIMD,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
      AArch64::AEK_BF16,
    })
  },
  {
    "cortex-x925",
    ARMV9_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_MTE,
      AArch64::AEK_FP16FML,
      AArch64::AEK_CCIDX,
      AArch64::AEK_ETE,
      AArch64::AEK_PERFMON,
      AArch64::AEK_PROFILE,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_SPE_EEF,
      AArch64::AEK_TRBE,
      AArch64::AEK_FLAGM,
      AArch64::AEK_PREDRES,
      AArch64::AEK_SB,
      AArch64::AEK_SSBS,
      AArch64::AEK_SVE,
      AArch64::AEK_SVE2,
      AArch64::AEK_BF16,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP,
      AArch64::AEK_FP16,
      AArch64::AEK_I8MM,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_SIMD,
      AArch64::AEK_PAUTH,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
    })
  },
  {
    "grace",
    ARMV9A,
    AArch64::ExtensionBitset({
      AArch64::AEK_BF16,
      AArch64::AEK_PROFILE,
      AArch64::AEK_PERFMON,
      AArch64::AEK_ETE,
      AArch64::AEK_I8MM,
      AArch64::AEK_SIMD,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_FP16FML,
      AArch64::AEK_MTE,
      AArch64::AEK_RAND,
      AArch64::AEK_CCIDX,
      AArch64::AEK_SVE,
      AArch64::AEK_SVE2,
      AArch64::AEK_SSBS,
      AArch64::AEK_FP16,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_FP,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_PAUTH,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
      AArch64::AEK_FPAC,
      AArch64::AEK_SVE2SM4,
      AArch64::AEK_SVEAES,
      AArch64::AEK_SVE2SHA3,
    })
  },
  {
    "neoverse-e1",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP,
      AArch64::AEK_FP16,
      AArch64::AEK_SIMD,
      AArch64::AEK_RCPC,
      AArch64::AEK_SSBS,
      AArch64::AEK_PERFMON,
      AArch64::AEK_CRC,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RDM,
    })
  },
  {
    "neoverse-n1",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP,
      AArch64::AEK_FP16,
      AArch64::AEK_SIMD,
      AArch64::AEK_RCPC,
      AArch64::AEK_PROFILE,
      AArch64::AEK_SSBS,
      AArch64::AEK_PERFMON,
      AArch64::AEK_CRC,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RDM,
    })
  },
  {
    "neoverse-n2",
    ARMV9A,
    AArch64::ExtensionBitset({
      AArch64::AEK_BF16,
      AArch64::AEK_ETE,
      AArch64::AEK_FP16FML,
      AArch64::AEK_I8MM,
      AArch64::AEK_MTE,
      AArch64::AEK_SVE2,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_TRBE,
      AArch64::AEK_PERFMON,
      AArch64::AEK_CCIDX,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP16,
      AArch64::AEK_SB,
      AArch64::AEK_SSBS,
      AArch64::AEK_SVE,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_FP,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_SIMD,
      AArch64::AEK_PAUTH,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
    })
  },
  {
    "neoverse-n3",
    ARMV9_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_ETE,
      AArch64::AEK_FP16FML,
      AArch64::AEK_FP16,
      AArch64::AEK_MTE,
      AArch64::AEK_PERFMON,
      AArch64::AEK_RAND,
      AArch64::AEK_PROFILE,
      AArch64::AEK_SPE_EEF,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_CCIDX,
      AArch64::AEK_SSBS,
      AArch64::AEK_SB,
      AArch64::AEK_PREDRES,
      AArch64::AEK_PAUTH,
      AArch64::AEK_FLAGM,
      AArch64::AEK_SVE,
      AArch64::AEK_SVE2,
      AArch64::AEK_BF16,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP,
      AArch64::AEK_I8MM,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
      AArch64::AEK_SIMD,
    })
  },
  {
    "neoverse-512tvb",
    ARMV8_4A,
    AArch64::ExtensionBitset({
      AArch64::AEK_BF16,
      AArch64::AEK_CCDP,
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_FP16FML,
      AArch64::AEK_FP16,
      AArch64::AEK_I8MM,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_RAND,
      AArch64::AEK_PROFILE,
      AArch64::AEK_SSBS,
      AArch64::AEK_SVE,
      AArch64::AEK_CCIDX,
      AArch64::AEK_SHA3,
      AArch64::AEK_SM4,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_PAUTH,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
    })
  },
  {
    "neoverse-v1",
    ARMV8_4A,
    AArch64::ExtensionBitset({
      AArch64::AEK_BF16,
      AArch64::AEK_CCDP,
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_FP16FML,
      AArch64::AEK_FP16,
      AArch64::AEK_I8MM,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_RAND,
      AArch64::AEK_PROFILE,
      AArch64::AEK_SSBS,
      AArch64::AEK_SVE,
      AArch64::AEK_CCIDX,
      AArch64::AEK_SHA3,
      AArch64::AEK_SM4,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_PAUTH,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
    })
  },
  {
    "neoverse-v2",
    ARMV9A,
    AArch64::ExtensionBitset({
      AArch64::AEK_BF16,
      AArch64::AEK_PROFILE,
      AArch64::AEK_PERFMON,
      AArch64::AEK_ETE,
      AArch64::AEK_I8MM,
      AArch64::AEK_SIMD,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_FP16FML,
      AArch64::AEK_MTE,
      AArch64::AEK_RAND,
      AArch64::AEK_CCIDX,
      AArch64::AEK_SVE,
      AArch64::AEK_SVE2,
      AArch64::AEK_SSBS,
      AArch64::AEK_FP16,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_FP,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_PAUTH,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
      AArch64::AEK_FPAC,
    })
  },
  {
    "neoverse-v3",
    ARMV9_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_ETE,
      AArch64::AEK_FP16FML,
      AArch64::AEK_FP16,
      AArch64::AEK_LS64,
      AArch64::AEK_MTE,
      AArch64::AEK_PERFMON,
      AArch64::AEK_RAND,
      AArch64::AEK_PROFILE,
      AArch64::AEK_CCIDX,
      AArch64::AEK_SPE_EEF,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_BRBE,
      AArch64::AEK_SSBS,
      AArch64::AEK_SB,
      AArch64::AEK_PREDRES,
      AArch64::AEK_PAUTH,
      AArch64::AEK_FLAGM,
      AArch64::AEK_SVE,
      AArch64::AEK_SVE2,
      AArch64::AEK_BF16,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP,
      AArch64::AEK_I8MM,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_SIMD,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
      AArch64::AEK_RME,
    })
  },
  {
    "neoverse-v3ae",
    ARMV9_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_ETE,
      AArch64::AEK_FP16FML,
      AArch64::AEK_FP16,
      AArch64::AEK_LS64,
      AArch64::AEK_MTE,
      AArch64::AEK_PERFMON,
      AArch64::AEK_RAND,
      AArch64::AEK_PROFILE,
      AArch64::AEK_SPE_EEF,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_BRBE,
      AArch64::AEK_SSBS,
      AArch64::AEK_SB,
      AArch64::AEK_PREDRES,
      AArch64::AEK_PAUTH,
      AArch64::AEK_FLAGM,
      AArch64::AEK_CCIDX,
      AArch64::AEK_SVE,
      AArch64::AEK_SVE2,
      AArch64::AEK_BF16,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP,
      AArch64::AEK_I8MM,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_SIMD,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
      AArch64::AEK_RME,
    })
  },
  {
    "exynos-m3",
    ARMV8A,
    AArch64::ExtensionBitset({
      AArch64::AEK_CRC,
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_PERFMON,
      AArch64::AEK_SIMD,
      AArch64::AEK_FP,
    })
  },
  {
    "exynos-m4",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP16,
      AArch64::AEK_PERFMON,
      AArch64::AEK_CRC,
      AArch64::AEK_FP,
      AArch64::AEK_LSE,
      AArch64::AEK_SIMD,
      AArch64::AEK_RAS,
      AArch64::AEK_RDM,
    })
  },
  {
    "exynos-m5",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP16,
      AArch64::AEK_PERFMON,
      AArch64::AEK_CRC,
      AArch64::AEK_FP,
      AArch64::AEK_LSE,
      AArch64::AEK_SIMD,
      AArch64::AEK_RAS,
      AArch64::AEK_RDM,
    })
  },
  {
    "falkor",
    ARMV8A,
    AArch64::ExtensionBitset({
      AArch64::AEK_CRC,
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_RDM,
    })
  },
  {
    "saphira",
    ARMV8_4A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PROFILE,
      AArch64::AEK_PERFMON,
      AArch64::AEK_CRC,
      AArch64::AEK_CCIDX,
      AArch64::AEK_LSE,
      AArch64::AEK_RDM,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
    })
  },
  {
    "kryo",
    ARMV8A,
    AArch64::ExtensionBitset({
      AArch64::AEK_CRC,
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
    })
  },
  {
    "thunderx",
    ARMV8A,
    AArch64::ExtensionBitset({
      AArch64::AEK_CRC,
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_PERFMON,
      AArch64::AEK_SIMD,
    })
  },
  {
    "thunderxt88",
    ARMV8A,
    AArch64::ExtensionBitset({
      AArch64::AEK_CRC,
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_PERFMON,
      AArch64::AEK_SIMD,
    })
  },
  {
    "thunderxt81",
    ARMV8A,
    AArch64::ExtensionBitset({
      AArch64::AEK_CRC,
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_PERFMON,
      AArch64::AEK_SIMD,
    })
  },
  {
    "thunderxt83",
    ARMV8A,
    AArch64::ExtensionBitset({
      AArch64::AEK_CRC,
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_PERFMON,
      AArch64::AEK_SIMD,
    })
  },
  {
    "thunderx2t99",
    ARMV8_1A,
    AArch64::ExtensionBitset({
      AArch64::AEK_CRC,
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_LSE,
      AArch64::AEK_RDM,
    })
  },
  {
    "thunderx3t110",
    ARMV8_3A,
    AArch64::ExtensionBitset({
      AArch64::AEK_CRC,
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_LSE,
      AArch64::AEK_CCIDX,
      AArch64::AEK_PAUTH,
      AArch64::AEK_PERFMON,
      AArch64::AEK_FCMA,
      AArch64::AEK_JSCVT,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
    })
  },
  {
    "tsv110",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_PROFILE,
      AArch64::AEK_FP16,
      AArch64::AEK_FP16FML,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_JSCVT,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RDM,
    })
  },
  {
    "apple-a7",
    ARMV8A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
    })
  },
  {
    "apple-a10",
    ARMV8A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_CRC,
      AArch64::AEK_RDM,
      AArch64::AEK_PAN,
      AArch64::AEK_LOR,
      AArch64::AEK_VH,
    })
  },
  {
    "apple-a11",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_FP16,
      AArch64::AEK_CRC,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RDM,
    })
  },
  {
    "apple-a12",
    ARMV8_3A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_FP16,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_PAUTH,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
    })
  },
  {
    "apple-a13",
    ARMV8_4A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_FP16,
      AArch64::AEK_FP16FML,
      AArch64::AEK_SHA3,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_PAUTH,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
      AArch64::AEK_DOTPROD,
    })
  },
  {
    "apple-a14",
    ARMV8_4A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_FP16,
      AArch64::AEK_FP16FML,
      AArch64::AEK_SHA3,
      AArch64::AEK_ALTERNATIVENZCV,
      AArch64::AEK_FRINT3264,
      AArch64::AEK_SPECRESTRICT,
      AArch64::AEK_SSBS,
      AArch64::AEK_SB,
      AArch64::AEK_PREDRES,
      AArch64::AEK_CCDP,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_PAUTH,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
      AArch64::AEK_DOTPROD,
    })
  },
  {
    "apple-a15",
    ARMV8_6A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_SHA3,
      AArch64::AEK_FP16,
      AArch64::AEK_FP16FML,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_PAUTH,
      AArch64::AEK_FPAC,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
      AArch64::AEK_BF16,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_I8MM,
      AArch64::AEK_SSBS,
    })
  },
  {
    "apple-a16",
    ARMV8_6A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_SHA3,
      AArch64::AEK_FP16,
      AArch64::AEK_FP16FML,
      AArch64::AEK_HCX,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_PAUTH,
      AArch64::AEK_FPAC,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
      AArch64::AEK_BF16,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_I8MM,
      AArch64::AEK_SSBS,
    })
  },
  {
    "apple-a17",
    ARMV8_6A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_SHA3,
      AArch64::AEK_FP16,
      AArch64::AEK_FP16FML,
      AArch64::AEK_HCX,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_PAUTH,
      AArch64::AEK_FPAC,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
      AArch64::AEK_BF16,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_I8MM,
      AArch64::AEK_SSBS,
    })
  },
  {
    "apple-m4",
    ARMV8_7A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SHA2,
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_SHA3,
      AArch64::AEK_FP16,
      AArch64::AEK_FP16FML,
      AArch64::AEK_AES,
      AArch64::AEK_BF16,
      AArch64::AEK_SME,
      AArch64::AEK_SME2,
      AArch64::AEK_SMEF64F64,
      AArch64::AEK_SMEI16I64,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_PAUTH,
      AArch64::AEK_FPAC,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_I8MM,
    })
  },
  {
    "a64fx",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_FP,
      AArch64::AEK_SIMD,
      AArch64::AEK_SHA2,
      AArch64::AEK_PERFMON,
      AArch64::AEK_FP16,
      AArch64::AEK_SVE,
      AArch64::AEK_FCMA,
      AArch64::AEK_AES,
      AArch64::AEK_CRC,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RDM,
    })
  },
  {
    "fujitsu-monaka",
    ARMV9_3A,
    AArch64::ExtensionBitset({
      AArch64::AEK_PERFMON,
      AArch64::AEK_CCIDX,
      AArch64::AEK_FPAC,
      AArch64::AEK_FP16FML,
      AArch64::AEK_RAND,
      AArch64::AEK_SSBS,
      AArch64::AEK_LS64,
      AArch64::AEK_CLRBHB,
      AArch64::AEK_SPECRES2,
      AArch64::AEK_SVEAES,
      AArch64::AEK_SVE2SM4,
      AArch64::AEK_SVE2SHA3,
      AArch64::AEK_SVE2,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_ETE,
      AArch64::AEK_MEC,
      AArch64::AEK_FAMINMAX,
      AArch64::AEK_FP8DOT2,
      AArch64::AEK_LUT,
    })
  },
  {
    "carmel",
    ARMV8_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SIMD,
      AArch64::AEK_SHA2,
      AArch64::AEK_AES,
      AArch64::AEK_FP16,
      AArch64::AEK_CRC,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RDM,
      AArch64::AEK_FP,
    })
  },
  {
    "olympus",
    ARMV9_2A,
    AArch64::ExtensionBitset({
      AArch64::AEK_BRBE,
      AArch64::AEK_CCIDX,
      AArch64::AEK_CHK,
      AArch64::AEK_ETE,
      AArch64::AEK_FAMINMAX,
      AArch64::AEK_FP16FML,
      AArch64::AEK_FP8DOT2,
      AArch64::AEK_FP8DOT4,
      AArch64::AEK_FP8FMA,
      AArch64::AEK_FPAC,
      AArch64::AEK_LS64,
      AArch64::AEK_LUT,
      AArch64::AEK_MEC,
      AArch64::AEK_MTE,
      AArch64::AEK_PERFMON,
      AArch64::AEK_RAND,
      AArch64::AEK_PROFILE,
      AArch64::AEK_SPE_EEF,
      AArch64::AEK_SSBS,
      AArch64::AEK_SVEBITPERM,
      AArch64::AEK_SVE2SHA3,
      AArch64::AEK_SVE2SM4,
      AArch64::AEK_SVEAES,
    })
  },
  {
    "ampere1",
    ARMV8_6A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_SSBS,
      AArch64::AEK_RAND,
      AArch64::AEK_SB,
      AArch64::AEK_SHA2,
      AArch64::AEK_SHA3,
      AArch64::AEK_AES,
      AArch64::AEK_FP16,
      AArch64::AEK_BF16,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP,
      AArch64::AEK_I8MM,
      AArch64::AEK_JSCVT,
      AArch64::AEK_CCIDX,
      AArch64::AEK_LSE,
      AArch64::AEK_PAUTH,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
    })
  },
  {
    "ampere1a",
    ARMV8_6A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_MTE,
      AArch64::AEK_SSBS,
      AArch64::AEK_RAND,
      AArch64::AEK_SB,
      AArch64::AEK_SM4,
      AArch64::AEK_SHA2,
      AArch64::AEK_SHA3,
      AArch64::AEK_AES,
      AArch64::AEK_FP16,
      AArch64::AEK_BF16,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP,
      AArch64::AEK_I8MM,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_PAUTH,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_CCIDX,
      AArch64::AEK_RDM,
    })
  },
  {
    "ampere1b",
    ARMV8_7A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_MTE,
      AArch64::AEK_SSBS,
      AArch64::AEK_RAND,
      AArch64::AEK_SB,
      AArch64::AEK_SM4,
      AArch64::AEK_SHA2,
      AArch64::AEK_SHA3,
      AArch64::AEK_AES,
      AArch64::AEK_CSSC,
      AArch64::AEK_WFXT,
      AArch64::AEK_FP16,
      AArch64::AEK_BF16,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP,
      AArch64::AEK_I8MM,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_PAUTH,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_CCIDX,
      AArch64::AEK_RDM,
    })
  },
  {
    "oryon-1",
    ARMV8_6A,
    AArch64::ExtensionBitset({
      AArch64::AEK_SIMD,
      AArch64::AEK_PERFMON,
      AArch64::AEK_RAND,
      AArch64::AEK_PAUTH,
      AArch64::AEK_SM4,
      AArch64::AEK_SHA2,
      AArch64::AEK_SHA3,
      AArch64::AEK_AES,
      AArch64::AEK_PROFILE,
      AArch64::AEK_BF16,
      AArch64::AEK_FCMA,
      AArch64::AEK_CRC,
      AArch64::AEK_DOTPROD,
      AArch64::AEK_FP,
      AArch64::AEK_I8MM,
      AArch64::AEK_SSBS,
      AArch64::AEK_CCIDX,
      AArch64::AEK_JSCVT,
      AArch64::AEK_LSE,
      AArch64::AEK_RAS,
      AArch64::AEK_RCPC,
      AArch64::AEK_RDM,
    })
  },
};
#undef EMIT_CPU_INFO
#endif // EMIT_CPU_INFO

