/* File automatically generated by u_unfilled_gen.py */

/*
 * Copyright 2009 VMware, Inc.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.  IN NO EVENT SHALL
 * VMWARE AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


/**
 * @file
 * Functions to translate and generate index lists
 */

#include "indices/u_indices.h"
#include "indices/u_indices_priv.h"
#include "util/compiler.h"
#include "util/u_debug.h"
#include "pipe/p_defines.h"
#include "util/u_memory.h"

static u_generate_func generate_line[OUT_COUNT][PRIM_COUNT];
static u_translate_func translate_line[IN_COUNT][OUT_COUNT][PRIM_COUNT];

static void generate_tris_uint16(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=3) {
      (out+j)[0] = (uint16_t)(i);
      (out+j)[1] = (uint16_t)(i+1);
      (out+j+2)[0] = (uint16_t)(i+1);
      (out+j+2)[1] = (uint16_t)(i+2);
      (out+j+4)[0] = (uint16_t)(i+2);
      (out+j+4)[1] = (uint16_t)(i);
   }
}
static void generate_tristrip_uint16(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) {
      (out+j)[0] = (uint16_t)(i);
      (out+j)[1] = (uint16_t)(i+1/*+(i&1)*/);
      (out+j+2)[0] = (uint16_t)(i+1/*+(i&1)*/);
      (out+j+2)[1] = (uint16_t)(i+2/*-(i&1)*/);
      (out+j+4)[0] = (uint16_t)(i+2/*-(i&1)*/);
      (out+j+4)[1] = (uint16_t)(i);
   }
}
static void generate_trifan_uint16(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) {
      (out+j)[0] = (uint16_t)(0);
      (out+j)[1] = (uint16_t)(i+1);
      (out+j+2)[0] = (uint16_t)(i+1);
      (out+j+2)[1] = (uint16_t)(i+2);
      (out+j+4)[0] = (uint16_t)(i+2);
      (out+j+4)[1] = (uint16_t)(0);
   }
}
static void generate_quads_uint16(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=4) {
      (out+j)[0] = (uint16_t)(i+0);
      (out+j)[1] = (uint16_t)(i+1);
      (out+j+2)[0] = (uint16_t)(i+1);
      (out+j+2)[1] = (uint16_t)(i+2);
      (out+j+4)[0] = (uint16_t)(i+2);
      (out+j+4)[1] = (uint16_t)(i+3);
      (out+j+6)[0] = (uint16_t)(i+3);
      (out+j+6)[1] = (uint16_t)(i+0);
   }
}
static void generate_quadstrip_uint16(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=2) {
      (out+j)[0] = (uint16_t)(i+2);
      (out+j)[1] = (uint16_t)(i+0);
      (out+j+2)[0] = (uint16_t)(i+0);
      (out+j+2)[1] = (uint16_t)(i+1);
      (out+j+4)[0] = (uint16_t)(i+1);
      (out+j+4)[1] = (uint16_t)(i+3);
      (out+j+6)[0] = (uint16_t)(i+3);
      (out+j+6)[1] = (uint16_t)(i+2);
   }
}
static void generate_polygon_uint16(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)(i);
      (out+j)[1] = (uint16_t)((i+1)%(out_nr/2)
);
   }
}
static void generate_trisadj_uint16(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)(i);
      (out+j)[1] = (uint16_t)(i+2);
      (out+j+2)[0] = (uint16_t)(i+2);
      (out+j+2)[1] = (uint16_t)(i+4);
      (out+j+4)[0] = (uint16_t)(i+4);
      (out+j+4)[1] = (uint16_t)(i);
   }
}
static void generate_tristripadj_uint16(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j)[0] = (uint16_t)(i);
      (out+j)[1] = (uint16_t)(i+2);
      (out+j+2)[0] = (uint16_t)(i+2);
      (out+j+2)[1] = (uint16_t)(i+4);
      (out+j+4)[0] = (uint16_t)(i+4);
      (out+j+4)[1] = (uint16_t)(i);
   }
}
static void generate_tris_uint32(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=3) {
      (out+j)[0] = (uint32_t)(i);
      (out+j)[1] = (uint32_t)(i+1);
      (out+j+2)[0] = (uint32_t)(i+1);
      (out+j+2)[1] = (uint32_t)(i+2);
      (out+j+4)[0] = (uint32_t)(i+2);
      (out+j+4)[1] = (uint32_t)(i);
   }
}
static void generate_tristrip_uint32(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) {
      (out+j)[0] = (uint32_t)(i);
      (out+j)[1] = (uint32_t)(i+1/*+(i&1)*/);
      (out+j+2)[0] = (uint32_t)(i+1/*+(i&1)*/);
      (out+j+2)[1] = (uint32_t)(i+2/*-(i&1)*/);
      (out+j+4)[0] = (uint32_t)(i+2/*-(i&1)*/);
      (out+j+4)[1] = (uint32_t)(i);
   }
}
static void generate_trifan_uint32(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) {
      (out+j)[0] = (uint32_t)(0);
      (out+j)[1] = (uint32_t)(i+1);
      (out+j+2)[0] = (uint32_t)(i+1);
      (out+j+2)[1] = (uint32_t)(i+2);
      (out+j+4)[0] = (uint32_t)(i+2);
      (out+j+4)[1] = (uint32_t)(0);
   }
}
static void generate_quads_uint32(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=4) {
      (out+j)[0] = (uint32_t)(i+0);
      (out+j)[1] = (uint32_t)(i+1);
      (out+j+2)[0] = (uint32_t)(i+1);
      (out+j+2)[1] = (uint32_t)(i+2);
      (out+j+4)[0] = (uint32_t)(i+2);
      (out+j+4)[1] = (uint32_t)(i+3);
      (out+j+6)[0] = (uint32_t)(i+3);
      (out+j+6)[1] = (uint32_t)(i+0);
   }
}
static void generate_quadstrip_uint32(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=2) {
      (out+j)[0] = (uint32_t)(i+2);
      (out+j)[1] = (uint32_t)(i+0);
      (out+j+2)[0] = (uint32_t)(i+0);
      (out+j+2)[1] = (uint32_t)(i+1);
      (out+j+4)[0] = (uint32_t)(i+1);
      (out+j+4)[1] = (uint32_t)(i+3);
      (out+j+6)[0] = (uint32_t)(i+3);
      (out+j+6)[1] = (uint32_t)(i+2);
   }
}
static void generate_polygon_uint32(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)(i);
      (out+j)[1] = (uint32_t)((i+1)%(out_nr/2)
);
   }
}
static void generate_trisadj_uint32(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)(i);
      (out+j)[1] = (uint32_t)(i+2);
      (out+j+2)[0] = (uint32_t)(i+2);
      (out+j+2)[1] = (uint32_t)(i+4);
      (out+j+4)[0] = (uint32_t)(i+4);
      (out+j+4)[1] = (uint32_t)(i);
   }
}
static void generate_tristripadj_uint32(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j)[0] = (uint32_t)(i);
      (out+j)[1] = (uint32_t)(i+2);
      (out+j+2)[0] = (uint32_t)(i+2);
      (out+j+2)[1] = (uint32_t)(i+4);
      (out+j+4)[0] = (uint32_t)(i+4);
      (out+j+4)[1] = (uint32_t)(i);
   }
}
static void translate_tris_uint82uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint8_t *in = (const uint8_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=3) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j+2)[0] = (uint16_t)in[i+1];
      (out+j+2)[1] = (uint16_t)in[i+2];
      (out+j+4)[0] = (uint16_t)in[i+2];
      (out+j+4)[1] = (uint16_t)in[i];
   }
}
static void translate_tristrip_uint82uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint8_t *in = (const uint8_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1/*+(i&1)*/];
      (out+j+2)[0] = (uint16_t)in[i+1/*+(i&1)*/];
      (out+j+2)[1] = (uint16_t)in[i+2/*-(i&1)*/];
      (out+j+4)[0] = (uint16_t)in[i+2/*-(i&1)*/];
      (out+j+4)[1] = (uint16_t)in[i];
   }
}
static void translate_trifan_uint82uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint8_t *in = (const uint8_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) {
      (out+j)[0] = (uint16_t)in[0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j+2)[0] = (uint16_t)in[i+1];
      (out+j+2)[1] = (uint16_t)in[i+2];
      (out+j+4)[0] = (uint16_t)in[i+2];
      (out+j+4)[1] = (uint16_t)in[0];
   }
}
static void translate_quads_uint82uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint8_t *in = (const uint8_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j+2)[0] = (uint16_t)in[i+1];
      (out+j+2)[1] = (uint16_t)in[i+2];
      (out+j+4)[0] = (uint16_t)in[i+2];
      (out+j+4)[1] = (uint16_t)in[i+3];
      (out+j+6)[0] = (uint16_t)in[i+3];
      (out+j+6)[1] = (uint16_t)in[i+0];
   }
}
static void translate_quadstrip_uint82uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint8_t *in = (const uint8_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=2) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i+0];
      (out+j+2)[0] = (uint16_t)in[i+0];
      (out+j+2)[1] = (uint16_t)in[i+1];
      (out+j+4)[0] = (uint16_t)in[i+1];
      (out+j+4)[1] = (uint16_t)in[i+3];
      (out+j+6)[0] = (uint16_t)in[i+3];
      (out+j+6)[1] = (uint16_t)in[i+2];
   }
}
static void translate_polygon_uint82uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint8_t *in = (const uint8_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[(i+1)%(out_nr/2)
];
   }
}
static void translate_trisadj_uint82uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint8_t *in = (const uint8_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j+2)[0] = (uint16_t)in[i+2];
      (out+j+2)[1] = (uint16_t)in[i+4];
      (out+j+4)[0] = (uint16_t)in[i+4];
      (out+j+4)[1] = (uint16_t)in[i];
   }
}
static void translate_tristripadj_uint82uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint8_t *in = (const uint8_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j+2)[0] = (uint16_t)in[i+2];
      (out+j+2)[1] = (uint16_t)in[i+4];
      (out+j+4)[0] = (uint16_t)in[i+4];
      (out+j+4)[1] = (uint16_t)in[i];
   }
}
static void translate_tris_uint82uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint8_t *in = (const uint8_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=3) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j+2)[0] = (uint32_t)in[i+1];
      (out+j+2)[1] = (uint32_t)in[i+2];
      (out+j+4)[0] = (uint32_t)in[i+2];
      (out+j+4)[1] = (uint32_t)in[i];
   }
}
static void translate_tristrip_uint82uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint8_t *in = (const uint8_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1/*+(i&1)*/];
      (out+j+2)[0] = (uint32_t)in[i+1/*+(i&1)*/];
      (out+j+2)[1] = (uint32_t)in[i+2/*-(i&1)*/];
      (out+j+4)[0] = (uint32_t)in[i+2/*-(i&1)*/];
      (out+j+4)[1] = (uint32_t)in[i];
   }
}
static void translate_trifan_uint82uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint8_t *in = (const uint8_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) {
      (out+j)[0] = (uint32_t)in[0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j+2)[0] = (uint32_t)in[i+1];
      (out+j+2)[1] = (uint32_t)in[i+2];
      (out+j+4)[0] = (uint32_t)in[i+2];
      (out+j+4)[1] = (uint32_t)in[0];
   }
}
static void translate_quads_uint82uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint8_t *in = (const uint8_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j+2)[0] = (uint32_t)in[i+1];
      (out+j+2)[1] = (uint32_t)in[i+2];
      (out+j+4)[0] = (uint32_t)in[i+2];
      (out+j+4)[1] = (uint32_t)in[i+3];
      (out+j+6)[0] = (uint32_t)in[i+3];
      (out+j+6)[1] = (uint32_t)in[i+0];
   }
}
static void translate_quadstrip_uint82uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint8_t *in = (const uint8_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=2) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i+0];
      (out+j+2)[0] = (uint32_t)in[i+0];
      (out+j+2)[1] = (uint32_t)in[i+1];
      (out+j+4)[0] = (uint32_t)in[i+1];
      (out+j+4)[1] = (uint32_t)in[i+3];
      (out+j+6)[0] = (uint32_t)in[i+3];
      (out+j+6)[1] = (uint32_t)in[i+2];
   }
}
static void translate_polygon_uint82uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint8_t *in = (const uint8_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[(i+1)%(out_nr/2)
];
   }
}
static void translate_trisadj_uint82uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint8_t *in = (const uint8_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j+2)[0] = (uint32_t)in[i+2];
      (out+j+2)[1] = (uint32_t)in[i+4];
      (out+j+4)[0] = (uint32_t)in[i+4];
      (out+j+4)[1] = (uint32_t)in[i];
   }
}
static void translate_tristripadj_uint82uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint8_t *in = (const uint8_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j+2)[0] = (uint32_t)in[i+2];
      (out+j+2)[1] = (uint32_t)in[i+4];
      (out+j+4)[0] = (uint32_t)in[i+4];
      (out+j+4)[1] = (uint32_t)in[i];
   }
}
static void translate_tris_uint162uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint16_t *in = (const uint16_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=3) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j+2)[0] = (uint16_t)in[i+1];
      (out+j+2)[1] = (uint16_t)in[i+2];
      (out+j+4)[0] = (uint16_t)in[i+2];
      (out+j+4)[1] = (uint16_t)in[i];
   }
}
static void translate_tristrip_uint162uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint16_t *in = (const uint16_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1/*+(i&1)*/];
      (out+j+2)[0] = (uint16_t)in[i+1/*+(i&1)*/];
      (out+j+2)[1] = (uint16_t)in[i+2/*-(i&1)*/];
      (out+j+4)[0] = (uint16_t)in[i+2/*-(i&1)*/];
      (out+j+4)[1] = (uint16_t)in[i];
   }
}
static void translate_trifan_uint162uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint16_t *in = (const uint16_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) {
      (out+j)[0] = (uint16_t)in[0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j+2)[0] = (uint16_t)in[i+1];
      (out+j+2)[1] = (uint16_t)in[i+2];
      (out+j+4)[0] = (uint16_t)in[i+2];
      (out+j+4)[1] = (uint16_t)in[0];
   }
}
static void translate_quads_uint162uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint16_t *in = (const uint16_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j+2)[0] = (uint16_t)in[i+1];
      (out+j+2)[1] = (uint16_t)in[i+2];
      (out+j+4)[0] = (uint16_t)in[i+2];
      (out+j+4)[1] = (uint16_t)in[i+3];
      (out+j+6)[0] = (uint16_t)in[i+3];
      (out+j+6)[1] = (uint16_t)in[i+0];
   }
}
static void translate_quadstrip_uint162uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint16_t *in = (const uint16_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=2) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i+0];
      (out+j+2)[0] = (uint16_t)in[i+0];
      (out+j+2)[1] = (uint16_t)in[i+1];
      (out+j+4)[0] = (uint16_t)in[i+1];
      (out+j+4)[1] = (uint16_t)in[i+3];
      (out+j+6)[0] = (uint16_t)in[i+3];
      (out+j+6)[1] = (uint16_t)in[i+2];
   }
}
static void translate_polygon_uint162uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint16_t *in = (const uint16_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[(i+1)%(out_nr/2)
];
   }
}
static void translate_trisadj_uint162uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint16_t *in = (const uint16_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j+2)[0] = (uint16_t)in[i+2];
      (out+j+2)[1] = (uint16_t)in[i+4];
      (out+j+4)[0] = (uint16_t)in[i+4];
      (out+j+4)[1] = (uint16_t)in[i];
   }
}
static void translate_tristripadj_uint162uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint16_t *in = (const uint16_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j+2)[0] = (uint16_t)in[i+2];
      (out+j+2)[1] = (uint16_t)in[i+4];
      (out+j+4)[0] = (uint16_t)in[i+4];
      (out+j+4)[1] = (uint16_t)in[i];
   }
}
static void translate_tris_uint162uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint16_t *in = (const uint16_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=3) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j+2)[0] = (uint32_t)in[i+1];
      (out+j+2)[1] = (uint32_t)in[i+2];
      (out+j+4)[0] = (uint32_t)in[i+2];
      (out+j+4)[1] = (uint32_t)in[i];
   }
}
static void translate_tristrip_uint162uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint16_t *in = (const uint16_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1/*+(i&1)*/];
      (out+j+2)[0] = (uint32_t)in[i+1/*+(i&1)*/];
      (out+j+2)[1] = (uint32_t)in[i+2/*-(i&1)*/];
      (out+j+4)[0] = (uint32_t)in[i+2/*-(i&1)*/];
      (out+j+4)[1] = (uint32_t)in[i];
   }
}
static void translate_trifan_uint162uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint16_t *in = (const uint16_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) {
      (out+j)[0] = (uint32_t)in[0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j+2)[0] = (uint32_t)in[i+1];
      (out+j+2)[1] = (uint32_t)in[i+2];
      (out+j+4)[0] = (uint32_t)in[i+2];
      (out+j+4)[1] = (uint32_t)in[0];
   }
}
static void translate_quads_uint162uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint16_t *in = (const uint16_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j+2)[0] = (uint32_t)in[i+1];
      (out+j+2)[1] = (uint32_t)in[i+2];
      (out+j+4)[0] = (uint32_t)in[i+2];
      (out+j+4)[1] = (uint32_t)in[i+3];
      (out+j+6)[0] = (uint32_t)in[i+3];
      (out+j+6)[1] = (uint32_t)in[i+0];
   }
}
static void translate_quadstrip_uint162uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint16_t *in = (const uint16_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=2) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i+0];
      (out+j+2)[0] = (uint32_t)in[i+0];
      (out+j+2)[1] = (uint32_t)in[i+1];
      (out+j+4)[0] = (uint32_t)in[i+1];
      (out+j+4)[1] = (uint32_t)in[i+3];
      (out+j+6)[0] = (uint32_t)in[i+3];
      (out+j+6)[1] = (uint32_t)in[i+2];
   }
}
static void translate_polygon_uint162uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint16_t *in = (const uint16_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[(i+1)%(out_nr/2)
];
   }
}
static void translate_trisadj_uint162uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint16_t *in = (const uint16_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j+2)[0] = (uint32_t)in[i+2];
      (out+j+2)[1] = (uint32_t)in[i+4];
      (out+j+4)[0] = (uint32_t)in[i+4];
      (out+j+4)[1] = (uint32_t)in[i];
   }
}
static void translate_tristripadj_uint162uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint16_t *in = (const uint16_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j+2)[0] = (uint32_t)in[i+2];
      (out+j+2)[1] = (uint32_t)in[i+4];
      (out+j+4)[0] = (uint32_t)in[i+4];
      (out+j+4)[1] = (uint32_t)in[i];
   }
}
static void translate_tris_uint322uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint32_t *in = (const uint32_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=3) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j+2)[0] = (uint16_t)in[i+1];
      (out+j+2)[1] = (uint16_t)in[i+2];
      (out+j+4)[0] = (uint16_t)in[i+2];
      (out+j+4)[1] = (uint16_t)in[i];
   }
}
static void translate_tristrip_uint322uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint32_t *in = (const uint32_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+1/*+(i&1)*/];
      (out+j+2)[0] = (uint16_t)in[i+1/*+(i&1)*/];
      (out+j+2)[1] = (uint16_t)in[i+2/*-(i&1)*/];
      (out+j+4)[0] = (uint16_t)in[i+2/*-(i&1)*/];
      (out+j+4)[1] = (uint16_t)in[i];
   }
}
static void translate_trifan_uint322uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint32_t *in = (const uint32_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) {
      (out+j)[0] = (uint16_t)in[0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j+2)[0] = (uint16_t)in[i+1];
      (out+j+2)[1] = (uint16_t)in[i+2];
      (out+j+4)[0] = (uint16_t)in[i+2];
      (out+j+4)[1] = (uint16_t)in[0];
   }
}
static void translate_quads_uint322uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint32_t *in = (const uint32_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=4) {
      (out+j)[0] = (uint16_t)in[i+0];
      (out+j)[1] = (uint16_t)in[i+1];
      (out+j+2)[0] = (uint16_t)in[i+1];
      (out+j+2)[1] = (uint16_t)in[i+2];
      (out+j+4)[0] = (uint16_t)in[i+2];
      (out+j+4)[1] = (uint16_t)in[i+3];
      (out+j+6)[0] = (uint16_t)in[i+3];
      (out+j+6)[1] = (uint16_t)in[i+0];
   }
}
static void translate_quadstrip_uint322uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint32_t *in = (const uint32_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=2) {
      (out+j)[0] = (uint16_t)in[i+2];
      (out+j)[1] = (uint16_t)in[i+0];
      (out+j+2)[0] = (uint16_t)in[i+0];
      (out+j+2)[1] = (uint16_t)in[i+1];
      (out+j+4)[0] = (uint16_t)in[i+1];
      (out+j+4)[1] = (uint16_t)in[i+3];
      (out+j+6)[0] = (uint16_t)in[i+3];
      (out+j+6)[1] = (uint16_t)in[i+2];
   }
}
static void translate_polygon_uint322uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint32_t *in = (const uint32_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[(i+1)%(out_nr/2)
];
   }
}
static void translate_trisadj_uint322uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint32_t *in = (const uint32_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j+2)[0] = (uint16_t)in[i+2];
      (out+j+2)[1] = (uint16_t)in[i+4];
      (out+j+4)[0] = (uint16_t)in[i+4];
      (out+j+4)[1] = (uint16_t)in[i];
   }
}
static void translate_tristripadj_uint322uint16(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint32_t *in = (const uint32_t*)_in;
  uint16_t *out = (uint16_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j)[0] = (uint16_t)in[i];
      (out+j)[1] = (uint16_t)in[i+2];
      (out+j+2)[0] = (uint16_t)in[i+2];
      (out+j+2)[1] = (uint16_t)in[i+4];
      (out+j+4)[0] = (uint16_t)in[i+4];
      (out+j+4)[1] = (uint16_t)in[i];
   }
}
static void translate_tris_uint322uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint32_t *in = (const uint32_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=3) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j+2)[0] = (uint32_t)in[i+1];
      (out+j+2)[1] = (uint32_t)in[i+2];
      (out+j+4)[0] = (uint32_t)in[i+2];
      (out+j+4)[1] = (uint32_t)in[i];
   }
}
static void translate_tristrip_uint322uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint32_t *in = (const uint32_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+1/*+(i&1)*/];
      (out+j+2)[0] = (uint32_t)in[i+1/*+(i&1)*/];
      (out+j+2)[1] = (uint32_t)in[i+2/*-(i&1)*/];
      (out+j+4)[0] = (uint32_t)in[i+2/*-(i&1)*/];
      (out+j+4)[1] = (uint32_t)in[i];
   }
}
static void translate_trifan_uint322uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint32_t *in = (const uint32_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) {
      (out+j)[0] = (uint32_t)in[0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j+2)[0] = (uint32_t)in[i+1];
      (out+j+2)[1] = (uint32_t)in[i+2];
      (out+j+4)[0] = (uint32_t)in[i+2];
      (out+j+4)[1] = (uint32_t)in[0];
   }
}
static void translate_quads_uint322uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint32_t *in = (const uint32_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=4) {
      (out+j)[0] = (uint32_t)in[i+0];
      (out+j)[1] = (uint32_t)in[i+1];
      (out+j+2)[0] = (uint32_t)in[i+1];
      (out+j+2)[1] = (uint32_t)in[i+2];
      (out+j+4)[0] = (uint32_t)in[i+2];
      (out+j+4)[1] = (uint32_t)in[i+3];
      (out+j+6)[0] = (uint32_t)in[i+3];
      (out+j+6)[1] = (uint32_t)in[i+0];
   }
}
static void translate_quadstrip_uint322uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint32_t *in = (const uint32_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=2) {
      (out+j)[0] = (uint32_t)in[i+2];
      (out+j)[1] = (uint32_t)in[i+0];
      (out+j+2)[0] = (uint32_t)in[i+0];
      (out+j+2)[1] = (uint32_t)in[i+1];
      (out+j+4)[0] = (uint32_t)in[i+1];
      (out+j+4)[1] = (uint32_t)in[i+3];
      (out+j+6)[0] = (uint32_t)in[i+3];
      (out+j+6)[1] = (uint32_t)in[i+2];
   }
}
static void translate_polygon_uint322uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint32_t *in = (const uint32_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[(i+1)%(out_nr/2)
];
   }
}
static void translate_trisadj_uint322uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint32_t *in = (const uint32_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=6) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j+2)[0] = (uint32_t)in[i+2];
      (out+j+2)[1] = (uint32_t)in[i+4];
      (out+j+4)[0] = (uint32_t)in[i+4];
      (out+j+4)[1] = (uint32_t)in[i];
   }
}
static void translate_tristripadj_uint322uint32(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint32_t *in = (const uint32_t*)_in;
  uint32_t *out = (uint32_t*)_out;
  unsigned i, j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=2) {
      (out+j)[0] = (uint32_t)in[i];
      (out+j)[1] = (uint32_t)in[i+2];
      (out+j+2)[0] = (uint32_t)in[i+2];
      (out+j+2)[1] = (uint32_t)in[i+4];
      (out+j+4)[0] = (uint32_t)in[i+4];
      (out+j+4)[1] = (uint32_t)in[i];
   }
}
void u_unfilled_init( void )
{
  static int firsttime = 1;
  if (!firsttime) return;
  firsttime = 0;
generate_line[OUT_UINT16][MESA_PRIM_TRIANGLES] = generate_tris_uint16;
generate_line[OUT_UINT16][MESA_PRIM_TRIANGLE_FAN] = generate_trifan_uint16;
generate_line[OUT_UINT16][MESA_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint16;
generate_line[OUT_UINT16][MESA_PRIM_QUADS] = generate_quads_uint16;
generate_line[OUT_UINT16][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint16;
generate_line[OUT_UINT16][MESA_PRIM_POLYGON] = generate_polygon_uint16;
generate_line[OUT_UINT16][MESA_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint16;
generate_line[OUT_UINT16][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint16;
generate_line[OUT_UINT32][MESA_PRIM_TRIANGLES] = generate_tris_uint32;
generate_line[OUT_UINT32][MESA_PRIM_TRIANGLE_FAN] = generate_trifan_uint32;
generate_line[OUT_UINT32][MESA_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint32;
generate_line[OUT_UINT32][MESA_PRIM_QUADS] = generate_quads_uint32;
generate_line[OUT_UINT32][MESA_PRIM_QUAD_STRIP] = generate_quadstrip_uint32;
generate_line[OUT_UINT32][MESA_PRIM_POLYGON] = generate_polygon_uint32;
generate_line[OUT_UINT32][MESA_PRIM_TRIANGLES_ADJACENCY] = generate_trisadj_uint32;
generate_line[OUT_UINT32][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = generate_tristripadj_uint32;
translate_line[IN_UINT8][OUT_UINT16][MESA_PRIM_TRIANGLES] = translate_tris_uint82uint16;
translate_line[IN_UINT8][OUT_UINT16][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint82uint16;
translate_line[IN_UINT8][OUT_UINT16][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint82uint16;
translate_line[IN_UINT8][OUT_UINT16][MESA_PRIM_QUADS] = translate_quads_uint82uint16;
translate_line[IN_UINT8][OUT_UINT16][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint16;
translate_line[IN_UINT8][OUT_UINT16][MESA_PRIM_POLYGON] = translate_polygon_uint82uint16;
translate_line[IN_UINT8][OUT_UINT16][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint82uint16;
translate_line[IN_UINT8][OUT_UINT16][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint82uint16;
translate_line[IN_UINT8][OUT_UINT32][MESA_PRIM_TRIANGLES] = translate_tris_uint82uint32;
translate_line[IN_UINT8][OUT_UINT32][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint82uint32;
translate_line[IN_UINT8][OUT_UINT32][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint82uint32;
translate_line[IN_UINT8][OUT_UINT32][MESA_PRIM_QUADS] = translate_quads_uint82uint32;
translate_line[IN_UINT8][OUT_UINT32][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint82uint32;
translate_line[IN_UINT8][OUT_UINT32][MESA_PRIM_POLYGON] = translate_polygon_uint82uint32;
translate_line[IN_UINT8][OUT_UINT32][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint82uint32;
translate_line[IN_UINT8][OUT_UINT32][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint82uint32;
translate_line[IN_UINT16][OUT_UINT16][MESA_PRIM_TRIANGLES] = translate_tris_uint162uint16;
translate_line[IN_UINT16][OUT_UINT16][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint162uint16;
translate_line[IN_UINT16][OUT_UINT16][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint162uint16;
translate_line[IN_UINT16][OUT_UINT16][MESA_PRIM_QUADS] = translate_quads_uint162uint16;
translate_line[IN_UINT16][OUT_UINT16][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint16;
translate_line[IN_UINT16][OUT_UINT16][MESA_PRIM_POLYGON] = translate_polygon_uint162uint16;
translate_line[IN_UINT16][OUT_UINT16][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint162uint16;
translate_line[IN_UINT16][OUT_UINT16][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint162uint16;
translate_line[IN_UINT16][OUT_UINT32][MESA_PRIM_TRIANGLES] = translate_tris_uint162uint32;
translate_line[IN_UINT16][OUT_UINT32][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint162uint32;
translate_line[IN_UINT16][OUT_UINT32][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint162uint32;
translate_line[IN_UINT16][OUT_UINT32][MESA_PRIM_QUADS] = translate_quads_uint162uint32;
translate_line[IN_UINT16][OUT_UINT32][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint162uint32;
translate_line[IN_UINT16][OUT_UINT32][MESA_PRIM_POLYGON] = translate_polygon_uint162uint32;
translate_line[IN_UINT16][OUT_UINT32][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint162uint32;
translate_line[IN_UINT16][OUT_UINT32][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint162uint32;
translate_line[IN_UINT32][OUT_UINT16][MESA_PRIM_TRIANGLES] = translate_tris_uint322uint16;
translate_line[IN_UINT32][OUT_UINT16][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint322uint16;
translate_line[IN_UINT32][OUT_UINT16][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint322uint16;
translate_line[IN_UINT32][OUT_UINT16][MESA_PRIM_QUADS] = translate_quads_uint322uint16;
translate_line[IN_UINT32][OUT_UINT16][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint16;
translate_line[IN_UINT32][OUT_UINT16][MESA_PRIM_POLYGON] = translate_polygon_uint322uint16;
translate_line[IN_UINT32][OUT_UINT16][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint322uint16;
translate_line[IN_UINT32][OUT_UINT16][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint322uint16;
translate_line[IN_UINT32][OUT_UINT32][MESA_PRIM_TRIANGLES] = translate_tris_uint322uint32;
translate_line[IN_UINT32][OUT_UINT32][MESA_PRIM_TRIANGLE_FAN] = translate_trifan_uint322uint32;
translate_line[IN_UINT32][OUT_UINT32][MESA_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint322uint32;
translate_line[IN_UINT32][OUT_UINT32][MESA_PRIM_QUADS] = translate_quads_uint322uint32;
translate_line[IN_UINT32][OUT_UINT32][MESA_PRIM_QUAD_STRIP] = translate_quadstrip_uint322uint32;
translate_line[IN_UINT32][OUT_UINT32][MESA_PRIM_POLYGON] = translate_polygon_uint322uint32;
translate_line[IN_UINT32][OUT_UINT32][MESA_PRIM_TRIANGLES_ADJACENCY] = translate_trisadj_uint322uint32;
translate_line[IN_UINT32][OUT_UINT32][MESA_PRIM_TRIANGLE_STRIP_ADJACENCY] = translate_tristripadj_uint322uint32;
}
#include "indices/u_unfilled_indices.c"
