{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FEventAddChildren: TMFNodeEvent;
    {  }
    public property EventAddChildren: TMFNodeEvent read FEventAddChildren;

    strict private FEventRemoveChildren: TMFNodeEvent;
    {  }
    public property EventRemoveChildren: TMFNodeEvent read FEventRemoveChildren;

    strict private FFdChildren: TMFNode;
    { Internal wrapper for property @link(Children). This wrapper API may change, we advise to access simpler @link(Children) instead. }
    public property FdChildren: TMFNode read FFdChildren;

{$endif read_interface}

{$ifdef read_implementation}

{ TContour2DNode ----------------------------------------------- }

class function TContour2DNode.ClassX3DType: String;
begin
  Result := 'Contour2D';
end;

procedure TContour2DNode.CreateNode;
begin
  inherited;

  FEventAddChildren := TMFNodeEvent.Create(Self, 'addChildren', true);
  AddEvent(FEventAddChildren);

  FEventRemoveChildren := TMFNodeEvent.Create(Self, 'removeChildren', true);
  AddEvent(FEventRemoveChildren);

  FFdChildren := TMFNode.Create(Self, True, 'children', [TNurbsCurve2DNode, TContourPolyline2DNode]);
   FdChildren.ChangeAlways := chEverything;
  AddField(FFdChildren);

  DefaultContainerField := 'trimmingContour';
end;

{$endif read_implementation}
