/*
** Copyright 2011-2013 Centreon
**
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**     http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
**
** For more information : contact@centreon.com
*/

#include <string.h>
#include "com/centreon/misc/stringifier.hh"

using namespace com::centreon::misc;

/**
 *  Check the stringifier append data.
 *
 *  @return 0 on success.
 */
int main() {
  {
    stringifier buffer;
    buffer.append(__FILE__, sizeof(__FILE__));
    if (strcmp(buffer.data(), __FILE__))
      return (1);
  }

  {
    stringifier buffer;
    buffer.append(__FILE__, sizeof(__FILE__) - 3);
    if (strncmp(buffer.data(), __FILE__, sizeof(__FILE__) - 3))
      return (1);
  }

  {
    char ref[] = "**\0**";
    stringifier buffer;
    buffer.append(ref, sizeof(ref));
    if (memcmp(buffer.data(), ref, 3))
      return (1);
  }

  return (0);
}
