package com.triplemedia.sms.alphabets.cimd2;

/**
 * Utility class for CIMD2 alphabet as defined in CIMD_Interface_Specification_SC70.pdf
 */
public class CIMD2Alphabet{
	public static final char CIMD2_SPECIAL_COMBINATION_CHARACTER = '_';

    public static final String COMMERCIAL_AT = "_Oa";
    public static final String SMALL_LETTER_y = "y";
    public static final String SMALL_LETTER_z = "z";
    
    public static final String VERTICAL_BAR = "_XX_!!"; // |
    public static final String CARET = "_XX_gl"; // ^
    public static final String EURO = "_XXe"; // 
    public static final String OPENING_BRACE = "_XX("; // {
    public static final String CLOSING_BRACE = "_XX)"; // }
    public static final String PAGE_BREAK = "_XX\f)"; 
    public static final String OPENING_BRACKET = "_XX<"; // [
    public static final String CLOSING_BRACKET = "_XX>"; // ]
    public static final String TILDE = "_XX="; // ~
    public static final String BACKSLASH = "_XX/"; // \
    
    public static final String VERTICAL_BAR_NO_ESC = "_!!"; // |
    public static final String CARET_NO_ESC = "_gl"; // ^
    public static final String EURO_NO_ESC = "e"; // 
    public static final String OPENING_BRACE_NO_ESC = "("; // {
    public static final String CLOSING_BRACE_NO_ESC = ")"; // }
    public static final String PAGE_BREAK_NO_ESC = "\f"; 
    public static final String OPENING_BRACKET_NO_ESC = "<"; // [
    public static final String CLOSING_BRACKET_NO_ESC = ">"; // ]
    public static final String TILDE_NO_ESC = "="; // ~
    public static final String BACKSLASH_NO_ESC = "/"; // \

}
