#!/bin/sh
#
# Copyright (c) 2008, 2011, 2019  Peter Pentchev
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

[ -z "$CONFGET" ] && CONFGET='./confget'
[ -z "$TESTDIR" ] && TESTDIR='t'

echo '1..19'


if [ ! -f "$TESTDIR/t1.ini" ]; then
        echo "Bail out!  No test file $TESTDIR/t1.ini"
        exit 255
fi

if [ ! -f "$TESTDIR/t4.ini" ]; then
        echo "Bail out!  No test file $TESTDIR/t4.ini"
        exit 255
fi
v=`$CONFGET '-f' "$TESTDIR/t1.ini" '-s' 'a' 'key1' `
res="$?"
if [ "$v" = 'value1' ]; then echo 'ok 1'; else echo "not ok 1 v is '$v'"; fi
v=`$CONFGET '-f' "$TESTDIR/t1.ini" '-s' 'a' '-N' 'key2' `
res="$?"
if [ "$v" = 'key2=value2' ]; then echo 'ok 2'; else echo "not ok 2 v is '$v'"; fi
v=`$CONFGET '-f' "$TESTDIR/t1.ini" '-s' 'a' 'key3' `
res="$?"
if [ "$v" = '		 val'"'"'ue3' ]; then echo 'ok 3'; else echo "not ok 3 v is '$v'"; fi
v=`$CONFGET '-f' "$TESTDIR/t1.ini" '-s' 'b sect' 'key4' `
res="$?"
if [ "$v" = 'v'"'"'alu'"'"'e4' ]; then echo 'ok 4'; else echo "not ok 4 v is '$v'"; fi
v=`$CONFGET '-f' "$TESTDIR/t1.ini" '-s' 'c' 'key5' `
res="$?"
if [ "$v" = '		# value5' ]; then echo 'ok 5'; else echo "not ok 5 v is '$v'"; fi
v=`$CONFGET '-f' "$TESTDIR/t1.ini" '-s' 'a' 'key1' 'key2' | tr "\n" " "`
res="$?"
if [ "$v" = 'key1=value1 key2=value2 ' ]; then echo 'ok 6'; else echo "not ok 6 v is '$v'"; fi
v=`$CONFGET '-f' "$TESTDIR/t1.ini" '-s' 'a' '-n' 'key6' 'key2' | tr "\n" " "`
res="$?"
if [ "$v" = 'value2 value6 ' ]; then echo 'ok 7'; else echo "not ok 7 v is '$v'"; fi
v=`$CONFGET '-f' "$TESTDIR/t1.ini" '-s' 'b sect' 'key7' `
res="$?"
if [ "$v" = 'value7' ]; then echo 'ok 8'; else echo "not ok 8 v is '$v'"; fi
v=`$CONFGET '-s' 'b sect' -f - 'key7' < "$TESTDIR/t1.ini" `
res="$?"
if [ "$v" = 'value7' ]; then echo 'ok 9'; else echo "not ok 9 v is '$v'"; fi
v=`$CONFGET '-s' 'b sect' -f - 'key77' < "$TESTDIR/t1.ini" `
res="$?"
if [ "$v" = '' ]; then echo 'ok 10'; else echo "not ok 10 v is '$v'"; fi
v=`env Q1='key4&amp;key5=%09%09%20val%27ue5&key6' Q2='' QUERY_STRING='key1=value1&key2=%3Dvalue2%26&amp;key3=%09%09%20val%27ue3' $CONFGET -t http_get 'key1' `
res="$?"
if [ "$v" = 'value1' ]; then echo 'ok 11'; else echo "not ok 11 v is '$v'"; fi
v=`env Q1='key4&amp;key5=%09%09%20val%27ue5&key6' Q2='' QUERY_STRING='key1=value1&key2=%3Dvalue2%26&amp;key3=%09%09%20val%27ue3' $CONFGET -t http_get '-N' 'key2' `
res="$?"
if [ "$v" = 'key2==value2&' ]; then echo 'ok 12'; else echo "not ok 12 v is '$v'"; fi
v=`env Q1='key4&amp;key5=%09%09%20val%27ue5&key6' Q2='' QUERY_STRING='key1=value1&key2=%3Dvalue2%26&amp;key3=%09%09%20val%27ue3' $CONFGET -t http_get 'key3' `
res="$?"
if [ "$v" = '		 val'"'"'ue3' ]; then echo 'ok 13'; else echo "not ok 13 v is '$v'"; fi
v=`env Q1='key4&amp;key5=%09%09%20val%27ue5&key6' Q2='' QUERY_STRING='key1=value1&key2=%3Dvalue2%26&amp;key3=%09%09%20val%27ue3' $CONFGET -t http_get '-s' 'Q1' 'key4' `
res="$?"
if [ "$v" = '' ]; then echo 'ok 14'; else echo "not ok 14 v is '$v'"; fi
v=`env Q1='key4&amp;key5=%09%09%20val%27ue5&key6' Q2='' QUERY_STRING='key1=value1&key2=%3Dvalue2%26&amp;key3=%09%09%20val%27ue3' $CONFGET -t http_get '-s' 'Q1' 'key5' `
res="$?"
if [ "$v" = '		 val'"'"'ue5' ]; then echo 'ok 15'; else echo "not ok 15 v is '$v'"; fi
v=`env Q1='key4&amp;key5=%09%09%20val%27ue5&key6' Q2='' QUERY_STRING='key1=value1&key2=%3Dvalue2%26&amp;key3=%09%09%20val%27ue3' $CONFGET -t http_get '-s' 'Q1' 'key6' `
res="$?"
if [ "$v" = '' ]; then echo 'ok 16'; else echo "not ok 16 v is '$v'"; fi
v=`env Q1='key4&amp;key5=%09%09%20val%27ue5&key6' Q2='' QUERY_STRING='key1=value1&key2=%3Dvalue2%26&amp;key3=%09%09%20val%27ue3' $CONFGET -t http_get '-s' 'Q1' 'key66' `
res="$?"
if [ "$v" = '' ]; then echo 'ok 17'; else echo "not ok 17 v is '$v'"; fi
v=`env Q1='key4&amp;key5=%09%09%20val%27ue5&key6' Q2='' QUERY_STRING='key1=value1&key2=%3Dvalue2%26&amp;key3=%09%09%20val%27ue3' $CONFGET -t http_get '-s' 'Q2' 'key66' `
res="$?"
if [ "$v" = '' ]; then echo 'ok 18'; else echo "not ok 18 v is '$v'"; fi
v=`$CONFGET '-f' "$TESTDIR/t4.ini" '-s' 'x' 'key8' `
res="$?"
if [ "$v" = 'key9=key10=key11' ]; then echo 'ok 19'; else echo "not ok 19 v is '$v'"; fi
