# Foxconn D41S

This page describes how to run coreboot on the [FOXCONN D41S] desktop from [FOXCONN].
The D42S, D51S, D52S are compatible boards with the difference being the CPU.

## Building coreboot

The default options for this board should result in a fully working image:

	# echo "CONFIG_VENDOR_FOXCONN=y" > .config
	# echo "CONFIG_BOARD_FOXCONN_D41S=y" >> .config
	# make olddefconfig && make


## Flashing coreboot

```{eval-rst}
+---------------------+--------+
| Type                | Value  |
+=====================+========+
| Socketed flash      | yes    |
+---------------------+--------+
| Model               | W25X80 |
+---------------------+--------+
| Size                | 1 MiB  |
+---------------------+--------+
| In circuit flashing | yes    |
+---------------------+--------+
| Package             | DIP-8  |
+---------------------+--------+
| Write protection    | No     |
+---------------------+--------+
| Dual BIOS feature   | No     |
+---------------------+--------+
| Internal flashing   | yes    |
+---------------------+--------+
```

### Internal programming

The SPI flash can be accessed using [flashrom].

### External programming

The easiest to flash externally is to simply extract the SPI flash from its socket.
To do this gently take the SPI flash out of its socket and flash with your programmer.

**NOTE: Don't forget to set the WP# AND HOLD# to 3V.**

**NOTE2: Make sure to reinsert it in the right direction afterward**

**Location and orientation of the SPI flash socket**
![][d41s_flash]

[d41s_flash]: d41s_flash.jpg

## Technology

```{eval-rst}
+------------------+------------------+
| Northbridge      | Intel Pinevew    |
+------------------+------------------+
| Southbridge      | Intel NM10       |
+------------------+------------------+
| CPU              | model_106cx      |
+------------------+------------------+
| SuperIO          | ITE IT8721F      |
+------------------+------------------+
| clockgen (CK505) | ICS 9LPRS525AGLF |
+------------------+------------------+
```

[FOXCONN D41S]: http://www.foxconnchannel.com/ProductDetail.aspx?T=motherboard&U=en-us0000481
[FOXCONN]: http://www.foxconnchannel.com
[Flashrom]: https://flashrom.org/
