/* SPDX-License-Identifier: GPL-2.0-only */

#include <mainboard/gpio.h>
#include <soc/gpio.h>

static const struct pad_config gpio_table[] = {
	/* ------- GPIO Group GPD ------- */
	PAD_CFG_NF(GPD0, UP_20K, PWROK, NF1), // PM_BATLOW#
	PAD_CFG_NF(GPD1, NATIVE, PWROK, NF1), // AC_PRESENT
	PAD_NC(GPD2, NONE),
	PAD_CFG_NF(GPD3, UP_20K, PWROK, NF1), // PWN_BTN#
	PAD_CFG_NF(GPD4, NONE, PWROK, NF1), // SUSB#_PCH
	PAD_CFG_NF(GPD5, NONE, PWROK, NF1), // SUSC#_PCH
	PAD_CFG_NF(GPD6, NONE, PWROK, NF1), // SLP_A#
	PAD_NC(GPD7, NONE),
	PAD_CFG_NF(GPD8, NONE, PWROK, NF1), // SUS_CLK
	PAD_CFG_GPO(GPD9, 0, PWROK), // SLP_WLAN#
	PAD_CFG_NF(GPD10, NONE, PWROK, NF1), // SLP_S5#
	PAD_NC(GPD11, NONE),

	/* ------- GPIO Group GPP_A ------- */
	PAD_CFG_NF(GPP_A0, UP_20K, DEEP, NF1), // ESPI_IO0_EC
	PAD_CFG_NF(GPP_A1, UP_20K, DEEP, NF1), // ESPI_IO1_EC
	PAD_CFG_NF(GPP_A2, UP_20K, DEEP, NF1), // ESPI_IO2_EC
	PAD_CFG_NF(GPP_A3, UP_20K, DEEP, NF1), // ESPI_IO3_EC
	PAD_CFG_NF(GPP_A4, UP_20K, DEEP, NF1), // ESPI_CS_EC#
	PAD_CFG_NF(GPP_A5, UP_20K, DEEP, NF1), // ESPI_ALRT0#
	_PAD_CFG_STRUCT(GPP_A6, 0x80100100, 0x0000), // INTP_8851
	PAD_CFG_GPI(GPP_A7, NONE, PLTRST), // GC6_FB_EN_PCH
	PAD_CFG_GPO(GPP_A8, 0, DEEP), // GPIO_LANRTD3
	PAD_CFG_NF(GPP_A9, DN_20K, DEEP, NF1), // ESPI_CLK_EC
	PAD_CFG_NF(GPP_A10, NONE, DEEP, NF1), // ESPI_RESET#
	PAD_NC(GPP_A11, NONE), // GPU_PROCHOT#
	PAD_NC(GPP_A12, NONE),
	PAD_CFG_GPO(GPP_A13, 1, PLTRST), // PCH_BT_EN
	// GPP_A14 (DGPU_PWR_EN) configured in bootblock
	_PAD_CFG_STRUCT(GPP_A15, 0x46880100, 0x0000), // G_DP_HDPD_E
	PAD_NC(GPP_A16, NONE), // USB_OC3#
	PAD_NC(GPP_A17, NONE),
	_PAD_CFG_STRUCT(GPP_A18, 0x46880100, 0x0000), // HDMI_HPD
	PAD_NC(GPP_A19, NONE),
	_PAD_CFG_STRUCT(GPP_A20, 0x46880100, 0x0000), // DP_F_HPD
	PAD_NC(GPP_A21, NONE),
	PAD_CFG_GPO(GPP_A22, 0, DEEP), // PCIE4_WAKE_N
	PAD_CFG_GPI(GPP_A23, UP_20K, DEEP), // GPIO4_NVVDD_EN

	/* ------- GPIO Group GPP_B ------- */
	PAD_CFG_NF(GPP_B0, NONE, DEEP, NF1), // VCCIN_AUX_VID0
	PAD_CFG_NF(GPP_B1, NONE, DEEP, NF1), // VCCIN_AUX_VID1
	// GPP_B2 (DGPU_RST#_CPU) configured in bootblock
	PAD_CFG_GPI(GPP_B3, NONE, DEEP), // SCI#
	PAD_CFG_GPI(GPP_B4, NONE, DEEP), // SWI#
	PAD_CFG_NF(GPP_B5, NONE, DEEP, NF1), // GPPB_I2C2_SDA (Pantone)
	PAD_CFG_NF(GPP_B6, NONE, DEEP, NF1), // GPPB_I2C2_SCL (Pantone)
	PAD_CFG_NF(GPP_B7, NONE, DEEP, NF1), // I2C3_SDA (IT8851)
	PAD_CFG_NF(GPP_B8, NONE, DEEP, NF1), // I2C3_SCL (IT8851)
	// GPP_B9 missing
	// GPP_B10 missing
	PAD_CFG_NF(GPP_B11, NONE, PWROK, NF1), // TBT_I2C_INT
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1), // SLP_S0#
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1), // PLT_RST#
	PAD_NC(GPP_B14, NONE), // Top swap override
	PAD_CFG_GPI(GPP_B15, NONE, DEEP), // PS8461_SW
	PAD_NC(GPP_B16, NONE),
	PAD_NC(GPP_B17, NONE),
	PAD_CFG_GPI(GPP_B18, NONE, DEEP), // NO REBOOT strap
	// GPP_B19 missing
	// GPP_B20 missing
	// GPP_B21 missing
	// GPP_B22 missing
	PAD_CFG_GPO(GPP_B23, 0, DEEP), // CPUNSSC CLOCK FREQ strap

	/* ------- GPIO Group GPP_C ------- */
	PAD_CFG_NF(GPP_C0, NONE, DEEP, NF1), // SMB_CLK
	PAD_CFG_NF(GPP_C1, NONE, DEEP, NF1), // SMB_DATA
	PAD_CFG_GPO(GPP_C2, 1, PLTRST), // M2_PWR_EN2
	PAD_CFG_NF(GPP_C3, NONE, DEEP, NF1), // SML0_CLK
	PAD_CFG_NF(GPP_C4, NONE, DEEP, NF1), // SML0_DATA
	PAD_CFG_GPO(GPP_C5, 0, DEEP), // ESPI OR EC LESS strap
	PAD_CFG_NF(GPP_C6, NONE, DEEP, NF1), // TBT_I2C_SCL
	PAD_CFG_NF(GPP_C7, NONE, DEEP, NF1), // TBT_I2C_SDA
	// GPP_C8 missing
	// GPP_C9 missing
	// GPP_C10 missing
	// GPP_C11 missing
	// GPP_C12 missing
	// GPP_C13 missing
	// GPP_C14 missing
	// GPP_C15 missing
	// GPP_C16 missing
	// GPP_C17 missing
	// GPP_C18 missing
	// GPP_C19 missing
	// GPP_C20 missing
	// GPP_C21 missing
	// GPP_C22 missing
	// GPP_C23 missing

	/* ------- GPIO Group GPP_D ------- */
	PAD_CFG_GPO(GPP_D0, 1, DEEP), // SB_BLON
	PAD_CFG_GPI(GPP_D1, NONE, DEEP), // SB_KBCRST#
	PAD_CFG_GPO(GPP_D2, 0, DEEP), // ROM_I2C_EN
	PAD_NC(GPP_D3, NONE),
	PAD_CFG_GPO(GPP_D4, 1, PLTRST), // GPIO_LAN_EN
	// GPP_D5 (SSD0_CLKREQ#) configured by FSP
	PAD_CFG_GPO(GPP_D6, 1, DEEP), // LAN_PLT_RST#
	// GPP_D7 (WLAN_CLKREQ#) configured by FSP
	// GPP_D8 (GPU_PCIE_CLKREQ#) configured by FSP
	PAD_NC(GPP_D9, NONE),
	PAD_NC(GPP_D10, NONE),
	PAD_NC(GPP_D11, NONE),
	PAD_CFG_GPI(GPP_D12, NATIVE, DEEP), // DGPU_PWRGD_R
	PAD_CFG_GPI(GPP_D13, NONE, DEEP), // WLAN_WAKEUP#
	PAD_CFG_GPO(GPP_D14, 1, PLTRST), // M2_PWR_EN1
	PAD_NC(GPP_D15, NONE),
	PAD_NC(GPP_D16, NONE),
	PAD_NC(GPP_D17, NONE),
	PAD_NC(GPP_D18, NONE),
	PAD_CFG_GPO(GPP_D19, 1, PLTRST), // SATA_LED#

	/* ------- GPIO Group GPP_E ------- */
	PAD_CFG_GPI(GPP_E0, NONE, DEEP), // CNVI_WAKE#
	_PAD_CFG_STRUCT(GPP_E1, 0x40100100, 0x3000), // TPM_PIRQ#
	PAD_CFG_GPI(GPP_E2, NONE, DEEP), // BOARD_ID2
	PAD_CFG_GPO(GPP_E3, 1, PLTRST), // PCH_WLAN_EN
	PAD_CFG_GPO(GPP_E4, 0, PLTRST), // TC_RETIMER_FORCE_PWR
	PAD_NC(GPP_E5, NONE),
	PAD_CFG_GPI(GPP_E6, NONE, DEEP), // JTAG ODT DISABLE strap
	PAD_CFG_GPI(GPP_E7, NONE, DEEP), // SMI#
	PAD_CFG_GPI(GPP_E8, NONE, DEEP), // SLP_DRAM#
	PAD_CFG_NF(GPP_E9, NONE, DEEP, NF1), // USB_OC0#
	PAD_CFG_GPI(GPP_E10, NONE, DEEP), // BOARD_ID4
	PAD_CFG_GPI(GPP_E11, NONE, DEEP), // BOARD_ID1
	PAD_CFG_GPI_INT(GPP_E12, NONE, PLTRST, LEVEL), // TP_ATTN#
	PAD_CFG_GPI(GPP_E13, NONE, DEEP), // BOARD_ID3
	PAD_CFG_NF(GPP_E14, NONE, DEEP, NF1), // EDP_HPD
	PAD_NC(GPP_E15, NONE),
	PAD_NC(GPP_E16, NONE),
	PAD_CFG_GPI(GPP_E17, NONE, DEEP), // BOARD_ID5
	// GPP_E18 (TBTA_LSX2_TXD) configured by FSP
	// GPP_E19 (TBTA_LSX2_RXD) configured by FSP
	PAD_NC(GPP_E20, NONE),
	PAD_NC(GPP_E21, NONE), // Strap
	PAD_NC(GPP_E22, NONE),
	PAD_NC(GPP_E23, NONE),

	/* ------- GPIO Group GPP_F ------- */
	PAD_CFG_NF(GPP_F0, NONE, DEEP, NF1), // CNVI_BRI_DT
	PAD_CFG_NF(GPP_F1, UP_20K, DEEP, NF1), // CNVI_BRI_RSP
	PAD_CFG_NF(GPP_F2, NONE, DEEP, NF1), // CNVI_RGI_DT
	PAD_CFG_NF(GPP_F3, UP_20K, DEEP, NF1), // CNVI_RGI_RSP
	PAD_CFG_NF(GPP_F4, NONE, DEEP, NF1), // CNVI_RST#
	// GPP_F5 (CNVI_CLKREQ) configured by FSP
	PAD_CFG_NF(GPP_F6, NONE, DEEP, NF1), // CNVI_GNSS_PA_BLANKING
	PAD_NC(GPP_F7, NONE), // MCRO LDO BYPASS strap
	// GPP_F8 missing
	PAD_NC(GPP_F9, NONE),
	PAD_NC(GPP_F10, NONE), // RSMRSTB SAMPLING strap
	PAD_NC(GPP_F11, NONE),
	PAD_CFG_GPO(GPP_F12, 0, DEEP), // OVRM
	PAD_NC(GPP_F13, NONE),
	PAD_NC(GPP_F14, NONE),
	PAD_CFG_GPI(GPP_F15, NONE, DEEP), // BOARD_ID6
	PAD_CFG_GPI(GPP_F16, NONE, DEEP), // BOARD_ID7
	PAD_CFG_GPI(GPP_F17, NONE, DEEP), // PLVDD_RST_EC
	PAD_NC(GPP_F18, NONE),
	// GPP_F19 (CARD_CLKREQ#) configured by FSP
	PAD_CFG_GPO(GPP_F20, 1, PLTRST), // M.2_PLT_RST_CNTRL1#
	PAD_NC(GPP_F21, NONE),
	PAD_NC(GPP_F22, NONE),
	PAD_NC(GPP_F23, NONE),

	/* ------- GPIO Group GPP_H ------- */
	PAD_NC(GPP_H0, NONE),
	PAD_CFG_GPO(GPP_H1, 1, PLTRST), // M.2_PLT_RST_CNTRL2#
	PAD_CFG_GPO(GPP_H2, 1, PLTRST), // M.2_PLT_RST_CNTRL3#
	PAD_CFG_GPI(GPP_H3, NONE, DEEP), // TPM_DET
	PAD_CFG_NF(GPP_H4, NONE, DEEP, NF1), // I2C_SDA_TP (Touchpad)
	PAD_CFG_NF(GPP_H5, NONE, DEEP, NF1), // I2C_SCL_TP (Touchpad)
	PAD_CFG_NF(GPP_H6, NONE, DEEP, NF1), // PCH_I2C_SDA (Retimer)
	PAD_CFG_NF(GPP_H7, NONE, DEEP, NF1), // PCH_I2C_SCL (Retimer)
	PAD_CFG_NF(GPP_H8, NONE, DEEP, NF1), // CNVI_MFUART2_RXD
	PAD_CFG_NF(GPP_H9, NONE, DEEP, NF1), // CNVI_MFUART2_TXD
	// GPP_H10 (UART0_RX) configured in bootblock
	// GPP_H11 (UART0_TX) configured in bootblock
	PAD_NC(GPP_H12, NONE),
	PAD_NC(GPP_H13, NONE),
	// GPP_H14 missing
	PAD_NC(GPP_H15, NONE),
	// GPP_H16 missing
	PAD_NC(GPP_H17, NONE),
	PAD_CFG_NF(GPP_H18, NONE, DEEP, NF1), // CPU_C10_GATE#
	// GPP_H19 (SSD1_CLKREQ#) configured by FSP
	PAD_NC(GPP_H20, NONE),
	PAD_NC(GPP_H21, NONE),
	PAD_NC(GPP_H22, NONE),
	// GPP_H23 (GLAN_CLKREQ#) configured by FSP

	/* ------- GPIO Group GPP_R ------- */
	PAD_CFG_NF(GPP_R0, NONE, DEEP, NF1), // HDA_BITCLK
	PAD_CFG_NF(GPP_R1, NATIVE, DEEP, NF1), // HDA_SYNC
	PAD_CFG_NF(GPP_R2, NATIVE, DEEP, NF1), // HDA_SDOUT
	PAD_CFG_NF(GPP_R3, NATIVE, DEEP, NF1), // HDA_SDIN0
	PAD_CFG_NF(GPP_R4, NONE, DEEP, NF1), // HDA_RST#
	PAD_CFG_GPO(GPP_R5, 1, DEEP), // PCH_MUTE#
	PAD_CFG_GPI(GPP_R6, NONE, DEEP), // GPPR_DMIC_CLK
	PAD_CFG_GPI(GPP_R7, NONE, DEEP), // GPPR_DMIC_DATA

	/* ------- GPIO Group GPP_S ------- */
	PAD_NC(GPP_S0, NONE),
	PAD_NC(GPP_S1, NONE),
	PAD_NC(GPP_S2, NONE),
	PAD_NC(GPP_S3, NONE),
	PAD_NC(GPP_S4, NONE),
	PAD_NC(GPP_S5, NONE),
	PAD_NC(GPP_S6, NONE),
	PAD_NC(GPP_S7, NONE),

	/* ------- GPIO Group GPP_T ------- */
	PAD_NC(GPP_T2, NONE),
	PAD_NC(GPP_T3, NONE),
};

void mainboard_configure_gpios(void)
{
	gpio_configure_pads(gpio_table, ARRAY_SIZE(gpio_table));
}
