# Quickstep Density Functional Theory

## Description

Ab-initio molecular dynamics of liquid water using the Born-Oppenheimer approach,
using [Quickstep](https://www.cp2k.org/quickstep) DFT. Production quality settings
for the basis sets (TZV2P) and the planewave cutoff (280 Ry) are chosen, and the
Local Density Approximation (LDA) is used for the calculation of the Exchange-Correlation
energy. The configurations were generated by classical equilibration, and the
initial guess of the electronic density is made based on Atomic Orbitals.

## Benchmarks

- [`H2O-32.inp`](H2O-32.inp): a system of 32 water molecules (96 atoms,
  256 electrons) in a 9.9 cubic angstrom cell and MD is run for 10 steps
- [`H2O-64.inp`](H2O-64.inp): a system of 64 water molecules (192 atoms,
  512 electrons) in a 12.4 cubic angstrom cell and MD is run for 10 steps
- [`H2O-128.inp`](H2O-128.inp): a system of 128 water molecules (384 atoms,
  1'024 electrons) in a 15.6 cubic angstrom cell and MD is run for 10 steps
- [`H2O-256.inp`](H2O-256.inp): a system of 256 water molecules (768 atoms,
  2'048 electrons) in a 19.7 cubic angstrom cell and MD is run for 10 steps
- [`H2O-512.inp`](H2O-512.inp): a system of 512 water molecules (1'536 atoms,
  4'096 electrons) in a 24.9 cubic angstrom cell and MD is run for 10 steps
- [`H2O-1024.inp`](H2O-1024.inp): a system of 1'024 water molecules (3'072 atoms,
  8'192 electrons) in a 31.3 cubic angstrom cell and MD is run for 10 steps
- [`H2O-2048.inp`](H2O-2048.inp): a system of 2'048 water molecules (6'144 atoms,
  16'384 electrons) in a 39.5 cubic angstrom cell and MD is run for 10 steps
- [`H2O-4096.inp`](H2O-4096.inp): a system of 4'096 water molecules (12'288 atoms,
  32'768 electrons) in a 49.7 cubic angstrom cell and MD is run for 10 steps
- [`H2O-8192.inp`](H2O-8192.inp): a system of 8'192 water molecules (24'576 atoms,
  65'536 electrons) in a 62.7 cubic angstrom cell and MD is run for 10 steps

## Results

The best configurations are shown below.
Click the links under "Detailed Results" to see more detail.

<!-- markdownlint-disable MD013 -->
| Machine Name | Architecture | Date       | SVN Revision | Fastest time (s) | Number of Cores | Number of Threads                 | Detailed Results |
| ------------ | ------------ | ---------- | ------------ | ---------------- | --------------- | --------------------------------- | ---------------- |
| HECToR       | Cray XE6     | 21/1/2014  | 13196        | 39.066           | 512 cores       | 2 OMP threads per MPI task        | [hector-h2o-64](https://www.cp2k.org/performance:hector-h2o-64) |
| ARCHER       | Cray XC30    | 8/1/2014   | 13473        | 18.11            | 576 cores       | 1 OMP thread per MPI task         | [archer-h2o-64](https://www.cp2k.org/performance:archer-h2o-64) |
| Magnus       | Cray XC40    | 22/10/2014 | 14377        | 17.275           | 384 cores       | 1 OMP thread per MPI task         | [magnus-h2o-64](https://www.cp2k.org/performance:magnus-h2o-64) |
| Piz Daint    | Cray XC30    | 12/05/2015 | 15268        | 19.885           | 192 cores       | 1 OMP thread per MPI task, no GPU | [piz-daint-h2o-64](https://www.cp2k.org/performance:piz-daint-h2o-64) |
| Cirrus       | SGI ICE XA   | 24/11/2016 | 17566        | 15.560           | 1152 cores      | 9 OMP threads per MPI task        | [cirrus-h2o-64](https://www.cp2k.org/performance:cirrus-h2o-64) |
| Noctua       | Cray CS500   | 25/09/2019 | 9f58d81      | 13.3             | 640 cores       | 10 OMP threads per MPI task       | [noctua-h2o-64](https://www.cp2k.org/performance:noctua-h2o-64) |
<!-- markdownlint-enable MD013 -->