// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file AllocTestType.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__ALLOCTESTTYPE_HPP
#define FAST_DDS_GENERATED__ALLOCTESTTYPE_HPP

#include <cstdint>
#include <utility>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(ALLOCTESTTYPE_SOURCE)
#define ALLOCTESTTYPE_DllAPI __declspec( dllexport )
#else
#define ALLOCTESTTYPE_DllAPI __declspec( dllimport )
#endif // ALLOCTESTTYPE_SOURCE
#else
#define ALLOCTESTTYPE_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define ALLOCTESTTYPE_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure AllocTestType defined by the user in the IDL file.
 * @ingroup AllocTestType
 */
class AllocTestType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AllocTestType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AllocTestType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AllocTestType that will be copied.
     */
    eProsima_user_DllExport AllocTestType(
            const AllocTestType& x)
    {
                    m_index = x.m_index;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AllocTestType that will be copied.
     */
    eProsima_user_DllExport AllocTestType(
            AllocTestType&& x) noexcept
    {
        m_index = x.m_index;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AllocTestType that will be copied.
     */
    eProsima_user_DllExport AllocTestType& operator =(
            const AllocTestType& x)
    {

                    m_index = x.m_index;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AllocTestType that will be copied.
     */
    eProsima_user_DllExport AllocTestType& operator =(
            AllocTestType&& x) noexcept
    {

        m_index = x.m_index;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AllocTestType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AllocTestType& x) const
    {
        return (m_index == x.m_index);
    }

    /*!
     * @brief Comparison operator.
     * @param x AllocTestType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AllocTestType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member index
     * @param _index New value for member index
     */
    eProsima_user_DllExport void index(
            uint32_t _index)
    {
        m_index = _index;
    }

    /*!
     * @brief This function returns the value of member index
     * @return Value of member index
     */
    eProsima_user_DllExport uint32_t index() const
    {
        return m_index;
    }

    /*!
     * @brief This function returns a reference to member index
     * @return Reference to member index
     */
    eProsima_user_DllExport uint32_t& index()
    {
        return m_index;
    }



private:

    uint32_t m_index{0};

};

#endif // _FAST_DDS_GENERATED_ALLOCTESTTYPE_HPP_


