/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __FOR_LOOP_STAT_HPP_INCLUDED
#define __FOR_LOOP_STAT_HPP_INCLUDED

#include "frontend/ast/LoopStat.hpp"
#include "frontend/ast/DiscreteRange.hpp"
#include "frontend/ast/ConstantDeclaration.hpp"

namespace ast {

/** for loop statement */
class ForLoopStat : public LoopStat {
public:
	//! c'tor
	/** @param lbl optional label of the loop.
          * @param stats sequential statements of the loop.
	  * @param loopVar loop counter variable.
	  * @param rng discrete range to iterate over.
	  * @param loc location of the for statement.
          */
	ForLoopStat(
		std::string *lbl,
		std::list<SeqStat*> *stats,
		ConstantDeclaration *loopVar,
		DiscreteRange *rng,
		Location loc
		) : 	LoopStat(lbl, stats, loc),
			loopVariable(loopVar),
			range(rng) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor &visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << "FOR " << this->loopVariable << " IN " 
			<< this->range << ';';
	}


	/** loop counter variable */
	ConstantDeclaration *loopVariable;

	/** discrete range that gets iterated over. */
	DiscreteRange *range;

protected:
	/** Destructor */
	virtual ~ForLoopStat() {
		util::MiscUtil::terminate(loopVariable);
		util::MiscUtil::terminate(range);
	}

};

}; /* namespace ast */

#endif /* __FOR_LOOP_STAT_HPP_INCLUDED */
