# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


### Firefox Home / New Tab strings for about:home / about:newtab.

newtab-page-title = ᱱᱟᱶᱟ ᱴᱮᱵᱽ
newtab-settings-button =
    .title = ᱟᱢᱟᱜ ᱱᱟᱶᱟ ᱴᱮᱵᱽ ᱥᱟᱦᱴᱟ ᱥᱟᱡᱟᱣ ᱢᱮ
newtab-personalize-settings-icon-label =
    .title = ᱱᱟᱶᱟ ᱴᱮᱵᱽ ᱥᱟᱡᱟᱣ ᱢᱮ
    .aria-label = ᱥᱟᱡᱟᱣᱠᱚ
newtab-settings-dialog-label =
    .aria-label = ᱥᱟᱡᱟᱣ ᱠᱚ
newtab-personalize-icon-label =
    .title = ᱱᱟᱶᱟ ᱴᱮᱵᱽ ᱥᱟᱡᱟᱣ ᱢᱮ
    .aria-label = ᱱᱟᱶᱟ ᱴᱮᱵᱽ ᱥᱟᱡᱟᱣ ᱢᱮ
newtab-personalize-dialog-label =
    .aria-label = ᱥᱟᱡᱟᱣ
newtab-logo-and-wordmark =
    .aria-label = { -brand-full-name }

## Search box component.

# "Search" is a verb/action
newtab-search-box-search-button =
    .title = ᱥᱮᱸᱫᱽᱨᱟ
    .aria-label = ᱥᱮᱸᱫᱽᱨᱟ
# Variables:
#   $engine (string) - The name of the user's default search engine
newtab-search-box-handoff-text = { $engine } ᱥᱟᱶ ᱥᱮᱸᱫᱽᱨᱟ ᱟᱨ ᱵᱟᱝ ᱴᱷᱤᱠᱬᱟᱹ ᱟᱫᱮᱨ ᱢᱮ
newtab-search-box-handoff-text-no-engine = ᱴᱷᱤᱠᱬᱟᱹ ᱯᱟᱱᱛᱮ ᱟᱨ ᱵᱟᱝ ᱥᱮᱸᱫᱽᱨᱟ
# Variables:
#   $engine (string) - The name of the user's default search engine
newtab-search-box-handoff-input =
    .placeholder = { $engine } ᱥᱟᱶ ᱥᱮᱸᱫᱽᱨᱟ ᱟᱨ ᱵᱟᱝ ᱴᱷᱤᱠᱬᱟᱹ ᱟᱫᱮᱨ ᱢᱮ
    .title = { $engine } ᱥᱟᱶ ᱥᱮᱸᱫᱽᱨᱟ ᱟᱨ ᱵᱟᱝ ᱴᱷᱤᱠᱬᱟᱹ ᱟᱫᱮᱨ ᱢᱮ
    .aria-label = { $engine } ᱥᱟᱶ ᱥᱮᱸᱫᱽᱨᱟ ᱟᱨ ᱵᱟᱝ ᱴᱷᱤᱠᱬᱟᱹ ᱟᱫᱮᱨ ᱢᱮ
newtab-search-box-handoff-input-no-engine =
    .placeholder = ᱴᱷᱤᱠᱬᱟᱹ ᱯᱟᱱᱛᱮ ᱟᱨ ᱵᱟᱝ ᱥᱮᱸᱫᱽᱨᱟ
    .title = ᱴᱷᱤᱠᱬᱟᱹ ᱯᱟᱱᱛᱮ ᱟᱨ ᱵᱟᱝ ᱥᱮᱸᱫᱽᱨᱟ
    .aria-label = ᱴᱷᱤᱠᱬᱟᱹ ᱯᱟᱱᱛᱮ ᱟᱨ ᱵᱟᱝ ᱥᱮᱸᱫᱽᱨᱟ
newtab-search-box-text = ᱣᱮᱵᱽ ᱨᱮ ᱥᱮᱸᱫᱽᱨᱟᱭ ᱢᱮ
newtab-search-box-input =
    .placeholder = ᱣᱮᱵᱽ ᱨᱮ ᱥᱮᱸᱫᱽᱨᱟᱭ ᱢᱮ
    .aria-label = ᱣᱮᱵᱽ ᱨᱮ ᱥᱮᱸᱫᱽᱨᱟᱭ ᱢᱮ

## Top Sites - General form dialog.

newtab-topsites-add-search-engine-header = ᱥᱮᱸᱫᱽᱨᱟ ᱤᱧᱡᱤᱱ ᱥᱮᱞᱮᱫ ᱢᱮ
newtab-topsites-add-shortcut-header = ᱱᱟᱶᱟ ᱠᱷᱟᱴᱚᱢᱟᱪᱷᱟ
newtab-topsites-edit-topsites-header = ᱪᱮᱛᱟᱱ ᱨᱤᱱ ᱥᱟᱭᱤᱴ ᱥᱟᱯᱲᱟᱣ ᱢᱮ
newtab-topsites-edit-shortcut-header = ᱠᱷᱟᱴᱚᱢᱟᱪᱷᱟ ᱥᱟᱯᱲᱟᱣ ᱢᱮ
newtab-topsites-add-shortcut-label = ᱠᱷᱟᱴᱚᱢᱟᱪᱷᱟ ᱥᱮᱞᱮᱫᱽ ᱢᱮ
newtab-topsites-title-label = ᱧᱩᱛᱩᱢ
newtab-topsites-title-input =
    .placeholder = ᱧᱩᱛᱩᱢ ᱟᱫᱮᱨ ᱢᱮ
newtab-topsites-url-label = URL
newtab-topsites-url-input =
    .placeholder = ᱢᱤᱫᱴᱟᱝ URL ᱚᱞ ᱢᱮ ᱟᱨᱵᱟᱝᱠᱷᱟᱱ ᱞᱟᱴᱷᱟᱭ ᱢᱮ
newtab-topsites-url-validation = ᱴᱷᱤᱠ URL ᱫᱚᱨᱠᱟᱨ ᱠᱟᱱᱟ
newtab-topsites-image-url-label = ᱱᱤᱡᱚᱨ URL ᱪᱤᱛᱟᱹᱨ
newtab-topsites-use-image-link = ᱱᱤᱡᱚᱨ ᱪᱤᱛᱟᱹᱨ ᱵᱮᱵᱷᱟᱨ ᱢᱮ …
newtab-topsites-image-validation = ᱪᱤᱛᱟᱹᱨ ᱞᱟᱫᱮ ᱰᱤᱜᱟᱹᱣ ᱮᱱᱟ ᱾ ᱮᱴᱟᱜ URL ᱪᱮᱥᱴᱟ ᱵᱤᱲᱟᱹᱣ ᱢᱮ ᱾

## Top Sites - General form dialog buttons. These are verbs/actions.

newtab-topsites-cancel-button = ᱵᱟᱹᱰᱨᱟᱹ
newtab-topsites-delete-history-button = ᱱᱟᱜᱟᱢ ᱠᱷᱚᱱ ᱢᱮᱴᱟᱣ ᱢᱮ
newtab-topsites-save-button = ᱥᱟᱺᱪᱟᱣ ᱢᱮ
newtab-topsites-preview-button = ᱢᱟᱲᱟᱝ ᱧᱮᱞ ᱵᱤᱲᱟᱹᱣ
newtab-topsites-add-button = ᱥᱮᱞᱮᱫᱽ ᱢᱮ

## Top Sites - Delete history confirmation dialog.

newtab-confirm-delete-history-p1 = ᱟᱢ ᱥᱟᱹᱨᱤ ᱛᱮ ᱱᱚᱶᱟ ᱥᱟᱦᱴᱟ ᱨᱮᱭᱟᱜ ᱠᱟᱹᱢᱤ ᱦᱚᱨᱟ ᱟᱢᱟᱜ ᱦᱤᱛᱟᱹᱞ ᱠᱷᱚᱱ ᱢᱮᱴᱟᱣ ᱥᱮᱱᱟᱢ ᱠᱟᱱᱟ ᱥᱮ ?
# "This action" refers to deleting a page from history.
newtab-confirm-delete-history-p2 = ᱱᱚᱶᱟ ᱠᱟᱹᱢᱤ ᱥᱟᱹᱛ ᱵᱟᱝ ᱫᱟᱲᱮᱭᱟᱜᱼᱟ ᱾

## Top Sites - Sponsored label

newtab-topsite-sponsored = ᱠᱟᱹᱢᱤᱼᱤᱭᱟᱹ

## Context Menu - Action Tooltips.

# General tooltip for context menus.
newtab-menu-section-tooltip =
    .title = ᱢᱮᱱᱩ ᱡᱷᱤᱡᱽ ᱢᱮ
    .aria-label = ᱢᱮᱱᱩ ᱡᱷᱤᱡᱽ ᱢᱮ
# Tooltip for dismiss button
newtab-dismiss-button-tooltip =
    .title = ᱚᱪᱚᱜᱽ ᱢᱮ
    .aria-label = ᱚᱪᱚᱜᱽ ᱢᱮ
# This tooltip is for the context menu of Pocket cards or Topsites
# Variables:
#   $title (string) - The label or hostname of the site. This is for screen readers when the context menu button is focused/active.
newtab-menu-content-tooltip =
    .title = ᱢᱮᱱᱩ ᱡᱷᱤᱡᱽ ᱢᱮ
    .aria-label = { $title } ᱞᱟᱹᱜᱤᱫ ᱠᱚᱱᱴᱮᱠᱥᱴ ᱢᱮᱱᱩ ᱠᱷᱩᱞᱟᱹᱭ ᱢᱮ
# Tooltip on an empty topsite box to open the New Top Site dialog.
newtab-menu-topsites-placeholder-tooltip =
    .title = ᱱᱚᱶᱟ ᱴᱮᱵᱽ ᱥᱟᱯᱲᱟᱣ ᱢᱮ
    .aria-label = ᱱᱚᱶᱟ ᱴᱮᱵᱽ ᱥᱟᱯᱲᱟᱣ ᱢᱮ

## Context Menu: These strings are displayed in a context menu and are meant as a call to action for a given page.

newtab-menu-edit-topsites = ᱥᱟᱯᱲᱟᱣ
newtab-menu-open-new-window = ᱱᱟᱶᱟ ᱣᱤᱱᱰᱳ ᱨᱮ ᱡᱷᱤᱡᱽ ᱢᱮ
newtab-menu-open-new-private-window = ᱱᱟᱶᱟ ᱱᱤᱡᱚᱨ ᱣᱤᱱᱰᱳ ᱨᱮ ᱡᱷᱤᱡᱽ ᱢᱮ
newtab-menu-dismiss = ᱵᱚᱸᱫ
newtab-menu-pin = ᱞᱟᱴᱷᱟ
newtab-menu-unpin = ᱚᱪᱚᱜᱽ
newtab-menu-delete-history = ᱱᱟᱜᱟᱢ ᱠᱷᱚᱱ ᱢᱮᱴᱟᱣ ᱢᱮ
newtab-menu-save-to-pocket = { -pocket-brand-name } ᱨᱮ ᱥᱟᱧᱪᱟᱣ ᱢᱮ
newtab-menu-delete-pocket = { -pocket-brand-name } ᱠᱷᱚᱱ ᱢᱮᱴᱟᱣ ᱢᱮ
newtab-menu-archive-pocket = { -pocket-brand-name } ᱨᱮ ᱫᱚᱦᱚ ᱵᱟᱭ ᱠᱟᱜ ᱢᱮ
newtab-menu-show-privacy-info = ᱟᱞᱮ ᱠᱟᱹᱢᱤᱠᱚ ᱟᱨ ᱟᱢᱟᱜ ᱱᱤᱥᱚᱱ ᱠᱚ
newtab-menu-about-fakespot = { -fakespot-brand-name } ᱵᱚᱵᱚᱛ

## Message displayed in a modal window to explain privacy and provide context for sponsored content.

newtab-privacy-modal-button-done = ᱦᱩᱭᱮᱱᱟ
newtab-privacy-modal-button-manage = ᱜᱚᱲᱚ ᱠᱟᱱ ᱡᱤᱱᱤᱥ ᱥᱟᱡᱟᱣ ᱠᱚ ᱥᱚᱢᱵᱷᱲᱟᱣ ᱢᱮ
newtab-privacy-modal-header = ᱟᱢᱟᱜ ᱱᱤᱥᱚᱱ ᱞᱟᱹᱠᱛᱤ ᱠᱟᱱᱟ ᱾
newtab-privacy-modal-paragraph-2 =
    ᱡᱚᱛᱚ ᱠᱷᱚᱱ ᱱᱟᱯᱟᱭ ᱠᱟᱹᱦᱱᱤ ᱠᱚ ᱮᱢᱚᱜ ᱥᱟᱶᱛᱮ, ᱟᱯᱮ ᱠᱚ ᱞᱟᱹᱜᱤᱫ ᱥᱚᱨᱮᱥ, ᱟᱹᱰᱤ ᱱᱟᱯᱟᱭ ᱵᱟᱷᱪᱟᱣ ᱠᱟᱱ ᱥᱯᱳᱱᱥᱚᱨ ᱠᱚ ᱠᱷᱚᱱ ᱠᱟᱹᱦᱱᱤ ᱠᱚ ᱟᱯᱮ ᱠᱚ ᱴᱷᱮᱱ ᱞᱮ ᱯᱟᱨᱥᱟᱞ ᱟ ᱾ 
    ᱱᱤᱥᱪᱤᱱᱛ ᱛᱟᱦᱮᱸᱱ ᱢᱮ, <strong>ᱟᱢᱟᱜ ᱵᱽᱨᱟᱣᱡᱤᱝ ᱰᱟᱴᱟ ᱫᱚ ᱟᱢᱟᱜ { -brand-product-name } ᱠᱷᱚᱱ ᱛᱤᱥ ᱦᱚᱸ ᱵᱟᱦᱨᱮ ᱛᱮ ᱵᱟᱭ ᱪᱟᱞᱟᱜᱼᱟ</strong> - ᱟᱞᱮ ᱫᱚ ᱵᱟᱞᱮ ᱧᱮᱞ ᱫᱟᱲᱮᱭᱟᱜᱼᱟ, ᱟᱨ ᱟᱞᱮ ᱨᱤᱱ ᱠᱚ ᱢᱟᱸ ᱢᱩᱴᱮ ᱵᱟᱝᱟ ᱾
newtab-privacy-modal-link = ᱱᱟᱶᱟ ᱴᱮᱵᱽ ᱨᱮ ᱯᱚᱨᱟᱭᱵᱟᱥᱤ ᱪᱮᱫ ᱞᱮᱠᱟᱭ ᱠᱟᱹᱢᱤᱟᱭ ᱵᱟᱲᱟᱭ ᱢᱮ

##

# Bookmark is a noun in this case, "Remove bookmark".
newtab-menu-remove-bookmark = ᱵᱩᱩᱠᱢᱟᱨᱠ ᱚᱪᱚᱜ ᱢᱮ
# Bookmark is a verb here.
newtab-menu-bookmark = ᱯᱩᱛᱷᱤ ᱪᱤᱱᱦᱟ.

## Context Menu - Downloaded Menu. "Download" in these cases is not a verb,
## it is a noun. As in, "Copy the link that belongs to this downloaded item".

newtab-menu-copy-download-link = ᱰᱟᱣᱱᱞᱚᱰ ᱞᱤᱝᱠ ᱱᱚᱠᱚᱞ ᱢᱮ
newtab-menu-go-to-download-page = ᱰᱟᱣᱱᱞᱚᱰ ᱥᱟᱦᱴᱟ ᱥᱮᱫ ᱪᱟᱞᱟᱜ ᱢᱮ
newtab-menu-remove-download = ᱱᱟᱜᱟᱢ ᱠᱷᱚᱱ ᱚᱪᱚᱜᱽ ᱢᱮ

## Context Menu - Download Menu: These are platform specific strings found in the context menu of an item that has
## been downloaded. The intention behind "this action" is that it will show where the downloaded file exists on the file
## system for each operating system.

newtab-menu-show-file =
    { PLATFORM() ->
        [macos] ᱯᱟᱱᱛᱮᱭᱟᱜ ᱨᱮ ᱫᱮᱠᱷᱟᱣ ᱢᱮ
       *[other] ᱢᱮᱱᱟᱜ ᱯᱚᱴᱚᱢ ᱧᱮᱞ ᱢᱮ
    }
newtab-menu-open-file = ᱨᱮᱫ ᱡᱷᱤᱡᱽ ᱢᱮ

## Card Labels: These labels are associated to pages to give
## context on how the element is related to the user, e.g. type indicates that
## the page is bookmarked, or is currently open on another device.

newtab-label-visited = ᱧᱮᱞᱟᱜ
newtab-label-bookmarked = ᱯᱩᱛᱷᱤ ᱪᱤᱱᱦᱟ. ᱠᱟᱱ
newtab-label-removed-bookmark = ᱵᱩᱠᱢᱟᱨᱠ ᱚᱪᱚᱜᱟᱠᱟᱱᱟ
newtab-label-recommended = ᱴᱨᱮᱱᱰᱤᱝ
newtab-label-saved = { -pocket-brand-name } ᱨᱮ ᱥᱟᱧᱪᱟᱣ ᱮᱱᱟ
newtab-label-download = ᱰᱟᱣᱱᱞᱚᱰ ᱦᱩᱭ
# This string is used in the story cards to indicate sponsored content
# Variables:
#   $sponsorOrSource (string) - The name of a company or their domain
newtab-label-sponsored = { $sponsorOrSource } · ᱜᱚᱲᱚᱭᱤᱡ
# This string is used at the bottom of story cards to indicate sponsored content
# Variables:
#   $sponsor (string) - The name of a sponsor
newtab-label-sponsored-by = ᱜᱚᱲᱚᱭᱤᱡ ᱫᱚ { $sponsor }
# This string is used under the image of story cards to indicate source and time to read
# Variables:
#   $source (string) - The name of a company or their domain
#   $timeToRead (number) - The estimated number of minutes to read this story
newtab-label-source-read-time = { $source } · { $timeToRead } ᱴᱤᱯᱤᱡ

## Section Menu: These strings are displayed in the section context menu and are
## meant as a call to action for the given section.

newtab-section-menu-remove-section = ᱛᱷᱚᱠ ᱚᱪᱚᱜᱽ ᱢᱮ
newtab-section-menu-collapse-section = ᱦᱟᱹᱴᱤᱧ ᱦᱩᱰᱤᱧ ᱪᱷᱚᱭ ᱢᱮ
newtab-section-menu-expand-section = ᱦᱟᱹᱴᱤᱧ ᱢᱟᱨᱟᱝ ᱪᱷᱚᱭ ᱢᱮ
newtab-section-menu-manage-section = ᱦᱟᱹᱴᱤᱧ ᱥᱚᱢᱵᱷᱲᱟᱣ ᱢᱮ
newtab-section-menu-manage-webext = ᱮᱠᱮᱴᱮᱱᱮᱚᱱ ᱢᱮᱱᱟᱡᱽ ᱢᱮ
newtab-section-menu-add-topsite = ᱪᱮᱛᱟᱱ ᱨᱤᱱᱟᱜ ᱥᱟᱭᱤᱴ ᱥᱮᱞᱮᱫ ᱢᱮ
newtab-section-menu-add-search-engine = ᱥᱮᱸᱫᱽᱨᱟ ᱤᱧᱡᱤᱱ ᱥᱮᱞᱮᱫ ᱢᱮ
newtab-section-menu-move-up = ᱪᱮᱛᱟᱱ ᱥᱮᱫ ᱥᱟᱦᱟ
newtab-section-menu-move-down = ᱞᱟᱛᱟᱨ ᱪᱟᱞᱟᱣ
newtab-section-menu-privacy-notice = ᱫᱟᱱᱟᱝ ᱠᱷᱚᱵᱚᱨ

## Section aria-labels

newtab-section-collapse-section-label =
    .aria-label = ᱦᱟᱹᱴᱤᱧ ᱦᱩᱰᱤᱧ ᱪᱷᱚᱭ ᱢᱮ
newtab-section-expand-section-label =
    .aria-label = ᱦᱟᱹᱴᱤᱧ ᱢᱟᱨᱟᱝ ᱪᱷᱚᱭ ᱢᱮ

## Section Headers.

newtab-section-header-topsites = ᱪᱮᱛᱟᱱ ᱨᱤᱱ ᱥᱟᱭᱤᱴ
newtab-section-header-recent-activity = ᱱᱤᱛᱚᱜᱟᱜ ᱠᱟᱹᱢᱤ
# Variables:
#   $provider (string) - Name of the corresponding content provider.
newtab-section-header-pocket = { $provider } ᱨᱮᱭᱟᱜ ᱵᱟᱛᱟᱣᱟᱜ
newtab-section-header-stories = ᱢᱚᱱᱮᱼᱜᱷᱟᱱᱴᱟ ᱠᱟᱹᱦᱱᱤ ᱠᱚ
# "picks" refers to recommended articles
newtab-section-header-todays-picks = ᱟᱢ ᱞᱟᱹᱜᱤᱫ ᱛᱟᱦᱮᱸᱧᱟᱜ ᱦᱟᱛᱟᱣ

## Empty Section States: These show when there are no more items in a section. Ex. When there are no more Pocket story recommendations, in the space where there would have been stories, this is shown instead.

newtab-empty-section-highlights = ᱵᱽᱨᱟᱣᱡᱤᱝ ᱮᱛᱚᱦᱚᱵ ᱢᱮ, ᱟᱨ ᱟᱢ ᱡᱟᱦᱟᱸᱱ ᱱᱟᱯᱟᱭ ᱚᱱᱚᱞ, ᱵᱷᱤᱰᱤᱭᱳ ᱟᱨ ᱮᱴᱟᱜ ᱥᱟᱦᱴᱟ ᱠᱚ ᱞᱮ ᱫᱮᱠᱷᱟᱣ ᱟᱢᱟ ᱡᱟᱦᱟᱸ ᱫᱚ ᱟᱢ ᱱᱮᱞᱮ ᱮᱢ ᱧᱮᱞ ᱠᱟᱫᱟ ᱵᱟᱝᱠᱷᱟᱱ ᱡᱟᱦᱟᱸ ᱯᱩᱛᱷᱤᱪᱤᱱᱦᱟᱹ ᱠᱟᱫᱟᱢ ᱾
# Ex. When there are no more Pocket story recommendations, in the space where there would have been stories, this is shown instead.
# Variables:
#   $provider (string) - Name of the content provider for this section, e.g "Pocket".
newtab-empty-section-topstories = ᱡᱷᱚᱛᱚ ᱪᱟᱵᱟ ᱮᱱᱟ ᱾ { $provider } ᱠᱷᱚᱱ ᱟᱨᱦᱚᱸ ᱰᱷᱮᱨ ᱠᱟᱹᱦᱱᱤ ᱞᱟᱹᱜᱤᱫ ᱛᱟᱭᱚᱢ ᱛᱮ ᱧᱮᱞ ᱢᱮ ᱾ ᱵᱟᱝ ᱛᱟᱹᱝᱜᱤ ᱫᱟᱲᱮᱭᱟᱜ ᱠᱟᱱᱟᱢ ? ᱣᱮᱵᱽ ᱡᱟᱠᱟᱛ ᱠᱷᱚᱱ ᱟᱨᱦᱚᱸ ᱱᱟᱯᱟᱭ ᱠᱟᱹᱦᱤᱱᱤ ᱧᱟᱢ ᱞᱟᱹᱜᱤᱫ ᱢᱤᱫ ᱧᱩᱛᱩᱢᱟᱱ ᱡᱤᱱᱤᱥ ᱵᱟᱪᱷᱟᱣ ᱢᱮ ᱾
# Ex. When there are no more story recommendations, in the space where there would have been stories, this is shown instead.
newtab-empty-section-topstories-generic = ᱡᱷᱚᱛᱚ ᱪᱟᱵᱟ ᱮᱱᱟ ᱾ ᱰᱷᱮᱨ ᱠᱟᱹᱦᱱᱤ ᱞᱟᱹᱜᱤᱫ ᱛᱟᱭᱚᱢ ᱛᱮ ᱧᱮᱞ ᱢᱮ ᱾ ᱵᱟᱝ ᱛᱟᱹᱝᱜᱤ ᱫᱟᱲᱮᱭᱟᱜ ᱠᱟᱱᱟᱢ ? ᱣᱮᱵᱽ ᱡᱟᱠᱟᱛ ᱠᱷᱚᱱ ᱟᱨᱦᱚᱸ ᱱᱟᱯᱟᱭ ᱠᱟᱹᱦᱤᱱᱤ ᱧᱟᱢ ᱞᱟᱹᱜᱤᱫ ᱢᱤᱫ ᱧᱩᱛᱩᱢᱟᱱ ᱡᱤᱱᱤᱥ ᱵᱟᱪᱷᱟᱣ ᱢᱮ ᱾

## Empty Section (Content Discovery Experience). These show when there are no more stories or when some stories fail to load.

newtab-discovery-empty-section-topstories-header = ᱡᱷᱚᱛᱚ ᱧᱮᱞ ᱦᱩᱭ ᱠᱮᱜᱼᱟᱢ !
newtab-discovery-empty-section-topstories-content = ᱰᱷᱮᱨ ᱠᱟᱹᱦᱱᱤ ᱞᱟᱹᱜᱤᱫ ᱛᱟᱭᱚᱢ ᱛᱮ ᱧᱮᱞ ᱢᱮ ᱾
newtab-discovery-empty-section-topstories-try-again-button = ᱫᱩᱦᱲᱟᱹ ᱠᱩᱨᱩᱢᱩᱴᱩ
newtab-discovery-empty-section-topstories-loading = ᱞᱟᱫᱮᱜ ᱠᱟᱱᱟ …
# Displays when a layout in a section took too long to fetch articles.
newtab-discovery-empty-section-topstories-timed-out = ᱮᱦᱮ! ᱱᱚᱶᱟ ᱡᱟᱭᱜᱟ ᱨᱮ ᱞᱮ ᱞᱮᱫᱮ ᱠᱟᱫ ᱜᱮᱭᱟ ᱞᱮ, ᱞᱟᱫᱮ ᱠᱟᱹᱢᱤ ᱵᱟᱭ ᱯᱩᱨᱟᱹᱣ ᱠᱟᱱᱟ ᱾

## Pocket Content Section.

# This is shown at the bottom of the trending stories section and precedes a list of links to popular topics.
newtab-pocket-read-more = ᱧᱩᱛᱩᱢᱟᱱ ᱵᱤᱥᱚᱭ ᱠᱚ :
newtab-pocket-new-topics-title = ᱟᱨᱦᱚᱸ ᱰᱷᱮᱨ ᱠᱟᱹᱦᱱᱤ ᱠᱚ ᱫᱚᱨᱠᱟᱨ ᱠᱟᱱᱟ ᱥᱮ ? { -pocket-brand-name } ᱠᱷᱚᱱ ᱧᱩᱛᱩᱢᱟᱱ ᱡᱤᱱᱤᱥ ᱠᱚ ᱧᱮᱞ ᱢᱮ ᱾
newtab-pocket-more-recommendations = ᱰᱷᱮᱨ ᱵᱟᱛᱟᱣᱟᱜ ᱠᱚ
newtab-pocket-learn-more = ᱰᱷᱮᱨ ᱥᱮᱬᱟᱭ ᱢᱮ
newtab-pocket-cta-button = { -pocket-brand-name } ᱧᱟᱢ ᱢᱮ
newtab-pocket-cta-text = { -pocket-brand-name } ᱨᱮ ᱟᱢᱟᱜ ᱠᱩᱥᱤ ᱠᱟᱹᱦᱱᱤ ᱠᱚ ᱥᱟᱧᱪᱟᱣ ᱢᱮ, ᱟᱨ ᱵᱮᱥ ᱡᱤᱱᱤᱥ ᱠᱚ ᱮᱢᱟᱱ ᱯᱟᱲᱦᱟᱣ ᱢᱮ ᱾
newtab-pocket-pocket-firefox-family = { -pocket-brand-name } ᱫᱚ { -brand-product-name } ᱜᱷᱟᱨᱚᱧᱡᱽ ᱨᱮᱭᱟᱜ ᱦᱟᱹᱴᱤᱧ ᱠᱟᱱᱟ
# A save to Pocket button that shows over the card thumbnail on hover.
newtab-pocket-image =
    .aria-label = { -pocket-brand-name }
newtab-pocket-save = ᱥᱟᱺᱪᱟᱣ ᱢᱮ
newtab-pocket-saved = ᱥᱟᱺᱪᱟᱣᱮᱱᱟ

## Thumbs up and down buttons that shows over a newtab stories card thumbnail on hover.

# Clicking the thumbs up button for this story will result in more stories like this one being recommended
newtab-pocket-thumbs-up-tooltip =
    .title = ᱱᱚᱠᱟ ᱞᱮᱠᱷᱟ ᱟᱨᱦᱚᱸ
# Clicking the thumbs down button for this story informs us that the user does not feel like the story is interesting for them
newtab-pocket-thumbs-down-tooltip =
    .title = ᱤᱧ ᱞᱟᱹᱜᱤᱫ ᱫᱚ ᱵᱟᱝᱟ
# Used to show the user a message upon clicking the thumbs up or down buttons
newtab-toast-thumbs-up-or-down2 =
    .message = ᱥᱟᱨᱦᱟᱣ ᱾ ᱟᱢᱟᱜ ᱢᱚᱱᱚᱛ ᱟᱞᱮ ᱟᱢᱟᱜ ᱢᱚᱱᱚᱛ ᱥᱩᱫᱷᱨᱟᱹᱣ ᱞᱟᱹᱜᱤᱫ ᱜᱚᱲᱚ ᱞᱮ ᱮᱢᱟᱭᱟ ᱾
newtab-toast-thumbs-up-or-down = ᱥᱟᱨᱦᱟᱣ ᱾ ᱟᱢᱟᱜ ᱢᱚᱱᱚᱛ ᱟᱞᱮ ᱟᱢᱟᱜ ᱢᱚᱱᱚᱛ ᱥᱩᱫᱷᱨᱟᱹᱣ ᱞᱟᱹᱜᱤᱫ ᱜᱚᱲᱚ ᱞᱮ ᱮᱢᱟᱭᱟ ᱾
newtab-toast-dismiss-button =
    .title = ᱵᱚᱸᱫ
    .aria-label = ᱵᱚᱸᱫ

## Pocket content onboarding experience dialog and modal for new users seeing the Pocket section for the first time, shown as the first item in the Pocket section.

newtab-pocket-onboarding-discover = ᱣᱮᱵ ᱨᱮᱭᱟᱜ ᱡᱚᱛᱚ ᱠᱷᱚᱱ ᱱᱟᱯᱟᱭ ᱡᱤᱱᱤᱥ ᱦᱟᱛᱟᱣ ᱢᱮ
newtab-pocket-onboarding-cta = { -pocket-brand-name } ᱟᱢᱟᱜ { -brand-product-name } ᱵᱽᱨᱟᱣᱡᱚᱨ ᱨᱮ ᱡᱚᱛᱚ ᱠᱷᱚᱱ ᱱᱟᱯᱟᱭ, ᱥᱚᱨᱮᱥ ᱠᱟᱛᱷᱟ ᱠᱚ ᱧᱟᱢ ᱞᱟᱹᱜᱤᱫ ᱟᱹᱰᱤ ᱞᱮᱠᱟᱱ ᱯᱚᱵᱞᱤᱠᱮᱥᱚᱱ ᱮ ᱥᱮᱸᱫᱽᱨᱟ ᱮᱫᱟᱭ ᱾

## Error Fallback Content.
## This message and suggested action link are shown in each section of UI that fails to render.

newtab-error-fallback-info = ᱮᱦᱮ, ᱱᱚᱶᱟ ᱡᱤᱱᱤᱥ ᱞᱟᱫᱮ ᱡᱷᱚᱜ ᱪᱮᱫ ᱪᱷᱚᱸ ᱵᱷᱩᱞ ᱦᱩᱭ ᱮᱱᱟ ᱾
newtab-error-fallback-refresh-link = ᱫᱩᱦᱲᱟᱹ ᱠᱩᱨᱩᱢᱩᱴᱩ ᱞᱟᱹᱜᱤᱫ ᱥᱟᱦᱴᱟ ᱯᱷᱟᱨᱱᱟᱭ ᱢᱮ ᱾

## Customization Menu

newtab-custom-shortcuts-title = ᱠᱷᱟᱴᱚᱢᱟᱪᱷᱟ
newtab-custom-shortcuts-subtitle = ᱟᱢ ᱥᱟᱺᱪᱟᱣ ᱠᱟᱫ ᱟᱨ ᱵᱟᱝ ᱪᱟᱞᱟᱜ ᱠᱟᱱ ᱥᱟᱭᱤᱴ ᱠᱚ
newtab-custom-shortcuts-toggle =
    .label = ᱠᱷᱟᱴᱚᱢᱟᱪᱷᱟ
    .description = ᱟᱢ ᱥᱟᱺᱪᱟᱣ ᱠᱟᱫ ᱟᱨ ᱵᱟᱝ ᱪᱟᱞᱟᱜ ᱠᱟᱱ ᱥᱟᱭᱤᱴ ᱠᱚ
# Variables
#   $num (number) - Number of rows to display
newtab-custom-row-selector =
    { $num ->
        [one] { $num } ᱛᱷᱟᱨ
        [two] { $num } ᱛᱷᱟᱨ ᱠᱤᱱ
       *[other] { $num } ᱛᱷᱟᱨ ᱠᱚ
    }
newtab-custom-sponsored-sites = ᱠᱟᱹᱢᱤᱼᱤᱡ ᱠᱷᱟᱴᱚ ᱢᱟᱪᱷᱟ ᱠᱚ
newtab-custom-pocket-title = { -pocket-brand-name } ᱮᱛ ᱵᱟᱛᱟᱣᱟᱜ
newtab-custom-pocket-subtitle = { -pocket-brand-name } ᱫᱚ { -brand-product-name } ᱜᱷᱟᱨᱚᱸᱡᱽ ᱨᱮᱱᱟᱜ ᱢᱤᱫ ᱟᱹᱰᱤ ᱱᱟᱯᱟᱭ ᱞᱮᱠᱷᱟᱛᱮ ᱠᱭᱩᱨᱮᱴ ᱠᱟᱱᱟ
newtab-custom-stories-toggle =
    .label = ᱥᱚᱞᱦᱟ ᱟᱠᱟᱱ ᱠᱟᱹᱦᱱᱤ ᱠᱚ
    .description = { -brand-product-name } ᱜᱷᱟᱨᱚᱧᱡᱽ ᱦᱚᱛᱮᱛᱮ ᱠᱭᱩᱨᱮᱴ ᱟᱠᱟᱱ ᱥᱟᱨᱦᱟᱣᱮᱱ ᱡᱤᱱᱤᱥ
newtab-custom-pocket-sponsored = ᱜᱟᱲᱚ ᱠᱟᱱ ᱠᱟᱹᱦᱱᱤ ᱠᱚ
newtab-custom-pocket-show-recent-saves = ᱱᱮᱱᱮ ᱥᱟᱧᱪᱟᱣ ᱠᱚ ᱫᱮᱠᱷᱟᱣ ᱢᱮ
newtab-custom-recent-title = ᱱᱤᱛᱚᱜᱟᱜ ᱠᱟᱹᱢᱤ ᱠᱚ
newtab-custom-recent-subtitle = ᱱᱚᱱᱮᱛᱚᱜᱟᱜ ᱥᱟᱭᱤᱴ ᱟᱨ ᱡᱤᱱᱤᱥ ᱨᱮᱭᱟᱜ ᱢᱤᱫᱴᱟᱝ ᱵᱟᱪᱷᱟᱣ
newtab-custom-recent-toggle =
    .label = ᱱᱤᱛᱚᱜᱟᱜ ᱠᱟᱹᱢᱤ ᱠᱚ
    .description = ᱱᱚᱱᱮᱛᱚᱜᱟᱜ ᱥᱟᱭᱤᱴ ᱟᱨ ᱡᱤᱱᱤᱥ ᱨᱮᱭᱟᱜ ᱢᱤᱫᱴᱟᱝ ᱵᱟᱪᱷᱟᱣ
newtab-custom-weather-toggle =
    .label = ᱦᱚᱭ ᱦᱤᱥᱤᱫ
    .description = ᱢᱤᱫ ᱧᱮᱞ ᱛᱮ ᱛᱮᱦᱮᱧᱟᱜ ᱯᱷᱚᱨᱠᱟᱥᱴ
newtab-custom-close-button = ᱵᱚᱸᱫᱚᱭ ᱢᱮ
newtab-custom-settings = ᱥᱟᱡᱟᱣ ᱠᱚ ᱥᱚᱢᱵᱷᱲᱟᱣ ᱢᱮ

## New Tab Wallpapers

newtab-wallpaper-title = ᱠᱟᱸᱛᱷᱪᱤᱛᱟᱹᱨ
newtab-wallpaper-reset = ᱢᱩᱞ ᱞᱮᱠᱷᱟ ᱛᱮ ᱨᱤᱥᱮᱴ ᱢᱮ
newtab-wallpaper-light-red-panda = ᱟᱨᱟᱜ ᱯᱟᱱᱰᱟ
newtab-wallpaper-light-mountain = ᱯᱟᱸᱰ ᱵᱩᱨᱩ
newtab-wallpaper-light-sky = ᱵᱮᱝᱜᱟᱲ ᱟᱨ ᱜᱩᱞᱟᱯᱤ ᱨᱤᱢᱤᱞ ᱥᱟᱶ ᱥᱮᱨᱢᱟ
newtab-wallpaper-light-color = ᱞᱤᱞ, ᱜᱩᱞᱟᱯᱤ ᱟᱨ ᱥᱟᱥᱟᱝ ᱜᱚᱲᱦᱚᱱ
newtab-wallpaper-light-landscape = ᱞᱤᱞ ᱠᱩᱦᱲᱟ ᱵᱩᱨᱩ ᱞᱮᱱᱰᱥᱠᱮᱯ
newtab-wallpaper-light-beach = ᱛᱟᱞᱮ ᱫᱟᱨᱮ ᱥᱟᱶ ᱵᱤᱪ
newtab-wallpaper-dark-aurora = Aurora Borealis
newtab-wallpaper-dark-color = ᱟᱨᱟᱜ ᱟᱨ ᱞᱤᱞ ᱜᱚᱲᱦᱚᱱ
newtab-wallpaper-dark-panda = ᱟᱨᱟᱜ ᱯᱟᱱᱰᱟ ᱵᱤᱨ ᱨᱮ ᱩᱠᱩ ᱟᱠᱟᱱᱟ
newtab-wallpaper-dark-sky = ᱧᱤᱱᱫᱟᱹ ᱥᱮᱨᱢᱟ ᱥᱟᱶ ᱥᱚᱦᱚᱨ ᱞᱮᱱᱰᱥᱠᱮᱯ
newtab-wallpaper-dark-mountain = ᱞᱮᱱᱰᱥᱠᱮᱯ ᱵᱩᱨᱩ
newtab-wallpaper-dark-city = ᱵᱮᱝᱜᱟᱲ ᱥᱚᱦᱚᱨ ᱞᱮᱱᱰᱥᱠᱮᱯ
newtab-wallpaper-dark-fox-anniversary = ᱵᱤᱨ ᱥᱩᱨ ᱨᱮ ᱯᱷᱩᱴᱷᱯᱟᱛᱷ ᱨᱮ ᱢᱤᱫᱴᱟᱹᱝ ᱛᱩᱭᱩ
newtab-wallpaper-light-fox-anniversary = ᱢᱤᱫ ᱛᱩᱭᱩ ᱢᱤᱫ ᱜᱷᱟᱸᱥ ᱯᱟᱦᱴᱟ ᱨᱮ ᱢᱤᱫ ᱠᱩᱦᱲᱟ ᱵᱩᱨᱩ ᱞᱮᱱᱰᱥᱠᱮᱯ ᱥᱟᱶ

## Solid Colors

newtab-wallpaper-category-title-colors = ᱠᱮᱴᱮᱡ ᱨᱚᱝ
newtab-wallpaper-blue = ᱞᱤᱞ
newtab-wallpaper-light-blue = ᱦᱟᱞᱠᱟ ᱞᱤᱞ
newtab-wallpaper-light-purple = ᱦᱟᱞᱠᱟ ᱵᱮᱝᱜᱟᱲ
newtab-wallpaper-light-green = ᱦᱟᱞᱠᱟ ᱦᱟᱹᱨᱭᱟᱹᱲ
newtab-wallpaper-green = ᱦᱟᱹᱨᱤᱭᱟᱹᱲ
newtab-wallpaper-beige = ᱵᱮᱜᱤ
newtab-wallpaper-yellow = ᱥᱟᱥᱟᱝ
newtab-wallpaper-orange = ᱥᱟᱱᱛᱨᱟ
newtab-wallpaper-pink = ᱜᱩᱞᱟᱹᱯ
newtab-wallpaper-light-pink = ᱦᱟᱞᱠᱟ ᱜᱩᱞᱟᱯᱤ
newtab-wallpaper-red = ᱟᱨᱟᱜ
newtab-wallpaper-dark-blue = ᱦᱮᱱᱫᱮ ᱞᱤᱞ
newtab-wallpaper-dark-purple = ᱧᱩᱛ ᱵᱮᱝᱜᱩᱱᱤ
newtab-wallpaper-dark-green = ᱧᱩᱛ ᱦᱟᱹᱨᱤᱭᱟᱹᱲ
newtab-wallpaper-brown = ᱢᱟᱹᱴᱤᱭᱟᱹᱲ

## Abstract

newtab-wallpaper-category-title-abstract = ᱮᱵᱽᱥᱴᱨᱟᱠᱴ
newtab-wallpaper-abstract-green = ᱦᱟᱹᱨᱭᱟᱹᱲ ᱜᱚᱲᱦᱚᱱ
newtab-wallpaper-abstract-blue = ᱞᱤᱞ ᱜᱚᱲᱦᱚᱱ
newtab-wallpaper-abstract-purple = ᱵᱮᱝᱜᱟᱲ ᱜᱚᱲᱦᱚᱱ
newtab-wallpaper-abstract-orange = ᱞᱮᱢᱵᱚ ᱜᱚᱲᱦᱚᱱ
newtab-wallpaper-gradient-orange = ᱜᱽᱨᱮᱰᱤᱭᱮᱱᱴ ᱞᱮᱢᱵᱚ ᱟᱨ ᱜᱩᱞᱟᱯᱤ
newtab-wallpaper-abstract-blue-purple = ᱞᱤᱞ ᱟᱨ ᱵᱮᱝᱜᱩᱱᱤ ᱜᱚᱲᱦᱚᱱ

## Photographs

newtab-wallpaper-category-title-photographs = ᱯᱷᱳᱴᱳᱜᱽᱨᱟᱯᱷ
newtab-wallpaper-beach-at-sunrise = ᱥᱤᱛᱩᱝ ᱩᱰᱩᱝ ᱨᱮ ᱫᱚᱨᱭᱟ ᱟᱲᱮ
newtab-wallpaper-beach-at-sunset = ᱵᱮᱲᱟ ᱦᱟᱹᱥᱩᱨ ᱨᱮ ᱫᱚᱨᱭᱟ ᱟᱲᱮ
newtab-wallpaper-storm-sky = ᱦᱚᱭᱫᱟᱜ ᱥᱮᱨᱢᱟ
newtab-wallpaper-sky-with-pink-clouds = ᱜᱩᱞᱟᱯᱤ ᱨᱤᱢᱤᱞ ᱥᱟᱶ ᱥᱮᱨᱢᱟ
newtab-wallpaper-red-panda-yawns-in-a-tree = ᱟᱨᱟᱜ ᱯᱟᱱᱰᱟ ᱫᱟᱨᱮ ᱨᱮ ᱡᱟᱢᱵᱮ ᱮᱫᱟᱭ
newtab-wallpaper-white-mountains = ᱯᱟᱸᱰ ᱵᱩᱨᱩᱠᱚ
# Variables
#   $author_string (String) - The name of the creator of the photo.
#   $webpage_string (String) - The name of the webpage where the photo is located.
newtab-wallpaper-attribution = ᱪᱤᱛᱟᱹᱨᱤᱭᱟᱹ <a data-l10n-name="name-link">{ $author_string }</a> ᱨᱮ <a data-l10n-name="webpage-link">{ $webpage_string }</a>
newtab-wallpaper-feature-highlight-header = ᱨᱚᱝ ᱨᱮᱭᱟᱜ ᱟᱨᱮᱡ ᱧᱮᱞ ᱵᱤᱲᱟᱹᱣ ᱢᱮ
newtab-wallpaper-feature-highlight-content = ᱟᱢᱟᱜ ᱱᱟᱶᱟ ᱴᱮᱵᱽ ᱣᱟᱞᱯᱮᱯᱟᱨ ᱥᱟᱶ ᱢᱤᱫ ᱛᱟᱜᱽᱲᱟ ᱧᱮᱞ ᱮᱢᱚᱜ ᱢᱮ ᱾
newtab-wallpaper-feature-highlight-button = ᱵᱩᱡᱷᱟᱹᱣ ᱠᱮᱫᱟ
# Tooltip for dismiss button
feature-highlight-dismiss-button =
    .title = ᱵᱚᱸᱫ
    .aria-label = ᱴᱟᱴᱠᱟ ᱵᱚᱸᱫᱚᱭ ᱢᱮ
feature-highlight-wallpaper =
    .title = { -newtab-wallpaper-feature-highlight-header }
    .aria-label = { -newtab-wallpaper-feature-highlight-content }

## New Tab Weather

# Variables:
#   $provider (string) - Service provider for weather data
newtab-weather-see-forecast =
    .title = { $provider } ᱨᱮ ᱨᱮ ᱯᱷᱚᱨᱠᱟᱥᱴ ᱧᱮᱞ ᱢᱮ
# Variables:
#   $provider (string) - Service provider for weather data
newtab-weather-sponsored = { $provider } ∙ ᱥᱯᱚᱱᱥᱚᱨ ᱟᱠᱟᱱ
newtab-weather-menu-change-location = ᱡᱟᱭᱜᱟ ᱵᱚᱫᱚᱞ ᱢᱮ
newtab-weather-change-location-search-input-placeholder =
    .placeholder = ᱡᱟᱭᱜᱟ ᱥᱮᱸᱫᱽᱨᱟᱭ ᱢᱮ
    .aria-label = ᱡᱟᱭᱜᱟ ᱥᱮᱸᱫᱽᱨᱟᱭ ᱢᱮ
newtab-weather-change-location-search-input = ᱡᱟᱭᱜᱟ ᱥᱮᱸᱫᱽᱨᱟᱭ ᱢᱮ
newtab-weather-menu-weather-display = ᱦᱚᱭ ᱦᱤᱥᱤᱫ ᱩᱫᱩᱜ
# Display options are:
# - Simple: Displays a current weather condition icon and the current temperature
# - Detailed: Include simple information plus a short text summary: e.g. "Mostly cloudy"
newtab-weather-menu-weather-display-option-simple = ᱟᱞᱜᱟ
newtab-weather-menu-change-weather-display-simple = ᱟᱞᱜᱟ ᱧᱮᱞ ᱛᱮ ᱵᱚᱫᱚᱞ ᱢᱮ
newtab-weather-menu-weather-display-option-detailed = ᱵᱤᱵᱨᱚᱬ ᱠᱚ
newtab-weather-menu-change-weather-display-detailed = ᱯᱩᱥᱴᱟᱹᱣ ᱧᱮᱞ ᱨᱮ ᱵᱚᱫᱚᱞ ᱢᱮ
newtab-weather-menu-temperature-units = ᱞᱚᱞᱚᱢᱟᱯ ᱭᱩᱱᱤᱴ
newtab-weather-menu-temperature-option-fahrenheit = ᱯᱷᱟᱨᱮᱱᱦᱮᱭᱤᱴ
newtab-weather-menu-temperature-option-celsius = ᱥᱮᱞᱥᱤᱭᱚᱥ
newtab-weather-menu-change-temperature-units-fahrenheit = ᱯᱷᱟᱨᱮᱱᱦᱟᱭᱤᱴ ᱨᱮ ᱵᱚᱫᱚᱞ ᱢᱮ
newtab-weather-menu-change-temperature-units-celsius = ᱥᱮᱞᱥᱤᱭᱟᱥ ᱨᱮ ᱵᱚᱫᱚᱞ ᱢᱮ
newtab-weather-menu-hide-weather = ᱱᱟᱶᱟ ᱴᱮᱵᱽ ᱨᱮ ᱦᱚᱭ ᱦᱤᱥᱤᱫ ᱩᱠᱩᱭ ᱢᱮ
newtab-weather-menu-learn-more = ᱰᱷᱮᱨ ᱥᱮᱬᱟᱭ ᱢᱮ
# This message is shown if user is working offline
newtab-weather-error-not-available = ᱱᱤᱛᱚᱜ ᱫᱚ ᱦᱚᱭ ᱦᱤᱥᱤᱫ ᱰᱟᱴᱟ ᱵᱟᱝ ᱧᱟᱢᱚᱜ ᱠᱟᱱᱟ ᱾

## Topic Labels

newtab-topic-label-business = ᱵᱮᱯᱟᱨ
newtab-topic-label-career = ᱠᱮᱨᱤᱭᱚᱨ
newtab-topic-label-education = ᱥᱮᱪᱮᱫ
newtab-topic-label-arts = ᱨᱚᱢᱚᱡᱽ
newtab-topic-label-food = ᱡᱚᱢᱟᱜ
newtab-topic-label-health = ᱦᱚᱲᱢᱚ ᱥᱟᱶᱟᱨ
newtab-topic-label-hobbies = ᱜᱮᱢᱤᱝ
# ”Money” = “Personal Finance”, refers to articles and stories that help readers better manage
# and understand their personal finances – from saving money to buying a home. See the
# “Curated by our editors“ section at the top of https://getpocket.com/explore/personal-finance for more context
newtab-topic-label-finance = ᱴᱟᱠᱟ
newtab-topic-label-society-parenting = ᱟᱭᱳ-ᱵᱟᱵᱟ ᱵᱮᱵᱷᱟᱨ
newtab-topic-label-government = ᱨᱟᱡᱽᱱᱤᱛᱤ
newtab-topic-label-education-science = ᱥᱟᱬᱮᱥ
# ”Life Hacks” = “Self Improvement”, refers to articles and stories aimed at helping readers improve various
# aspects of their lives – from mental health to  productivity. See the “Curated by our editors“ section
# at the top of https://getpocket.com/explore/self-improvement for more context.
newtab-topic-label-society = ᱡᱤᱭᱚᱱ ᱦᱮᱠᱥ
newtab-topic-label-sports = ᱠᱷᱮᱞ
newtab-topic-label-tech = ᱴᱮᱠ
newtab-topic-label-travel = ᱫᱟᱬᱟᱱ
newtab-topic-label-home = ᱚᱲᱟᱜ ᱟᱨ ᱵᱟᱜᱟᱱ

## Topic Selection Modal

# “fine-tune” refers to the process of making small adjustments to something to get
# the best or desired experience or performance.
newtab-topic-selection-title = ᱟᱢᱟᱜ ᱯᱷᱤᱰ ᱵᱮᱥ ᱴᱩᱱ ᱞᱟᱹᱜᱤᱫ ᱥᱟᱛᱟᱢ ᱵᱟᱪᱷᱟᱣ ᱢᱮ
# “tailored” refers to process of (a tailor) making (clothes) to fit individual customers.
# In other words, “Our expert curators prioritize stories to fit your selected interests”
newtab-topic-selection-subtitle = ᱵᱟᱨ ᱵᱟᱝᱠᱷᱟᱱ ᱵᱟᱹᱲᱛᱤ ᱥᱟᱛᱟᱢ ᱵᱟᱪᱷᱟᱣ ᱢᱮ ᱾ ᱟᱞᱮ ᱨᱮᱱ ᱜᱟᱹᱠᱷᱩᱲᱤᱭᱟᱹ ᱠᱩᱨᱮᱴᱚᱨ ᱠᱚ ᱟᱢᱟᱜ ᱨᱚᱜ ᱞᱮᱠᱟ ᱠᱟᱹᱦᱱᱤ ᱠᱚ ᱯᱟᱹᱦᱤᱞᱟᱜ ᱠᱚ ᱮᱢᱟ ᱾ ᱡᱟᱦᱟᱸ ᱚᱠᱛᱚ ᱨᱮᱜᱮ ᱟᱯᱰᱮᱴ ᱢᱮ ᱾
newtab-topic-selection-save-button = ᱥᱟᱺᱪᱟᱣ ᱢᱮ
newtab-topic-selection-cancel-button = ᱵᱟᱹᱰᱨᱟᱹ
newtab-topic-selection-button-maybe-later = ᱦᱩᱭ ᱫᱟᱲᱮᱭᱟᱜᱼᱟ ᱛᱟᱭᱚᱢ ᱛᱮ
newtab-topic-selection-privacy-link = ᱵᱟᱰᱟᱭ ᱢᱮ ᱪᱮᱫ ᱞᱮᱠᱟ ᱟᱞᱮ ᱰᱟᱴᱟ ᱵᱚᱱ ᱨᱩᱠᱷᱤᱭᱟᱹ ᱟᱨ ᱵᱚᱱ ᱪᱟᱞᱟᱣ ᱫᱟᱲᱮᱭᱟᱜᱼᱟ
newtab-topic-selection-button-update-interests = ᱟᱢᱟᱜ ᱠᱩᱥᱤ ᱠᱚ ᱦᱟᱹᱞᱤᱭᱟᱹᱠ ᱢᱮ
newtab-topic-selection-button-pick-interests = ᱟᱢᱟᱜ ᱠᱩᱥᱤ ᱠᱚ ᱵᱟᱪᱷᱟᱣ ᱢᱮ

## Content Feed Sections
## "Follow", "unfollow", and "following" are social media terms that refer to subscribing to or unsubscribing from a section of stories.
## e.g. Following the travel section of stories.


## Button to block/unblock listed topics
## "Block", "unblocked", and "blocked" are social media terms that refer to hiding a section of stories.
## e.g. Blocked the politics section of stories.


## Confirmation modal for blocking a section


## Panel in the Customize menu section to manage followed and blocked topics

