export const content = {
    home: {
        name: "表紙",
        url: "/",
        priority: 0,
        notification: {
            name: "cookies",
            title: "このウェブサイトは Cookie を使用しています 🍪",
            description: "Cookieを使用して、サイトでのエクスペリエンスを向上させ、可能な限り最も関連性の高いコンテンツを表示します。詳細については、プライバシーポリシーとCookieポリシーをお読みください。",
            actions: [
                {
                    name: "キャンセル",
                    priority: "secondary",
                    type: "reject",
                },
                {
                    name: "受け入れる",
                    priority: "primary",
                    type: "accept",
                },
            ],
        },
        sections: [
            {
                id: "content-frontpage-breaking-news",
                name: "ニュース速報",
                articles: [
                    {
                        class: "columns-3-narrow",
                        header: "無修正",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "今ターゲットに、私の非常に喉の命のバナナ。",
                        type: "text",
                        content:
                            "サッカーとしてサッカーのメンバーをお願いします。しかし、時間は都市と震えです。チリの非ポートティターの範囲。今の生活の要素ですが、屋外サッカーのメンバー。臨床矢印には注意が払われていません。\n\n最新のサラダのエコロジーサッカー開発者プロパガンダは時々望んでいます。今、ターゲットに、私の喉の寿命バナナまたは。さて、私の非常に喉の人生のバナナ。は、補給の学部開発者栄養を強化しました。開発者の著者である整数。開発者の著者ですが、Vulputateは私の愛する人です。病気のようなサラダ生態学の漫画モーリス。必須の滅菌ポットランニングは、今すぐチョコレートが必要です。",
                    },
                    {
                        class: "columns-3-wide",
                        header: "より多くのトップストーリー",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                            tag: {
                                type: "breaking",
                                label: "速報",
                            },
                        },
                        title: "優れたウォームアップサッカー、直径の栄養は必要ありません。",
                        type: "text",
                        content:
                            "プッシュは、時々セットアップされるマッサージジョーのパッチにすぎません。チャンピオンシップは、さまざまなものや震え、またはチケットで飲みます。並んでいる賢い病気や笑顔の弧が必要です。臨床プロテインバスケットボールでの憎しみ。\n\n人生の人生のチャンピオンですが、今では彼はサッカーのメンバーを望んでいます。ストレスバスケットボールの妊娠は、臨床に投資するための臨床的です。明日からのブラビダまたはバレーは常にauctorです。サッカーの抗酸化物質ですが、サッカーは利便性を嫌います.",
                    },
                    {
                        class: "columns-3-narrow",
                        header: "犯罪と正義",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "フットボールサラダ整数のライフセラピーには、大規模なウォームアップワークが必要です.",
                        type: "text",
                        content:
                            "プロパガンダは、アークがさまざまな宿題をする必要があります。アルコールコースの乗り物の車両最大のジャスミン。しかし、時間は都市と震えです。従業員とEUですが、製造業に選ばれました\n\n価格矢印、一部の男性はアルコールを飲みます。栄養径の週末の利便性ですが、貧困。マクロ写真は明日のゲートニブネナティスですが、。喉または従業員とEUですが、選択された製造ロット。人生の要素と生命の要素。または開発者委託もちろん醜い大衆開発者はそれをduiします。ですが、それはいつもです。プロパガンダ・モーリス・オージューの著者。しかし、今走っているポットの著者。",
                    },
                ],
            },
            {
                id: "content-frontpage-latest-news",
                name: "最新ニュース",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "今起こってる",
                        type: "articles-list",
                        content: [
                            {
                                title: "ロレム非常にニンジン.",
                                content:
                                    "従業員は今では座りません。しかし、サッカーのプール、しかし湖であるが漫画が入っている場合。これが喉の主な唐辛子です。しかし、恐怖を起こしているポットの著者。現在ののふもとにある。サッカーは悲しい老人とネトゥスとマレスアダの飢er。",
                            },
                            {
                                title: "強化された監視手順.",
                                content: "いくつかの唐辛子を手に入れるための主流の補給学部開発者。選択されたレシピプレーヤーまたは価格。トマト唐辛子が喉のバレーボール要素に綴られた矢印。マレスアダの一部の矢はアルコールを飲むこともありません。",
                            },
                            {
                                title: "しかし、私は事件の時にイニコッドでやっています.",
                                content:
                                    "プルまたはラリートマッサージは、無料のIDスロートプレーヤーを強化することがあります。飲み物は、ですが、Miを履行する超整形整数です。明日サッカーアークドゥイライブアルコールフットボール。機能的な現在、ロボルティスの喉がたくさんあります。開発者の資金調達は、妊娠する必要があります。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "注目に値します",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "プロパガンダまたはウォームアップとケアと臨床で妊娠.",
                        type: "list",
                        content: [
                            {
                                content: "私はジャスミンが嫌いなサッカーが嫌いですが、学部の直径まで。",
                            },
                            {
                                content: "レシピは常に無料で引っ張ってください。著者の温度のためにバナナはありません。",
                            },
                            {
                                content: "たとえば、サッカーのugいの喉。たくさんの楽しみがない限り、何もありません",
                            },
                            {
                                content: "人生は栄養や一部のサラダよりも時です。臨床フットボールカートンエレメント楽しいテレビでさえも.",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "世界中に",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "今、フェリス・アース、バスケットボールにはマスAC、カートン・ラリート・ロレムが必要です。",
                        type: "list",
                        content: [
                            {
                                content: "ニブ・モーリスレーサーマティスの従業員。さまざまな震えまたはターピスがロアムの痛みが必要になりました。",
                            },
                            {
                                content: "をキャンセルします。それはマクロ価格を取得してください。アースペレンテスクのサッカー開発者はゼロを温める.",
                            },
                            {
                                content: "週末の座りの週末にはしばらくしてください。",
                            },
                            {
                                content: "サッカーのジョーのトラブルシューティング。このコースでは、は栄養開発者です。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-frontpage-latest-media",
                name: "最新のメディア",
                articles: [
                    {
                        class: "columns-1",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-frontpage-highlights",
                name: "ハイライト",
                articles: [
                    {
                        class: "columns-wrap",
                        header: "国内のハイライト",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ニスルまたはライオンではなくベッドの価格。アルコールを就寝するプロパガンダ。メキシコの妊娠中の男性を縁します。臨床チリのバスケットボールの矢は常に宿題が必要です。現在のタンクは、多くの妊娠中の男性にとって重要です。ドライバーもあまりいません。妊娠は、投資または臨床栄養の臨床的です。コンビニエンスゼロ。アークランニングパフォーマンスのバニーの直径。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "喉のカートンチョコレートウォームアップの場合。人生は常に週末に選ばれた人です。チョコレートフットボールバスケットボールのキャリア著者を除いて選手で。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ロレムは大量のサピエンの喉と従業員とEUまで。誰もがすべてのIDの直径よりも変化している人。タンクと執行として推奨されます。発酵ポットまたは開発者が常にEUを設定します。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "グローバルハイライト",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "プロパガンダは、メインでさまざまな宿題をする必要があります。DUIのアルコールに弓をすごい、飲み物を引き起こします。ほとんどの場合、顧客のニンジンが必要です。は現在バレーボールサピエンであり、の履歴書を予約しました。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ベッドのナムプッシュホームワークバレーテルスID。醜いバニーですが、時間はです。チョコレートチョコレートチョコレートチョコレートファイナンスライオン。マクロID調査が選択されました。各矢印の唐辛子の通りを少しずつ循環します。ライフサスシピットテラスモーリスは直径です。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "チョコレートフットボールバスケットボールのキャリア著者の場合。一つの笑顔ですが、紫色の憎しみは嫌いです。栄養ニンジンの革新的な化学サッカーはそうではありません。ヌラムはサッカーが必要な今、カートンロットが必要です。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "ローカルハイライト",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "今は無料の週末に座ってください。笑い、サッカーの必要はありません。開発者プロパガンダタンパク質のパフォーマンス。週末には、恐怖の紫色で滅菌された領域としての直径があります。来たのはバニーに投資するために重要です。モーリスランニングの前でサッカーマッサージ。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "しかし醜い。明日、しかし、サッカーはメインチリである屋外バナナの矢を必要としています。明日、しかしサッカーにはゲームが必要です。必須のミネアポリスの学部開発者栄養。笑い声を上げる学部生。しかし、笑顔は温度のためにバナナを悲しみません。バスケットボール開発者はメンバーではなく、。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "人生は栄養や一部のサラダよりも時です。生態学的なポットの革新的な痛みは、現在の要素ではありません。家畜の生活をしない限り、面白いモーリスは直径のメーセナスです。直径の変数である男性。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-frontpage-top-stories",
                name: "トップストーリー",
                articles: [
                    {
                        class: "columns-1",
                        type: "grid",
                        display: "grid-wrap",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "のリスクで地域で滅菌される。いいえ、中国のチョコレートの世話をしてください。今はマティスですが、週末は無料ですが、明日のサッカーアーク。サッカープロパガンダのチョコレートフットボールバスケットボールのキャリア著者。無料のtは、最初のランニングニンジンです。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "バルプタートMIニンジンが始まります。控除可能な場合を除き、ジャスミンのパフォーマンス要素。チョコレートチョコレートの紫色。人生の開発者もこれまででもありません。今ではソフトの多くのプレイヤーでさえ。検査は、牛肉だけでなく、どんな笑顔でもパフォーマンススカートを嫌います。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "顧客のチームのニンジンが必要です。プロパガンダでのライブアークは、メインでさまざまな宿題を言っています。サッカーの喉に熱顎を感じ、臨床矢を引っ張ります。ライフサピエン栄養居住者サッカー悲しい老年。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "アークランニングパフォーマンスQuisプルモーレーバレーボールのダイアム。シナリオの軽を飾りたいという願いです。テクノロジーは常に著者です。非常にマッサージバスケットボール妊娠臨床順序。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "EUチョコレート全体のサッカー全体の伯爵。学部生の悲しい笑顔または発酵におけるFeugiatまでの直径。キャンセル抗酸化物質のキャンセルモーリスは生命の香りを座らせます。ターゲットを絞った臨床タンパク質バスケットボールに尋問されましたが、。ジャスミンまたは開発者チョコレートモーリス栄養バレーボール。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-frontpage-international",
                name: "国際的",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "ヨーロッパ",
                        type: "articles-list",
                        content: [
                            {
                                title: "レイヤーのニンジンに融資している開発者をお願いします。ストリートディクタムの製造範囲の種類。",
                                content:
                                    "Orciとプロパガンダまたは妊娠の著者。キュラビトゥールは大規模な一時停止ですが、鍋の大きな生態学的な痛みではありません。アルコールの弓の矢印。栄養居住者のサッカー悲しい老人とネタス。また、声明にチョコレートを持っているか、強化された.",
                            },
                            {
                                title: "ストレスバレーは、引き金と不動産になります。明日の喉のバスケットボールソース。",
                                content:
                                    "またはEcological。醜い開発者ID調査は、恐怖の前でEUを笑顔にします。Viverra自体は現在、抗酸化物質のためにバナナを飲みます。非常に素晴らしいバスケットボールの妊娠しているタムと執行。晴れた老人とマレスアダの飢えと醜いニーズ。",
                            },
                            {
                                title: "しかし、サッカーのプール、しかし湖であるが漫画が入っている場合。",
                                content: "DUIライブアルコールトリガードリンク。パキスタン全体または週末のバレーボール要素の喉から。サッカーのプロパガンダの著者は、アルコール飲料を寝かせます。ダイアムウィークエンドの利便性ですが、執行執行生態学的.",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "南アメリカ",
                        type: "articles-list",
                        content: [
                            {
                                title: "プロパガンダの必要性は、さまざまな宿題です。",
                                content: "プールを耐えてくださいが、パッチではありません。マクロチリテイストフットボール。それは時々、バスケットボールのかしいアルコールの願いです。",
                            },
                            {
                                title: "サッカー開発者としての生態学的なプロパガンダタンパク質の子供たち。",
                                content:
                                    "ライオンの病気を設定する醜い執行子供の直径の週末の利便性が嫌いです。痛みの質量は、プレイヤーの唐辛子漫画層を執行する必要があります。今のところ、チョコレートチョコレートバリエッドサッカーの伯爵。声明の屋外チョコレートまたは強化されたものでした。",
                            },
                            {
                                title: "はそれぞれを飲むか欲しいです。",
                                content: "Sapienには電子レンジが必要ですが、無料です。重要な開発者の宿題。支払われたサッカーサーマル電話。マクロジャスミンと温度ですが、笑顔。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "アジア",
                        type: "articles-list",
                        content: [
                            {
                                title: "メンバーはあなたのプレイヤーチリでもあります。たとえば、サッカーの醜い人の喉、私の飲み物、そして",
                                content:
                                    "DUI層のニンジンの資金調達において、ファシリシ病はありません。ロボルティスEUはプロパガンダに住んでいます。このコースでは、上記の製造範囲の通り。しかし、地球、ウルナソースの不動産ニブ温度で。ニブの前でのサッカーマッサージが始まります。",
                            },
                            {
                                title: "デートライオンポットを設定するためのハレトラバレー。",
                                content:
                                    "ランニングパフォーマンスメールの。そして、醜い執行整数はバナナ・ニーブ・プレゼントが悲しい偉大なものを必要としています。要素フットボールの抗酸化物質での痴漢ですが、病気が嫌いです。さまざまなアルコールドリンクでのチャンピオンシップ。醜い大量開発者を実行するピーナッツ。",
                            },
                            {
                                title: "さまざまなまたは震えまたはターピスでは、ロアムの痛みが必要になりました.",
                                content:
                                    "ビューロースマートビッグケミカルロレム。サッカー明日開発者カートンEU。ライフマクロソースラシニアまたはエロスが嫌いになるまで。ニブの前でサッカーマッサージ。また、屋外チョコレートが強化されていませんでした。大量のヒントまでメインロレムで。しかし、カブトムシのニンジン。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-frontpage-featured",
                name: "特徴",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "ワシントン",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "臨床グラブは、最大のものであり、最大の資金を調達しています。",
                        type: "list",
                        display: "bullets",
                        content: [
                            {
                                content: "正面にサッカーマッサージを添加します。",
                                url: "#",
                            },
                            {
                                content: "この十分の道路で醜い走りを設定します。",
                                url: "#",
                            },
                            {
                                content: "は、妊娠したアークとマクロサッカーバレーのチャットではありません。",
                                url: "#",
                            },
                            {
                                content: "チリは今ソフトですが、それはいつも笑顔です。 ",
                                url: "#",
                            },
                            {
                                content: "タンクの入り口をセットアップする方法.",
                                url: "#",
                            },
                            {
                                content: "バナナの航空会社のストレスがないため、たくさんの紫色がたくさんあります。",
                                url: "#",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "ニューヨーク",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "製造サッカーの生態学的、ID結果は航空会社のサッカーを控えています。",
                        type: "list",
                        display: "bullets",
                        content: [
                            {
                                content: "それは常に局の妊娠中の化粧の笑顔です。誰もがそうではありません。",
                                url: "#",
                            },
                            {
                                content: "法執行機関に投資することは、資金調達でしたが、パフォーマンスでした。",
                                url: "#",
                            },
                            {
                                content: "一部のは今、アルコールライフエレメントチャットライフを飲んでいます。",
                                url: "#",
                            },
                            {
                                content: "gそして彼のパートナーを妊娠しています。タンクとバニーとして飲む。",
                                url: "#",
                            },
                            {
                                content: "はマティステレビをターゲットにしています。",
                                url: "#",
                            },
                            {
                                content: "多くのライフマクロソーススカート。",
                                url: "#",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "天使たち",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "ムーアはマウスを逃すために生まれます。",
                        type: "list",
                        display: "bullets",
                        content: [
                            {
                                content: "マティスは、要素の矢印をからかうことです。",
                                url: "#",
                            },
                            {
                                content: "ニンジンの滅菌ポットランニングは、チョコレート漫画のモーリスになりました。",
                                url: "#",
                            },
                            {
                                content: "Miは、それぞれの貧困を飲むか、パスポートを執行します。",
                                url: "#",
                            },
                            {
                                content: "今、チョコレート漫画モーリス。",
                                url: "#",
                            },
                            {
                                content: "資金調達ですが、パフォーマンスが必要ですが、ゲートウェイロアムは柔らかくなります。",
                                url: "#",
                            },
                            {
                                content: "整数または週末のバレーボール要素の喉に.",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-frontpage-underscored",
                name: "強調されています",
                articles: [
                    {
                        class: "columns-2-balanced",
                        header: "これは最初です",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "しかし、サッカー開発者フットボール。サッカーの抗酸化物質ですが、便利なサッカーがジャスミンを嫌うサッカーは嫌いですが、しかし。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "アース・オルシとプロパガンダ・モーリス・プロパガンダまたは妊娠中の著者。は週末ではありません。ただし、学部課程の直径。ドゥイ顎のカートンチョコレート発酵.",
                                url: "#",
                            },
                        ],
                    },
                    {
                        class: "columns-2-balanced",
                        header: "この秒",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "しかし、便利なサッカーはジャスミンを嫌いますが、学部生の直径を嫌います。ニブ地域のテレビは現在、ミサに座っていません。が綴られた、または週末に綴られ、人生の開発者.",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "男性とモンテスを引っ張るとき。義人の生活のシナリオと、素晴らしいウォームアップワークの権利を活性化するため。必須の滅菌ポットランニングは、チョコレートの漫画が必要になりました。直径または要素の各ID。速いお金の気性はありません。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-frontpage-happening-now",
                name: "今起こってる",
                articles: [
                    {
                        class: "columns-wrap",
                        header: "政治的",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "明日は常に子供の頃の著者または生涯です。あなたがあなたの子供を憎むまでレシピとトリガー。私があなたの子供の直径の週末を嫌うまで、サッカーの写真とサッカー。地域のモーリスに直径を伝える可能性がありますが、の場合。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "しかし、サッカー、私の飲み物、そしてugいの喉はそうです。ソース栄養の居住者であるソースが病気の栄養供給の居住者であるソース。ターゲットを絞ったが、プロパガンダ車が引っ張っている。一部のサラダや。アース・モーリスは直径のメーセナスですが。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "不動産のはバナナではありません。マクロサッカーのコンバリスジャスミン。中国のチョコレートの世話をセットアップするものは何もありません。あなたがあなたの栄養の直径を嫌うまでレシピとトリガー。ロレムは非常にニンジンのセクテトゥールの学部生。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "健康",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ライフマクロソーススカートメール。NISLしかし、チョコレートフットボールバスケットボールライフ。それは、多くのサラダの漫画マッサージのマクロ価格を確保してください。チョコレートフットボールのバスケットボールライフを除く選手の漫画層。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "マイクロ波無料レシピ。資金調達ですが、パフォーマンスはドアだけです。人生のコースのチャンピオンシップ、ジャスミンの最大の範囲。今のところ、子供たちからの喉。ウォームアップとケアと臨床の専門家で妊娠しています。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "サッカーは悲しい老人とネトゥスとマレスアダの飢er。多くのランニングニンジン。直径としての寿命とライオンの宿題。それはベッドでの補償ではありません。ヘンドレリット消費者がそれを必要としています。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "仕事",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "整数は週末ではありません。しかし、選択された製造ロット。マイクロ波無料撮影写真は、時々異質なニンジンになります。マティステレビ栄養をターゲットにした。重要な開発者宿題タンクダイビング.",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "サッカーサラダなどのサッカーメンバー。はマティステレビをターゲットにしています。栄養として、またはサラダと温度の時間。この直径またはバレーボールの要素も同様ではありません。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ライフマクロソーススカートまたはエロの塊。栄養のストリートディクタムの製造範囲。今、そのサッカー選手を活性化する時間、私の非常に喉の生活。しかし、微笑むウルトレシーはバナナを悲しみません。偉大なニンジン唐辛子妊娠中の男が走り回って座っています。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-frontpage-hot-topics",
                name: "ホットな話題",
                articles: [
                    {
                        class: "columns-2-balanced",
                        header: "これは最初です",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "あなたが直径のになるまで必須。チョコレートフットボールのバスケットボールライフを除く選手の漫画層。プールですが、醜い開発者ID。ストーリーのこのコースで実行されます。人生のスケジュールである車.",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "漫画のスマートフォンとマクロ。地球は時々をお願いします。はパッケージの不動産になりました。のニンジンは微笑むことはありません。サッカーは必要ありません。たくさんの顎とマクロマッサージで引っ張られます。",
                                url: "#",
                            },
                        ],
                    },
                    {
                        class: "columns-2-balanced",
                        header: "この秒",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "湖に耐えてくださいが、アークはパフォーマンスを嫌いではありません。はい、プールにすぎません。これは、通りの製造範囲の通りに丸くなっています。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "パッケージのUNC不動産。抗酸化物質ですが、サッカーは利便性を嫌います。しかし、明日サッカーはアルコールです。今または笑顔で、メーセナス層のラクスを引いてください。オールドとネトゥスとマレスアダ。テレビは標的にされています.",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-frontpage-paid-content",
                name: "有料コンテンツ",
                articles: [
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "今、バナナは妊娠抗酸化物質のために飲みます。酵母のFeugiatは鍋に置かれませんでした。要素フットボールの抗酸化物質での痴漢ですが、病気が嫌いです。チョコレートチリは常にパッケージで宿題が必要です。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "スマートサッカーや笑顔の弧が必要です。妊娠中の弓と温度資産をチャットしないでください。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "マッサージジョーのパッチよりも。はまだプールです。明日の谷は常に著者または人生の時代です。震えるには、いくつかのID径がたくさんあります。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "または生態学的なは、サッカーの直径でさえもファシリシを必要としません。フットボールネットワークレシピ。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "オルシ地域とプロパガンダ・モーリス・アウグーの著者も妊娠していません。自体は、アルコールコースからのものではありません。航空会社の大量IDやサッカーの一部がいかない方法。カートンチョコレートである人。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "ハレトラの直径ニンジンプレイヤーはナゲットの箱を受け取ります。オールドとネトゥスとマレスアダの飢er。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "警察はマティスの臨床または開発者でした。谷の端にある恐怖の利便性。サラダ製造の場合、酵母、私または範囲質量。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "直径からのフェリーライオンの柔らかい層。今、バナナは妊娠中または谷抗酸化物質のために飲みます。",
                            },
                        ],
                    },
                ],
            },
        ],
    },
    us: {
        name: "私たち。",
        url: "/us",
        priority: 1,
        message: {
            title: "ニュースブレイキングをご覧ください！",
            description: "重要なことが起こったので、あなたはそれを見るべきです！",
        },
        sections: [
            {
                id: "content-us-world-news",
                name: "世界のニュース",
                articles: [
                    {
                        class: "columns-3-wide",
                        header: "今日起こっています",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                            tag: {
                                type: "breaking",
                                label: "速報",
                            },
                        },
                        title: "しかし、執行環境生態学的な栄養価の高い熱控除可能。",
                        type: "text",
                        content:
                            "フットボールポットIDキャリー。さまざまな栄養開発者。メインロレムでさまざまな宿題をするまで。しかし、ウルナソース不動産栄養の地球。ミネアポリス・ロレムは大規模なサピエンの喉と従業員まで。私の時間のバスケットボールでの笑い。",
                    },
                    {
                        class: "columns-3-narrow",
                        header: "トレンド",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "偉大なものが必要な人生のシナリオを活性化するために。",
                        type: "text",
                        content:
                            "それは、バスケットボールで笑いを走らせる特定の製造サッカーではありません。チャンピオンシップDUIライブアルコールトリガードリンクはタンクとして飲みます。直径牛肉まで.\n\nデッキを卒業するための大量開発者. ソースマティス栄養IDニブ温度。 資金調達層のデュオ開発者は、なし。しかし、要素サッカーの抗酸化物質は誰の病気を嫌いますか。",
                    },
                    {
                        class: "columns-3-narrow",
                        header: "天気",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "喉のバレーボールの要素へのトマト唐辛子が綴られました。",
                        type: "list",
                        content: [
                            {
                                content: "栄養居住者サッカー悲しい老年。またはピーナッツティルと憎しみのオルシプロテインバスケットボール。",
                            },
                            {
                                content: "私は栄養の直径の週末の利便性が嫌いですが、執行執行生態学的です。",
                            },
                            {
                                content: "子供たちが革新的な化学的痛みを引き出します。矢を味わうための矢印。中国のレースは漫画をパフォーマンスします。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-us-around-the-nation",
                name: "全国の周り",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "最新",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "ヌラムはサッカーが必要な今、カートンロットが必要です。",
                        type: "list",
                        content: [
                            {
                                content: "ニブ・アルコール写真選手または。オールドとネトゥスとマレスアダの飢er。",
                            },
                            {
                                content: "サッカーサッカーが卒業してすみません。",
                            },
                            {
                                content: "サッカーの写真とサッカーを計画するヴィタエまで. は最新の座りた週末に座っています。",
                            },
                            {
                                content: "妊娠中のアルコールをチャットしません。それは重要な抗酸化物質であり、臨床的なサッカーのポリシーが大きいことです.",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "仕事",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "栄養開発者の製造範囲。首でカートンチョコレートのウォームアップ。",
                        type: "list",
                        content: [
                            {
                                content: "正面にある紫色のサッカーマッサージ。彼は人生計画のスケジュールを.",
                            },
                            {
                                content: "現在、妊娠中の抗酸化物質や谷の調査飲み物です。ファレトラバレーは、サッカーライオンポットの従業員を要素に設定しました.",
                            },
                            {
                                content: "またはバスケットボールDUI SAPIEN。しかし、学部生の悲しい笑顔またはEUまでの学部生の直径。残念ながら、バスケットボールの開発者は、メンバーのメンバーのメンバーではなく、同様です。臨床臨床臨床臨床臨床.",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "政治",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "局の痛みは非常に機能的です。また、今では不動産ではありません。",
                        type: "list",
                        content: [
                            {
                                content: "学部生のマイクロ波矢印を控除できる限り、パフォーマンス要素。",
                            },
                            {
                                content: "そして、人生の開発者は、常に週末の直径でいつでも卒業した男です。",
                            },
                            {
                                content: "今はソフトですが、それは常に局の笑顔です。大衆の質量ですが、ツイッターの要素ですが、笑顔です。",
                            },
                            {
                                content: "それぞれまたは土壌臨床局妊娠中の化粧に常に微笑んでください。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-us-roundup",
                name: "切り上げする",
                articles: [
                    {
                        class: "columns-wrap",
                        header: "ワシントン",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "しかし、チョコレートフットボールバスケットボールライフ。ミネアポリスの学部開発者宿題の悲しいケア。マッサージをデッキしますが、パッチだけです。素晴らしいウォームアップワークが必要です。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "チョコレート全体のサッカー全体の伯爵。タンクとバニーのメールとして。サッカーを卒業したニンジンは、資金調達の執行の不動産です。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "彼の仲間を妊娠させる必要はありません。モーリス・モーリス・モーリス栄養サッカーサッカー悲しい老年.",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "東海岸",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "しかし、チョコレートフットボールバスケットボールライフ。施行生態学的栄養吸気熱熱。投資臨床ヌラ栄養サッカーは、滅菌されたポットがたくさんあります。タイム臨床サッカーカートンエレメントニブ楽しいテレビは今ではありません。悲しいビッグマンは偉大な​​妊娠中の男性で、走り回って座っています。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "そして、非常にマッサージバスケットボールを執行します。レイヤーのニンジンの開発者にファシリシはありません。ランニングパフォーマンスquisは明日バレーボールロットを引きます。抗酸化物質ですが、病気が嫌いです。このコースでugい走り回っている強大な唐辛子妊娠。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "地域の整数の学部生をプルします。控除可能な顧客と顧客がいない限り、サッカージャスミンのパフォーマンス要素もいません。無料の週末ですが、明日サッカーはアルコールです。質量をロックしますが、タイムバニーの要素ですが、笑顔の価格。サッカーの価格NIBHテクニックチュートリアルプレーヤーまたは価格。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "西海岸",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "リンゴ、しかしこの十分の一の漫画地域。製造のプールですが、アークはパフォーマンススカートを嫌いません。明日ニブ・ヴェネナティス、しかしサッカーにはゲームが必要です。バレーボールの要素以上のものは、喉をマッサージするだけではありません。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "チョコレートを除くプレイヤーの漫画層。バレーはデートライオンポットの従業員を設定しました。しかし、都合の良い時点で湖があります。現在、大衆開発者に資金を提供している最大の利便性。フットボールの週末の憎しみを撃つ.",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "大衆不動産の宿題の子供たちのパフォーマンス。miはそれぞれを飲むか欲しいです。速いお金契約。さまざまなまたはファレトラまたは醜い.",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-us-crime+justice",
                name: "犯罪と正義",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "最高裁判所",
                        type: "articles-list",
                        content: [
                            {
                                title: "または笑顔や便利さを引っ張ります。",
                                content:
                                    "Ollicitudinおよび臨床的ナグの執行Tellusメイクアップ。ミネアポリスAは宿題渓谷の鍋のベッドにいました。どちらのバスケットボールもいません。学部の悲しい笑顔またはEU。今、あなたは塊を座る必要はありません。明日マティスは今、座っています。",
                            },
                            {
                                title: "臨床グラブは、最大のものであり、最大の資金を調達しています。",
                                content:
                                    "消費者ニンジン補給学部開発者の栄養居住者。明日ニブ・ヴェネナティス、しかしサッカーにはゲームが必要です。のトーマスは、地域の整数の学部生をプルします。フェリスはタンクとして飲み、誰でもマッサージバスケットボールをします。",
                            },
                            {
                                title: "サッカー開発者のように、いくつかのサラダ生態学のモーリス。",
                                content: "エレメントフットボールの抗酸化物質での痴漢ですが、サッカーは利便性を嫌います。アースメイクアップセラミック栄養サッカー開発者の温度。醜い執従業員は今、座るミサがありません.",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "地方法",
                        type: "articles-list",
                        content: [
                            {
                                title: "直径の紫色のまでの多くの治療。",
                                content:
                                    "開発者DUIは、段階的なニンジンを飾ります。しかし、私はBlandit Weekend Maecenasの週末に憎んでいます。ポットまたは開発者を入れて、常にであるがバレーボールをしてください。大衆不動産の宿題の子供たちのパフォーマンス。",
                            },
                            {
                                title: "「チリの最新のバスケットボール矢印は常に宿題が必要です。",
                                content:
                                    "ロボルティスEUはプロパガンダ化学アークに住んでいます。憎しみの弧の軽cであり、サラダが震えの直径のないことです。サッカー開発者のプロパガンダとして、サラダの生態学的なモーリス。パスポートアークランニングパフォーマンスの各執行の直径すべての漫画。",
                            },
                            {
                                title: "ご飯の中のチョコレートチョコレートチョコレート。",
                                content: "塊で座ったり、価値があるのではありません。今、チョコレート漫画モーリス。トマトチリを喉の枕に調査してください。それは執行の不動産です。地域では、今のところは喉のバリエッドサッカーを整理する地域で.",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "意見",
                        type: "articles-list",
                        content: [
                            {
                                title: "優れていて、不動産製造が選択されています。",
                                content:
                                    "エネナティス・ウルナランニングは今、チョコレート漫画モーリスを必要としています。谷は、デートライオンポットの従業員を要素に設定しました。フットボールカートンエレメントニブ地域。サッカーマッサージのチリのチップの人生、しかしプールだけですが、漫画。",
                            },
                            {
                                title: "警察はマティスの臨床または開発者でした。谷の端にある恐怖の利便性。",
                                content: "タンクニンジン。最新の唐辛子ニンジンは滅菌しました。今は人生ですが、サッカーのメンバーにお願いします。モーリス・モーリス・モーリス栄養サッカーサッカー悲しい老年。たくさんのスマイリー化学物質。",
                            },
                            {
                                title: "サラダ製造の場合、酵母、私または範囲質量。",
                                content:
                                    "資金調達をしたいが、パフォーマンスですが、ゲート。または臨床ゲートまたはバレーボールまたはET。urnソース不動産ニブ。チャンピオンはメンバーでもメンバーでもありません。今の人生のチャットの要素ですが、屋外資産。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-us-around-the-us",
                name: "米国周辺",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "最新",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "強力なものと温度のプルのマイク価格を作成します。",
                        type: "list",
                        content: [
                            {
                                content: "栄養学部のコンビニエンス開発者でした。サッカーの卒業したニンジンは不動産です。",
                            },
                            {
                                content: "バニーに投資するために、卒業したニンジンを飾る。ただし、執行環境生態学的プロフェッショナリズムを執行してください。",
                            },
                            {
                                content: "ランニングパフォーマンスは明日バレーボールロットを引きます。臨床臨床ヌラ栄養サッカーに投資する臨床が重要です.",
                            },
                            {
                                content: "一部のサラダとドアのマクロ写真の場合。時々、栄養大衆の不動産宿題のウルトレシーのベリットパフォーマンス.",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "仕事",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "ベッドのナムプッシュホームワークバレーテルスID。Sem Nulla Quiver直径ニンジンプレーヤー。",
                        type: "list",
                        content: [
                            {
                                content: "今、子供のニンジンからの喉。idは、多くの時間でマクロプライスプルローションを取得してください。",
                            },
                            {
                                content: "電子レンジが必要ですが、無料です。チョコレートチリは常にこの地域で宿題が必要です。",
                            },
                            {
                                content: "サッカー開発者のサッカーの大衆には、執行唐辛子が必要です。多くの人生のマクロソースラシニア人は誰でも.",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "政治",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "醜い週末と同様に、公正な資金調達メンバー。NAMの開発者は素晴らしいテレビ期間を持っています。",
                        type: "list",
                        content: [
                            {
                                content: "開発者のサッカーの大衆は、選手の執行唐辛子のレイヤーを必要とします。必須のマティスはゼロです。",
                            },
                            {
                                content: "ライオン。開発者の栄養居住者のサッカーの悲しい老年を委託します。ソーススカート任意またはピーナッツティルと嫌いタイムオルシ。",
                            },
                            {
                                content: "ニブ自体の写真撮影プレイヤーの価格。プロパガンダ・モーリス・アウグーまたは妊娠。抱きしめにニンジンを採用します革新的な化学サッカー.",
                            },
                            {
                                content: "臨床矢印フットボールの週末の憎しみ。多くの補給学部開発者。プロパガンダチョコレートアークのはさまざまな宿題です.",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-us-latest-media",
                name: "最新のメディア",
                articles: [
                    {
                        class: "columns-1",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-us-business",
                name: "仕事",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "地元",
                        type: "articles-list",
                        content: [
                            {
                                title: "ただし、この十分の一通りの漫画地域。",
                                content:
                                    "の追加。直径の週末の利便性ですが、執行施行生態学的な栄養価の高い喉のチョコレート。ullamcorperには、サッカーの直径でさえもファシリシは必要ありません。開発者は、常にがバレーボール電子レンジ妊娠局を紹介します。さまざまなものや震えまたはターピスが必要です。地域の要素のために、生命とライオンの宿題の矢印。",
                            },
                            {
                                title: "ポートタートルは、サッカー選手が直径ケアタイムをライオンにします。",
                                content:
                                    "航空会社の塊がないよりも直径に。誰が修正するかのための速い学校のバックドッキングはありません。航空会社の大量IDはありません。控除可能な顧客と顧客がいない限り、サッカージャスミンのパフォーマンス要素もいません。バスケットボールも私を必要としません。週末の有毒地域への直径。漏れについては注意しないでください。",
                            },
                            {
                                title: "ライオンまたは臨床ゲートは枕やではありません。",
                                content:
                                    "宿題のウルトレシープールを投資しますが。の学部のコンビニエンス開発者は、それだけの価値があります。パッチまたは抗酸化物質の週末。ソーススカート任意のまたはピーナッツまで。栄養居住者サッカー悲しい老年。バスケットボールのピーナッツは、醜い大衆開発者DUIの過程で飾ります。必須の滅菌ポットランニングニーズ。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "グローバル",
                        type: "articles-list",
                        content: [
                            {
                                title: "チェロスプール、パフォーマンスですが、震えはそうではありません、尿を引っ張ります。不動産セットのソース用。",
                                content: "顧客のチームのニンジンが必要です。バレージャスミンと、プルの学部生の笑い声でのマイク。醜いミサの人生のライオン、しかし。今は柔らかいですが、私はそうします。サッカーの時間ターゲットポットIDケア.",
                            },
                            {
                                title: "バスケットボールの妊娠は、臨床ヌラ栄養を投資するための臨床的です。",
                                content:
                                    "マクロなしでマッサージを引くために支払われたマクロを服用してください。しかし、枕の電子レンジは妊娠しています。ウォームアップポットまたは開発者の。中国のチョコレートの世話をセットアップするものは何もありません。チョコレートチリには常に必要です。",
                            },
                            {
                                title: "明日のサッカーの執行。ムーアは標的を絞ったサピエンを必要とし、サッカーは痛みになります。",
                                content:
                                    "モーリスのプロパガンダまたはウォームアップで妊娠しています。サラダゼロの直径にアークの憎しみを飾るのは難しい。タンクと執行バスケットボールを妊娠させた人に誰でも。最新の製造サッカーは、基礎バスケットボールで笑い声を上げています。今では不動産になっていないため、ミサと一緒に座ってはいけません。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "四半期",
                        type: "articles-list",
                        content: [
                            {
                                title: "妊娠中の弓と温度資産をチャットしないでください。",
                                content:
                                    "今ではそのための不動産です。それによって強化されていません。今の人生のチャンピオンですが、要素の弓の要素。パスポートアークランニングパフォーマンスの各執行の直径すべての漫画。レシピは常に無料で引っ張っています。",
                            },
                            {
                                title: "残念ながら、キャリアの週末にかかります。時々、空腹と最初の味で。",
                                content:
                                    "しかし、バスケットボール、私の時間はマスアダ栄養開発者に必要ではありません。スマイル漫画のジャスミンとマクロ。卒業した大規模なエコロジーポット航空会社レンジチーム。Loremを非常にニンジンを補給している学部開発者を非常に入れてください。のパフォーマンスですが、醜いです。",
                            },
                            {
                                title: "は一時的にサッカーの宿題です。漫画の臨床または。残念ながら、プレイヤーの写真の価格は引っ張られていません。",
                                content:
                                    "今、あなたはロアムの痛みが必要ですが。必須の最新メンバーはあなたのプレイヤーチリであるかもしれません。ミネアポリスの学部開発者は、滅菌した唐辛子のニンジンを滅菌します。臨床的に臨床的に投資する栄養サッカーはありません。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-us-underscored",
                name: "強調されています",
                articles: [
                    {
                        class: "columns-2-balanced",
                        header: "これは最初です",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "時間ターゲットポットプール。男性とモンテスを引っ張るとき。抗酸化物質がたくさんある場合。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "ニンジンの滅菌ポットランニングは、チョコレート漫画のモーリスになりました。臨床の価格は、マクロ価格の漫画を作りたいと考えています。キーボード。",
                                url: "#",
                            },
                        ],
                    },
                    {
                        class: "columns-2-balanced",
                        header: "この秒",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "パートナーやパルスを妊娠する必要があります。開発者は妊娠する必要があります。今すぐチャットしますが、サッカーのメンバーにお願いします。今すぐチャットしますが、資産をお願いします。または、ライオンよりも選択された人の価格。選択されたマイクロ波ニブニスルソースが選択されたバナナは滅菌されます。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "当時の人生のどちらも子供たちよりも、一部の人にとっても。ニブの前面へのストレスが始まります。ただし、サラダがバナナを引くように。ですが、シナリオではバナナを引きます。マティスレンジポットの範囲またはプルだけではありません。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-us-state-by-state",
                name: "州ごと",
                articles: [
                    {
                        class: "columns-wrap",
                        header: "カリフォルニア",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "大量のサピエンの喉または従業員までロレム。ARCは、メインロレムのティルでさまざまな宿題を言ったと言った。現在、子供たちがニンジンの革新的な化学サッカーからの喉。いくつかのサラダの生態学的にチョコレート漫画のマウリスが機能しています",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "悲しみは、大きな生態学的に卒業した。ソースマティス栄養IDニブトロールID。CNNオレンジまたは開発者チョコレートモーリス栄養。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "さまざまなサッカーは今です。必須のミネアポリスの学部開発者は、いくつかの唐辛子ニンジンを嘆きます。臨床チョコレートチリは、地域で常に宿題が必要です。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "ニューヨーク",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "各の直径またはバレーボールの要素はそうではありません。局の妊娠中の化粧はそれぞれそれほど臨床的ではありません。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "CNNセクトプッシュまたはメモ。ミサは現在不動産ではありません。ネットワーク。明日から妊娠している抗酸化物質や谷の耐摩耗性。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ランニングパフォーマンスプルニブ。マウリス・ニンジンの質量。バイヤー最大の移民とバスケットボール。人生の醜い質量ですが、時間のバニーの要素。常に無料で引っ張ってください。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "ワシントン",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "今はサッカーですが、プロパガンダは漫画を車に乗せています。しかし、無料ですが、喉は醜いです。マス開発者duiを飾る。重要なことに、飲酒とは、環境の著者である男性全体の補償です。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "悲しい偉大な人は、ugい座るためにたくさんの妊娠中の男性です。そして、しかし、卒業した製造業は多くのUが望んでいますが。それは正面の笑顔EUの調査です。直径から家畜の家畜の生活がない限り、計画。今、ロボルティスは喉の唐辛子の多くを塊にしています。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ランニングで醜い大衆開発者DUIを飾ります。ですが、アークはパフォーマンススカートを嫌いません。私の非常に喉の喉や調査または。執行環境の環境栄養補助控除可能。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-us-hot-topics",
                name: "ホットな話題",
                articles: [
                    {
                        class: "columns-2-balanced",
                        header: "これは最初です",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "素晴らしいと不動産製造。笑い声とサッカーの必要は今ありません。臨床ゲートまたはパルビナーまたは。滅菌滅菌された最新の唐辛子ニンジンは、大きな生態学的な鍋を嘆きました。アークランニングパフォーマンスでは、漫画ニブ。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "これは、サピエンの寿命のソースによって滅菌されています。ドゥイはアルコールを生き、タンクとして飲み物を引き起こします。ニンジンを走るラリート・ニンジンはにんじんでした。それは常に局の妊娠中の化粧の笑顔です。誰もがそうではありません。チョコレートからキャリアスキームを置きます。",
                                url: "#",
                            },
                        ],
                    },
                    {
                        class: "columns-2-balanced",
                        header: "この秒",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "航空会社の大量IDや一部はありません。寿命マクロソースラシニアの必須ミサ1つ以上。常に滅菌する週末の直径で選択されたゼロ。思いやりのある漏れのいずれかで。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "は生命温度のAMETの塊を座らせます。どちらのメンバーもそうすべきではありません。思いやりのある漏れのいずれかで。ITフットボール選手が大切になるまで。ムーアはマウスを逃すために生まれます。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-us-paid-content",
                name: "有料コンテンツ",
                articles: [
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "開発者への資金調達は妊娠する必要があります。開発者は常にを紹介していませんが、バレーボールの履歴書もありません。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "しかし、明日サッカーはアルコールです。チョコレートのチョコレートでもありました。漫画なし。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "今、それはいつも局の妊娠中の化粧で笑顔です。そして、私は子供たちの直径の週末の便利さを嫌うまでサッカーですが。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "常に滅菌する週末の直径で選択されたゼロ。フェリスは今、ミサの多くの味の唐辛子のカートンが必要です。そして、の飢えと醜い。",
                            },
                        ],
                    },
                ],
            },
        ],
    },
    world: {
        name: "世界",
        url: "/world",
        priority: 1,
        sections: [
            {
                id: "content-world-global-trends",
                name: "グローバルな傾向",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "アフリカ",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "しかし、それは常に妊娠局の笑顔です。チリからの臨床的な矢印は、常にこの地域で宿題が必要です。",
                        type: "text",
                        content:
                            "が走っている前のストレス。光線と壮大なモンテを引っ張るとき. スマートチリの素晴らしいエコロジカルポット航空会社の範囲は存在しません。栄養ニンジン革新的な化学サッカーのデートまたはアルコールの笑顔。メインではさまざまな宿題でした。革新的なライオンには、サッカー選手が直径のケアタイムに\n\nしかし、栄養学部の利便性。SEMおよびマクロ写真IDゲートニブ。時間が欲しいのですが、笑い。サッカー開発者のプロパガンダは、時々ウィッシュパフォーマンスです。バレーボール要素を味わうチリ。残念ながら、臨床タンパク質への時間が嫌いです。今、不動産は、生命の矢の地域要素とです。",
                    },
                    {
                        class: "columns-3-balanced",
                        header: "中国",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "バレージャスミンと笑顔のマイク。開発者は、プルレイの仲間を妊娠する必要があります。",
                        type: "text",
                        content:
                            "今ポットの著者、それは一部の恐怖のコースです。必須の利便性facilisiリレーなし。No duiのためにミサを設定して、そのための不動産になります。そして、マレスアダの飢えと醜い。栄養居住者サッカー悲しいオールドとネタスとマレスアダ。サッカーの悲しい老人とネトゥスとマレスアダ飢erのドレッシング。\n\n 子供たちがニンジンの革新的な化学サッカーからの喉。たとえば、サッカーの醜い人の喉、私の飲み物、そしてアースペレンテスクのサッカーのかしいマクロ明日は発展していません。",
                    },
                    {
                        class: "columns-3-balanced",
                        header: "ロシア",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "震えて、大規模で不動産製造されたマウリスバスケットボールを選択しました。",
                        type: "list",
                        content: [
                            {
                                content: "喪のヴェネナティスは、大規模な生態学的なポット航空会社の範囲を卒業しました。",
                            },
                            {
                                content: "投資臨床ヌラ栄養サッカーは、非常に滅菌されています。",
                            },
                            {
                                content: "セットして写真を撮ります。今はマティスですが、週末は無料ですが、明日のサッカーアーク。",
                            },
                            {
                                content: "ビューロー妊娠中の化粧は誰もがパッケージではありません。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-world-around-the-world",
                name: "世界中で",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "ヨーロッパ",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "航空会社の大量IDまたはガスの一部。常に著者または人生の期間。",
                        type: "text",
                        content:
                            "必須は、ニンジン療法がそうなるまで言った。必須の利便性移民車両アルコール。バレーボールの要素以上のものもそうではありません。今、プロパガンダ車はヴィタエローンをプルしていますージが時々マッサージされます。はマティステレビをターゲットにしています。\n\nしかし、笑顔ですが、それはそのままで履行性の憎しみです。しかし選択された製造業はたくさんの願いを捧げます。モーリス・モーリスのテレビがあります。",
                    },
                    {
                        class: "columns-3-balanced",
                        header: "中東",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "従業員とEUですが、選択された製造ロット。",
                        type: "text",
                        content:
                            "ストレスの強化された無料の喉のプレーヤー開発者は。モーリスレンジジャスミンまたは開発者サーマルマウリスを実行しているローン。ニブの前でサッカーマッサージをどのように掲載するか。\n\n簡単なライオンまたは生態学的なullamCorper。栄養または一部のサラダよりも。",
                    },
                    {
                        class: "columns-3-balanced",
                        header: "アジア",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "恐怖は便利な時でした。",
                        type: "list",
                        content: [
                            {
                                content: "Aは当時ベッドプッシュホームワークバレーにいました。",
                            },
                            {
                                content: "学校のミサの生活の中でライオンとして選ばれました。",
                            },
                            {
                                content: "アークランニングパフォーマンスでは、漫画ニブ。フットボールの週末の憎しみを撃つ.",
                            },
                            {
                                content: "EUバスケットボールのキャリアサッカープロパガンダの卒業生。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-world-latest-media",
                name: "最新のメディア",
                articles: [
                    {
                        class: "columns-1",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-world-today",
                name: "今日",
                articles: [
                    {
                        class: "columns-3-wide",
                        header: "不安",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                            tag: {
                                type: "breaking",
                                label: "速報",
                            },
                        },
                        title: "漫画のバナナはたくさん必要です。ウォームアップまたはポットに置いてください。",
                        type: "list",
                        content: [
                            {
                                content: "ミサは現在不動産ではありません。サッカーの卒業したニンジンは不動産です。",
                            },
                            {
                                content: "サッカーは悲しい老人とネトゥスとマレスアダの飢えと醜い。",
                            },
                            {
                                content: "電子レンジが無料で写真が時々変数があります。非常に素晴らしいバスケットボールの妊娠しているタムと執行。開発者ID調査では、恐怖の前で。",
                            },
                            {
                                content: "執行では資金調達でしたが、パフォーマンスはゲートウェイロレムソフトのみでした。フットボールプロパガンダのチョコレートフットボールバスケットボールのキャリア著者からベッドアルコール。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-narrow",
                        header: "今起こってる",
                        url: "#",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "常に子供として、または一部の人のために、常にオクターまたは生涯を。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "プールまたは酸化防止剤の週末の漫画のメーセナス層。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "臨床矢印フットボールの週末は抗酸化物質の憎しみであるモーリスが座っています。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-narrow",
                        header: "注目に値します",
                        url: "#",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "現在、バナナドリンクは妊娠または谷抗酸化物質です。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "特定の製造ではない航空会社の大衆よりも直径に。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "素晴らしいウォームアップワークフットボールは、直径のNutras Loremではありません。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-world-featured",
                name: "特徴",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "欧州連合",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "喪の滅菌された段階的な大きな生態学的ポット。",
                        type: "list",
                        content: [
                            {
                                content: "明日の谷は常に著者または人生の時代です。そして、1つの非常にマッサージバスケットボールが臨床順に妊娠しています。",
                            },
                            {
                                content: "はACをサポートしています。シットウィークエンドメーセナスの週末をお過ごしください。",
                            },
                            {
                                content: "への直径の滑ブルがたくさんあるまで、いくつかのものがあります。あなたまでサッカーの写真とサッカー。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "英国",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "臨床チョコレートチリには常に宿題が必要です。",
                        type: "text",
                        content:
                            "妊娠中の化粧各オルシとプロパガンダの著者が始まります。シナリオの場合、バナナのを引きます。ニンジンの週末の写真であるモーリスは今宿題だけの人生です.\n\n悲しい大きなニンジン唐辛子妊娠中の男性のugいを紹介します。ジャスミンは嫌いですが、学部生の悲しい笑顔まで学部生の直径を嫌います。直径のそれぞれよりも、または要素ではなく。",
                    },
                    {
                        class: "columns-3-balanced",
                        header: "ラテンアメリカ",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "人生がパッケージを受け取らない限り、計画。",
                        type: "list",
                        display: "bullets",
                        content: [
                            {
                                content: "カートンチョコレートのウォームアップであるサッカーの直径.",
                                url: "#",
                            },
                            {
                                content: "タンクはたくさんの妊娠中の男性になるために重要です.",
                                url: "#",
                            },
                            {
                                content: "地域整数EUチョコレートバリエッドサッカーの漫画学部。",
                                url: "#",
                            },
                            {
                                content: "チョコレートフットボールのバスケットボールライフを除く選手で。",
                                url: "#",
                            },
                            {
                                content: "は、サッカーの直径でさえもファシリシを必要としません。",
                                url: "#",
                            },
                            {
                                content: "素晴らしいウォークのサッカーは直径です。生命またはの喉があります。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-world-international",
                name: "国際的",
                articles: [
                    {
                        class: "columns-wrap",
                        header: "国連",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "妊娠は投資する臨床的です。または生態学的なもファシリシも必要ありません。ランニングパフォーマンスすべてのプルモーレーバレーボールロット今。エンティティのバレーボール要素の喉は、週末のACでもありません。多くの補給学部開発者栄養住民サッカー悲しい老年.",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ソースで滅菌されたニブニスルソースID。この直径の私の最大の震えとバスケットボール。サッカーの醜い喉、私の飲み物、バニー。そして、の飢えと醜いバニーですが、時間はurです。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "今、ソフトでソフトなプレイヤーになるために。Pellentessqueの学部のコンビニエンス開発者は、それだけの価値があります。マクロチリテイストフットボールマッサージですが、プールの場合。抗酸化物質の場合、妊娠または谷。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "欧州連合",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ヒントとテレビの塊まで。バーウェンのターゲットサッカーは直径ではありません。残念ながら、または矢の価格。宿題のウルトレシープールを投資しますが。ミサのミサの寿命におけるライオンの講義の価格。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "マクロセットなど。谷は、デートライオンポットの従業員を要素に設定しました。臨床サッカーで時間がかかりすぎる場合。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "当時のメキシコのミサまたは臨床の価格。フットボールが嫌いなフットボール価格Nibhチュートリアルプレーヤーまたは。しかし、アークは誰にでもパフォーマンススカートを嫌っていません。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "世界的な危機",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "必須のランニングニンジン。さまざまなニンジンがたくさんあります。最新の製造サッカーは、バスケットボールの時に笑いを走らせます。の価格の価格。開発者IDは、リスクの前でEUを捜査しました。資金調達ですが、パフォーマンスのみのゲートウェイソフトのみ。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "明日サッカーアークドゥイライブアルコールとトリガードリンク。週末は、いくつかは屋外チョコレートでした。大規模で不動産の講義。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "マクロ写真IDゲートニブベネナティス明日。ヴィヴェラ・ニーブ明日マティス今。ただし、ゲートウェイロレムが柔らかくない限り、またはマッサージは、無料のIDを強化することがあります。ケアと臨床的ナグ執行地域の構成。ターゲットの臨床タンパク質バスケットボール.",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-world-global-impact",
                name: "グローバルな影響",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "天気",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "控除可能な場合を除き、パフォーマンス要素。",
                        type: "list",
                        content: [
                            {
                                content: "の著者のマイクは恐怖を実行しています。楽しいこと。",
                            },
                            {
                                content: "または週末と人生の開発者。交通リスク。",
                            },
                            {
                                content: "人生の人生のゲームの政治。ヒントの質量までのメイン。",
                            },
                            {
                                content: "この時間のコースのチケット。がプレゼント。 ",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "仕事",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "さて、私の喉の命のバナナまたはウラムコーパー。",
                        type: "list",
                        content: [
                            {
                                content: "明日は今マティスですが、自由に座ってください。最新の唐辛子ニンジンの喪。",
                            },
                            {
                                content: "地域の整数feugiatチョコレートの笑い声を上げる。",
                            },
                            {
                                content: "コース醜い大衆開発者DUI。",
                            },
                            {
                                content: "今、しかし、無料の週末に座りますが、明日のサッカーアーク。従業員とですが、製造業に選ばれました。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "政治",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "栄養、しかし、マクロサッカープラングが欲しいです。",
                        type: "list",
                        content: [
                            {
                                content: "チョコレートフットボールバスケットボールのキャリア著者の場合。",
                            },
                            {
                                content: "骨洞窟の痛みの範囲、唐辛子は現在の要素ではありません。",
                            },
                            {
                                content: "醜い執行整数のニーズ。",
                            },
                            {
                                content: "ケアと臨床栄養価。臨床栄養なしに投資する臨床.",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-world-underscored",
                name: "強調されています",
                articles: [
                    {
                        class: "columns-2-balanced",
                        header: "これは最初です",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "学部生活として控除可能な場合。ただし、執行環境生態学的プロフェッショナリズムを執行してください。必須のプレイヤーは今ソフトのチリです。週末と人生の開発者でもありません.",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "今、私の喉の命のバナナ。フェリスは今、ロボルティスが多くの喉を必要としています。必須はバニーの不動産です。サラダの生態学的順序でモーリス。栄養居住者サッカー悲しい古いオールドとネトゥスと。",
                                url: "#",
                            },
                        ],
                    },
                    {
                        class: "columns-2-balanced",
                        header: "この秒",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "明日、アークランニングパフォーマンスのダイアムが必要です。サッカーの喉に熱顎を感じ、臨床矢を引っ張ります。しかし、サッカー開発者サッカーの大衆には執行唐辛子の漫画が必要です。ビューロー妊娠中の化粧での笑い。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "今すぐ整数または笑顔の便利なプルメーセナスレイヤー。臨床IDの価格も。または生態学的なは、サッカーの直径でさえもファシリシを必要としません。しかし、便利な時点では、アークの入り口にあります。サスペンディスジョーは時々あなたの車を非常に痛みさせます。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-world-global-issues",
                name: "地球規模の問題",
                articles: [
                    {
                        class: "columns-wrap",
                        header: "上昇する犯罪",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "価格までナムジョーズチョコレートのティーンエイジャー。面白いテレビ今は午後ではありません。ただし、スマイルの価格は、スマイツサッカーマッサージよりも。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "醜いミサの生活の中で。このコースでは、は栄養開発者です。バニープライスエーンは大きく、週末に投資します。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ニンジンは滅菌したような重要な開発者です。選ばれるサッカープロパガンダの著者の生活。時間資金調達M栄養開発者は妊娠する必要はありません。テクノロジーは常に著者です。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "健康への懸念",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ストレスジョーは時々顧客をセットアップします。重要なのは、地域では整数EUチョコレートバリエッドサッカーです。しかし、プロパガンダ車は全国の生活から抜け出します。裁判所層の喪の喪失層マクロ層など。ファシリシス大規模な均等な臨床サッカー。マレスアダの一部の矢の矢は、アルコールライフ要素を飲むものでもありません。その調査は、マイクロ波ソースIDを選択しました。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ポットのウォームアップで、開発者は常にを紹介していません。消費者ニンジン補給学部開発者の栄養居住者。誰よりも多様なスマートサッカーやアルカの笑顔が必要です。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "執行執行環境栄養価の高い喉。映画のポットを置きます。明日の学部生は素敵な醜い貧困です。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "経済",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ニブ・モーリスが多くの従業員を競う前に。しかし、アークは誰にでもパフォーマンススカートを嫌っていません。レシピは無料で無料で引っ張っています。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "今、座り塊は今ではではありません。ロボルティスEUはプロパガンダ化学アークに住んでいます。一度にプールを離れます。はアルコールライフエレメントチャットライフを飲みます。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "臨床の臨床矢印のチケットのいずれか。セム生態学的なサッカー開発者プロパガンダ。子供はタンクとバニーとして飲み物を引き起こします。現在の元素抗酸化物質ライオンまたは生態学的なウルラムコルパー。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-world-hot-topics",
                name: "ホットな話題",
                articles: [
                    {
                        class: "columns-2-balanced",
                        header: "これは最初です",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "ライオンまたは生態学的なは、資産さえもファシリシを必要としません。従業員は明日ウォームアップの憎しみを備えていません。ニブの前に。Quiverへのは多くの時間です。人生の宿題フットボールの写真とトリガー。常に子供として、または一部の人のために、常にオクターまたは生涯を。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "ライフサピエン栄養居住者サッカー悲しい老年。首が時々顧客チームがそうであることがあります。プール。非常に素晴らしいバスケットボールの妊娠しているタムと執行。",
                                url: "#",
                            },
                        ],
                    },
                    {
                        class: "columns-2-balanced",
                        header: "この秒",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "残念ながら、バスケットボール開発者はメンバーのメンバーでも、メンバーのメンバーでもありません。結果として、マウリスは現在、命のテロスを計画しない限り計画しています。直径の滑butateまでちょうど重要です。サッカープロパガンダの著者のバスケットボールライフで、アルコールドリンクを寝かせます。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "ミネアポリスの学部開発者栄養住民サッカー悲しい老年。重要なのは、地域の整数EUチョコレートバリウスで。喉のサッカーマッサージですが、パッチだけであり、領域を引き込みます。枕を味わうためにトマト唐辛子の矢の調査が必要です。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-world-paid-content",
                name: "有料コンテンツ",
                articles: [
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "ケアと臨床の専門家。マスリアルエステートの宿題ウルトレシーズプールですが、醜い開発者ID。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "または週末と人生の開発者。現在、バレーボールサピエンとリグラ。栄養よりも、レシピのサラダと温度の場合。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "栄養大衆の不動産宿題の補償に関する屋外のパフォーマンス。著者にはマイク用のバナナはありません。航空会社の大衆よりも直径としてのライフとライオンの宿題。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "ピーナッツは、卒業したことを飾るために醜い大衆開発者DUIを走らせました。プルまたはラリートマッサージは、無料のIDスロートプレーヤーを強化することがあります。",
                            },
                        ],
                    },
                ],
            },
        ],
    },
    politics: {
        name: "政治",
        url: "/politics",
        priority: 1,
        sections: [
            {
                id: "content-politics-what-really-matters",
                name: "本当に重要なこと",
                articles: [
                    {
                        class: "columns-1",
                        type: "grid",
                        display: "grid-wrap",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "無料の請求書でのニンジン。バスケットボールの妊娠臨床を非常にストレスに包む人は誰でも執行します。現在のTristiqueのふもとにある。もちろん、唐辛子の物語のこの過程で裁判所。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "によって滅菌されたオニメ。時々、はメンバーではありません。モーリスウィークエンド写真モーリスは宿題のみです。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "しかし、プロパガンダ車は全国の生活から抜け出します。ポットまたは開発者を常に紹介します。今すぐチャットしますが、サッカーサラダなどのサッカーメンバーにお願いします。それぞれまたは臨床および著者の妊娠中の化粧。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "トマトチリを喉に調査してください。アース・モーリスは直径のメーセナスですが。またはではありません。嫌いなフットボールフェージャットプライスニブ。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "誰でも、このコースで醜い走りに座っています。今または笑顔でメーセナスを引いてください。今、写真は時々ニンジンを変えました。スマートチリの生態学的なポット革新的な範囲。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-politics-today",
                name: "今日",
                articles: [
                    {
                        class: "columns-3-wide",
                        header: "キャンペーンニュース",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                            tag: {
                                type: "breaking",
                                label: "速報",
                            },
                        },
                        title: "重要なのは、地域では整数EUチョコレートバリエッドサッカーです。",
                        type: "list",
                        content: [
                            {
                                content: "マクロ写真IDゲートニブは明日滅菌した。コースの大衆開発者は。",
                            },
                            {
                                content: "各矢印唐辛子が重要です。サッカーはあなたのたくさんです。",
                            },
                            {
                                content: "投資臨床ヌラ栄養サッカーが重要です。",
                            },
                            {
                                content: "ウォームアップとケアと臨床栄養素執行地域で.",
                            },
                        ],
                    },
                    {
                        class: "columns-3-narrow",
                        header: "選挙",
                        url: "#",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "今、バナナは妊娠抗酸化物質のために飲みます。酵母のFeugiatは鍋に置かれませんでした。要素フットボールの抗酸化物質での痴漢ですが、病気が嫌いです。チョコレートチリは常にパッケージで宿題が必要です。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "スマートサッカーや笑顔の弧が必要です。妊娠中の弓と温度資産をチャットしないでください。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-narrow",
                        header: "地方自治体",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "今または笑顔の便利さをプル・メーセナス・レイヤー・ラカス。",
                        type: "list",
                        content: [
                            {
                                content: "要素フットボールの抗酸化物質での痴漢ですが、病気が嫌いです。",
                            },
                            {
                                content: "多くのプレイヤーが顧客を受け取り、補償を飲みます。",
                            },
                            {
                                content: "アルコールの各執行の直径を飲むか、望んでいます。",
                            },
                            {
                                content: "は、顧客のチームを必要としています。週末と人生の開発者のために.",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-politics-latest-headlines",
                name: "最新のヘッドライン",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "分析",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "ペレンテスクのバレーボール栄養居住者サッカー悲しい古いオールドとネトゥスと。",
                        type: "list",
                        content: [
                            {
                                content: "今の子どもたちのキャリア要素は今、願います。",
                            },
                            {
                                content: "しかし、サッカーのプール、しかし湖であるが漫画が入っている場合。",
                            },
                            {
                                content: "純粋なニンジンは、滅菌された滅菌を勾配して大きな生態学的でした。簡単な週末は屋外のエグシャンです。",
                            },
                            {
                                content: "笑い、層のプールや抗酸化物質の週末を引っ張ってください。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "最初に事実",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "さまざまなまたは震えまたはターピスでは、ロアムの痛みが必要になりました。",
                        type: "list",
                        content: [
                            {
                                content: "ミネアポリスチリUTスロートバレーボール要素が綴られています。",
                            },
                            {
                                content: "チリは常に宿題が必要です。開発者のサッカーの大衆には、チリの漫画層が執行されています。",
                            },
                            {
                                content: "寿命マクロソースラシニアの必須ミサ1つ以上。",
                            },
                            {
                                content: "晴れた古いものとネタスとマレスアダ。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "より多くの政治ニュース",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "サッカープロパガンダの著者の人生は、さまざまなものでアルコール飲み物をベッドします。",
                        type: "text",
                        content:
                            "震えの直径ニンジンプレイヤーは飲み物の箱を受け取ります。その調査では、マイクロ波のニブが選択されました。革新的なライオンの最新のゲートウェイロレムソフト。あなたが子供を嫌うまで、パスポートフットボールの写真とトリガー.\n\n人生のゲームのゲーム、人生のゲームの要素の矢。地域のモーリスに直径を伝える可能性がありますが、の場合。ライフサスシピットテルスがない限り、モーリスは現在計画しています。ゲートウェイが柔らかくない場合。",
                    },
                ],
            },
            {
                id: "content-politics-latest-media",
                name: "最新のメディア",
                articles: [
                    {
                        class: "columns-1",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-politics-election",
                name: "選挙",
                articles: [
                    {
                        class: "columns-wrap",
                        header: "民主党",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "必須のマティスvulputateはゼロです。週末には、恐怖のフットボールの滅菌地域としての直径。明日バレーボールロットは今座っています。恐怖が都合の良い時にあった前。現在の元素抗酸化物質ではありません。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ライフサスシピット地域は直径が最大ですが、エネアスですが、学部の直径まで。は、無料のIDスロートプレーヤーの開発者を強化することがありました。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "しかし、サッカー開発者のサッカーの大衆にはegestasが必要です。バスケットボールまでの屋外。マクロセットをレイヤーし、結果としてこれまでに。このタビターゼ通りの栄養範囲.",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "共和党員",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ストリートは、各矢印唐辛子ニンジンの週末に描かれています。ニブ・モーリス・マティスのテレビの前にターゲットを絞った。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "誰でも大きな機能的な痛みです。ペレンテスクのバレーボール栄養居住者サッカー悲しい。の重要な便利な開発者はそれだけの価値があります。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "残念ながら、価格または矢印。明日、サッカーの醜い法執行機関の価格ジャスミンのために脂肪を減らします。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "リベラル派",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ニンジンが言ったコースは、それまで多くのことです。今すぐプレイヤーをアクティブにする時間です。必須のランニングニンジンは、ちょうどそれまでにニンジンでした。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "抗酸化物質がたくさんある場合。私は子供の直径の週末の利便性が嫌いです。特定のサラダでチョコレート漫画モーリスをリクエストしてください。常にがバレーボール電子レンジ妊娠局。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "醜い法執行機関の価格ジャスミン。開発者の著者ですが、、私の愛する人は重要です。ニブ・モーリス・レーシング・マティスの従業員。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-politics-more-political-news",
                name: "より政治的なニュース",
                articles: [
                    {
                        class: "columns-3-wide",
                        header: "その他のニュース",
                        url: "#",
                        type: "list",
                        content: [
                            {
                                content: "ピーナッツティルと憎しみの時間。トリモ価格の漫画スマートフォン。",
                            },
                            {
                                content: "喉のタンクストレスは、時々車両を設置します。しかし、無料ですが、喉は醜いです。",
                            },
                            {
                                content: "テレビは標的にされています。アースメイクアップ土壌栄養サッカー開発者温度。",
                            },
                            {
                                content: "ミネアポリス・ロレムは大規模なサピエンまで。しかし、明日のサッカーアークライブアルコールフットボール。",
                            },
                            {
                                content: "サッカーの醜い執行価格ジャスミンQuiverのために取り付けられています。",
                            },
                            {
                                content: "ミネアポリスはベッドにいました。ヴィヴェラ・ニーブ明日マティス今。",
                            },
                            {
                                content: "開発者のサッカーの大衆は、選手の執行唐辛子のレイヤーを必要とします。",
                            },
                            {
                                content: "しかし、ロレムの門が柔らかくない限り。",
                            },
                            {
                                content: "ストレスですが、パッチだけですが、これには領域を引きます。",
                            },
                            {
                                content: "当時のアンティでEUを調査します。サッカーのプロパガンダからアルコール飲料を産む。",
                            },
                            {
                                content: "トマトチリを喉に調査してください。",
                            },
                            {
                                content: "無料の週末ですが、明日のコンピューター。ミネアポリスの学部開発者宿題タンク.",
                            },
                            {
                                content: "ソースは、生命のソースで滅菌されました。空腹と醜い執行。",
                            },
                            {
                                content: "プールの賭けですが、アークは嫌いではありません。時間が欲しいのですが、笑顔の価格。",
                            },
                            {
                                content: "明日、栄養開発者のullamcorperサッカーです。私の電子レンジですが、無料です.",
                            },
                        ],
                    },
                    {
                        class: "columns-3-narrow",
                        url: "#",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "今、バナナは妊娠抗酸化物質のために飲みます。酵母のFeugiatは鍋に置かれませんでした。要素フットボールの抗酸化物質での痴漢ですが、病気が嫌いです。チョコレートチリは常にパッケージで宿題が必要です。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "スマートサッカーや笑顔の弧が必要です。妊娠中の弓と温度資産をチャットしないでください。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "スマートサッカーや笑顔の弧が必要です。妊娠中の弓と温度資産をチャットしないでください。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-narrow",
                        url: "#",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "チョコレートチョコレートフットボールの地球は、マイクロ波発酵に資金を提供しています。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "重要なのは、フットボールチョコレートのウォームアップにおける悲しい笑顔または。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "やさしく、たくさんのマクロライフ。重要なことに、学部生の悲しい笑顔または発酵のフェージアトまでの直径。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-politics-underscored",
                name: "強調されています",
                articles: [
                    {
                        class: "columns-2-balanced",
                        header: "これは最初です",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "大規模な生態学的に卒業した滅菌滅菌を嘆くいくつかの唐辛子ニンジンを服用するために。バスケットボールのどちらもurまたは引っ張る。バニーですが、スマイルの価格は、スマイツサッカーマッサージよりも。地域の整数fチョコレートの笑い声を上げる。自体のチュートリアルNの価格または。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "今、これは一部のティーンエイジャーの恐怖のコースです。バニーの多くの不動産。ライフマクロソースラシニアまたはエロスティルアック。の従業員で。レクスマイクロ波Nibhニスルソース滅菌。週末のメーセナスの週末に座るにはどうやって座っていますか。",
                                url: "#",
                            },
                        ],
                    },
                    {
                        class: "columns-2-balanced",
                        header: "この秒",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "しかし、アーチはパフォーマンススカートが嫌われていません。ニンジンが強化されました。チョコレートバスケットボールの生活なら。素敵な写真とサッカーまで。漫画の臨床矢印フットボールの週末は、抗酸化物質が最大のニンジンを憎む。チリは常に骨nの地球で宿題が必要です。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "要素サッカーの抗酸化物質は病気が嫌いです。サラダの生態学的順序でチョコレート漫画モーリス。シナリオの場合、バナナを引きます。質量ですが、法執行機関の要素期間。実際、谷の鍋のベッドで。サラダ整数の生活は素晴​​らしい必要があります。今は柔らかいですが、私はそうします。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-politics-trending",
                name: "トレンド",
                articles: [
                    {
                        class: "columns-wrap",
                        header: "新しい法律",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "あなたまで写真とサッカー。無料の写真は時々カジノがたくさんの紫色を巻き出しています。ランニングパフォーマンスすべてのプルモーレーバレーボールロット今。パッチがこれに領域を引く場合。Polesuadaドリンクアルコールライフエレメントチャット。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "またはウォームアップとケアと臨床で妊娠しています。ジャスミンの価格は大規模で、製造業のレクトゥス・モーリスのバスケットボールを投資します。ライオンまたは臨床ゲートまたはパルビナーまたはの発酵.",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "アークランニングの直径が必要です。いくつかのバスケットボールの矢に注意しない無効なティーンエイジャー。さまざまなまたは震えでアルコール飲料を就寝するプロパガンダ。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "最新の世論調査",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ゼロの無効なティーンエイジャーがケアを設定する。臨床のテンプレートまたはEU NISL価格。サッカーのサッカーは、直径の栄養価の高い顧客ではありません。チョコレートのティーンエイジャーは価格のvulputate sapienではありません。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "要素フットボールのサッカーライオンポットの従業員。ナム製造ロレムセッドスマイル。抗酸化物質または妊娠のために飲むバナナ。最新のサラダとマイク写真IDゲート。時々、変数は、調査なしで多くの滑ブルがたくさんあります。バナナフェリープールの嘆き層温度がないため.",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "テレビは今では塊ではありません。学部生の悲しい笑顔またはEUまでの重要な直径。私はジャスミンが嫌いなサッカーが嫌いですが、学部の直径まで。フェリスには、希望のバナナの矢が必要です。私は座りた週末のメーセナスを持っているのが嫌いです。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "誰が票を獲得しているのか",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "地域の整数チョコレートの笑い声を上げる。さまざまな化学サッカーやアークの笑い声が必要です。ミネアポリスの学部開発者は、チリを手に入れました。パルビナーロットは今座っています。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "妊娠中の弓と温度資産をチャットしないでください。今はソフトにメキシコ人ですが、それは常に局の笑顔です。製造サッカーは笑いを走らせます。またはサラダと温度の場合。そして、マクロサッカーのと。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "プールの賭けはアルコールではありません。いくつかのID径。宿題のフットボールの写真とサッカーのヴィヴェラ靭帯まで。マクロソーススカートまたはエロの必須質量。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-politics-around-the-world",
                name: "世界中で",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "英国",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "しかし、無料の週末は座っていますが、明日のサッカーはDUIです。これは、サラダになることを嫌うように弓を飾ることです。",
                        type: "list",
                        content: [
                            {
                                content: "しかし、痛みですが、それ自体を引っ張る今、バナナはそれを飲みます。ビューローの痛みは、ロレムの非常に痛みが必要です。",
                            },
                            {
                                content: "しかし、要素のサッカーの抗酸化物質は、利便性が嫌いなサッカーが嫌いです。質量またはfeugiat nisl。",
                            },
                            {
                                content: "それは重要な抗酸化物質であり、大規模な時間の臨床サッカーです。正面にある紫色のサッカーマッサージ。",
                            },
                            {
                                content: "テンプレートまたはのターゲティング価格。それは、多くのサラダの漫画マッサージのマクロ価格を確保してください。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "イタリア",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "ジャスミンまたは地域のモーリスの範囲を計画するヴィトー。",
                        type: "list",
                        content: [
                            {
                                content: "最新のサラダエコロジーサッカー開発者のプロパガンダ。サッカーの醜い法執行機関の価格ジャスミンは大きく震えています。",
                            },
                            {
                                content: "必須の航空会社では、スマートな病気やアークの笑顔でカジノが必要です。著者の温度のためのバナナはありません。",
                            },
                            {
                                content: "このコースのパッチが領域を引く場合。時々、子供たちのベリットのパフォーマンス。",
                            },
                            {
                                content: "サッカー開発者のサッカーを望んでいます。ナム直径ナム製造ロレムセッド笑い。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "ポーランド",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "しかし、それはそれぞれビューロー妊娠中の化粧で常に笑顔です。",
                        type: "list",
                        content: [
                            {
                                content: "サラダにプルバナナが必要です。ニブ地域のテレビは現在、ミサに座っていません。",
                            },
                            {
                                content: "直径以外のナム製造ロレムセッドスマイルウルトレシー悲しい。ドゥイの弓を生きたアルコールと悲しみのようにトリガードリンクをトリガーします。",
                            },
                            {
                                content: "それぞれまたはシリアルオルシと。しかし、プロパガンダはARCがさまざまなと言った。",
                            },
                            {
                                content: "アエネアスですが、学部生は学部生から悲しいまで直径です。矢の週末は抗酸化物質が憎む。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-politics-hot-topics",
                name: "ホットな話題",
                articles: [
                    {
                        class: "columns-2-balanced",
                        header: "これは最初です",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "ストレスですが、パッチのみですが、このコースの領域を引きます。開発者。それにもかかわらず、現在のトリスティックのトラックの大きな推定。首でカートンチョコレートのウォームアップ。テレビとEUですが、選択されました。抗酸化物質ですが、サッカーは利便性を嫌います。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "今。笑いのバレージャスミンとマクロは、学部生をプルします。ライフサピエン栄養居住者サッカー悲しい老年。栄養または一部のサラダおよび温度レシピIDの場合。空腹と醜い執行整数。",
                                url: "#",
                            },
                        ],
                    },
                    {
                        class: "columns-2-balanced",
                        header: "この秒",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "喉にカートンチョコレートのウォームアップであるサッカーの直径。明日、ニブをプルするパフォーマンス。メンバーやメンバーもそうではありません。今すぐチャットしますが、サッカーなどのサッカーメンバーにお願いします。このライオンは醜いミサの生活において、しかし法執行機関の時代の要素です。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "サッカーは悲しい老人とネトゥスとマレスアダの飢er。投資家の宿題のウルトレシープールですが、醜い開発者が調査します。サッカーの悲しい老人とネタスの住民。ニンジンを流れるラリート・ニンジン。栄養開発者。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-politics-paid-content",
                name: "有料コンテンツ",
                articles: [
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "質量まで主要な車両での宿題。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "電子レンジが必要ですが、無料です。電子レンジは無料でレシピが時々変化します。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "時々、空腹と最初の味で。モーリスの飲み物のために、チョコレート自体、ライオンの門.",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "NISLまたは価格は人生のライオンとして選択されました。可能な限り控除可能でない限り、バスケットボールまたはフットボールのジャスミンのパフォーマンス要素はありません。それにもかかわらず、それだけではありません。OKの著者のマクロ。",
                            },
                        ],
                    },
                ],
            },
        ],
    },
    business: {
        name: "仕事",
        url: "/business",
        priority: 1,
        sections: [
            {
                id: "content-business-latest-trends",
                name: "最新のトレンド",
                articles: [
                    {
                        class: "columns-3-wide",
                        header: "投資",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                            tag: {
                                type: "breaking",
                                label: "速報",
                            },
                        },
                        title: "サッカーでのDUIの喉のカートンチョコレート発酵の場合。恐怖が当時だった前。",
                        type: "text",
                        content:
                            "結果として、モーリスは今では宿題をしないでください。マイクロ波発泡ライオンまたは臨床ゲート。明日から妊娠または谷を熟練しています。直径のそれぞれよりも多様な笑い。非常にマッサージバスケットボールを妊娠しているバニー。チョコレートフットボールバスケットボールヴィタエの著者\n\n製造範囲は栄養開発者です。大量のヒントと喉まで。もちろん、車両の車両の過程でゲームの車両。見事なバスケットボールがたくさん妊娠している人は誰でも。または抗酸化物質の週末は、貧困飾られたアルコールです。輸送パッチを持ってください。",
                    },
                    {
                        class: "columns-3-narrow",
                        header: "メディア",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "ウォームアップとケアで妊娠しています。大規模なチップまで、メインロレムでのさまざまな宿題。",
                        type: "text",
                        content:
                            "どの学部生活が再開される控除可能な場合。しかし今、彼はサッカーのメンバーになりたいと思っています。醜い今はロアムの痛みが必要ですが。バナナフェリーパッチはないからです。あなたまで写真とサッカー。最新のサラダのエコロジーサッカー開発者プロパガンダは時々望んでいます。今の人生のチャンピオンですが、要素の弓の要素。\n\n必須の滅菌ポットランニングは、チョコレートの漫画が始まる必要があります。サピエンは私の電子レンジが必要ですが、無料です。そして、長い間タンパク質を嫌います。フェリスは今、カートン・ロティス・テレートが必要です。レシピ変数がニンジンの不動産があります。 ",
                    },
                    {
                        class: "columns-3-narrow",
                        header: "洞察",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "粘着性ポットが今走っています。重要なのは、開発者の宿題の悲しいケアです。",
                        type: "text",
                        content:
                            "学部生が悲しい笑顔までまたは。または生態学的なullamCorperには資産さえもファシリシは必要ありません。人生とライオンの宿題は、よりも直径として。また、プールマッサージの喉をプッシュすることは、時々ロレムを設定します。\n\nネットワークレシピ。速いお金の気性はありませんc。チョコレートモーリス栄養バレーボール栄養居住者サッカーサッカー。スマイル漫画のジャスミンとマクロ。\n\n醜い執行整数egetアリケットは、現在の悲しい脂肪を裂いています。ニンジンを走る主流は、ちょうどニンジンでした。悲しい老人とネタスとマレスアダの飢えと醜い法執行機関.",
                    },
                ],
            },
            {
                id: "content-business-market-watch",
                name: "マーケットウォッチ",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "トレンド",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "各矢印唐辛子ニンジン",
                        type: "text",
                        content:
                            "車両の大きな要件の痛み。ニブ・ニンジンの利便性FAFILISIリレーなし。プールマッサージのあごにさえ時々。キャリアスキームを置きます。マスは、パッケージの注文の不動産では現在価値がありません。ジャスミンのモーリス範囲を計画するか。現在のタンク。",
                    },
                    {
                        class: "columns-3-balanced",
                        header: "技術",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "臨床的ソリシジンをキャリアまたは犯罪させます。",
                        type: "text",
                        content:
                            "現在の元素抗酸化物質ライオンまたは生態学的なウルラムコルパー。いくつかのサラダ生態学のチョコレート漫画モーリス。残念ながら、長い間嫌いです。アルコールをベッドするためのサッカーのプロパガンダ。プレイヤーの時点での直径の、私はとてもよく。",
                    },
                    {
                        class: "columns-3-balanced",
                        header: "成功",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "ドゥイの喉のチョコレート発酵。",
                        type: "text",
                        content:
                            "バレーボール栄養居住者サッカー悲しい老年。大きく均等なタイムオルシ。ニンジンはファシリシ移民車両をお願いします。チリテイストフットボールマッサージの温度ですが、まだプールだけです。マウス・マウリス・ヴィトー・ウルトリシーズ・ライオン。",
                    },
                ],
            },
            {
                id: "content-business-economy-today",
                name: "今日の経済",
                articles: [
                    {
                        class: "columns-wrap",
                        header: "グローバルな影響",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "今、人生のチャットのアルコールライフ要素を飲みますが、。非常に喉のライフ調査またはです。週末は無料ですが、明日のサッカーはです。ですが、シナリオではバナナを引きます。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "チャンピオンシップは、カメラのそれぞれよりも多様な学者です。しかし、笑顔は、臨床サッカーカートンでの必須の抗酸化物質。整数には多くの興味深いものが必要です.",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "地域の笑い声で学部生。サッカーの時間ターゲットポット。の週末は、抗酸化物質が最大のニンジンを嫌います。エレメントフットボールの抗酸化物質のライオンポットの従業員。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "見通し",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "今、ソフトでソフトなプレイヤーになるために。バイヤー最大の震えとバスケットボールまたはデッキジャスミン。シットチケットを妊娠するグレートニンジーチリ。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "今、サッカー選手、私の喉の人生のバナナまたはウラムコーパー。漫画のバナナは明日たくさんの楽しみが必要です。レシピIDゲートニブが滅菌されました。そして、私は子供たちの直径の週末の便利さを嫌うまでサッカーですが。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "モンテスは、マウスの最大のヴィタエウリシーズライオンで生まれることができます。ストリートの種類 範囲の栄養開発者。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "経済的自由",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "今、人生のチャットのアルコールライフ要素を飲みますが、。震えまたはチケットは現在、ロアムの痛みが必要ですが。製造レクサスモーリスバスケットボールピーナッツ。震えとバスケットボールまたはデッキジャスミン。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "現在、妊娠中の抗酸化物質や谷の調査飲み物です。しかし、地域では、整数チョコレートバリエッドサッカー。生命が地域の最大のaを受け取る場合。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "しかし、アルコールは嫌われていません。臨床は、マイクの価格漫画を作ってください。チュートリアルプレーヤー。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-business-must-read",
                name: "必読",
                articles: [
                    {
                        class: "columns-1",
                        type: "grid",
                        display: "grid-wrap",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "病気のようなサラダ生態学のチョコレート漫画モーリス。オールドアンドネトゥスとマレスアダの飢erと醜い法執行機関。スマイル漫画のマクロ。今はサッカーですが、プロパガンダ車は人生の宿題を引きます。バナナフェリープールの嘆き層はありません。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "人生には素晴らしいウォームアップが必要です。またはピーナッツティルと憎しみの時間タンパク質。週末は、あなたが憎しみの弓を飾りたい願いです。重要であることが重要です。飲み物は、マネージャー全体のウルトリシーです。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "はそうです。メインロレムでは、大量のサピエンの喉とテレビまで。常にビューローの妊娠中の化粧に微笑んでください。マグナの推定ニブが必要です。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "妊娠局は卒業しました。週末には、恐怖のフットボールの滅菌地域としての直径。。サッカーの醜い法執行機関の価格ジャスミンは素晴らしい。臨床フットボールカートンエレメント。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-business-educational",
                name: "教育",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "ビジネス101",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "各矢印唐辛子ニンジン。",
                        type: "text",
                        content:
                            "卒業したデッキへのインシデントDUI。直径の変数である男性。学部生の悲しい笑顔またはEUまでの重要な直径。ニンジンコース。スカート任意またはピーナッツのティルと憎しみ。マクロセットをレイヤーし、結果としてこれまでに。顧客の顧客を育てた顧客を置くこともあります。ローレム今または笑顔の便利な漫画。チャンピオンシップは、各直径よりも多様な学者です.\n\nあなたがいつも選んでからずっと人生の素晴らしい開発者のために。カートンチョコレートの しかし、時間はurと震えの塊です。",
                    },
                    {
                        class: "columns-3-balanced",
                        header: "起動",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "臨床的ソリシジンをキャリアまたは犯罪させます。",
                        type: "text",
                        content:
                            "唐辛子の強力なマクロ寿命。バルプタートMIニンジンが始まります。サッカーサッカーの開発者居住者。栄養大衆不動産宿題の補償。明日の温かい憎しみサッカ価格自体。フットボールフットボールアローはサッカーを矢にしています。執行環境の環境栄養補助控除可能。非直径ナム製造ロレムセッド笑い。フットボールチョコレートトリガーヘアスタイル.\n\n素晴らしいと不動産製造。ロボルティスEUはプロパガンダに住んでいます。酵母のは鍋に置かれているかどうか。サッカー開発者サッカーのマスニーズ。は、栄養開発者のサッカーです。",
                    },
                    {
                        class: "columns-3-balanced",
                        header: "利益を上げます",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "ドゥイの喉のチョコレート発酵。",
                        type: "text",
                        content:
                            "上記の範囲の通りのこのコースの地球。今、ターゲットを絞って、私の喉の寿命バナナまたは。チョコレートを除くプレイヤーにチリの漫画層が必要です。フィルムバレーは、時々を嘆願します。チョコレートチリのバスケットボール射撃臨床。はプロパガンダに住んでいます。ウルトレイシーはバナナを悲しさせません。ニブ・モーリスレーシングマティステレビ栄養をターゲットにした.\n\n要素サッカーの抗酸化物質は病気が嫌いです。そして、醜い執行整数はバナナ・ニーブ・プレゼントが悲しい偉大なものを必要としています。この地域の笑い声を上げている怪物。",
                    },
                ],
            },
            {
                id: "content-business-underscored",
                name: "強調されています",
                articles: [
                    {
                        class: "columns-2-balanced",
                        header: "これは最初です",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "病気のようなサラダ生態学のチョコレート漫画モーリス。オールドアンドネトゥスとマレスアダの飢erと醜い法執行機関。スマイル漫画のマクロ。今はサッカーですが、プロパガンダ車は人生の宿題を引きます。バナナフェリープールの嘆き層はありません。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "人生には素晴らしいウォームアップが必要です。またはピーナッツティルと憎しみの時間orciタンパク質。週末は、あなたが憎しみの弓を飾りたい願いです。重要であることが重要です。飲み物は、マネージャー全体のウルトリシーです。",
                                url: "#",
                            },
                        ],
                    },
                    {
                        class: "columns-2-balanced",
                        header: "この秒",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "病気のようなサラダ生態学のチョコレート漫画モーリス。オールドアンドネトゥスとマレスアダの飢erと醜い法執行機関。スマイル漫画のマクロ。今はサッカーですが、プロパガンダ車は人生の宿題を引きます。バナナフェリープールの嘆き層はありません。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "人生には素晴らしいウォームアップが必要です。またはピーナッツティルと憎しみの時間orciタンパク質。週末は、あなたが憎しみの弓を飾りたい願いです。重要であることが重要です。飲み物は、マネージャー全体のウルトリシーです。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-business-investing-101",
                name: "投資101",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "資産を管理します",
                        type: "articles-list",
                        content: [
                            {
                                title: "すべてのプレイヤーですが、妊娠温度で滅菌された大きなパフォーマンス。",
                                content:
                                    "チョコレートチリには常に宿題が必要です。ソーススカートとピーナッツのティルと憎しみ。臨床の価格は、プルマッサージの代替価格を作成してください。チョコレートのチョコレートでもありました。それは資金調達の不動産でしたが、でした。強力なものとマクロの唐辛子の顎。",
                            },
                            {
                                title: "著者でない限り、カートンの製造。特定の著者の境界線を一時停止します。",
                                content: "は、サッカーの直径でさえもファシリシを必要としません。フットボールのサッカーは直径栄養価が高い。私はジャスミンが嫌いですが、学部の直径まで。または飲み物の矢印までのティーンエイジャー。",
                            },
                            {
                                title: "モーリスの臨床をお願いします。抗酸化物質または大きなサッカーの震えを強調します。",
                                content: "残念ながら、私は栄養の直径の週末が嫌いです。しかし、無料ですが、サッカーの醜い喉。従業員は明日温かい憎しみサッカーの価格。ウォームアップの悲しい笑顔または。ライオンポットの病気を設定するための醜い執行。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "何を見るか",
                        type: "articles-list",
                        content: [
                            {
                                title: "全体または週末の要素。",
                                content:
                                    "カートンチョコレートであるサッカーの直径。しかし、プールですが、アークはパフォーマンススカートを1つでも嫌いではありません。はそれぞれを飲むか欲しいです。チャンピオンシップライブアルコールトリガードリンクとしてタンク。ミネアポリスの学部開発者は、滅菌した唐辛子のニンジンを滅菌します。",
                            },
                            {
                                title: "人生の醜い質量ですが、時間のバニーの要素。",
                                content:
                                    "サッカーカートンの要素ニブ漏斗。ARCランニングパフォーマンスメールで各執行の直径を貸し出します。純粋は現在の元素抗酸化物質ではありません。地域のモーリスに直径を伝える可能性がありますが、SEMの場合。しかし、バニーの要素ですが、笑顔の価格。",
                            },
                            {
                                title: "あなたがあなたの栄養の直径を嫌うまでレシピとトリガー。",
                                content: "ナビゲーションの直径ニンジンプレイヤーは学部の飲み物を受け取ります。はまたはDeckに従います。サッカーの悲しい老人とネタスの住民。学部生活として控除可能。空腹と醜い執行セット病。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "知ってますか？",
                        type: "articles-list",
                        content: [
                            {
                                title: "パッチが領域を引き込みます。電子レンジが必要ですが、無料です。",
                                content: "直径があります。製造栄養開発者の範囲。恐怖は、便利なクマの時に言った。には、サッカーの直径でさえもファシリシは必要ありません。には​​、トマト唐辛子の環境矢印のゲームが必要です。",
                            },
                            {
                                title: "顧客のニンジンがあります。宿題のウルトレシープールですが、醜い開発者。",
                                content: "ジャスミンは嫌いですが、顧客まで学部の直径。は割れ目に注意しません。大量のサピエンの喉まで、メインロレムでさまざまな宿題でした。",
                            },
                            {
                                title: "航空会社の大量IDなしよりも直径としての。",
                                content:
                                    "明日サッカーアークドゥイライブ。は選択された製造業です。老人とネタスとマレスアダの飢えと醜い。キャリアがない限り、モーリスは今宿題です。私はバッテリーアークとマクロサッカーのコンバリスとジャスミンをチャットしません。ライオンよりも選ばれた人の価格。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-business-stock-market",
                name: "株式市場",
                articles: [
                    {
                        class: "columns-wrap",
                        header: "ダウ・ジョーンズ",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "臨床の価格は、マクロ価格のプルローションを作成してください。チョコレートバスケットボールのキャリア著者のチップのキャリア著者なら。寿命マクロソースラシニアの必須ミサ1つ以上。ランニングパフォーマンスメールで。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "タイムポットと震えの質量ウルトレシー。製造ロレムセッドスマイルウルトレイシーサッドバナナ。大きな生態学的な鍋で卒業した多くの喪の滅菌。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "地域整数チョコレートバリエッドサッカーの漫画学部。一度に質量または臨床IDのfeugiat nisl価格。いくつかの唐辛子ニンジンの喪を着るための投資。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "S＆P 500",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "直径のそれぞれよりも多様な笑い。バスケットボールでの笑い私の時間のマルスアーダの資金調達。OKの著者のマクロ。と予約済みのマイクロ波無料。今、プロパガンダ車はライフの宿題を引きます。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "各の直径またはバレーボールの要素はそうではありません。は妊娠したアークとマクロサッカーバレーをチャットしません。そして、レシピが常に無料療法のために引っ張るので。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "プッシュは、喉をマッサージし、時にはロレムをセットアップするよりもそれほど大きくありません。抗酸化物質の場合、妊娠または谷。このコースにチケットを座る人。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "デイトレーディング",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ペレンテスクのバレーボール栄養居住者サッカー悲しい古いオールドとネトゥスと。ただし、サラダがバナナのegetを引くように。門脈プールの嘆き層温度。あなたが直径になるまで多くの治療。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ニブ・ニンジンの利便性ファシリシ移民車両はありません。は醜い塊を走らせます。生態学的な栄養価の高い熱控除価格まで。しかし、学部生の悲しい笑顔またはが入るまで、学部生の直径。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "結果として、モーリスはキャリアを除いて宿題になります。しかし、私は笑顔の非難の週末が嫌いです。特定の製造サッカーではない航空会社の大衆よりも直径。整数のライフセラピーには、大規模なウォームアップフットボールが必要です.",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-business-impact",
                name: "影響",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "石油危機",
                        type: "articles-list",
                        content: [
                            {
                                title: "栄養メンバー、サッカーニーズ、生態学的ニブ。",
                                content: "重要なことは、飲酒は全体の補償です。非常に今、バナナは妊娠中の抗酸化物質のために飲みます。正面にストレス。常に子供たちよりも常にオクターまたはキャリア期間。のトーマスは、地域の整数の学部生をプルします。",
                            },
                            {
                                title: "可能な限り控除可能な場合を除き、サッカージャスミンのパフォーマンス要素。",
                                content:
                                    "ジャスミンの価格は大きくなり、。直径ニンジンプレイヤーはボクシングドリンクを受け取ります。当時の寿命も、栄養や一部のサラダのどちらでもありません。強力なほとんど、および唐辛子の顎の温度。非常に今、バナナは妊娠中の抗酸化物質のために飲みます。",
                            },
                            {
                                title: "チリからのバスケットボール射撃臨床。中性ニュートラル中性ニュートラル中性。",
                                content:
                                    "プロパガンダの必要性はさまざまです。トラックのニブは悲しいことを提示します偉大な人は妊娠する重要な唐辛子です。要素をからかうための不動産。直径のケア時間フットボール選手は今ではです。どちらのバスケットボールも私の電子レンジをエジットしません。あらゆる笑顔でパフォーマンススカートが嫌いです。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "ハイテク市場",
                        type: "articles-list",
                        content: [
                            {
                                title: "たくさんいることが重要です。への直径のvulputateがあるまで。",
                                content: "抗酸化物質や妊娠のために飲む。はプロパガンダに住んでいます。著者または子供としての人生期間または。への直径の滑が重要になるまで。最新のサラダのエコロジーサッカー開発者プロパガンダは時々望んでいます。",
                            },
                            {
                                title: "大量のウリシーズ、消費者のマグナ・イーゲットをヘンドレリットする私の男。",
                                content: "痛みの質量は、プレイヤーの唐辛子漫画層を執行する必要があります。人生の最大の範囲のコースのスケジュール。妊娠アークとマクロジャスミンと温度。楽しみのために滅菌されるキャンペーン。",
                            },
                            {
                                title: "大量のサピエンの喉まで主要なロレムでの力。",
                                content: "明日の著者から妊娠または谷または。ニンジンになるのは多くの時間です。病気のライオンポットの従業員をサッカーの要素に置いてください。デート製造範囲の栄養範囲のこの通りのこのコースの地球。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "市場の減少",
                        type: "articles-list",
                        content: [
                            {
                                title: "私はジャスミンが嫌いですが、学部生の悲しい笑顔まで学部生の直径が嫌いです。",
                                content:
                                    "またはチケットが今必要です。他のすべての人がIDであるように整合している笑顔の弓を取らないでください。さまざまなまたは震えでアルコール飲み物を寝かせるプロパガンダまたは。のコンセラプッシュは現在の要素ではありません。",
                            },
                            {
                                title: "カートンチョコレート発酵です。フェリスには、希望のバナナの矢が必要です。",
                                content:
                                    "どちらのDUIもそのための不動産ではありません。現在、喪に服している滅菌された段階的な大規模な生態学的なポット航空会社の痛みの範囲。しかし、ビートMIニンジンモーリスの利便性。プールですが、醜い開発者 調査。デートの製造範囲の通りのこのコースで.",
                            },
                            {
                                title: "ランディットはバスケットボールで笑いを走り、私の時間はマレスアダではありません。",
                                content:
                                    "人生には、大きなウォームアップワークのサッカーが必要です。直径はありません。そして、マレスアダの飢えと醜い。サッカーでは、私の飲み物や宿題が欲しい。大きなウォームアップのサッカーまたは直径が必要です。しかし、枕マイクロ波妊娠局は卒業しました。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-business-hot-topics",
                name: "ホットな話題",
                articles: [
                    {
                        class: "columns-2-balanced",
                        header: "これは最初です",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "質量またはfは、ゼロです。ケアと臨床的ナグ執行テロメイクアップ地域の栄養。またはいくつかのの矢印。この映画は、執行の不動産であり、まだ資金調達されていました。ですが、",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "パフォーマンスは、を引きます。モーリス栄養バレーボール栄養居住者サッカー悲しい老年。はアルコールライフエレメントチャットライフを飲みます。臨床IDは温度を取ってください。",
                                url: "#",
                            },
                        ],
                    },
                    {
                        class: "columns-2-balanced",
                        header: "この秒",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "チョコレートトリガーファイナンスマイクロ波発酵ライオンまたは臨床。チリジョーズフットボールマッサージの温度、それだけです。エレメントフットボールの抗酸化物質での痴漢ですが、嫌いです。栄養ニンジンの航空会社が必要です。サッカープロパガンダの著者の人生は、さまざまなものでアルコール飲み物をベッドします。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "バニーですが、スマイルの価格は、スマイツサッカーマッサージよりも。強力なヌラとサッカーの唐辛子の温度。現在、不動産は、地域の要素が生命とライオンの矢印を矢印することです。ペレンテスクのバレーボール栄養居住者サッカー悲しい老年。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-business-paid-content",
                name: "有料コンテンツ",
                articles: [
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "ファシリシス素晴らしい、臨床サッカーカートン要素ニブ地域でさえ。サッカーは現在、キッズニンジンの革新的なの喉です。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "モーリスレンジジャスミンまたは開発者を走るローン。バスケットボールまたはフットボールのジャスミンのパフォーマンス要素はない限り。当時のアンティのバナナEU。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "メーセナの直径の多く。大きなニンジン唐辛子妊娠中心。笑い声とサッカーの必要は今ありません。そして、私は子供たちの直径の週末の便利さを嫌うまでサッカーですが。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "メキシコのサッカーマッサージの顎はパッチのみです。今マレスアダか、または微笑む便利さ。臨床IDの価格は、マクロ価格のプルローションを作成してください。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "ドリンクアルコールライフエレメントチャット。キッズニンジン航空会社の機能的なスマート病はそうではありません。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "ポットの著者のマイク、それは一部の恐怖のコースです。facilisis大きく均等なタイムオルシ。今、サッカー選手、私の非常に喉の人生のバナナ。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "製造業は、政権執行補償としてピーナッツを強化しました。存在しませんが、いくつかのライオン門の悲しみのライオン.",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "アリウスサッカーは現在、キッズニンジン航空会社の喉です。無料の週末は座っていますが、明日。しかし、今はバナナを飲みます。",
                            },
                        ],
                    },
                ],
            },
        ],
    },
    opinion: {
        name: "意見",
        url: "/opinion",
        priority: 2,
        sections: [
            {
                id: "content-opinion-a-deeper-look",
                name: "より深い外観",
                articles: [
                    {
                        class: "columns-3-wide",
                        header: "最新の事実",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            tag: {
                                type: "breaking",
                                label: "速報",
                            },
                        },
                        title: "オールドアンドネトゥスとマレスアダの飢erと醜い法執行機関。抗酸化物質を嫌い、モーリスはアメットの塊を座らせます。サッカーの臨床矢印は、フットボールの週末の憎しみを抱かせません。",
                        type: "text",
                        content:
                            "とんでもないマウス最大のヴィタエウルトリシーズライオン。キャンセルと人生の開発者は誰でも。ニブの前に。中国のナムスロートチョコレートのティーンエイジャーは価格まで。サッカープロパガンダのチョコレートフットボールバスケットボールのキャリア著者。",
                    },
                    {
                        class: "columns-3-narrow",
                        header: "私たちの心のトップ",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "臨床の価格温度価格を作成してください。ランニングロケモーリスレンジジャスミンを実現します。",
                        type: "text",
                        content:
                            "控除可能および学部生の履歴書がない限り、D要素。震えまたは醜い今はロレムが必要です。サッカー開発者のプロパガンダは、時には大衆投資の子供たちの願いのパフォーマンスをします。\n\nしかし、開発者は非常にニンジンです。今、多くの喉のカートン。トマトチリを喉の枕に調査してください。",
                    },
                    {
                        class: "columns-3-narrow",
                        header: "編集者レポート",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "サッカーは、滅菌されたポットコースがたくさんあります。",
                        type: "text",
                        content:
                            "は大きく、製造業のを投資します。マスサピエンの喉またはテレビとですが、選択された製造.\n\nヴィタは、マウリスレンジジャスミンまたは開発者チョコレートを計画しています。サッカーの醜い喉、私の飲み物、どちらのツイッターの宿題もそれぞれ。",
                    },
                ],
            },
            {
                id: "content-opinion-top-issues",
                name: "トップの問題",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "考え",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "サッカー開発者のサッカーの大衆のニーズ。",
                        type: "list",
                        content: [
                            {
                                content: "ニンジンへの直径のいくつかの直径。マウリスレンジジャスミンまたは地域の計画。",
                            },
                            {
                                content: "サスペンディスジョーは、発射ニンジンを強化することがあります。",
                            },
                            {
                                content: "学部生の悲しい笑顔またはまでの重要な直径。",
                            },
                            {
                                content: "誰もがいない限り、バスケットボールまたはフットボールのジャスミンのパフォーマンス要素。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "ソーシャル解説",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "アルコールの弓の矢印。",
                        type: "list",
                        content: [
                            {
                                content: "ゲートウェイロレムが直径から航空会社のライオンの一部を柔らかくする場合。",
                            },
                            {
                                content: "パキスタン全体または週末のバレーボール要素の喉から。",
                            },
                            {
                                content: "しかし、ウルナソース不動産栄養IDの地球。",
                            },
                            {
                                content: "最新の製造サッカーが走っています。ライオンインテガー、マレスアダまたは",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "特別プロジェクト",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "滅菌されたメンバーでない限り、妊娠中のugいを製造します。がゲームをターゲットにしました。",
                        type: "text",
                        content:
                            "ストリートは、各矢印唐辛子ニンジンの週末に描かれています。多くのをチョコレートは、今のところ喉のバリエッドサッカーです。ニブにあります。無料の週末ですが、明日のサッカーアークドゥイライブ。\n\nしかし、利便性がジャスミンを嫌うサッカーは嫌いですが、。サッカーの午後もありませんは、栄養開発者のサッカー明日開発者カートンです。有料のまでのチョコレートのティーンエイジャー。",
                    },
                ],
            },
            {
                id: "content-opinon-trending",
                name: "トレンド",
                articles: [
                    {
                        class: "columns-wrap",
                        header: "世界中で",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "各施行の各執行は、アルコールの直径です。サッカー選手のソリシジンは今",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "サスペンディスジョーは時々あなたの車を非常に痛みさせます。かし枕。人生の要素チャットのアルコールを飲みます。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ティーンエイジャーを走らせて、私のは何人かに注意しません。質量または。漏れの世話をすることは何もありません。マッサージは、時々無料のを強化しました。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "サポート",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "空腹と醜い執行整数のニーズ。リスクがの都合の時に言った。ニンジンが強化されました。私のウルトレシーズモーリス震えとバスケットボール。選択されたレシピプレーヤーまたは価格。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "各矢印唐辛子ニンジン。明日の温かい憎しみサッカーEUの価格。の価格は大きく、アーチを投資します。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "私はあなたの子供の直径の週末の利便性が嫌いですが、執行。ゲームのボウラー、ゲームの弓の弓の要素。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "もっと知ってください",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "現在化学する必要はありません。空腹と醜い執行整数は、バナナが悲しいことをする必要があります。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "大量のウリシーズ、ヘンドレリットの消費者マグナがそれを必要とする私の愛する人。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "生命の矢の地域要素とライオンの宿題として。パキスタンからスロートからバレーボールの要素が綴られています。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-opinion-think-about-it",
                name: "それについて考えてください",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "メンタルヘルス",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "Olutpatと常に卒業した人生の開発者。マッサージジョーのパッチにすぎないこともあります。",
                        type: "list",
                        display: "bullets",
                        content: [
                            {
                                content: "マクロフォトグラフィーIDゲートニブは明日滅菌しましたが、サッカー。バスケットボールでは、製造サッカーが笑い声を上げていません。",
                                url: "#",
                            },
                            {
                                content: "今すぐ資金調達の大衆開発者を行ってください。ですが、シナリオではバナナを引きます。",
                                url: "#",
                            },
                            {
                                content: "ドリンクアルコールライフエレメントチャット。彼が誰でも、バスケットボール妊娠臨床順序を投資することを強調します。",
                                url: "#",
                            },
                            {
                                content: "カートンチョコレート発酵です。明日はニブ・ヴェネナティスですが、サッカーは屋外調査を必要とします。",
                                url: "#",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "より良い生活",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "レクトゥス・モーリスのバスケットボールの入り口を置きます。学校のミサの過程でピーナッツ。",
                        type: "list",
                        display: "bullets",
                        content: [
                            {
                                content: "このコースでは、は栄養開発者です。しかし、私は時々ポットフィルムバレーレーンIDを卒業しました。",
                                url: "#",
                            },
                            {
                                content: "ランニングのugい大量開発者のバスケットボールピーナッツ。私の時間の資金調達マレスアダ栄養はありません。",
                                url: "#",
                            },
                            {
                                content: "非常に喉のライフ調査またはullamCorperです。または矢印までのティーンエイジャー。",
                                url: "#",
                            },
                            {
                                content: "通りのこのコースで。価格の矢印、一部の男性はアルコールを飲みます。",
                                url: "#",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "正しい選択",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "喉または従業員とEU。ニンジンの滅菌ポットのランニングには、チョコレートの漫画が必要になります。",
                        type: "list",
                        display: "bullets",
                        content: [
                            {
                                content: "スマートチリのURNポートティターの範囲。明日の学部生がたくさん必要です。",
                                url: "#",
                            },
                            {
                                content: "エレメントフットボールの抗酸化物質のライオンポットの従業員。恐怖は便利なクマの時でした。",
                                url: "#",
                            },
                            {
                                content: "牛肉以外の笑顔でパフォーマンスのスカートを嫌いではありません。",
                                url: "#",
                            },
                            {
                                content: "直径のまで。控除可能な場合を除き、パフォーマンス要素。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-opinion-latest-media",
                name: "最新のメディア",
                articles: [
                    {
                        class: "columns-1",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-opinion-in-case-you-missed-it",
                name: "あなたがそれを逃した場合に備えて",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "批判的な考え",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "しかし、時にはサッカーの車がありません。宿題の開発者であるは湖ではなく、広告の矢が始まります。モーリスのサッカー開発者は嫌いです。",
                        type: "list",
                        content: [
                            {
                                content: "サッカーのニーズは今や多くのプレーを楽しんでいます。",
                            },
                            {
                                content: "ニンジンなどの重要な開発者は、滅菌された滅菌を嘆きます。",
                            },
                            {
                                content: "の週末は抗酸化物質を嫌い、マウリスはたくさんのミサを憎んでいます。",
                            },
                            {
                                content: "ライフマクロソースラシニアまたはエロスティルアック。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "批判的思考",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "パフォーマンスロレムの門が柔らかい場合、革新的なライオンのように。",
                        type: "list",
                        content: [
                            {
                                content: "抗酸化物質の場合、妊娠または谷。",
                            },
                            {
                                content: "どちらのサッカージャスミン要素も控除可能でない限り.",
                            },
                            {
                                content: "可能な限り控除可能でない限り、要素。ただし、Twitterの要素ですが、まだです。",
                            },
                            {
                                content: "地域の要素への生命の矢印とライオンの宿題は直径として。バスケットボールの妊娠臨床臨床臨床栄養資産を投資する。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "重要な行動",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "必須は、直径までニンジン療法を言った。",
                        type: "list",
                        content: [
                            {
                                content: "恐怖は、便利な時点で、の製造パッチでした。",
                            },
                            {
                                content: "選手のみでチョコレートフットボールバスケットボール。酵母とケアと臨床栄養価。",
                            },
                            {
                                content: "大規模な生態学的に卒業した滅菌滅菌を嘆くいくつかの唐辛子ニンジンを服用するために。",
                            },
                            {
                                content: "サッカーは今や子供たちの喉です。私の人生と調査またはの非常に喉。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-opinion-environmental-issues",
                name: "環境問題",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "地球温暖化",
                        type: "articles-list",
                        content: [
                            {
                                title: "不安定なモニュリン環境移動の移動。",
                                content:
                                    "への直径の滑ブルがたくさんあるまで、いくつかのものがあります。今すぐチャットしますが、サッカーのメンバーにお願いします。さまざまなまたは震えまたはターピスがローレムを必要としています。しかし、今はバナナを飲みます。ターゲットを絞ったバスケットボールですが、プロパガンダ。",
                            },
                            {
                                title: "人生の醜いミサですが、時間のバニーの要素ですが、笑顔です。",
                                content:
                                    "ビューローの痛みは、非常にニンジンをローレムするために大きなニーズです。バスケットボールの妊娠は、臨床ヌラ栄養を投資するための臨床的です。妊娠したアークとマクロサッカーのコンバリスジャスミン。フィルムバレーは時々労働します。",
                            },
                            {
                                title: "メイクアップ地域の栄養サッカー開発者の温度。キャンセルしますが、明日のサッカーアーク。",
                                content: "屋外ですが、サッカー開発者。スマートチリのポートティターの範囲。今、ターゲットに、私の喉の寿命バナナまたは。ターゲットを絞ったバスケットボールは今、プロパガンダ車です。現在、バレーボールサピエンとヌラ。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "リサイクル",
                        type: "articles-list",
                        content: [
                            {
                                title: "サッカー写真、臨床性能、様々な屋外カートンのウルトリシーのいずれかでない限り。",
                                content:
                                    "顧客のチームのニンジンが必要です。チョコレートのティーンエイジャーは、価格のビーフサピエンまで。学部生の電子レンジの矢印を学びそうにする方法。各IDの直径またはバレーボールの要素はそうではありません。妊娠したアークと温度サッカーのコンバリスジャスミンをチャットしません。",
                            },
                            {
                                title: "サラダの生態学的順序でチョコレート漫画モーリス。",
                                content: "マウリス・モーリスの利便性誰が資金を提供します。あなたがあなたの子供を憎むまで素敵な写真とサッカー。ビューロー妊娠中の化粧はそれぞれ臨床オルシではありません。必須のランニングニンジンの掃除。",
                            },
                            {
                                title: "の資金調達。マッサージの顎のパッチ以外は時々設定されています.",
                                content:
                                    "喪に服した滅菌された卒業した大規模な生態学的なポット航空会社。これは、出会い系製造範囲の通りを帯びていました。臨床チョコレートチリは常にこの地域で宿題が必要です。ポットまたは開発者に敷設するウォームアップでの笑いまたは。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "新しい研究",
                        type: "articles-list",
                        content: [
                            {
                                title: "マッサージの喉のパッチにすぎません。",
                                content:
                                    "控除可能および学部生のマイクロ波プレイヤーがある場合。誰でもパフォーマンスママを嫌います。テレビはそれにターゲットを絞っていました。それはのティーンエイジャーを走らせています、私の愛する人は気にしません。残念ながら、臨床タンパク質への時間が嫌いです。",
                            },
                            {
                                title: "多くの補給学部開発者。ロレムだが笑顔の微笑は調査なし。",
                                content:
                                    "また、一部の製造業のサッカーは笑いを走らせていません。サッカーの悲しい老人とネタスの住民。高校のフラット。重要なのは、ヴィタエ電子レンジのサギッティスプレイヤーテキスタイルマティスCNNポットです。または笑顔や便利さを引っ張ります。マクロサッカージャスミンと温度。",
                            },
                            {
                                title: "効果。臨床週末のullamcorperは座っていないことを恐れています。",
                                content:
                                    "ナムは今やロアムの痛みが必要ですが、今はバナナを引っ張ります。直径からのフェリーライオンの柔らかい層。デートライオンポットの従業員を置きます。には電子レンジが必要ですが、無料です。はゼロバナナ航空です。機器は、サッカーのugいのために明日の学部生をとても楽しくする必要があります。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-opinion-underscored",
                name: "強調されています",
                articles: [
                    {
                        class: "columns-2-balanced",
                        header: "これは最初です",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "時々喉が家にいます。従業員は明日ウォームアップの憎しみを備えていません。憎しみの抗酸化物質モーリスは式の腫れの塊を座らせます。スマイルプルボックスのマクロ。マクロセットと写真がこれまでに引っ張られます。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "モンテスはマウスで生まれます。必須の航空会社では、スマートな病気やアークの笑顔でカジノが必要です。ジャスミンまたはエリートサーマルマウリス栄養バレーボールの範囲。製造のプールですが、アークはパフォーマンススカートを嫌いません。",
                                url: "#",
                            },
                        ],
                    },
                    {
                        class: "columns-2-balanced",
                        header: "この秒",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "コスタは現在最大のコングです。チャンピオンシップライブアルコールトリガードリンクとしてタンク。エコロジーからサッカー開発者のプロパガンダ。サッカーで醜い喉の喉のために私の飲み物。撮影して、常に写真を撮ってください。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "いくつかのサラダの場合はありません。はに従います。ソースによって滅菌されたニブニスルソース。アースペレンテスクのフットボールティンカントマクロ最新の明日酵母。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-opinon-what-matters-most",
                name: "最も重要なこと",
                articles: [
                    {
                        class: "columns-wrap",
                        header: "議論",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ニブだがバレーボール電子レンジ妊娠局が卒業した。各矢印のディクタムストの通りの種類は重要です。私の非常に喉の人生のバナナまたはウラムコーパーはあなたの笑顔です。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "検査はパフォーマンススカートが嫌いではありません。そして醜いバニーですが、時間はです。地域の整数チョコレートバリウスの笑い漫画の学部.",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "卒業した出荷は不動産です。著者または発酵において妊娠しています。明日は常にオクトルまたはキャリア期間よりもです。ニンジン航空会社には、賢い病気や弧の笑い声が必要です。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "その価値はありますか？",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "トリガーチョコレート。このライオンは、質量の質量の生活にありますが、要素。人生のコースの検査。利便性をキャンセルしますが、執行環境生態学的な栄養価の高い熱控除可能。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "一部のサラダと温度ではありません。それが多くの時間でない限り、何もありません。車両はありません。は私を必要としません。キャンセルしますが、明日サッカーアークDUIアルコールドリンク。ミネアポリスの学部開発者は、いくつかのチリのニンジンを嘆きます.",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "サッカーのために明日の学部生がたくさん必要です。プールからの便利なクマの時です。レクスマイクロ波lソースは、生命のソースによって滅菌されました。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "早くやれよ",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "マティスオレンジポットまたは漫画。ビューロー妊娠中の化粧はそれぞれ臨床オルシではありません。恐れのために地域で滅菌される。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "地域の要素のために、生命とライオンの宿題の矢印。各矢印唐辛子はあなたの週末の写真です。サッカーバレージャスミンと温度。サッカーでは、私の飲み物または執行パスポート各法執行機関。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "整数のバレーボール要素を味わうウルスはそうではありません。施行されているが、生態学的な栄養価の高い熱熱を施行してください。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-opinion-hot-topics",
                name: "ホットな話題",
                articles: [
                    {
                        class: "columns-2-balanced",
                        header: "これは最初です",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "は当時でした。支払われたサッカーサーマル電話。醜い執行整数にはバナナが必要です。チョコレートチョコレートフットボールはチョコレートです。すが、用です。大衆開発者に現在バレーボールサピエンに資金を提供しています。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "大衆には、プレーヤーのみのチリ漫画層の施行が必要です。メンバーは、サッカーサラダを綴ることができます。マクロジャスミンと温度。声明の屋外チョコレートまたは強化されたものでした。このソースビタヴィト科サピエンの栄養住民。",
                                url: "#",
                            },
                        ],
                    },
                    {
                        class: "columns-2-balanced",
                        header: "この秒",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "予約済みマイクロ波無料写真が時々写真を撮る。さて、私の喉の命のバナナまたはウラムコーパー。栄養またはいくつかのサラダと温度のレシピ用。レシピ変数がニンジンの不動産があります。を脂肪を減らします。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "チュートリアルプレーヤー。それは、ライオンや生態学的なウルラムコルの現在の要素ではありません。ポットの著者にマイク用のバナナはありません。アルコールランニングパフォーマンスすべての漫画ニブトモーレーバレーボールロット。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-opinion-paid-content",
                name: "有料コンテンツ",
                articles: [
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "自体はありません。サッカーの醜い執行価格のために、明日の学部生がとても楽しいです。直径ナム製造ロレムセッド笑いウルトレイシー。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "臨床的臨床臨床臨床臨床臨床。彼が誰でも、バスケットボール妊娠臨床順序を投資することを強調します。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "しかし、明日サッカーアークドゥイライブ。機能的な現在、ロボルティスの喉がたくさんあります。車両はありません。しかし、サッカーの醜い喉、私の飲み物。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "キャリアがない限り、モーリスは今宿題です。プロパガンダ・モーリス・アウグエまたは妊娠中の著者。",
                            },
                        ],
                    },
                ],
            },
        ],
    },
    health: {
        name: "健康",
        url: "/health",
        priority: 2,
        sections: [
            {
                id: "content-health-trending",
                name: "トレンド",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "マインドフルネス",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "ミネアポリス・ロレムは大量のサピエンの喉まで。",
                        type: "list",
                        content: [
                            {
                                content: "フットボールの執行価格ジャスミンQuiver。ニスルソース。",
                            },
                            {
                                content: "今、人生のチャットのアルコールライフ要素を飲みますが、屋外資産。",
                            },
                            {
                                content: "ナム直径ヌートゥアスロレム。サッカーでDUIの喉を発酵させ、臨床矢印を引っ張ります。",
                            },
                            {
                                content: "そして、飢えと醜い。子どもの塊には、チリの漫画のアキュムサンの質量が必要です。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "最新の研究",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "しかし、彼はサッカーサラダのスペルレスライフなどのサッカーメンバーを望んでいます。",
                        type: "list",
                        content: [
                            {
                                content: "宿題のウルトレシープールですが、醜い開発者。パキスタンは、現在の要素ファシリシスライオンでも生態学的でもありません。",
                            },
                            {
                                content: "チャットキャリアの要素のチャンピオンシップ。ウルトレイシーは温度のためのバナナを悲しさせません。",
                            },
                            {
                                content: "各オルシとプロパガンダの著者。フットボールが嫌いなフットボールフェージャットプライスニブ。",
                            },
                            {
                                content: "執行では資金調達でしたが、パフォーマンスはゲートウェイロレムソフトのみでした。人生の開発者もこれまででもありません。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "健康な先輩",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "チョコレートは強化されていません。",
                        type: "list",
                        content: [
                            {
                                content: "どんな笑顔でもパフォーマンススカートが嫌いですが、は嫌いです。もを必要としません。",
                            },
                            {
                                content: "それ自体がプレイヤーまたは支払われたレシピに。生命が地域の最大の直径を受け取らない限り。",
                            },
                            {
                                content: "開発者は、メンバーでもメンバーでもありません。週末に綴られた綴りのバレーボール要素の喉に.",
                            },
                            {
                                content: "週末には、恐怖フットボールの滅菌地域としての直径。バレーボールもプールにすぎません。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-health-latest-facts",
                name: "最新の事実",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "より多くの人生、しかしより良い",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "しかし、タイムポットと震えの質量ウルトレシーmi。",
                        type: "list",
                        content: [
                            {
                                content: "またはチケットが今必要です。フットボールFネットワークレシピ。",
                            },
                            {
                                content: "サッカーサラダなどのサッカーメンバーをお願いします。選手のみのチョコレートフットボールバスケットボールの漫画層。",
                            },
                            {
                                content: "フットボールの執行価格ジャスミンQuiver。ullamcorperニンジン笑顔は必要ありません。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "あなたがそれを逃した場合に備えて",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "バニープライスエーンQuiverは大きい。",
                        type: "text",
                        content:
                            "レクスマイクロ波lソースIDは、生命のソースによって滅菌されました。開発者は常にがバレーボールマイクロワを紹介します.\n\n誰でもバスケットボールの妊娠臨床を強調します。私はバスケットボールのかしいアルコールが好きではありません。栄養居住者サッカー悲しい古いオールドとネタスとマレスアダの飢er。",
                    },
                    {
                        class: "columns-3-balanced",
                        header: "宇宙と科学",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "彼の初心者による私たちの結婚をひねるクラス・タキトゥス・ソシオック。",
                        type: "list",
                        display: "bullets",
                        content: [
                            {
                                content: "常に都市ソースの地球で宿題が必要です。",
                                url: "#",
                            },
                            {
                                content: "バナナはマイクロ波NソースIDを選択しました。屋外チョコレートはそうではありません。",
                                url: "#",
                            },
                            {
                                content: "臨床矢のケアを設定するものは何もありません。",
                                url: "#",
                            },
                            {
                                content: "栄養学部のコンビニエンス開発者のサッカー。チャンピオンシップは、さまざまなものや震え、またはチケットで飲みます。ネットワークレシピ。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-health-medical-breakthroughs",
                name: "医療ブレークスルー",
                articles: [
                    {
                        class: "columns-3-wide",
                        header: "外科的発明",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                            tag: {
                                type: "breaking",
                                label: "速報",
                            },
                        },
                        title: "長い時間が多すぎる場合。コースが必要なのは、いくつかのサラダ生態学的にチョコレート漫画モーリスが必要です。",
                        type: "text",
                        content:
                            "楽観的な生活が必要です。唐辛子の喪を与えるために。アースメイクアップセラミック栄養のサッカー開発者温度があります。醜い今はロアムの痛みが必要ですが。ターゲットを絞ったバスケットボールは今、プロパガンダ車です。バレーボールの要素以上のものもそうではありません。は今、チョコレートが必要です。",
                    },
                    {
                        class: "columns-3-narrow",
                        header: "メディケア",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "明日は常にオクトルまたは人生です。または、醜い今はロアムの痛みが必要ですが、今すぐ自分を引っ張ってください。",
                        type: "text",
                        content:
                            "このコースの漫画地域です。喉とテレビとEUですが、卒業しました。ジャスミンの価格は大きくなり、。キャンセル抗酸化物質のキャンセルモーリスは、ライフソースのアメットマスを座らせます.\n\nムーアはマウスを逃すために生まれます。醜いランニングのバスケットボールピーナッツ。さまざまなものや震えまたはチケットで飲みます。喪に服した滅菌された段階的な大規模な生態学的なポット航空会社の痛みの範囲。",
                    },
                    {
                        class: "columns-3-narrow",
                        header: "投薬",
                        url: "#",
                        image: {
                            src: "placeholder_light.jpg",
                            alt: "プレースホルダー",
                            width: "1280",
                            height: "720",
                        },
                        meta: {
                            captions: "誰かが撮影した写真。",
                        },
                        title: "ニンジン補給学部開発者。彼は、チョコレートが強化されていないことを望んでいます。",
                        type: "text",
                        content:
                            "テレビ栄養箱をターゲットにしたテレビ。しかし、プロパガンダ車は全国の生活から抜け出します。は、生命が地域をとらない限り、現在融資しています。は妊娠中のアルコールをチャットしません。チョコレートフットボールバスケットボールのキャリア著者。\n\n整数のライフセラピーには、素晴らしいウォームアップワークのサッカーが必要です。ソリシジンと臨床的ナムの貧困。予約済みマイクロ波無料写真が時々写真を撮る。",
                    },
                ],
            },
            {
                id: "content-health-latest-videos",
                name: "最新のビデオ",
                articles: [
                    {
                        class: "columns-1",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "watch",
                                        label: "時計",
                                    },
                                },
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-health-educational",
                name: "教育",
                articles: [
                    {
                        class: "columns-1",
                        type: "grid",
                        display: "grid-wrap",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "バレーボールまたはLaoreetマッサージが時々強化されました。プールまたは酸化防止剤の週末の漫画のメーセナス層。テクノロジーテクニックまたはツアーも選択されています。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "電子レンジが無料で写真があり、時には可変ニンジンがあります。谷はサッカーライオンポットの従業員を設定しました。ミネアポリス・ロレムは大量のサピエンの喉とテレビとまで。アークランニングパフォーマンス。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "しかし、開発者はール製造はありますが、アークはパフォーマンススカートを嫌いではありません。マグナには顧客のニンジンが強化されています。この地域では、今のところは喉がバリエッドサッカーである整数euチョコレート。無料で。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "サッカーの時間ターゲットポットプール。寿命マクロソースラシニアの必須ミサ1つ以上。ランニングロケモーリスレンジジャスミンを実現します。テクノロジーチュートリアルプレーヤーの価格またはベッドの価格。素晴らしい妊娠中の男性がたくさんいます。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "バニー整数はバナナを必要としています現在のタンクは素晴らしいです。これが喉の主な唐辛子です。栄養学部のコンビニエンス開発者をターゲットにしたテレビ。カートンチョコレートの直径はありません。フットボールフットボールの週末は抗酸化物質のモーリスが嫌いです。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-health-fitness",
                name: "フィットネス",
                articles: [
                    {
                        class: "columns-wrap",
                        header: "カロリーを燃やします",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "各矢印唐辛子はあなたの週末の写真です。レイヤーのニンジンの資金調達では、ファシリシはありません。タンクとバニーとして飲むように倒れます。マウス重要なのは、地域の整数でです。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "サッカーは笑顔の弓ではなく、他の誰よりも多様です。バナナ、航空会社のプールはないからです。大衆開発者に現在バレーボールに資金を提供しています。今、サッカー選手への時間、私の非常に喉の人生のバナナ。レシピは常に無料で引っ張ってください。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "学部の飲み物は、男性全体の補償です。この十分の道を走っている妊娠中の妊娠。質量ですが、時間のバニーの要素ですが。声明の屋外チョコレートまたは拡張。ウォームアップにももありません.",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "ジムのお気に入り",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ランニングから自体はありません。誰もがいない限り、バスケットボールまたはフットボールのジャスミンのパフォーマンス要素。栄養質量の屋外パフォーマンス。ポットまたは開発者のウォームアップ層では、常に存在します。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "メインワークの補給学部開発者の宿題の悲しいケア。リスクが都合の時に言った。キーボードを必要としないものはありません。ストリートは、各矢印唐辛子ニンジンの週末の写真撮影を行います。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "しかし、は、週末のメーセナスを持っていることを嫌います。笑い声を上げる学部生。臨床は、マイクの価格漫画を作ってください。直径ニンジンプレーヤー。ポットまたは開発者は常にニブを紹介します。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "ピラティス",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "大量のウリシーズ、消費者マグナをヘンドレリットする私の男。人生の計画モーリスの賢いジャスミンまたは開発者チョコレート。バニー生態学的な栄養価の高い熱控除可能なルート酸塩の価格まで。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "質量は、地域要素にとって現実的ではありません。醜い大量開発者DUIを実行するピーナッツ。いくつかの唐辛子ニンジンを手に入れるための主流の補給学部開発者。それにもかかわらず、それは多くの関心だけではありません。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "恐怖のブルプタートフットボールチョコレートトリガーファイナンス樹脂のエネナティス地域。サッカーでは、私の飲み物または執行パスポート各法執行機関。飲み物は、マネージャー全体のウルトリシーです。バナナの瞬間は抗酸化物質のために飲みます。スマートチリの素晴らしいエコロジカルポット航空会社の範囲は存在しません。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-health-guides",
                name: "ガイド",
                articles: [
                    {
                        class: "columns-3-balanced",
                        header: "50歳以降の健康",
                        type: "articles-list",
                        content: [
                            {
                                title: "そして、レシピが常に無料療法のために引っ張るので。",
                                content:
                                    "プールの製造がありますが、アークはパフォーマンススカートを嫌いではありません。サッカー開発者のプロパガンダとして、サラダの生態学的な漫画モーリス。どちらもこの地域には多くのことではありません。あなたが嫌うまでパスポートフットボールの写真とサッカー。ライフサピエン栄養居住者サッカー悲しい老年。",
                            },
                            {
                                title: "ニンジン航空会社には、賢い病気や弧の笑い声が必要です。",
                                content: "発酵とケアで妊娠しています。サッカー選手の直径のソリシジン。電子レンジが無料で写真があり、時には可変ニンジンがあります。現在、バレーボールマイクロ波無料。スカート任意またはピーナッツまで。",
                            },
                            {
                                title: "ニシュルニシュルニスタンスニス。",
                                content: "恐怖の滅菌領域から滅菌された領域。レイヤーマクロセットAC。現在ふもとにある。学部の悲しい笑顔またはウォームアップのまでの直径。痛みの病気は、みんなのように揃っている笑顔の弓ではありません。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "健康な心",
                        type: "articles-list",
                        content: [
                            {
                                title: "彼のパートナーを妊娠し、光線と山の大きな押しを引いています。",
                                content: "航空会社の大量IDやサッカーの一部はありません。抗酸化物質がたくさんない限り、何もありません。人生の醜い質量ですが、要素期間。メインロレムでのさまざまな宿題。レシピは常に無料で引っ張ってください。",
                            },
                            {
                                title: "ニンジンになるのに多くの時間だけではありませんが、多くの時間です。",
                                content:
                                    "しかし、プロパガンダには、アークがさまざまな宿題をする必要があります。子供はタンクとバニーとして飲み物を引き起こします。時間のバニーの要素ですが、スマイルの価格はよりも。パフォーマンスランニング。現在のSADグレートは、妊娠中の男性の主流です。",
                            },
                            {
                                title: "に直径が拡張されるまで、多くの治療。",
                                content: "滅菌領域の週末の直径ではありません。は今ですが、無料の週末に座ってください。直径の滑ブルプタートまで多くのもの。住民のソースによって滅菌されたソース。",
                            },
                        ],
                    },
                    {
                        class: "columns-3-balanced",
                        header: "健康的な消化",
                        type: "articles-list",
                        content: [
                            {
                                title: "一部のティーンエイジャーを恐れます、私の愛する人は気にしません。",
                                content:
                                    "メンバーはあなたのプレイヤーチリでもあります。開発者のサッカーの大衆には、チリの漫画層が施行されます。臨床サッカーカートンの要素ニブ楽しいテレビは今ではありません。整数のバレーボール要素の喉にはそうではありません。",
                            },
                            {
                                title: "宿題のウルトレシープールを投資しますが。直径牛肉まで。",
                                content:
                                    "ソースは、命のソースのサピエンによって滅菌されます。EUバスケットボールのキャリアサッカープロパガンダの卒業生。バーウェンはサッカーをターゲットにしています。ティーンエイジャーを実行しています。明日はヴェネナティス、しかしサッカーは屋外での調査の矢を持っている必要があります.",
                            },
                            {
                                title: "痛みの範囲は、抗酸化物質の現在の要素ではありません。",
                                content: "今、レシピは時々Variusです。非直径ナム製造ロレムセッドスマイルウルトレシー。しかし、枕マイクロ波妊娠局は卒業しました。チョコレートを除くプレイヤーにチリの漫画層が必要です。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-health-underscored",
                name: "強調されています",
                articles: [
                    {
                        class: "columns-2-balanced",
                        header: "これは最初です",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "さまざまなアルコールドリンクでのチャンピオンシップ。しかし、それは常に局の妊娠中の化粧で笑顔です。非常にマッサージバスケットボールを妊娠しているタンクと執行として飲む。ゲートウェイがソフトな場合のパフォーマンス。さまざまなまたは震えまたはチケットで。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "ジャスミンの価格は大規模で、製造業のレクトゥス・モーリスのバスケットボールを投資します。パッチが醜い開発者。サラダの生態学的順序でチョコレート漫画モーリスが必要になりました。ターゲットを絞ったプロテインバスケットボールですが。",
                                url: "#",
                            },
                        ],
                    },
                    {
                        class: "columns-2-balanced",
                        header: "この秒",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "時間ターゲットポットプール。学部生の履歴書として控除可能でない限り、要素。または、ライオンよりも選ばれた人の価格。サッカーのスコアのために明日の学部生がたくさん必要です.",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "矢印いくつかのマレスアダはアルコール寿命を飲みます。重要なのは、ライフマイクロ波プレイヤーCNNです。大衆不動産の宿題の子供たちのパフォーマンス。開発者は常にを紹介していませんが、バレーボールの履歴書もありません。航空会社の大量がないか。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-health-what-to-eat",
                name: "何を食べれば良いか",
                articles: [
                    {
                        class: "columns-wrap",
                        header: "低炭水化物",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "酵母は鍋に置かれませんでした。震えがないのは嫌いです。これは、著者開発者であっても、超整備です。サッカーの明日の開発者はプロパガンダに住んでいます。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "したいのですが、時間はです。は、補給開発者の栄養住民を強化しました。利便性をキャンセルしますが、執行執行生態学的専門家。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "栄養供与者。トマトではありませんでした。航空会社がないよりも直径として。チリのリレーと温度。チョコレートは病気に沿っています。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "ベジタリアン",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "ただし、この十分の一通りの漫画地域。楽しいこともあれば。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "明日の谷は常に著者または生涯です。バスケットボールで笑いを走らせて、私の時間の資金調達no。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "エンティティのバレーボール要素の喉に、または週末に。空腹と醜いバニーですが、時間はurです。",
                            },
                        ],
                    },
                    {
                        class: "columns-wrap",
                        header: "朝食",
                        type: "excerpt",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "バイヤー最大の移民とバスケットボール。便利なクマの時点で期待して。サラダゼロQuiver直径へ。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "が醜い開発者ID調査の笑顔。直径はありません。私は妊娠したアークと温度サッカーのコンバリスジャスミンをチャットしません。",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                text: "最新のものにも委託がありました。臨床の価格は、マイクの価格漫画を作ってください。",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-health-hot-topics",
                name: "ホットな話題",
                articles: [
                    {
                        class: "columns-2-balanced",
                        header: "これは最初です",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "プロパガンダはさまざまなものでアルコール飲み物をベッドします。コース醜い大衆開発者DUI。Feugiatチョコレートは病気に沿っています。または臨床ゲートは枕ではありません。それはあなたが憎しみの弓を飾りたいと願うことです。必須の航空会社には、痛みの病気や笑顔の弧が必要です。サッカーのハロウィーン、私の飲み物またはバニー。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "new",
                                        label: "新しい",
                                    },
                                },
                                text: "震えの質量。ジャスミンを嫌いますが、顧客まで学部の直径を嫌います。今はソフトですが、それは常に局の笑顔です。今、それはフットボール選手の直径のケア時間です。トマトの学部開発者の宿題タンクの多く。",
                                url: "#",
                            },
                        ],
                    },
                    {
                        class: "columns-2-balanced",
                        header: "この秒",
                        type: "grid",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "そして、人生の開発者は常に人のベッドです。どちらでもない大衆の航空会社。しかし、サッカー、私の飲み物、または執行宿題の喉は醜いです。開発者ID調査では、恐怖の前でSmile feugiat。ビューロー妊娠中のメイクアップそれぞれまたはシリアルプロパガンダ。プロパガンダは、アークがさまざまな宿題をする必要があります。",
                                url: "#",
                            },
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                meta: {
                                    tag: {
                                        type: "breaking",
                                        label: "速報",
                                    },
                                },
                                text: "または支払った選択。ニンジンが強化されました。非直径ナム製造ロレムセッド笑い。門脈プールの嘆き層温度。サッカーは現在、子供のニンジン航空会社の喉です。または醜い今はロレムが必要です。予約済みマイクロ波無料。",
                                url: "#",
                            },
                        ],
                    },
                ],
            },
            {
                id: "content-health-paid-content",
                name: "有料コンテンツ",
                articles: [
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "フットボールサラダ素晴らしいウォームアップワークの人生。は大きく、製造業を卒業しました。必須の利便性リレーなし。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "ヌラム車は、学校のコースからの訪問時の車両。地域の要素のために、生命とライオンの宿題の矢印。栄養開発者のニーズはありません。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "開発者、および。最大の一部のマスカラニブで。サッカーだが妊娠中のチリ。エロスのプレイヤーでは、サピエンのヘアスタイルですが、恐怖のために時間を嘆きます。",
                            },
                        ],
                    },
                    {
                        class: "columns-4-balanced",
                        type: "preview",
                        content: [
                            {
                                image: {
                                    src: "placeholder_light.jpg",
                                    alt: "プレースホルダー",
                                    width: "1280",
                                    height: "720",
                                },
                                title: "それは資金調達でしたが、パフォーマンスでしたが、ゲートでした。ヌラムと唐辛子の温度。臨床IDの価格。質量は、地域要素にとって現実的ではありません。",
                            },
                        ],
                    },
                ],
            },
        ],
    },
};
