/* prototypes.h --- Shared interfaces used by CGIJACL and JACL
 * (C) 2008 Stuart Allen, distribute and use 
 * according to GNU GPL, see file COPYING for details.
 */

#ifdef GLK
strid_t open_glk_file();
glui32 glk_get_bin_line_stream(); 
glui32 parse_utf8();
void convert_to_utf8(glui32 *text, int len);
glui32 parse_utf8(unsigned char *buf, glui32 buflen, glui32 *out, glui32 outlen);
#else
void update_parameters();
#endif

#ifdef GARGLK
extern char* garglk_fileref_get_name(frefid_t fref);

extern void garglk_set_program_name(const char *name);
extern void garglk_set_program_info(const char *info);
extern void garglk_set_story_name(const char *name);
extern void garglk_set_config(const char *name);
#endif

void default_footer();
void default_header();
int bearing();
int distance();
int strcondition();
int and_strcondition();
int logic_test();
int str_test();
int first_available();
int validate();
int noun_resolve();
int get_from_object();
int is_direct_child_of_from();
int is_child_of_from();
int verify_from_object();
int find_parent();
int scope();
int object_element_resolve();
int execute();
int object_resolve();
int random_number();
void log_access();
void log_error();
int parent_of();
int grand_of();
int check_light();
int find_route();
int exit_function();
int	count_resolve();
void jacl_set_window();
void create_cstring();
void create_string();
void create_integer();
void create_cinteger();
void scripting();
void undoing();
void walking_thru();
void create_paths();
int get_key();
char get_character();
int get_yes_or_no();
void get_string();
int get_number();
int save_interaction();
int restore_interaction();
void write_integer();
void write_long();
int  read_integer();
long read_long();
void jacl_encrypt ();
void jacl_decrypt ();
void log_message();
void set_them();
void preparse();
void inspect();
void add_all();
void add_to_list();
void call_functions();
int build_object_list();
long value_of();
long attribute_resolve();
long user_attribute_resolve();
struct word_type *exact_match();
struct word_type *object_match();
struct integer_type *integer_resolve();
struct integer_type *integer_resolve_indexed();
struct function_type *function_resolve();
struct string_type *string_resolve();
struct string_type *string_resolve_indexed();
struct string_type *cstring_resolve();
struct string_type *cstring_resolve_indexed();
struct cinteger_type *cinteger_resolve();
struct cinteger_type *cinteger_resolve_indexed();
int array_length_resolve();
int legal_label_check();
int attribute_test();
char* object_names();
char* arg_text_of();
char* arg_text_of_word();
char* var_text_of_word();
char* text_of();
char* text_of_word();
char* expand_function();
int* container_resolve();
int condition();
int and_condition();
void free_from();
void word_check();
void eachturn();
void read_config_file();
void version_info();
int jacl_whitespace();
int get_here();
char* stripwhite();
void command_encapsulate();
void encapsulate();
void jacl_truncate();
void parser();
void diagnose();
void look_around();
char* macro_resolve();
char* plain_output();
char* sub_output();
char* obj_output();
char* that_output();
char* sentence_output();
char* isnt_output();
char* is_output();
char* it_output();
char* doesnt_output();
char* does_output();
char* list_output();
char* long_output();
void terminate();
void set_arguments();
void pop_stack();
void push_stack();
void pop_proxy();
void push_proxy();
void write_text();
void status_line();
void newline();
void scroll();
int  save_game();
int  restore_game();
void write_integer();
int  read_integer();
void write_long();
long read_long();
void save_game_state();
void restore_game_state();
void add_string();
void add_cstring();
void clear_string();
void clear_cstring();
void add_cinteger();
void clear_cinteger();
void restart_game();
void read_gamefile();
void new_position();
void build_grammar_table();
void unkvalerr();
void totalerrs();
void unkatterr();
void unkfunrun();
void nofnamerr();
void nongloberr();
void unkkeyerr();
void maxatterr();
void unkattrun();
void badptrrun();
void badplrrun();
void badparrun();
void notintrun();
void noproprun();
void noproperr();
void noobjerr();
void unkobjerr();
void unkobjrun();
void unkdirrun();
void unkscorun();
void unkstrrun();
void unkvarrun();
void outofmem();
void set_defaults();
void no_it();
void clrscrn();
void more();
int jpp();
int process_file();
char* strip_return();
char** command_completion();
char* object_generator();
char* verb_generator();
void add_word();
void create_language_constants();
int select_next();
void jacl_sleep();
