//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armapimanagement_test

import (
	"context"
	"testing"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/internal/testutil"
	"github.com/stretchr/testify/suite"
)

type ApimdeploymentTestSuite struct {
	suite.Suite

	ctx               context.Context
	cred              azcore.TokenCredential
	options           *arm.ClientOptions
	serviceName       string
	location          string
	resourceGroupName string
	subscriptionId    string
}

func (testsuite *ApimdeploymentTestSuite) SetupSuite() {
	testutil.StartRecording(testsuite.T(), "sdk/resourcemanager/apimanagement/armapimanagement/testdata")
	testsuite.ctx = context.Background()
	testsuite.cred, testsuite.options = testutil.GetCredAndClientOptions(testsuite.T())
	testsuite.serviceName = testutil.GenerateAlphaNumericID(testsuite.T(), "servicedeploy", 6)
	testsuite.location = testutil.GetEnv("LOCATION", "westus")
	testsuite.resourceGroupName = testutil.GetEnv("RESOURCE_GROUP_NAME", "scenarioTestTempGroup")
	testsuite.subscriptionId = testutil.GetEnv("AZURE_SUBSCRIPTION_ID", "00000000-0000-0000-0000-000000000000")

	resourceGroup, _, err := testutil.CreateResourceGroup(testsuite.ctx, testsuite.subscriptionId, testsuite.cred, testsuite.options, testsuite.location)
	testsuite.Require().NoError(err)
	testsuite.resourceGroupName = *resourceGroup.Name
}

func (testsuite *ApimdeploymentTestSuite) TearDownSuite() {
	_, err := testutil.DeleteResourceGroup(testsuite.ctx, testsuite.subscriptionId, testsuite.cred, testsuite.options, testsuite.resourceGroupName)
	testsuite.Require().NoError(err)
	testutil.StopRecording(testsuite.T())
}

func TestApimdeploymentTestSuite(t *testing.T) {
	suite.Run(t, new(ApimdeploymentTestSuite))
}

// Microsoft.ApiManagement/service
func (testsuite *ApimdeploymentTestSuite) TestApimanagementservice() {
	var err error
	// From step ApiManagementService_CheckNameAvailability
	serviceClient, err := armapimanagement.NewServiceClient(testsuite.subscriptionId, testsuite.cred, testsuite.options)
	testsuite.Require().NoError(err)
	_, err = serviceClient.CheckNameAvailability(testsuite.ctx, armapimanagement.ServiceCheckNameAvailabilityParameters{
		Name: to.Ptr("apimService1"),
	}, nil)
	testsuite.Require().NoError(err)

	// From step ApiManagementService_CreateOrUpdate
	serviceClientCreateOrUpdateResponsePoller, err := serviceClient.BeginCreateOrUpdate(testsuite.ctx, testsuite.resourceGroupName, testsuite.serviceName, armapimanagement.ServiceResource{
		Tags: map[string]*string{
			"Name": to.Ptr("Contoso"),
			"Test": to.Ptr("User"),
		},
		Location: to.Ptr(testsuite.location),
		Properties: &armapimanagement.ServiceProperties{
			PublisherEmail: to.Ptr("foo@contoso.com"),
			PublisherName:  to.Ptr("foo"),
		},
		SKU: &armapimanagement.ServiceSKUProperties{
			Name:     to.Ptr(armapimanagement.SKUTypeStandard),
			Capacity: to.Ptr[int32](1),
		},
	}, nil)
	testsuite.Require().NoError(err)
	_, err = testutil.PollForTest(testsuite.ctx, serviceClientCreateOrUpdateResponsePoller)
	testsuite.Require().NoError(err)

	// From step ApiManagementService_List
	serviceClientNewListPager := serviceClient.NewListPager(nil)
	for serviceClientNewListPager.More() {
		_, err := serviceClientNewListPager.NextPage(testsuite.ctx)
		testsuite.Require().NoError(err)
		break
	}

	// From step ApiManagementService_ListByResourceGroup
	serviceClientNewListByResourceGroupPager := serviceClient.NewListByResourceGroupPager(testsuite.resourceGroupName, nil)
	for serviceClientNewListByResourceGroupPager.More() {
		_, err := serviceClientNewListByResourceGroupPager.NextPage(testsuite.ctx)
		testsuite.Require().NoError(err)
		break
	}

	// From step ApiManagementService_Get
	_, err = serviceClient.Get(testsuite.ctx, testsuite.resourceGroupName, testsuite.serviceName, nil)
	testsuite.Require().NoError(err)

	// From step ApiManagementService_Update
	serviceClientUpdateResponsePoller, err := serviceClient.BeginUpdate(testsuite.ctx, testsuite.resourceGroupName, testsuite.serviceName, armapimanagement.ServiceUpdateParameters{
		Properties: &armapimanagement.ServiceUpdateProperties{
			CustomProperties: map[string]*string{
				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("false"),
			},
		},
	}, nil)
	testsuite.Require().NoError(err)
	_, err = testutil.PollForTest(testsuite.ctx, serviceClientUpdateResponsePoller)
	testsuite.Require().NoError(err)

	// From step ApiManagementService_GetDomainOwnershipIdentifier
	_, err = serviceClient.GetDomainOwnershipIdentifier(testsuite.ctx, nil)
	testsuite.Require().NoError(err)

	// From step ApiManagementService_GetSsoToken
	_, err = serviceClient.GetSsoToken(testsuite.ctx, testsuite.resourceGroupName, testsuite.serviceName, nil)
	testsuite.Require().NoError(err)

	// From step ApiManagementServiceSkus_ListAvailableServiceSkus
	serviceSKUsClient, err := armapimanagement.NewServiceSKUsClient(testsuite.subscriptionId, testsuite.cred, testsuite.options)
	testsuite.Require().NoError(err)
	serviceSKUsClientNewListAvailableServiceSKUsPager := serviceSKUsClient.NewListAvailableServiceSKUsPager(testsuite.resourceGroupName, testsuite.serviceName, nil)
	for serviceSKUsClientNewListAvailableServiceSKUsPager.More() {
		_, err := serviceSKUsClientNewListAvailableServiceSKUsPager.NextPage(testsuite.ctx)
		testsuite.Require().NoError(err)
		break
	}

	// From step ApiManagementService_Delete
	serviceClientDeleteResponsePoller, err := serviceClient.BeginDelete(testsuite.ctx, testsuite.resourceGroupName, testsuite.serviceName, nil)
	testsuite.Require().NoError(err)
	_, err = testutil.PollForTest(testsuite.ctx, serviceClientDeleteResponsePoller)
	testsuite.Require().NoError(err)

	// From step DeletedServices_ListBySubscription
	deletedServicesClient, err := armapimanagement.NewDeletedServicesClient(testsuite.subscriptionId, testsuite.cred, testsuite.options)
	testsuite.Require().NoError(err)
	deletedServicesClientNewListBySubscriptionPager := deletedServicesClient.NewListBySubscriptionPager(nil)
	for deletedServicesClientNewListBySubscriptionPager.More() {
		_, err := deletedServicesClientNewListBySubscriptionPager.NextPage(testsuite.ctx)
		testsuite.Require().NoError(err)
		break
	}

	// From step DeletedServices_GetByName
	_, err = deletedServicesClient.GetByName(testsuite.ctx, testsuite.serviceName, testsuite.location, nil)
	testsuite.Require().NoError(err)

	// From step DeletedServices_Purge
	deletedServicesClientPurgeResponsePoller, err := deletedServicesClient.BeginPurge(testsuite.ctx, testsuite.serviceName, testsuite.location, nil)
	testsuite.Require().NoError(err)
	_, err = testutil.PollForTest(testsuite.ctx, deletedServicesClientPurgeResponsePoller)
	testsuite.Require().NoError(err)
}

// Microsoft.ApiManagement/operations
func (testsuite *ApimdeploymentTestSuite) TestApimanagementoperations() {
	var err error
	// From step ApiManagementOperations_List
	operationsClient, err := armapimanagement.NewOperationsClient(testsuite.cred, testsuite.options)
	testsuite.Require().NoError(err)
	operationsClientNewListPager := operationsClient.NewListPager(nil)
	for operationsClientNewListPager.More() {
		_, err := operationsClientNewListPager.NextPage(testsuite.ctx)
		testsuite.Require().NoError(err)
		break
	}
}
