//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappplatform

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// BuildServiceClient contains the methods for the BuildService group.
// Don't use this type directly, use NewBuildServiceClient() instead.
type BuildServiceClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewBuildServiceClient creates a new instance of BuildServiceClient with the specified values.
// subscriptionID - Gets subscription ID which uniquely identify the Microsoft Azure subscription. The subscription ID forms
// part of the URI for every service call.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewBuildServiceClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*BuildServiceClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &BuildServiceClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CreateOrUpdateBuild - Create or update a KPack build.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serviceName - The name of the Service resource.
// buildServiceName - The name of the build service resource.
// buildName - The name of the build resource.
// buildParam - Parameters for the create or update operation
// options - BuildServiceClientCreateOrUpdateBuildOptions contains the optional parameters for the BuildServiceClient.CreateOrUpdateBuild
// method.
func (client *BuildServiceClient) CreateOrUpdateBuild(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildParam Build, options *BuildServiceClientCreateOrUpdateBuildOptions) (BuildServiceClientCreateOrUpdateBuildResponse, error) {
	req, err := client.createOrUpdateBuildCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, buildName, buildParam, options)
	if err != nil {
		return BuildServiceClientCreateOrUpdateBuildResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return BuildServiceClientCreateOrUpdateBuildResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return BuildServiceClientCreateOrUpdateBuildResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateBuildHandleResponse(resp)
}

// createOrUpdateBuildCreateRequest creates the CreateOrUpdateBuild request.
func (client *BuildServiceClient) createOrUpdateBuildCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildParam Build, options *BuildServiceClientCreateOrUpdateBuildOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	if buildName == "" {
		return nil, errors.New("parameter buildName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildName}", url.PathEscape(buildName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, buildParam)
}

// createOrUpdateBuildHandleResponse handles the CreateOrUpdateBuild response.
func (client *BuildServiceClient) createOrUpdateBuildHandleResponse(resp *http.Response) (BuildServiceClientCreateOrUpdateBuildResponse, error) {
	result := BuildServiceClientCreateOrUpdateBuildResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Build); err != nil {
		return BuildServiceClientCreateOrUpdateBuildResponse{}, err
	}
	return result, nil
}

// GetBuild - Get a KPack build.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serviceName - The name of the Service resource.
// buildServiceName - The name of the build service resource.
// buildName - The name of the build resource.
// options - BuildServiceClientGetBuildOptions contains the optional parameters for the BuildServiceClient.GetBuild method.
func (client *BuildServiceClient) GetBuild(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, options *BuildServiceClientGetBuildOptions) (BuildServiceClientGetBuildResponse, error) {
	req, err := client.getBuildCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, buildName, options)
	if err != nil {
		return BuildServiceClientGetBuildResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return BuildServiceClientGetBuildResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BuildServiceClientGetBuildResponse{}, runtime.NewResponseError(resp)
	}
	return client.getBuildHandleResponse(resp)
}

// getBuildCreateRequest creates the GetBuild request.
func (client *BuildServiceClient) getBuildCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, options *BuildServiceClientGetBuildOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	if buildName == "" {
		return nil, errors.New("parameter buildName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildName}", url.PathEscape(buildName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getBuildHandleResponse handles the GetBuild response.
func (client *BuildServiceClient) getBuildHandleResponse(resp *http.Response) (BuildServiceClientGetBuildResponse, error) {
	result := BuildServiceClientGetBuildResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Build); err != nil {
		return BuildServiceClientGetBuildResponse{}, err
	}
	return result, nil
}

// GetBuildResult - Get a KPack build result.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serviceName - The name of the Service resource.
// buildServiceName - The name of the build service resource.
// buildName - The name of the build resource.
// buildResultName - The name of the build result resource.
// options - BuildServiceClientGetBuildResultOptions contains the optional parameters for the BuildServiceClient.GetBuildResult
// method.
func (client *BuildServiceClient) GetBuildResult(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildResultName string, options *BuildServiceClientGetBuildResultOptions) (BuildServiceClientGetBuildResultResponse, error) {
	req, err := client.getBuildResultCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, buildName, buildResultName, options)
	if err != nil {
		return BuildServiceClientGetBuildResultResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return BuildServiceClientGetBuildResultResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BuildServiceClientGetBuildResultResponse{}, runtime.NewResponseError(resp)
	}
	return client.getBuildResultHandleResponse(resp)
}

// getBuildResultCreateRequest creates the GetBuildResult request.
func (client *BuildServiceClient) getBuildResultCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildResultName string, options *BuildServiceClientGetBuildResultOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results/{buildResultName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	if buildName == "" {
		return nil, errors.New("parameter buildName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildName}", url.PathEscape(buildName))
	if buildResultName == "" {
		return nil, errors.New("parameter buildResultName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildResultName}", url.PathEscape(buildResultName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getBuildResultHandleResponse handles the GetBuildResult response.
func (client *BuildServiceClient) getBuildResultHandleResponse(resp *http.Response) (BuildServiceClientGetBuildResultResponse, error) {
	result := BuildServiceClientGetBuildResultResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BuildResult); err != nil {
		return BuildServiceClientGetBuildResultResponse{}, err
	}
	return result, nil
}

// GetBuildResultLog - Get a KPack build result log download URL.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serviceName - The name of the Service resource.
// buildServiceName - The name of the build service resource.
// buildName - The name of the build resource.
// buildResultName - The name of the build result resource.
// options - BuildServiceClientGetBuildResultLogOptions contains the optional parameters for the BuildServiceClient.GetBuildResultLog
// method.
func (client *BuildServiceClient) GetBuildResultLog(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildResultName string, options *BuildServiceClientGetBuildResultLogOptions) (BuildServiceClientGetBuildResultLogResponse, error) {
	req, err := client.getBuildResultLogCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, buildName, buildResultName, options)
	if err != nil {
		return BuildServiceClientGetBuildResultLogResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return BuildServiceClientGetBuildResultLogResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BuildServiceClientGetBuildResultLogResponse{}, runtime.NewResponseError(resp)
	}
	return client.getBuildResultLogHandleResponse(resp)
}

// getBuildResultLogCreateRequest creates the GetBuildResultLog request.
func (client *BuildServiceClient) getBuildResultLogCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildResultName string, options *BuildServiceClientGetBuildResultLogOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results/{buildResultName}/getLogFileUrl"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	if buildName == "" {
		return nil, errors.New("parameter buildName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildName}", url.PathEscape(buildName))
	if buildResultName == "" {
		return nil, errors.New("parameter buildResultName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildResultName}", url.PathEscape(buildResultName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getBuildResultLogHandleResponse handles the GetBuildResultLog response.
func (client *BuildServiceClient) getBuildResultLogHandleResponse(resp *http.Response) (BuildServiceClientGetBuildResultLogResponse, error) {
	result := BuildServiceClientGetBuildResultLogResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BuildResultLog); err != nil {
		return BuildServiceClientGetBuildResultLogResponse{}, err
	}
	return result, nil
}

// GetBuildService - Get a build service resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serviceName - The name of the Service resource.
// buildServiceName - The name of the build service resource.
// options - BuildServiceClientGetBuildServiceOptions contains the optional parameters for the BuildServiceClient.GetBuildService
// method.
func (client *BuildServiceClient) GetBuildService(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientGetBuildServiceOptions) (BuildServiceClientGetBuildServiceResponse, error) {
	req, err := client.getBuildServiceCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, options)
	if err != nil {
		return BuildServiceClientGetBuildServiceResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return BuildServiceClientGetBuildServiceResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BuildServiceClientGetBuildServiceResponse{}, runtime.NewResponseError(resp)
	}
	return client.getBuildServiceHandleResponse(resp)
}

// getBuildServiceCreateRequest creates the GetBuildService request.
func (client *BuildServiceClient) getBuildServiceCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientGetBuildServiceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getBuildServiceHandleResponse handles the GetBuildService response.
func (client *BuildServiceClient) getBuildServiceHandleResponse(resp *http.Response) (BuildServiceClientGetBuildServiceResponse, error) {
	result := BuildServiceClientGetBuildServiceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BuildService); err != nil {
		return BuildServiceClientGetBuildServiceResponse{}, err
	}
	return result, nil
}

// GetResourceUploadURL - Get an resource upload URL for build service, which may be artifacts or source archive.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serviceName - The name of the Service resource.
// buildServiceName - The name of the build service resource.
// options - BuildServiceClientGetResourceUploadURLOptions contains the optional parameters for the BuildServiceClient.GetResourceUploadURL
// method.
func (client *BuildServiceClient) GetResourceUploadURL(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientGetResourceUploadURLOptions) (BuildServiceClientGetResourceUploadURLResponse, error) {
	req, err := client.getResourceUploadURLCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, options)
	if err != nil {
		return BuildServiceClientGetResourceUploadURLResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return BuildServiceClientGetResourceUploadURLResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BuildServiceClientGetResourceUploadURLResponse{}, runtime.NewResponseError(resp)
	}
	return client.getResourceUploadURLHandleResponse(resp)
}

// getResourceUploadURLCreateRequest creates the GetResourceUploadURL request.
func (client *BuildServiceClient) getResourceUploadURLCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientGetResourceUploadURLOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/getResourceUploadUrl"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getResourceUploadURLHandleResponse handles the GetResourceUploadURL response.
func (client *BuildServiceClient) getResourceUploadURLHandleResponse(resp *http.Response) (BuildServiceClientGetResourceUploadURLResponse, error) {
	result := BuildServiceClientGetResourceUploadURLResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceUploadDefinition); err != nil {
		return BuildServiceClientGetResourceUploadURLResponse{}, err
	}
	return result, nil
}

// GetSupportedBuildpack - Get the supported buildpack resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serviceName - The name of the Service resource.
// buildServiceName - The name of the build service resource.
// buildpackName - The name of the buildpack resource.
// options - BuildServiceClientGetSupportedBuildpackOptions contains the optional parameters for the BuildServiceClient.GetSupportedBuildpack
// method.
func (client *BuildServiceClient) GetSupportedBuildpack(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildpackName string, options *BuildServiceClientGetSupportedBuildpackOptions) (BuildServiceClientGetSupportedBuildpackResponse, error) {
	req, err := client.getSupportedBuildpackCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, buildpackName, options)
	if err != nil {
		return BuildServiceClientGetSupportedBuildpackResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return BuildServiceClientGetSupportedBuildpackResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BuildServiceClientGetSupportedBuildpackResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSupportedBuildpackHandleResponse(resp)
}

// getSupportedBuildpackCreateRequest creates the GetSupportedBuildpack request.
func (client *BuildServiceClient) getSupportedBuildpackCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildpackName string, options *BuildServiceClientGetSupportedBuildpackOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/supportedBuildpacks/{buildpackName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	if buildpackName == "" {
		return nil, errors.New("parameter buildpackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildpackName}", url.PathEscape(buildpackName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSupportedBuildpackHandleResponse handles the GetSupportedBuildpack response.
func (client *BuildServiceClient) getSupportedBuildpackHandleResponse(resp *http.Response) (BuildServiceClientGetSupportedBuildpackResponse, error) {
	result := BuildServiceClientGetSupportedBuildpackResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SupportedBuildpackResource); err != nil {
		return BuildServiceClientGetSupportedBuildpackResponse{}, err
	}
	return result, nil
}

// GetSupportedStack - Get the supported stack resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serviceName - The name of the Service resource.
// buildServiceName - The name of the build service resource.
// stackName - The name of the stack resource.
// options - BuildServiceClientGetSupportedStackOptions contains the optional parameters for the BuildServiceClient.GetSupportedStack
// method.
func (client *BuildServiceClient) GetSupportedStack(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, stackName string, options *BuildServiceClientGetSupportedStackOptions) (BuildServiceClientGetSupportedStackResponse, error) {
	req, err := client.getSupportedStackCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, stackName, options)
	if err != nil {
		return BuildServiceClientGetSupportedStackResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return BuildServiceClientGetSupportedStackResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BuildServiceClientGetSupportedStackResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSupportedStackHandleResponse(resp)
}

// getSupportedStackCreateRequest creates the GetSupportedStack request.
func (client *BuildServiceClient) getSupportedStackCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, stackName string, options *BuildServiceClientGetSupportedStackOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/supportedStacks/{stackName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	if stackName == "" {
		return nil, errors.New("parameter stackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{stackName}", url.PathEscape(stackName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSupportedStackHandleResponse handles the GetSupportedStack response.
func (client *BuildServiceClient) getSupportedStackHandleResponse(resp *http.Response) (BuildServiceClientGetSupportedStackResponse, error) {
	result := BuildServiceClientGetSupportedStackResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SupportedStackResource); err != nil {
		return BuildServiceClientGetSupportedStackResponse{}, err
	}
	return result, nil
}

// NewListBuildResultsPager - List KPack build results.
// Generated from API version 2022-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serviceName - The name of the Service resource.
// buildServiceName - The name of the build service resource.
// buildName - The name of the build resource.
// options - BuildServiceClientListBuildResultsOptions contains the optional parameters for the BuildServiceClient.ListBuildResults
// method.
func (client *BuildServiceClient) NewListBuildResultsPager(resourceGroupName string, serviceName string, buildServiceName string, buildName string, options *BuildServiceClientListBuildResultsOptions) *runtime.Pager[BuildServiceClientListBuildResultsResponse] {
	return runtime.NewPager(runtime.PagingHandler[BuildServiceClientListBuildResultsResponse]{
		More: func(page BuildServiceClientListBuildResultsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *BuildServiceClientListBuildResultsResponse) (BuildServiceClientListBuildResultsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listBuildResultsCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, buildName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return BuildServiceClientListBuildResultsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return BuildServiceClientListBuildResultsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return BuildServiceClientListBuildResultsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listBuildResultsHandleResponse(resp)
		},
	})
}

// listBuildResultsCreateRequest creates the ListBuildResults request.
func (client *BuildServiceClient) listBuildResultsCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, options *BuildServiceClientListBuildResultsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	if buildName == "" {
		return nil, errors.New("parameter buildName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildName}", url.PathEscape(buildName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBuildResultsHandleResponse handles the ListBuildResults response.
func (client *BuildServiceClient) listBuildResultsHandleResponse(resp *http.Response) (BuildServiceClientListBuildResultsResponse, error) {
	result := BuildServiceClientListBuildResultsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BuildResultCollection); err != nil {
		return BuildServiceClientListBuildResultsResponse{}, err
	}
	return result, nil
}

// NewListBuildServicesPager - List build services resource.
// Generated from API version 2022-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serviceName - The name of the Service resource.
// options - BuildServiceClientListBuildServicesOptions contains the optional parameters for the BuildServiceClient.ListBuildServices
// method.
func (client *BuildServiceClient) NewListBuildServicesPager(resourceGroupName string, serviceName string, options *BuildServiceClientListBuildServicesOptions) *runtime.Pager[BuildServiceClientListBuildServicesResponse] {
	return runtime.NewPager(runtime.PagingHandler[BuildServiceClientListBuildServicesResponse]{
		More: func(page BuildServiceClientListBuildServicesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *BuildServiceClientListBuildServicesResponse) (BuildServiceClientListBuildServicesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listBuildServicesCreateRequest(ctx, resourceGroupName, serviceName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return BuildServiceClientListBuildServicesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return BuildServiceClientListBuildServicesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return BuildServiceClientListBuildServicesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listBuildServicesHandleResponse(resp)
		},
	})
}

// listBuildServicesCreateRequest creates the ListBuildServices request.
func (client *BuildServiceClient) listBuildServicesCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, options *BuildServiceClientListBuildServicesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBuildServicesHandleResponse handles the ListBuildServices response.
func (client *BuildServiceClient) listBuildServicesHandleResponse(resp *http.Response) (BuildServiceClientListBuildServicesResponse, error) {
	result := BuildServiceClientListBuildServicesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BuildServiceCollection); err != nil {
		return BuildServiceClientListBuildServicesResponse{}, err
	}
	return result, nil
}

// NewListBuildsPager - List KPack builds.
// Generated from API version 2022-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serviceName - The name of the Service resource.
// buildServiceName - The name of the build service resource.
// options - BuildServiceClientListBuildsOptions contains the optional parameters for the BuildServiceClient.ListBuilds method.
func (client *BuildServiceClient) NewListBuildsPager(resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientListBuildsOptions) *runtime.Pager[BuildServiceClientListBuildsResponse] {
	return runtime.NewPager(runtime.PagingHandler[BuildServiceClientListBuildsResponse]{
		More: func(page BuildServiceClientListBuildsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *BuildServiceClientListBuildsResponse) (BuildServiceClientListBuildsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listBuildsCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return BuildServiceClientListBuildsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return BuildServiceClientListBuildsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return BuildServiceClientListBuildsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listBuildsHandleResponse(resp)
		},
	})
}

// listBuildsCreateRequest creates the ListBuilds request.
func (client *BuildServiceClient) listBuildsCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientListBuildsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBuildsHandleResponse handles the ListBuilds response.
func (client *BuildServiceClient) listBuildsHandleResponse(resp *http.Response) (BuildServiceClientListBuildsResponse, error) {
	result := BuildServiceClientListBuildsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BuildCollection); err != nil {
		return BuildServiceClientListBuildsResponse{}, err
	}
	return result, nil
}

// ListSupportedBuildpacks - Get all supported buildpacks.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serviceName - The name of the Service resource.
// buildServiceName - The name of the build service resource.
// options - BuildServiceClientListSupportedBuildpacksOptions contains the optional parameters for the BuildServiceClient.ListSupportedBuildpacks
// method.
func (client *BuildServiceClient) ListSupportedBuildpacks(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientListSupportedBuildpacksOptions) (BuildServiceClientListSupportedBuildpacksResponse, error) {
	req, err := client.listSupportedBuildpacksCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, options)
	if err != nil {
		return BuildServiceClientListSupportedBuildpacksResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return BuildServiceClientListSupportedBuildpacksResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BuildServiceClientListSupportedBuildpacksResponse{}, runtime.NewResponseError(resp)
	}
	return client.listSupportedBuildpacksHandleResponse(resp)
}

// listSupportedBuildpacksCreateRequest creates the ListSupportedBuildpacks request.
func (client *BuildServiceClient) listSupportedBuildpacksCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientListSupportedBuildpacksOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/supportedBuildpacks"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSupportedBuildpacksHandleResponse handles the ListSupportedBuildpacks response.
func (client *BuildServiceClient) listSupportedBuildpacksHandleResponse(resp *http.Response) (BuildServiceClientListSupportedBuildpacksResponse, error) {
	result := BuildServiceClientListSupportedBuildpacksResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SupportedBuildpacksCollection); err != nil {
		return BuildServiceClientListSupportedBuildpacksResponse{}, err
	}
	return result, nil
}

// ListSupportedStacks - Get all supported stacks.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serviceName - The name of the Service resource.
// buildServiceName - The name of the build service resource.
// options - BuildServiceClientListSupportedStacksOptions contains the optional parameters for the BuildServiceClient.ListSupportedStacks
// method.
func (client *BuildServiceClient) ListSupportedStacks(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientListSupportedStacksOptions) (BuildServiceClientListSupportedStacksResponse, error) {
	req, err := client.listSupportedStacksCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, options)
	if err != nil {
		return BuildServiceClientListSupportedStacksResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return BuildServiceClientListSupportedStacksResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BuildServiceClientListSupportedStacksResponse{}, runtime.NewResponseError(resp)
	}
	return client.listSupportedStacksHandleResponse(resp)
}

// listSupportedStacksCreateRequest creates the ListSupportedStacks request.
func (client *BuildServiceClient) listSupportedStacksCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientListSupportedStacksOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/supportedStacks"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSupportedStacksHandleResponse handles the ListSupportedStacks response.
func (client *BuildServiceClient) listSupportedStacksHandleResponse(resp *http.Response) (BuildServiceClientListSupportedStacksResponse, error) {
	result := BuildServiceClientListSupportedStacksResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SupportedStacksCollection); err != nil {
		return BuildServiceClientListSupportedStacksResponse{}, err
	}
	return result, nil
}
